/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.metaqtl.CMarkerSequence;
import org.metaqtl.Chromosome;
import org.metaqtl.algo.CMSAlgorithm;
import org.metaqtl.graph.ChromAxe;
import org.metaqtl.graph.ChromShape;
import org.metaqtl.graph.Layer;

public class ChromLayer
extends Layer {
    public static final int RIGHT_LABEL = 0;
    public static final int LEFT_LABEL = 1;
    public static final int ALIGN_FIRST_COMMON = 0;
    public static final int ALIGN_FIRST_MARKER = 1;
    public static final int SINGLE_COMMON = 2;
    public static final int POS_COMMON = 0;
    public static final int NEG_COMMON = 1;
    private ChromShape chromShape = null;
    private Chromosome chromosome = null;

    public static void alignChromLayers(ChromLayer ref, ChromLayer layer, int mode) {
        double y_ref = 0.0;
        double y_layer = 0.0;
        switch (mode) {
            case 0: {
                int idx_ref = Chromosome.getFirstCommonMrkIdx(ref.chromosome, layer.chromosome);
                if (idx_ref >= 0) {
                    int idx_layer = layer.chromosome.getMarkerIdxWithName(ref.chromosome.getMarkerName(idx_ref));
                    y_ref = ref.getChromAxe().transformY(ref.chromosome.getDistance(idx_ref));
                    y_layer = layer.getChromAxe().transformY(layer.chromosome.getDistance(idx_layer));
                    break;
                }
                y_ref = ref.getChromAxe().getYMin();
                y_layer = layer.getChromAxe().getYMin();
                break;
            }
            case 1: {
                y_ref = ref.getChromAxe().getYMin();
                y_layer = layer.getChromAxe().getYMin();
                break;
            }
            default: {
                y_ref = ref.getChromAxe().getYMin();
                y_layer = layer.getChromAxe().getYMin();
            }
        }
        layer.setY(layer.getY() + (y_ref - y_layer));
    }

    public ChromLayer(double x, double y) {
        super(x, y);
    }

    public void draw(Graphics2D graph) {
        Color c = graph.getColor();
        AffineTransform t = graph.getTransform();
        AffineTransform trans = new AffineTransform();
        trans.translate(this.x, this.y);
        graph.transform(trans);
        if (this.chromShape != null) {
            this.chromShape.draw(graph);
        }
        graph.setTransform(t);
        graph.setColor(c);
    }

    public void build(Graphics2D graph) {
        this.chromShape = new ChromShape();
        this.chromShape.buildShape(graph, this.chromosome);
    }

    public ChromAxe getChromAxe() {
        return this.chromShape.getChromAxe();
    }

    public void attach(Object object) {
        if (object instanceof Chromosome) {
            this.chromosome = (Chromosome)object;
        }
    }

    public void setLabelSide(int side) {
        this.chromShape.setLabelSide(side);
    }

    public double getHeight() {
        return this.chromShape.getHeight();
    }

    public double getWidth() {
        return this.chromShape.getWidth();
    }

    public double getYMin() {
        return this.y;
    }

    public double getYMax() {
        return this.chromShape.getYMax();
    }

    public CMrkTickPoint[] getCommonMarkerPoints(ChromLayer chromLayer) {
        boolean reverse = this.chromShape.getLabelSide() == chromLayer.chromShape.getLabelSide();
        CMarkerSequence cms = CMSAlgorithm.run(this.chromosome, chromLayer.chromosome);
        if (cms != null) {
            CMrkTickPoint[] points = new CMrkTickPoint[cms.nmc];
            int k = 0;
            int i = 0;
            while (i < cms.ncs) {
                int j = 0;
                while (j < cms.css[i]) {
                    int mrk1 = cms.idx1[i][j];
                    int mrk2 = cms.idx2[i][j];
                    points[k] = new CMrkTickPoint();
                    points[k].p1 = this.getMrkTickPoint2D(mrk1, false);
                    points[k].p2 = chromLayer.getMrkTickPoint2D(mrk2, reverse);
                    points[k].status = cms.frames[i] ? 0 : 1;
                    ++k;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < cms.nmc) {
                if (!cms.incms[i]) {
                    points[k] = new CMrkTickPoint();
                    points[k].p1 = this.getMrkTickPoint2D(cms.mcidx[0][i], false);
                    points[k].p2 = chromLayer.getMrkTickPoint2D(cms.mcidx[1][i], reverse);
                    points[k].status = 2;
                    ++k;
                }
                ++i;
            }
            return points;
        }
        return null;
    }

    public CMrkTickPath[] getCommonMarkerPaths(ChromLayer chromLayer) {
        CMrkTickPoint[] points = this.getCommonMarkerPoints(chromLayer);
        if (points == null) {
            return null;
        }
        CMrkTickPath[] paths = new CMrkTickPath[points.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = new CMrkTickPath();
            paths[i].path = new GeneralPath(0, 4);
            double x1 = points[i].p1.getX();
            double y1 = points[i].p1.getY();
            double w = Math.abs(points[i].p1.getX() - points[i].p2.getX());
            paths[i].path.moveTo((float)x1, (float)y1);
            x1 = points[i].p1.getX() + w * 0.1;
            paths[i].path.lineTo((float)x1, (float)y1);
            x1 = points[i].p2.getX() - w * 0.1;
            y1 = points[i].p2.getY();
            paths[i].path.lineTo((float)x1, (float)y1);
            x1 = points[i].p2.getX();
            paths[i].path.lineTo((float)x1, (float)y1);
            paths[i].status = points[i].status;
            ++i;
        }
        return paths;
    }

    public double getChromWidth() {
        if (this.chromShape != null) {
            return this.chromShape.getChromWidth();
        }
        return 0.0;
    }

    public Point2D getMrkTickPoint2D(int mrkIdx, boolean reverse) {
        if (this.chromShape != null) {
            Point2D p = this.chromShape.getMrkTickPoint2D(mrkIdx, reverse);
            p.setLocation(p.getX() + this.getX(), p.getY() + this.getY());
            return p;
        }
        return null;
    }

    public boolean hasProba() {
        return this.chromosome.proba != null;
    }

    public class CMrkTickPoint {
        Point2D p1;
        Point2D p2;
        int status = 0;
    }

    public class CMrkTickPath {
        GeneralPath path;
        int status;
    }
}

