/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.metaqtl.Chromosome;
import org.metaqtl.MetaDico;
import org.metaqtl.adapter.ChromosomeAdapter;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.bio.entity.factory.MapTabFactory;
import org.metaqtl.bio.entity.factory.XmlGeneticMapFactory;
import org.metaqtl.bio.entity.factory.XmlOntologyFactory;
import org.metaqtl.bio.util.BioUtilities;
import org.metaqtl.factory.MapDBFactory;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;
import org.metaqtl.util.GeneticMapProperties;

public final class MetaDB
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = " Syntaxe: MetaDB [{-e, --exp}]] [{-m, --mapdb}]] [{-q, --qtldb}]] [{-o, --outdir}]] [{-t, --tonto}][{-d, --mrkdico}][{--mrkup}][{--mrkrm}][{--chrm}]" + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        System.out.println("MetaDB, 1.0");
        System.out.println("Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println("MetaDB comes with ABSOLUTELY NO WARRANTY.  ");
        System.out.println("This is free software, and you are welcome  ");
        System.out.println("to redistribute it under certain conditions.");
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-e, --exp     : the location of the experiment table");
        System.out.println("-m, --mapdb   : the location of the directory of the map files");
        System.out.println("-q, --qtldb   : the location of the directory of the qtl files (optional)");
        System.out.println("-o, --outdir  : the location of the output directory");
        System.out.println("-t, --tonto   : the location of the trait ontology");
        System.out.println("-d, --mrkdico : the location of marker dictionary");
        System.out.println("--mrkup : file for updating some marker names.");
        System.out.println("--mrkrm : file for removing some markers.");
        System.out.println("--chrm  : file for removing some chromosomes.");
    }

    public static void main(String[] args) {
        File dir;
        MetaDB program = new MetaDB();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option ainFile = parser.addStringOption('e', "exp");
        CmdLineParser.Option amapDir = parser.addStringOption('m', "mapdb");
        CmdLineParser.Option aqtlDir = parser.addStringOption('q', "qtldb");
        CmdLineParser.Option aoutDir = parser.addStringOption('o', "outdir");
        CmdLineParser.Option aontoFile = parser.addStringOption('t', "tonto");
        CmdLineParser.Option amrkDicoFile = parser.addStringOption('d', "mrkdico");
        CmdLineParser.Option amrkUp = parser.addStringOption("mrkup");
        CmdLineParser.Option amrkRm = parser.addStringOption("mrkrm");
        CmdLineParser.Option achRm = parser.addStringOption("chrm");
        program.parseCmdLine(args);
        String inFile = (String)parser.getOptionValue(ainFile);
        String mapDir = (String)parser.getOptionValue(amapDir);
        String qtlDir = (String)parser.getOptionValue(aqtlDir);
        String outDir = (String)parser.getOptionValue(aoutDir);
        String ontoFile = (String)parser.getOptionValue(aontoFile);
        String mrkDicoFile = (String)parser.getOptionValue(amrkDicoFile);
        String mrkUpFile = (String)parser.getOptionValue(amrkUp);
        String mrkRmFile = (String)parser.getOptionValue(amrkRm);
        String chRmFile = (String)parser.getOptionValue(achRm);
        if (inFile == null) {
            System.err.println("No input file defined : EXIT");
            System.exit(2);
        }
        if (mapDir == null) {
            System.err.println("No map directory defined : EXIT");
            System.exit(2);
        }
        if (outDir == null) {
            System.err.println("No output directory defined : EXIT");
            System.exit(2);
        }
        IBioGenome[] maps = null;
        IBioGenome[] qtls = null;
        try {
            maps = MetaDB.getMaps(inFile, mapDir);
            MetaDB.setQtls(maps, qtlDir);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(5);
        }
        if (mrkDicoFile != null) {
            try {
                MetaDico mrkDico = MetaDB.getDico(mrkDicoFile);
                MetaDB.renameMarkers(maps, mrkDico);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(5);
            }
        }
        int i = 0;
        while (i < maps.length) {
            Chromosome[] chroms = ChromosomeAdapter.toChromosomes(maps[i]);
            int j = 0;
            while (j < chroms.length) {
                chroms[j].updateMappingContext(1, 2);
                ++j;
            }
            IBioGenome map = ChromosomeAdapter.toIBioGenome(chroms, 0);
            map.setName(maps[i].getName());
            GeneticMapProperties.setMappingContext(map, 1, 2);
            GeneticMapProperties.setCrossDesign(map, GeneticMapProperties.getCrossDesign(maps[i]));
            maps[i] = map;
            ++i;
        }
        try {
            if (mrkUpFile != null) {
                MetaDB.updateMarkerNames(maps, mrkUpFile);
            }
            if (mrkRmFile != null) {
                MetaDB.removeLocus(maps, mrkRmFile);
            }
            if (chRmFile != null) {
                MetaDB.removeChromosomes(maps, chRmFile);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(6);
        }
        if (!(dir = new File(outDir)).exists()) {
            dir.mkdirs();
        }
        int i2 = 0;
        while (i2 < maps.length) {
            try {
                MetaDB.writeMap(maps[i2], dir);
            }
            catch (IOException e) {
                System.err.println("[ ERROR ] : Unable to unload map " + maps[i2].getName());
                System.exit(7);
            }
            ++i2;
        }
        if (ontoFile != null) {
            try {
                IBioOntology ontology = MetaDB.getOntology(ontoFile, 't');
                MetaDB.writeOntology(ontology, dir);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(8);
            }
        }
    }

    private static void removeChromosomes(IBioGenome[] maps, String chRmFile) throws IOException {
        Hashtable hash = MetaDB.getChrToRm(new File(chRmFile));
        if (hash == null) {
            return;
        }
        Enumeration iter = hash.keys();
        while (iter.hasMoreElements()) {
            String mapName = (String)iter.nextElement();
            ArrayList chromNames = (ArrayList)hash.get(mapName);
            IBioGenome map = MetaDB.getMap(maps, mapName);
            if (map != null) {
                int i = 0;
                while (i < chromNames.size()) {
                    String chromName = (String)chromNames.get(i);
                    map.removeGroup(chromName);
                    ++i;
                }
                continue;
            }
            System.err.println("[ WARNING ] Unable to find map " + mapName + " : wrong name in " + chRmFile);
        }
    }

    private static Hashtable getChrToRm(File file) throws IOException {
        String line;
        int i = 0;
        Hashtable<String, ArrayList<String>> hash = null;
        ArrayList<String> list = null;
        FileReader reader = new FileReader(file);
        if (reader == null) {
            return null;
        }
        BufferedReader buffer = new BufferedReader(reader);
        while ((line = buffer.readLine()) != null) {
            ++i;
            StringTokenizer token = new StringTokenizer(line, "\t");
            if (token.countTokens() >= 2) {
                String map = token.nextToken();
                String chrom = token.nextToken();
                if (hash == null) {
                    hash = new Hashtable<String, ArrayList<String>>();
                }
                if ((list = (ArrayList<String>)hash.get(map)) == null) {
                    list = new ArrayList<String>();
                }
                list.add(chrom);
                hash.put(map, list);
                continue;
            }
            throw new IOException("[ ERROR ] Unexpected line format at line " + i + " in " + file.getName());
        }
        reader.close();
        return hash;
    }

    private static void updateMarkerNames(IBioGenome[] maps, String mrkUpFile) throws IOException {
        Hashtable hash = MetaDB.getMrkToUp(new File(mrkUpFile));
        if (hash == null) {
            return;
        }
        Enumeration iter = hash.keys();
        while (iter.hasMoreElements()) {
            String mapName = (String)iter.nextElement();
            ArrayList mrkLists = (ArrayList)hash.get(mapName);
            IBioGenome map = MetaDB.getMap(maps, mapName);
            if (map != null) {
                int i = 0;
                while (i < mrkLists.size()) {
                    String chromName = (String)((ArrayList)mrkLists.get(i)).get(0);
                    String mrkName = (String)((ArrayList)mrkLists.get(i)).get(1);
                    String upName = (String)((ArrayList)mrkLists.get(i)).get(2);
                    IBioLGroup chrom = map.getGroup(chromName);
                    if (chrom != null) {
                        IBioLocus locus = chrom.getLocus(mrkName);
                        if (locus != null) {
                            locus.setName(upName);
                            chrom.removeLocus(mrkName);
                            chrom.addLocus(locus);
                        } else {
                            System.err.println("[ WARNING ] Unable to find marker " + mrkName + " : wrong name in " + mrkUpFile);
                        }
                    } else {
                        System.err.println("[ WARNING ] Unable to find chromosome " + chromName + " : wrong name in " + mrkUpFile);
                    }
                    ++i;
                }
                continue;
            }
            System.err.println("[ WARNING ] Unable to find map " + mapName + " : wrong name in " + mrkUpFile);
        }
    }

    private static Hashtable getMrkToUp(File file) throws IOException {
        String line;
        int i = 0;
        Hashtable hash = null;
        ArrayList list = null;
        FileReader reader = new FileReader(file);
        if (reader == null) {
            return null;
        }
        BufferedReader buffer = new BufferedReader(reader);
        while ((line = buffer.readLine()) != null) {
            ++i;
            StringTokenizer token = new StringTokenizer(line, "\t");
            if (token.countTokens() >= 4) {
                String map = token.nextToken();
                String chrom = token.nextToken();
                String marker = token.nextToken();
                String update = token.nextToken();
                if (hash == null) {
                    hash = new Hashtable();
                }
                if ((list = (ArrayList)hash.get(map)) == null) {
                    list = new ArrayList();
                }
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(chrom);
                tmp.add(marker);
                tmp.add(update);
                list.add(tmp);
                hash.put(map, list);
                continue;
            }
            throw new IOException("[ ERROR ] Unexpected line format at line " + i + " in " + file.getName());
        }
        reader.close();
        return hash;
    }

    private static void renameMarkers(IBioGenome[] maps, MetaDico mrkDico) {
        int i = 0;
        while (i < maps.length) {
            IBioLGroup[] groups = maps[i].groups();
            int j = 0;
            while (j < groups.length) {
                IBioLocus[] loci = groups[j].loci();
                int k = 0;
                while (k < loci.length) {
                    String mrkName = mrkDico.getTerm(loci[k].getName());
                    if (mrkName != null) {
                        loci[k].setName(mrkName);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void writeOntology(IBioOntology o, File d) throws IOException {
        if (o == null || d == null) {
            return;
        }
        File outf = new File(String.valueOf(d.getAbsolutePath()) + System.getProperty("file.separator") + "ontology.xml");
        FileOutputStream stream = new FileOutputStream(outf);
        XmlOntologyFactory factory = new XmlOntologyFactory();
        factory.unload((IBioEntity)o, stream);
        stream.close();
    }

    private static void writeMap(IBioGenome genome, File dir) throws IOException {
        if (genome == null) {
            return;
        }
        if (dir == null) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        String outF = String.valueOf(dir.getAbsolutePath()) + System.getProperty("file.separator") + genome.getName() + ".xml";
        FileOutputStream stream = new FileOutputStream(outF);
        XmlGeneticMapFactory xmlFactory = new XmlGeneticMapFactory();
        xmlFactory.unload((IBioEntity)genome, stream);
        stream.close();
    }

    private static IBioGenome[] getMaps(String inFile, String mapDir) throws IOException {
        if (inFile == null) {
            return null;
        }
        if (mapDir == null) {
            return null;
        }
        File dir = new File(mapDir);
        if (!dir.isDirectory()) {
            System.err.println("[ ERROR ] " + mapDir + " is not a directory");
            System.exit(3);
        }
        File[] files = dir.listFiles();
        FileReader reader = new FileReader(inFile);
        IBioGenome[] maps = MapDBFactory.read(reader);
        reader.close();
        MapTabFactory factory = new MapTabFactory();
        int i = 0;
        while (i < maps.length) {
            int j = 0;
            while (j < files.length) {
                if (files[j].getName().startsWith(maps[i].getName())) {
                    reader = new FileReader(files[j]);
                    IBioGenome map = (IBioGenome)factory.load(reader);
                    reader.close();
                    if (map == null) {
                        System.err.println("[ ERROR ] Had trouble when parsing file " + files[j].getAbsolutePath());
                        System.exit(4);
                    }
                    map.setName(maps[i].getName());
                    map.setProperties(maps[i].getProperties());
                    maps[i] = map;
                }
                ++j;
            }
            ++i;
        }
        return maps;
    }

    private static void setQtls(IBioGenome[] maps, String qtlDir) throws IOException {
        if (maps == null) {
            return;
        }
        if (qtlDir == null) {
            return;
        }
        File dir = new File(qtlDir);
        if (!dir.isDirectory()) {
            System.err.println("[ ERROR ] " + qtlDir + " is not a directory");
            System.exit(3);
        }
        File[] files = dir.listFiles();
        MapTabFactory factory = new MapTabFactory();
        int i = 0;
        while (i < maps.length) {
            int j = 0;
            while (j < files.length) {
                if (files[j].getName().startsWith(maps[i].getName())) {
                    FileReader reader = new FileReader(files[j]);
                    IBioGenome qtl = (IBioGenome)factory.load(reader);
                    reader.close();
                    if (qtl == null) {
                        System.err.println("[ ERROR ] Had trouble when parsing file " + files[j].getAbsolutePath());
                        System.exit(4);
                    }
                    BioUtilities.mergeGenome(maps[i], qtl);
                }
                ++j;
            }
            ++i;
        }
    }
}

