/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.bio.entity.factory.BioEntityFactory;
import org.metaqtl.bio.entity.factory.OntologyTabFactory;
import org.metaqtl.bio.entity.factory.XmlOntologyFactory;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public final class Xml2A
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: Xml2A [{-x, --xmlfile}]] [{-t, --type}]] [{-f, --format}]] [{-o, --outfile}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        MetaMain.printLicense("Xml2A", VERSION);
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-x, --xmlfile  : the xml file location.");
        System.out.println("-t, --type     : the xml file type among this list");
        System.out.println("                   - map : a genetic map");
        System.out.println("-f, --format   : the ascii format among this list");
        System.out.println("                   if -t map : ");
        System.out.println("                            - tab   : Tabulated format");
        System.out.println("                            - mch   : MapChart  format");
        System.out.println("                            - mmk   : MapMaker  format");
        System.out.println("-o, --outfile  : the stem name for output files");
    }

    public static void main(String[] args) {
        Xml2A program = new Xml2A();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option axmlFile = parser.addStringOption('x', "xmlfile");
        CmdLineParser.Option atype = parser.addStringOption('t', "type");
        CmdLineParser.Option aformat = parser.addStringOption('f', "format");
        CmdLineParser.Option aoutFile = parser.addStringOption('o', "outfile");
        program.parseCmdLine(args);
        String xmlFile = (String)parser.getOptionValue(axmlFile);
        String type = (String)parser.getOptionValue(atype);
        String format = (String)parser.getOptionValue(aformat);
        String outFile = (String)parser.getOptionValue(aoutFile);
        if (xmlFile == null) {
            System.err.println("No xml file defined");
            System.exit(2);
        }
        if (type == null) {
            System.err.println("No xml type defined");
            System.exit(2);
        }
        if (outFile == null) {
            System.err.println("No input file defined");
            System.exit(2);
        }
        IBioEntity xmlObject = null;
        try {
            if (type.equals("map")) {
                if (format == null) {
                    System.err.println("No input ascii format defined");
                    System.exit(2);
                }
                xmlObject = Xml2A.getMap(xmlFile);
            } else if (type.equals("onto")) {
                XmlOntologyFactory factory = new XmlOntologyFactory();
                FileReader reader = new FileReader(xmlFile);
                xmlObject = ((BioEntityFactory)factory).load(reader);
                reader.close();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (xmlObject == null) {
            System.err.println("Unable to load xml file from " + xmlFile);
            System.exit(4);
        }
        try {
            if (type.equals("map")) {
                Xml2A.writeMap(xmlObject, format, outFile);
            } else if (type.equals("onto")) {
                FileWriter writer = new FileWriter(outFile);
                OntologyTabFactory factory = new OntologyTabFactory();
                ((BioEntityFactory)factory).unload((IBioEntity)((IBioOntology)xmlObject), writer);
                writer.close();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(5);
        }
        System.exit(0);
    }
}

