/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.util;

import org.metaqtl.numrec.NumericalUtilities;

public final class OffspringManager {
    public static double fisherVariance(double r, int size, int type, int gen) {
        double var = 0.0;
        if (type == 1) {
            var = r * (1.0 - r) / (double)size;
        } else if (type == 3) {
            var = r * (1.0 + 6.0 * r) * (1.0 + 6.0 * r) * (1.0 + 2.0 * r) / (4.0 * (double)size);
        } else if (type == 2) {
            var = r * (1.0 + 2.0 * r) * (1.0 + 2.0 * r) / (2.0 * (double)size);
        } else if (type == 4) {
            if (gen == 2) {
                var = r * (1.0 - r) * (1.0 - 2.0 * r + 2.0 * r * r);
                var /= 2.0 * (double)size * (1.0 - 3.0 * r + 3.0 * r * r);
            } else if (gen > 2) {
                HaldaneWaddingtonProportion p = new OffspringManager().new HaldaneWaddingtonProportion();
                int g = 1;
                do {
                    OffspringManager.selfingRecurrence(p, r);
                } while (++g < gen);
                var = OffspringManager.selfingIndividualInformation(p);
                var = 1.0 / (var * (double)size);
            }
        } else if (type == 5) {
            if (gen == 2) {
                var = r * (1.0 - r) * (1.0 - 2.0 * r + 2.0 * r * r);
                var /= 2.0 * (double)size * (1.0 - 3.0 * r + 3.0 * r * r);
            } else if (gen > 2) {
                double tmp = Math.pow(1.0 - r, 4 * (gen - 1));
                var = 1.0 - Math.pow(1.0 - 2.0 * r, 4.0) * tmp;
                var /= Math.pow(1.0 - r, 2 * (gen - 1) - 2);
                var /= Math.pow(2.0 * (1.0 - r) + (double)(gen - 1) * (1.0 - 2.0 * r), 2.0);
                tmp = Math.pow(1.0 - r, 2 * (gen - 1));
                var /= 1.0 + 3.0 * (1.0 - 2.0 * r) * (1.0 - 2.0 * r) * tmp;
                var /= (double)size;
            }
        } else if (type == 7) {
            OffspringManager offspringManager = new OffspringManager();
            offspringManager.getClass();
            IRISEFunction func1 = offspringManager.new IRISEFunction();
            func1.t = gen;
            double R = OffspringManager.r2R(r, type, gen);
            var = OffspringManager.fisherVariance(R, size, 1, gen);
            double tmp = Math.min(R, 0.5 - R) / 10000.0;
            NumericalUtilities.dfridr(func1, R, tmp);
            tmp = func1.getDF();
            var *= tmp * tmp;
        } else if (type == 8) {
            OffspringManager offspringManager = new OffspringManager();
            offspringManager.getClass();
            IRISIFunction func1 = offspringManager.new IRISIFunction();
            func1.t = gen;
            double R = OffspringManager.r2R(r, type, gen);
            var = OffspringManager.fisherVariance(R, size, 1, gen);
            double tmp = Math.min(R, 0.5 - R) / 10000.0;
            NumericalUtilities.dfridr(func1, R, tmp);
            tmp = func1.getDF();
            var *= tmp * tmp;
        } else if (type == 0) {
            var = OffspringManager.fisherVariance(r, size, 1, gen);
        }
        return var;
    }

    public static void selfingRecurrence(HaldaneWaddingtonProportion p, double r) {
        double C = p.C + 0.5 * p.E + 0.25 * (1.0 - r) * (1.0 - r) * p.F + 0.25 * r * r * p.G;
        double D = p.D + 0.5 * p.E + 0.25 * r * r * p.F + 0.25 * (1.0 - r) * (1.0 - r) * p.G;
        double E = 0.5 * p.E + 0.5 * r * (1.0 - r) * (p.F + p.G);
        double F = 0.5 * (1.0 - r) * (1.0 - r) * p.F + 0.5 * r * r * p.G;
        double G = 0.5 * r * r * p.F + 0.5 * (1.0 - r) * (1.0 - r) * p.G;
        double dC = p.dC + 0.5 * p.dE - 0.5 * (1.0 - r) * p.F + 0.25 * (1.0 - r) * (1.0 - r) * p.dF + 0.5 * r * p.G + 0.25 * r * r * p.dG;
        double dD = p.dD + 0.5 * p.dE + 0.5 * r * p.F + 0.25 * r * r * p.dF - 0.5 * (1.0 - r) * p.G + 0.25 * (1.0 - r) * (1.0 - r) * p.dG;
        double dE = 0.5 * p.dE + 0.5 * (1.0 - 2.0 * r) * (p.F + p.G) + 0.5 * r * (1.0 - r) * (p.dF + p.dG);
        double dF = (r - 1.0) * p.F + 0.5 * (1.0 - r) * (1.0 - r) * p.dF + r * p.G + 0.5 * r * r * p.dG;
        double dG = (r - 1.0) * p.G + 0.5 * (1.0 - r) * (1.0 - r) * p.dG + r * p.F + 0.5 * r * r * p.dF;
        p.C = C;
        p.D = D;
        p.E = E;
        p.F = F;
        p.G = G;
        p.dC = dC;
        p.dD = dD;
        p.dE = dE;
        p.dF = dF;
        p.dG = dG;
    }

    public static double selfingIndividualInformation(HaldaneWaddingtonProportion p) {
        double ir = 0.0;
        double m1 = p.C / 1.0;
        double m2 = p.D / 1.0;
        double m3 = p.E / 2.0;
        double m4 = p.F / 0.5;
        m4 += p.G / 0.5;
        double dm1 = p.dC;
        if (m1 == 0.0) {
            dm1 = 0.0;
            m1 = 1.0;
        }
        double dm2 = p.dD;
        if (m2 == 0.0) {
            dm2 = 0.0;
            m2 = 1.0;
        }
        double dm3 = p.dE;
        if (m3 == 0.0) {
            dm3 = 0.0;
            m3 = 1.0;
        }
        double dm4 = p.dF + p.dG;
        if (m4 == 0.0) {
            dm4 = 0.0;
            m4 = 1.0;
        }
        ir = dm1 * dm1 / m1;
        ir += dm2 * dm2 / m2;
        ir += dm3 * dm3 / m3;
        return ir += dm4 * dm4 / m4;
    }

    public static double R2r(double R, int type, int gen) {
        double r = 0.0;
        if (R == 0.0) {
            return 0.0;
        }
        if (R == 0.5) {
            return 0.5;
        }
        switch (type) {
            case 2: {
                r = R / (2.0 * (1.0 - R));
                break;
            }
            case 3: {
                r = R / (4.0 - 6.0 * R);
                break;
            }
            case 5: {
                OffspringManager offspringManager = new OffspringManager();
                offspringManager.getClass();
                IRFunction func0 = offspringManager.new IRFunction();
                func0.t = gen;
                r = func0.func(R);
                break;
            }
            case 7: {
                OffspringManager offspringManager = new OffspringManager();
                offspringManager.getClass();
                IRISEFunction func1 = offspringManager.new IRISEFunction();
                func1.t = gen;
                r = func1.func(R);
                break;
            }
            case 8: {
                OffspringManager offspringManager = new OffspringManager();
                offspringManager.getClass();
                IRISIFunction func2 = offspringManager.new IRISIFunction();
                func2.t = gen;
                r = func2.func(R);
                break;
            }
            default: {
                r = R;
            }
        }
        return r;
    }

    public static double r2R(double r, int type, int gen) {
        double R = 0.0;
        if (r == 0.0) {
            return 0.0;
        }
        if (r == 0.5) {
            return 0.5;
        }
        switch (type) {
            case 2: {
                R = 2.0 * r / (1.0 + 2.0 * r);
                break;
            }
            case 3: {
                R = 4.0 * r / (1.0 + 6.0 * r);
                break;
            }
            case 5: {
                R = 0.5 * (1.0 - Math.pow(1.0 - r, gen) * (1.0 - 2.0 * r));
            }
            case 7: {
                R = 0.5 * (1.0 - (1.0 - 2.0 * r) / (1.0 + 2.0 * r) * Math.pow(1.0 - r, gen));
                break;
            }
            case 8: {
                R = 0.5 * (1.0 - (1.0 - 2.0 * r) / (1.0 + 6.0 * r) * Math.pow(1.0 - r, gen));
                break;
            }
            default: {
                R = r;
            }
        }
        return R;
    }

    private class IRFunction
    implements NumericalUtilities.Function {
        int t;
        double df;
        IRPolynome func1;

        private IRFunction() {
            OffspringManager offspringManager2 = new OffspringManager();
            offspringManager2.getClass();
            this.func1 = offspringManager2.new IRPolynome();
        }

        public double func(double x) {
            this.func1.R = x;
            this.func1.t = this.t;
            double r = NumericalUtilities.rtsafe(this.func1, 0.5, 1.0, 1.0E-8);
            return 1.0 - r;
        }

        public double getDF() {
            return this.df;
        }

        public void setDF(double df) {
            this.df = df;
        }
    }

    private class IRISEFunction
    implements NumericalUtilities.Function {
        int t;
        double df;
        IRISEPolynome func1;

        private IRISEFunction() {
            OffspringManager offspringManager2 = new OffspringManager();
            offspringManager2.getClass();
            this.func1 = offspringManager2.new IRISEPolynome();
        }

        public double func(double x) {
            this.func1.R = x;
            this.func1.t = this.t;
            double r = NumericalUtilities.rtsafe(this.func1, 0.5, 1.0, 1.0E-8);
            return 1.0 - r;
        }

        public double getDF() {
            return this.df;
        }

        public void setDF(double df) {
            this.df = df;
        }
    }

    private class IRISIFunction
    implements NumericalUtilities.Function {
        int t;
        double df;
        IRISIPolynome func1;

        private IRISIFunction() {
            OffspringManager offspringManager2 = new OffspringManager();
            offspringManager2.getClass();
            this.func1 = offspringManager2.new IRISIPolynome();
        }

        public double func(double x) {
            this.func1.R = x;
            this.func1.t = this.t;
            double r = NumericalUtilities.rtsafe(this.func1, 0.5, 1.0, 1.0E-8);
            return 1.0 - r;
        }

        public double getDF() {
            return this.df;
        }

        public void setDF(double df) {
            this.df = df;
        }
    }

    private class IRPolynome
    implements NumericalUtilities.NRFunction {
        public double f;
        public double df;
        public int t = 0;
        public double R = 0.0;

        private IRPolynome() {
        }

        public void funcd(double x) {
            this.f = 2.0 * Math.pow(x, this.t + 1) - Math.pow(x, this.t) + (2.0 * this.R - 1.0);
            this.df = 2.0 * (double)(this.t + 1) * Math.pow(x, this.t) - (double)this.t * Math.pow(x, this.t - 1);
        }

        public double getF() {
            return this.f;
        }

        public double getDF() {
            return this.df;
        }
    }

    private class IRISEPolynome
    implements NumericalUtilities.NRFunction {
        public double f;
        public double df;
        public int t = 0;
        public double R = 0.0;

        private IRISEPolynome() {
        }

        public void funcd(double x) {
            this.f = 2.0 * Math.pow(x, this.t + 1) - Math.pow(x, this.t) + (2.0 - 4.0 * this.R) * x + 3.0 * (2.0 * this.R - 1.0);
            this.df = 2.0 * (double)(this.t + 1) * Math.pow(x, this.t) - (double)this.t * Math.pow(x, this.t - 1) + (2.0 - 4.0 * this.R);
        }

        public double getF() {
            return this.f;
        }

        public double getDF() {
            return this.df;
        }
    }

    private class IRISIPolynome
    implements NumericalUtilities.NRFunction {
        public double f;
        public double df;
        public int t = 0;
        public double R = 0.0;

        private IRISIPolynome() {
        }

        public void funcd(double x) {
            this.f = 2.0 * Math.pow(x, this.t + 1) - Math.pow(x, this.t) + 6.0 * (1.0 - 2.0 * this.R) * x + 7.0 * (2.0 * this.R - 1.0);
            this.df = 2.0 * (double)(this.t + 1) * Math.pow(x, this.t) - (double)this.t * Math.pow(x, this.t - 1) + 6.0 * (1.0 - 2.0 * this.R);
        }

        public double getF() {
            return this.f;
        }

        public double getDF() {
            return this.df;
        }
    }

    public class HaldaneWaddingtonProportion {
        public static final double C_coeff = 1.0;
        public static final double D_coeff = 1.0;
        public static final double E_coeff = 2.0;
        public static final double F_coeff = 0.5;
        public static final double G_coeff = 0.5;
        public double C = 0.0;
        public double D = 0.0;
        public double E = 0.0;
        public double F = 2.0;
        public double G = 0.0;
        public double dC = 0.0;
        public double dD = 0.0;
        public double dE = 0.0;
        public double dF = 0.0;
        public double dG = 0.0;
    }
}

