/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.HashMap;
import java.util.HashSet;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IClass;
import org.jibx.binding.model.ValidationContext;

public class ClassHierarchyContext {
    private final ClassHierarchyContext m_outerContext;
    private HashMap m_typeToComponentMap;
    private HashSet m_compatibleTypeSet;
    private HashMap m_nameToComponentMap;

    protected ClassHierarchyContext(ClassHierarchyContext outer) {
        this.m_outerContext = outer;
        this.m_typeToComponentMap = new HashMap();
        this.m_compatibleTypeSet = new HashSet();
        this.m_nameToComponentMap = new HashMap();
    }

    public ClassHierarchyContext getContaining() {
        return this.m_outerContext;
    }

    public void addTypedComponent(IClass clas, ElementBase comp, ValidationContext vctx) {
        String type = clas.getName();
        if (this.m_typeToComponentMap.put(type, comp) == null) {
            String[] interfaces = clas.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.m_compatibleTypeSet.add(interfaces[i]);
            }
            IClass sclas = clas;
            do {
                this.m_compatibleTypeSet.add(sclas.getName());
            } while ((sclas = sclas.getSuperClass()) != null);
        } else {
            vctx.addError("Duplicate conversion defined for type " + type, comp);
        }
    }

    public void addNamedComponent(String label, ElementBase comp, ValidationContext vctx) {
        if (this.m_nameToComponentMap.put(label, comp) != null) {
            vctx.addError("Duplicate label " + label, comp);
        }
    }

    public ElementBase getSpecificComponent(String name) {
        ElementBase comp = null;
        if (this.m_typeToComponentMap != null) {
            comp = (ElementBase)this.m_typeToComponentMap.get(name);
        }
        if (comp == null && this.m_outerContext != null) {
            comp = this.m_outerContext.getSpecificComponent(name);
        }
        return comp;
    }

    public ElementBase getNamedComponent(String name) {
        ElementBase comp = null;
        if (this.m_nameToComponentMap != null) {
            comp = (FormatElement)this.m_nameToComponentMap.get(name);
        }
        if (comp == null && this.m_outerContext != null) {
            comp = this.m_outerContext.getNamedComponent(name);
        }
        return comp;
    }

    public ElementBase getBestComponent(IClass clas) {
        IClass sclas;
        ElementBase comp = this.getSpecificComponent(clas.getName());
        while (comp == null && (sclas = clas.getSuperClass()) != null) {
            clas = sclas;
            comp = this.getSpecificComponent(clas.getName());
        }
        return comp;
    }

    public boolean isCompatibleType(IClass clas) {
        if (this.m_compatibleTypeSet.contains(clas.getName())) {
            return true;
        }
        if (this.m_outerContext != null) {
            return this.m_outerContext.isCompatibleType(clas);
        }
        return false;
    }
}

