/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import org.metaqtl.MetaQtlModel;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.Qtl;

public class MetaQtlAnalysis {
    public int nchr;
    public String[] chromNames;
    public Qtl[][] qtlByChrom;
    public MetaQtlResult[][] resultByChrom;

    public MetaQtlAnalysis(int nchr) {
        this.nchr = nchr;
        this.chromNames = new String[nchr];
        this.qtlByChrom = new Qtl[nchr][];
        this.resultByChrom = new MetaQtlResult[nchr][];
    }

    public MetaQtlResult getResult(String chrom, String trait) {
        int i = this.getChromIdx(chrom);
        if (i < this.chromNames.length) {
            int j = 0;
            while (j < this.resultByChrom[i].length) {
                if (this.resultByChrom[i][j].trait.equals(trait)) {
                    return this.resultByChrom[i][j];
                }
                ++j;
            }
        }
        return null;
    }

    public MetaQtlResult getResult(String chrom) {
        int i = this.getChromIdx(chrom);
        if (i < this.chromNames.length) {
            return this.resultByChrom[i][0];
        }
        return null;
    }

    public MetaQtlResult getResult(int chromIdx, String trait) {
        if (chromIdx < this.chromNames.length) {
            int j = 0;
            while (j < this.resultByChrom[chromIdx].length) {
                if (this.resultByChrom[chromIdx][j].trait.equals(trait)) {
                    return this.resultByChrom[chromIdx][j];
                }
                ++j;
            }
        }
        return null;
    }

    public int getChromIdx(String chrom) {
        int i = 0;
        while (i < this.chromNames.length) {
            if (this.chromNames[i].equals(chrom)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getTraitIdx(int chromIdx, String trait) {
        if (chromIdx >= 0 && chromIdx < this.nchr) {
            int j = 0;
            while (j < this.resultByChrom[chromIdx].length) {
                if (this.resultByChrom[chromIdx][j].trait.equals(trait)) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    public Qtl[] getMetaQtl(String chrom, String trait, int k) {
        int cidx = this.getChromIdx(chrom);
        int tidx = this.getTraitIdx(cidx, trait);
        if (tidx != -1) {
            return this.resultByChrom[cidx][tidx].getMetaQtl(k);
        }
        return null;
    }

    public MetaQtlModel getBestModel(int criterion) {
        MetaQtlModel model = null;
        model = new MetaQtlModel(this.nchr);
        int i = 0;
        while (i < this.nchr) {
            String[] traits = new String[this.resultByChrom[i].length];
            int[] models = new int[this.resultByChrom[i].length];
            int j = 0;
            while (j < this.resultByChrom[i].length) {
                traits[j] = this.resultByChrom[i][j].getTraitName();
                System.out.println(String.valueOf(this.chromNames[i]) + " " + traits[j]);
                models[j] = this.resultByChrom[i][j].getBestClustering((int)criterion).k;
                ++j;
            }
            model.setChromName(i, this.chromNames[i]);
            model.setTraitNames(i, traits);
            model.setModel(i, models);
            ++i;
        }
        return model;
    }

    public MetaQtlResult[] getResults(String chromName) {
        int cidx = this.getChromIdx(chromName);
        if (cidx >= 0) {
            return this.resultByChrom[cidx];
        }
        return null;
    }
}

