/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import org.metaqtl.Tree;
import org.metaqtl.TreeNode;

public class HClustAlgorithm {
    public static final int CENTROID_METHOD = 1;
    public static final int WARD_METHOD = 2;
    public static int METHOD = 1;

    public static Tree run(double[] x, double[] sd) {
        switch (METHOD) {
            case 1: {
                return HClustAlgorithm.CentroidMethod(x, sd);
            }
            case 2: {
                return HClustAlgorithm.WardMethod(x, sd);
            }
        }
        return HClustAlgorithm.CentroidMethod(x, sd);
    }

    public static Tree CentroidMethod(double[] x, double[] sd) {
        int n;
        TreeNode[] nodes = null;
        int k = n = x.length;
        nodes = new TreeNode[2 * n - 1];
        double[] xx = new double[n];
        double[] var2 = new double[n];
        double[] var = new double[n];
        int i = 0;
        while (i < n) {
            nodes[i] = new TreeNode(i);
            xx[i] = x[i];
            var2[i] = var[i] = sd[i] * sd[i];
            ++i;
        }
        int iter = 0;
        while (iter < n - 1) {
            int ii;
            double t;
            int minj = -1;
            int mini = -1;
            double dmin = Double.POSITIVE_INFINITY;
            i = 0;
            while (i < k) {
                int j = i + 1;
                while (j < k) {
                    t = (xx[i] - xx[j]) * (xx[i] - xx[j]);
                    if (Math.sqrt(t /= var2[i] + var2[j]) < dmin) {
                        dmin = Math.sqrt(t);
                        mini = i;
                        minj = j;
                    }
                    ++j;
                }
                ++i;
            }
            t = 0.0;
            double s = 0.0;
            double wi = 0.0;
            double wj = 0.0;
            i = 0;
            while (i < nodes[mini].card) {
                ii = nodes[mini].nidx[i];
                t += x[ii] / var[ii];
                s += 1.0 / var[ii];
                wi += var[ii];
                ++i;
            }
            i = 0;
            while (i < nodes[minj].card) {
                ii = nodes[minj].nidx[i];
                t += x[ii] / var[ii];
                s += 1.0 / var[ii];
                wj += var[ii];
                ++i;
            }
            nodes[mini].dist = dmin * wi / (wi + wj);
            nodes[minj].dist = dmin * wj / (wi + wj);
            TreeNode[] children = new TreeNode[]{nodes[mini], nodes[minj]};
            nodes[n + iter] = new TreeNode(n + iter, children);
            nodes[Math.min((int)mini, (int)minj)] = nodes[n + iter];
            xx[Math.min((int)mini, (int)minj)] = t / s;
            var2[Math.min((int)mini, (int)minj)] = 1.0 / s;
            i = Math.max(mini, minj);
            while (i < k - 1) {
                xx[i] = xx[i + 1];
                var2[i] = var2[i + 1];
                nodes[i] = nodes[i + 1];
                ++i;
            }
            --k;
            ++iter;
        }
        Tree tree = new Tree();
        tree.nodes = nodes;
        tree.root = nodes[nodes.length - 1];
        return tree;
    }

    public static Tree WardMethod(double[] x, double[] sd) {
        int n;
        TreeNode[] nodes = null;
        int k = n = x.length;
        nodes = new TreeNode[2 * n - 1];
        double[] var = new double[n];
        int i = 0;
        while (i < n) {
            nodes[i] = new TreeNode(i);
            var[i] = sd[i] * sd[i];
            ++i;
        }
        int iter = 0;
        while (iter < n - 1) {
            int minj = -1;
            int mini = -1;
            double min = Double.POSITIVE_INFINITY;
            i = 0;
            while (i < k) {
                int j = i + 1;
                while (j < k) {
                    int l;
                    double s = 0.0;
                    double t = 0.0;
                    int ii = 0;
                    while (ii < nodes[i].card) {
                        l = nodes[i].nidx[ii];
                        t += x[l] / var[l];
                        s += 1.0 / var[l];
                        ++ii;
                    }
                    ii = 0;
                    while (ii < nodes[j].card) {
                        l = nodes[j].nidx[ii];
                        t += x[l] / var[l];
                        s += 1.0 / var[l];
                        ++ii;
                    }
                    t /= s;
                    double chi = 0.0;
                    ii = 0;
                    while (ii < nodes[i].card) {
                        l = nodes[i].nidx[ii];
                        chi += (x[l] - t) * (x[l] - t) / var[l];
                        ++ii;
                    }
                    ii = 0;
                    while (ii < nodes[j].card) {
                        l = nodes[j].nidx[ii];
                        chi += (x[l] - t) * (x[l] - t) / var[l];
                        ++ii;
                    }
                    if ((chi /= s) < min) {
                        min = chi;
                        mini = i;
                        minj = j;
                    }
                    ++j;
                }
                ++i;
            }
            TreeNode[] children = new TreeNode[2];
            nodes[mini].dist = min * 0.5;
            nodes[minj].dist = min * 0.5;
            children[0] = nodes[mini];
            children[1] = nodes[minj];
            nodes[n + iter] = new TreeNode(n + iter, children);
            nodes[Math.min((int)mini, (int)minj)] = nodes[n + iter];
            i = Math.max(mini, minj);
            while (i < k - 1) {
                nodes[i] = nodes[i + 1];
                ++i;
            }
            --k;
            ++iter;
        }
        Tree tree = new Tree();
        tree.nodes = nodes;
        tree.root = nodes[nodes.length - 1];
        return tree;
    }
}

