/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import java.util.ArrayList;
import org.metaqtl.CMarkerSequence;
import org.metaqtl.ChromCluster;
import org.metaqtl.Chromosome;
import org.metaqtl.MapCluster;
import org.metaqtl.Qtl;
import org.metaqtl.algo.CMSAlgorithm;
import org.metaqtl.algo.MetaAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.numrec.NumericalUtilities;
import org.metaqtl.util.MappingFunction;
import org.metaqtl.util.OffspringManager;

public class QtlProjAlgorithm
extends MetaAlgorithm {
    private int _qidx;
    private int _chridx;
    private int _clustidx;
    private MapCluster mapCluster = new MapCluster();
    private Qtl[][] qtlMatrix;
    private Chromosome[] skeletons;
    private int nshare;
    private double alpha = 0.05;
    private double ratio = 0.5;
    public int sd_mode = 4;

    public QtlProjAlgorithm(IBioGenome[] maps, IBioGenome skeleton, IBioLocus[] dubious) {
        this.mapCluster.setDubiousMarker(dubious);
        int i = 0;
        while (i < maps.length) {
            this.mapCluster.addMap(maps[i], false);
            ++i;
        }
        if (skeleton != null) {
            this.mapCluster.addMap(skeleton, true);
        }
    }

    public Chromosome[] getResult() {
        ChromCluster[] chrClusters = this.mapCluster.getClusters();
        Chromosome[] out = new Chromosome[chrClusters.length];
        while (this.hasNextCluster(chrClusters)) {
            ChromCluster cluster = this.nextCluster(chrClusters);
            Chromosome skeleton = this.getSkeleton();
            if (skeleton.hasQTL()) {
                int np = this.getProjQtlNumber();
                Qtl[] tmp = new Qtl[skeleton.getQtlNumber() + np];
                int i = 0;
                while (i < skeleton.getQtlNumber()) {
                    tmp[i] = skeleton.qtls[i];
                    ++i;
                }
                i = 0;
                while (i < np) {
                    tmp[i + skeleton.getQtlNumber()] = this.getProjQtl(i);
                    ++i;
                }
                skeleton.qtls = tmp;
            } else {
                skeleton.qtls = this.getProjQtls();
            }
            out[this._clustidx - 1] = skeleton;
        }
        return out;
    }

    public void run() {
        if (this.mapCluster != null) {
            ChromCluster[] chrClusters = this.mapCluster.getClusters();
            this.initWorkSpace(chrClusters);
            this.initProjection(chrClusters);
            this.checkProjection(chrClusters);
            this.doProjection(chrClusters);
        }
    }

    private Qtl[] getProjQtls() {
        Qtl[] qtls = null;
        ArrayList<Qtl> list = new ArrayList<Qtl>();
        if (this.qtlMatrix[this._clustidx - 1] == null) {
            return null;
        }
        int i = 0;
        while (i < this.qtlMatrix[this._clustidx - 1].length) {
            if (!this.qtlMatrix[this._clustidx - 1][i].isIgnore()) {
                list.add(this.qtlMatrix[this._clustidx - 1][i]);
            }
            ++i;
        }
        if (list.size() > 0) {
            qtls = new Qtl[list.size()];
            list.toArray(qtls);
        }
        return qtls;
    }

    private Qtl getProjQtl(int i) {
        int np = 0;
        int j = 0;
        while (j < this.qtlMatrix[this._clustidx - 1].length) {
            if (!this.qtlMatrix[this._clustidx - 1][j].isIgnore()) {
                if (np == i) {
                    return this.qtlMatrix[this._clustidx - 1][j];
                }
                ++np;
            }
            ++j;
        }
        return null;
    }

    private int getProjQtlNumber() {
        int np = 0;
        int i = 0;
        while (i < this.qtlMatrix[this._clustidx - 1].length) {
            if (!this.qtlMatrix[this._clustidx - 1][i].isIgnore()) {
                ++np;
            }
            ++i;
        }
        return np;
    }

    private void initWorkSpace(ChromCluster[] chromClusters) {
        this._qidx = 0;
        this._chridx = 0;
        this._clustidx = 0;
        this.nshare = 0;
        this.qtlMatrix = new Qtl[chromClusters.length][];
        this.skeletons = new Chromosome[chromClusters.length];
    }

    private void initProjection(ChromCluster[] chromClusters) {
        while (this.hasNextCluster(chromClusters)) {
            ChromCluster cluster = this.nextCluster(chromClusters);
            this.initCluster(cluster);
        }
    }

    private void initCluster(ChromCluster cluster) {
        if (cluster == null) {
            return;
        }
        Chromosome[] chromosomes = cluster.getClusterMembers();
        this.initSkeleton(chromosomes);
        Chromosome skeleton = this.getSkeleton();
        int nqtl = this.getQtlNumber(chromosomes, skeleton);
        if (nqtl == 0) {
            return;
        }
        this.initQtlMatrix(nqtl);
        while (this.hasNextChromosome(chromosomes)) {
            Chromosome chromosome = this.nextChromosome(chromosomes);
            Qtl[] qtls = this.initChromosome(chromosome, skeleton);
            this.setQtlMatrix(qtls);
        }
    }

    private Qtl[] initChromosome(Chromosome chromosome, Chromosome skeleton) {
        chromosome.computeQtlSD(this.sd_mode);
        Qtl[] qtls = chromosome.getQtls();
        CMarkerSequence cms = CMSAlgorithm.run(chromosome, skeleton);
        if (cms == null) {
            if (this.isLoggerEnable()) {
                this.getLogger().println("[ WARNING ] No common markers for " + chromosome.getMapName() + " on chromosome " + chromosome.getName());
            }
            int l = 0;
            while (l < qtls.length) {
                qtls[l].setIgnore(true);
                ++l;
            }
            return qtls;
        }
        int ch_mrkIdxL = cms.mcidx[0][0];
        int ch_mrkIdxR = cms.mcidx[0][cms.nmc - 1];
        int l = 0;
        while (l < qtls.length) {
            if (ch_mrkIdxL > 0 && chromosome.areMarkersAroundQTL(0, ch_mrkIdxL, l)) {
                qtls[l].setIgnore(true);
            }
            if (ch_mrkIdxR < chromosome.nm - 1 && chromosome.areMarkersAroundQTL(ch_mrkIdxR, chromosome.nm - 1, l)) {
                qtls[l].setIgnore(true);
            }
            if (qtls[l].isIgnore() && this.isLoggerEnable()) {
                this.getLogger().println("[ WARNING ] Unable to project QTL " + qtls[l].getName() + " on chromosome " + chromosome.getName());
            }
            ++l;
        }
        int j = 0;
        while (j < cms.ncs) {
            int k = 0;
            while (k < cms.css[j] - 1) {
                int tmp;
                int sk_mrkIdxL = cms.idx2[j][k];
                int sk_mrkIdxR = cms.idx2[j][k + 1];
                ch_mrkIdxL = cms.idx1[j][k];
                ch_mrkIdxR = cms.idx1[j][k + 1];
                boolean swap = false;
                if (sk_mrkIdxL > sk_mrkIdxR) {
                    tmp = sk_mrkIdxR;
                    sk_mrkIdxR = sk_mrkIdxL;
                    sk_mrkIdxL = tmp;
                    swap = true;
                }
                if (ch_mrkIdxL > ch_mrkIdxR) {
                    tmp = ch_mrkIdxR;
                    ch_mrkIdxR = ch_mrkIdxL;
                    ch_mrkIdxL = tmp;
                    swap = !swap;
                }
                l = 0;
                while (l < chromosome.qtls.length) {
                    if (!qtls[l].isIgnore()) {
                        if (qtls[l].proj == null) {
                            qtls[l].proj = qtls[l].new Qtl.QTLProj();
                            qtls[l].proj.mapOrigin = chromosome.getMapName();
                        }
                        this.updateQtlScale(qtls[l], chromosome, ch_mrkIdxL, ch_mrkIdxR, skeleton, sk_mrkIdxL, sk_mrkIdxR);
                        if (!qtls[l].proj.shareFlanking) {
                            qtls[l].proj.shareFlanking = chromosome.areMarkersAroundQTL(ch_mrkIdxL, ch_mrkIdxR, l);
                            if (qtls[l].proj.shareFlanking) {
                                this.setQtlFlanking(qtls[l], chromosome, ch_mrkIdxL, ch_mrkIdxR, skeleton, sk_mrkIdxL, sk_mrkIdxR, swap);
                            }
                        }
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        return qtls;
    }

    public void checkProjection(ChromCluster[] chromClusters) {
        while (this.hasNextCluster(chromClusters)) {
            ChromCluster cluster = this.nextCluster(chromClusters);
            this.checkCluster(cluster);
        }
    }

    private void checkCluster(ChromCluster cluster) {
        if (cluster == null) {
            return;
        }
        Chromosome[] chromosomes = cluster.getClusterMembers();
        Chromosome skeleton = this.getSkeleton();
        while (this.hasNextChromosome(chromosomes)) {
            Chromosome chromosome = this.nextChromosome(chromosomes);
            this.checkChromosome(chromosome, skeleton);
        }
    }

    private void checkChromosome(Chromosome chromosome, Chromosome skeleton) {
        Qtl[] qtls = this.getQtlToProject(chromosome);
        int i = 0;
        while (i < qtls.length) {
            if (!qtls[i].isIgnore()) {
                Qtl.QTLProj projPar = qtls[i].proj;
                if (qtls[i].proj != null) {
                    if (!projPar.shareFlanking) {
                        qtls[i].setIgnore(!this.findFlanking(chromosome, skeleton, qtls[i]));
                    }
                } else {
                    qtls[i].setIgnore(true);
                    if (this.isLoggerEnable()) {
                        this.getLogger().println("[ WARNING ] : Unable to project QTL " + qtls[i].getName() + " on chromosome " + chromosome.getName());
                        this.getLogger().flush();
                    }
                }
                if (!qtls[i].isIgnore()) {
                    this.checkFlanking(chromosome, skeleton, qtls[i]);
                } else if (this.isLoggerEnable()) {
                    this.getLogger().println("[ WARNING ] : Unable to project QTL " + qtls[i].getName() + " on chromosome " + chromosome.getName());
                    this.getLogger().flush();
                }
            }
            ++i;
        }
    }

    private boolean findFlanking(Chromosome chromosome, Chromosome skeleton, Qtl qtl) {
        int ch_mrkIdxR;
        int m;
        int l;
        int j;
        boolean swap = false;
        boolean ok = false;
        CMarkerSequence cms = CMSAlgorithm.run(chromosome, skeleton);
        int ch_mrkIdxL = cms.getMarkerIdx(0, 0, 0);
        if (ch_mrkIdxL >= qtl.m2) {
            j = 0;
            while (j < cms.nmc) {
                if (cms.mcidx[0][j] <= qtl.m1) break;
                ++j;
            }
            l = 0;
            while (l < cms.ncs) {
                m = 0;
                while (m < cms.css[l]) {
                    if (cms.mcidx[1][j] == cms.getMarkerIdx(0, l, m)) break;
                    ++m;
                }
                ++l;
            }
            if (l == cms.ncs) {
                int ch_mrkIdxR2 = ch_mrkIdxL;
                ch_mrkIdxL = j;
                int sk_mrkIdxL = cms.mcidx[1][j];
                int sk_mrkIdxR = cms.getMarkerIdx(1, 0, 0);
                if (sk_mrkIdxL > sk_mrkIdxR) {
                    int tmp = sk_mrkIdxR;
                    sk_mrkIdxR = sk_mrkIdxL;
                    sk_mrkIdxL = tmp;
                    swap = true;
                }
                this.updateQtlScale(qtl, chromosome, ch_mrkIdxL, ch_mrkIdxR2, skeleton, sk_mrkIdxL, sk_mrkIdxR);
                this.setQtlFlanking(qtl, chromosome, ch_mrkIdxL, ch_mrkIdxR2, skeleton, sk_mrkIdxL, sk_mrkIdxR, swap);
                return true;
            }
        }
        if ((ch_mrkIdxR = cms.getMarkerIdx(0, cms.ncs - 1, cms.css[cms.ncs - 1] - 1)) <= qtl.m1) {
            j = 0;
            while (j < cms.nmc) {
                if (cms.mcidx[0][j] >= qtl.m2) break;
                ++j;
            }
            l = 0;
            while (l < cms.ncs) {
                m = 0;
                while (m < cms.css[l]) {
                    if (cms.mcidx[0][j] == cms.getMarkerIdx(0, l, m)) break;
                    ++m;
                }
                ++l;
            }
            if (l == cms.ncs) {
                int sk_mrkIdxR;
                ch_mrkIdxL = ch_mrkIdxR;
                ch_mrkIdxR = cms.mcidx[0][j];
                int sk_mrkIdxL = cms.getMarkerIdx(1, cms.ncs - 1, cms.css[cms.ncs - 1] - 1);
                if (sk_mrkIdxL > (sk_mrkIdxR = cms.mcidx[1][j])) {
                    int tmp = sk_mrkIdxR;
                    sk_mrkIdxR = sk_mrkIdxL;
                    sk_mrkIdxL = tmp;
                    swap = true;
                }
                this.updateQtlScale(qtl, chromosome, ch_mrkIdxL, ch_mrkIdxR, skeleton, sk_mrkIdxL, sk_mrkIdxR);
                this.setQtlFlanking(qtl, chromosome, ch_mrkIdxL, ch_mrkIdxR, skeleton, sk_mrkIdxL, sk_mrkIdxR, swap);
                return true;
            }
        }
        j = 0;
        while (j < cms.ncs - 1) {
            ch_mrkIdxL = cms.idx1[j][cms.css[j] - 1];
            ch_mrkIdxR = cms.idx1[j + 1][0];
            boolean frame = true;
            if (frame && ch_mrkIdxL <= qtl.m1 && ch_mrkIdxR >= qtl.m2) {
                ok = true;
                int sk_mrkIdxL = cms.idx2[j][cms.css[j] - 1];
                int sk_mrkIdxR = cms.idx2[j + 1][0];
                if (sk_mrkIdxL > sk_mrkIdxR) {
                    int tmp = sk_mrkIdxR;
                    sk_mrkIdxR = sk_mrkIdxL;
                    sk_mrkIdxL = tmp;
                    swap = true;
                }
                this.updateQtlScale(qtl, chromosome, ch_mrkIdxL, ch_mrkIdxR, skeleton, sk_mrkIdxL, sk_mrkIdxR);
                this.setQtlFlanking(qtl, chromosome, ch_mrkIdxL, ch_mrkIdxR, skeleton, sk_mrkIdxL, sk_mrkIdxR, swap);
                break;
            }
            if (ch_mrkIdxL > qtl.m1) break;
            ++j;
        }
        return ok;
    }

    private void updateQtlScale(Qtl qtl, Chromosome chromosome, int m1, int m2, Chromosome skeleton, int s1, int s2) {
        double rho = QtlProjAlgorithm.getRatio(chromosome, m1, m2, skeleton, s1, s2);
        double w = this.getQtlProba(qtl, chromosome, m1, m2);
        qtl.proj.mapScale += w * rho;
        qtl.proj.mapWeight += w;
    }

    private double getQtlProba(Qtl qtl, Chromosome chromosome, int m1, int m2) {
        if (m1 <= m2) {
            return chromosome.getQTLInMrkIntProb(m1, m2, qtl);
        }
        return chromosome.getQTLInMrkIntProb(m2, m1, qtl);
    }

    private void setQtlFlanking(Qtl qtl, Chromosome chromosome, int m1, int m2, Chromosome skeleton, int s1, int s2, boolean swap) {
        qtl.proj.o_mrkIdxL = m1;
        qtl.proj.o_mrkIdxR = m2;
        qtl.proj.s_mrkIdxL = s1;
        qtl.proj.s_mrkIdxR = s2;
        qtl.proj.swap = swap;
        qtl.proj.intScale = QtlProjAlgorithm.getRatio(chromosome, m1, m2, skeleton, s1, s2);
        ++this.nshare;
    }

    private void checkFlanking(Chromosome chromosome, Chromosome skeleton, Qtl qtl) {
        Qtl.QTLProj projPar = qtl.proj;
        int m1 = projPar.o_mrkIdxL;
        int m2 = projPar.o_mrkIdxR;
        int s1 = projPar.s_mrkIdxL;
        int s2 = projPar.s_mrkIdxR;
        double pvalue = QtlProjAlgorithm.getPvalue(chromosome, m1, m2, skeleton, s1, s2);
        double ratio = QtlProjAlgorithm.getRatio(chromosome, m1, m2, skeleton, s1, s2);
        if (ratio < this.ratio && pvalue < this.alpha) {
            qtl.setIgnore(!this.updateFlanking(chromosome, skeleton, qtl, 1.0, this.alpha));
            if (qtl.isIgnore() && this.isLoggerEnable()) {
                this.getLogger().println("[ WARNING ] : Unable to project QTL " + qtl.getName() + " on chromosome " + chromosome.getName());
                this.getLogger().flush();
            }
        }
    }

    private boolean updateFlanking(Chromosome chromosome, Chromosome skeleton, Qtl qtl, double ratio, double pvalue) {
        int m2;
        int m1;
        boolean ok = false;
        boolean swap = false;
        Qtl.QTLProj projPar = qtl.proj;
        int m2x = 0;
        int m1x = 0;
        int cs2 = 0;
        int cs1 = 0;
        int c1 = m1 = projPar.o_mrkIdxL;
        int c2 = m2 = projPar.o_mrkIdxR;
        int s1 = projPar.s_mrkIdxL;
        int s2 = projPar.s_mrkIdxR;
        CMarkerSequence cms = CMSAlgorithm.run(chromosome, skeleton);
        boolean rightEnd = false;
        boolean leftEnd = false;
        int[] idx = cms.getCSIdx(0, m1);
        if (idx == null) {
            leftEnd = true;
        } else {
            cs1 = idx[0];
            m1x = idx[1];
        }
        idx = cms.getCSIdx(0, m2);
        if (idx == null) {
            rightEnd = true;
        } else {
            cs2 = idx[0];
            m2x = idx[1];
        }
        int iter = 0;
        while (!ok) {
            int tmp;
            if (++iter % 2 == 0 && !leftEnd) {
                idx = cms.getLeftCSMarker(cs1, m1x);
                if (idx[0] == cs1 && idx[1] == m1x) {
                    leftEnd = true;
                }
                cs1 = idx[0];
                m1x = idx[1];
                c1 = cms.getMarkerIdx(0, cs1, m1x);
                s1 = cms.getMarkerIdx(1, cs1, m1x);
            } else if (!rightEnd) {
                idx = cms.getRightCSMarker(cs2, m2x);
                if (idx[0] == cs2 && idx[1] == m2x) {
                    rightEnd = true;
                }
                cs2 = idx[0];
                m2x = idx[1];
                c2 = cms.getMarkerIdx(0, cs2, m2x);
                s2 = cms.getMarkerIdx(1, cs2, m2x);
            }
            if (leftEnd && rightEnd) break;
            if (c1 > c2) {
                tmp = c2;
                c2 = c1;
                c1 = tmp;
                swap = true;
            }
            if (s1 > s2) {
                tmp = s2;
                s2 = s1;
                s1 = tmp;
                swap = !swap;
            }
            double r = QtlProjAlgorithm.getRatio(chromosome, c1, c2, skeleton, s1, s2);
            double p = QtlProjAlgorithm.getPvalue(chromosome, c1, c2, skeleton, s1, s2);
            if (!(r >= ratio) && !(p > pvalue)) continue;
            ok = true;
        }
        if (ok) {
            this.setQtlFlanking(qtl, chromosome, c1, c2, skeleton, s1, s2, swap);
            projPar.mapScale = 0.0;
            projPar.mapWeight = 0.0;
            this.updateQtlScale(qtl, chromosome, c1, c2, skeleton, s1, s2);
            while ((idx = cms.getLeftCSMarker(cs1, m1x))[0] != cs1 || idx[1] != m1x) {
                c1 = cms.getMarkerIdx(0, cs1, m1x);
                c2 = cms.getMarkerIdx(0, idx[0], idx[1]);
                s1 = cms.getMarkerIdx(1, cs1, m1x);
                s2 = cms.getMarkerIdx(1, idx[0], idx[1]);
                this.updateQtlScale(qtl, chromosome, c1, c2, skeleton, s1, s2);
                cs1 = idx[0];
                m1x = idx[1];
            }
            while ((idx = cms.getRightCSMarker(cs2, m2x))[0] != cs2 || idx[1] != m2x) {
                c1 = cms.getMarkerIdx(0, cs2, m2x);
                c2 = cms.getMarkerIdx(0, idx[0], idx[1]);
                s1 = cms.getMarkerIdx(1, cs2, m2x);
                s2 = cms.getMarkerIdx(1, idx[0], idx[1]);
                this.updateQtlScale(qtl, chromosome, c1, c2, skeleton, s1, s2);
                cs2 = idx[0];
                m2x = idx[1];
            }
        }
        return ok;
    }

    public void doProjection(ChromCluster[] chromClusters) {
        while (this.hasNextCluster(chromClusters)) {
            ChromCluster cluster = this.nextCluster(chromClusters);
            this.doCluster(cluster);
        }
    }

    private void doCluster(ChromCluster cluster) {
        if (cluster == null) {
            return;
        }
        Chromosome[] chromosomes = cluster.getClusterMembers();
        Chromosome skeleton = this.getSkeleton();
        while (this.hasNextChromosome(chromosomes)) {
            Chromosome chromosome = this.nextChromosome(chromosomes);
            this.doChromosome(chromosome, skeleton);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doChromosome(Chromosome chromosome, Chromosome skeleton) {
        qtls = this.getQtlToProject(chromosome);
        i = 0;
        while (i < qtls.length) {
            block6: {
                block7: {
                    block8: {
                        if (qtls[i].isIgnore()) break block6;
                        projPar = qtls[i].proj;
                        ch_mrkIdxL = projPar.o_mrkIdxL;
                        ch_mrkIdxR = projPar.o_mrkIdxR;
                        sk_mrkIdxL = projPar.s_mrkIdxL;
                        sk_mrkIdxR = projPar.s_mrkIdxR;
                        swap = projPar.swap;
                        if (!swap) break block7;
                        d = chromosome.getDistance(ch_mrkIdxR) - qtls[i].position;
                        if (!(d < 0.0)) break block8;
                        System.out.println("SWAP::ERROR " + qtls[i].name + " " + ch_mrkIdxL + " " + ch_mrkIdxR + " " + chromosome.getName());
                        System.out.println(String.valueOf(qtls[i].m1) + " " + qtls[i].m2);
                        System.out.println(String.valueOf(qtls[i].position) + " " + chromosome.getDistance(ch_mrkIdxR));
                        break block6;
                    }
                    x_l = MappingFunction.recombination(d, chromosome.mfc, chromosome.mut);
                    x_l = MappingFunction.distance(x_l, 1, 1);
                    ** GOTO lbl29
                }
                d = qtls[i].position - chromosome.getDistance(ch_mrkIdxL);
                if (d < 0.0) {
                    System.out.println("ERROR " + qtls[i].name + " " + ch_mrkIdxR + " " + ch_mrkIdxL + " " + chromosome.nm);
                } else {
                    x_l = MappingFunction.recombination(d, chromosome.mfc, chromosome.mut);
                    x_l = MappingFunction.distance(x_l, 1, 1);
lbl29:
                    // 2 sources

                    rho = projPar.intScale;
                    sk_d = skeleton.getDistanceBetween(sk_mrkIdxL, sk_mrkIdxR, 1, 1);
                    qtls[i].m1 = sk_mrkIdxL;
                    qtls[i].m2 = sk_mrkIdxR;
                    qtls[i].c1 = x_l * rho;
                    qtls[i].c2 = sk_d - qtls[i].c1;
                    sk_d = skeleton.getDistance(sk_mrkIdxL, 1, 1);
                    qtls[i].position = sk_d + qtls[i].c1;
                    qtls[i].position = MappingFunction.recombination(qtls[i].position, 1, 1);
                    qtls[i].position = MappingFunction.distance(qtls[i].position, skeleton.mfc, skeleton.mut);
                    qtls[i].c1 = MappingFunction.recombination(qtls[i].c1, 1, 1);
                    qtls[i].c2 = MappingFunction.recombination(qtls[i].c2, 1, 1);
                    rho = qtls[i].proj.mapWeight > 0.0 ? qtls[i].proj.mapScale / qtls[i].proj.mapWeight : 1.0;
                    qtls[i].proj.mapScale = rho;
                    if (qtls[i].ci != null) {
                        dic1 = MappingFunction.distance(qtls[i].ci.ic1, skeleton.mfc, skeleton.mut);
                        dic2 = MappingFunction.distance(qtls[i].ci.ic2, skeleton.mfc, skeleton.mut);
                        if (swap) {
                            tmp = dic1;
                            dic1 = dic2;
                            dic2 = tmp;
                        }
                        if ((tmp = qtls[i].position) + dic2 > skeleton.totd) {
                            dic2 = skeleton.totd - tmp;
                        }
                        qtls[i].ci.from = Math.max(0.0, tmp - dic1);
                        qtls[i].ci.to = tmp + dic2;
                        qtls[i].ci.ic1 = MappingFunction.recombination(dic1, skeleton.mfc, skeleton.mut);
                        qtls[i].ci.ic2 = MappingFunction.recombination(dic2, skeleton.mfc, skeleton.mut);
                    }
                }
            }
            ++i;
        }
    }

    private static double getPvalue(Chromosome chromosome, int m1, int m2, Chromosome skeleton, int s1, int s2) {
        double z = 0.0;
        double d1 = skeleton.getDistanceBetween(s1, s2, 1, 1);
        double d2 = chromosome.getDistanceBetween(m1, m2, 1, 1);
        double r2 = MappingFunction.recombination(d2, 1, 1);
        double vr2 = OffspringManager.fisherVariance(r2, chromosome.cs, chromosome.ct, chromosome.cg);
        double vd2 = MappingFunction.varianceDistance(r2, vr2, 1, 1);
        z = (d1 - d2) * (d1 - d2) / vd2;
        return 1.0 - NumericalUtilities.gammp(0.5, 0.5 * z);
    }

    private static double getRatio(Chromosome chromosome, int m1, int m2, Chromosome skeleton, int s1, int s2) {
        double d2;
        double d1 = s1 <= s2 ? skeleton.getDistanceBetween(s1, s2, 1, 1) : skeleton.getDistanceBetween(s2, s1, 1, 1);
        double r = d1 / (d2 = m1 <= m2 ? chromosome.getDistanceBetween(m1, m2, 1, 1) : chromosome.getDistanceBetween(m2, m1, 1, 1));
        if (Double.isInfinite(r) || Double.isNaN(r)) {
            r = 0.0;
        }
        return r;
    }

    private boolean hasNextCluster(ChromCluster[] clusters) {
        if (this._clustidx == clusters.length) {
            this._clustidx = 0;
            return false;
        }
        boolean next = this._clustidx < clusters.length;
        this._qidx = 0;
        return next;
    }

    private ChromCluster nextCluster(ChromCluster[] clusters) {
        return clusters[this._clustidx++];
    }

    private boolean hasNextChromosome(Chromosome[] chromosomes) {
        boolean next;
        if (this._chridx == chromosomes.length) {
            this._chridx = 0;
            return false;
        }
        boolean bl = next = this._chridx < chromosomes.length;
        if (next) {
            if (this._chridx > 0) {
                this._qidx += chromosomes[this._chridx - 1].getQtlNumber();
            }
            while (next && (!chromosomes[this._chridx].hasQTL() || this.isSkeleton(chromosomes[this._chridx], this.skeletons[this._clustidx - 1]))) {
                ++this._chridx;
                boolean bl2 = next = this._chridx < chromosomes.length;
            }
            if (this._chridx == chromosomes.length) {
                this._chridx = 0;
                next = false;
            }
        }
        return next;
    }

    private Chromosome nextChromosome(Chromosome[] chromosomes) {
        return chromosomes[this._chridx++];
    }

    private void initQtlMatrix(int nqtl) {
        this.qtlMatrix[this._clustidx - 1] = new Qtl[nqtl];
    }

    private void setQtlMatrix(Qtl[] qtls) {
        int i = 0;
        while (i < qtls.length) {
            this.qtlMatrix[this._clustidx - 1][this._qidx + i] = qtls[i];
            ++i;
        }
    }

    private Qtl[] getQtlToProject(Chromosome chromosome) {
        Qtl[] qtls = new Qtl[chromosome.getQtlNumber()];
        int i = 0;
        while (i < qtls.length) {
            qtls[i] = this.qtlMatrix[this._clustidx - 1][this._qidx + i];
            ++i;
        }
        return qtls;
    }

    private Chromosome getSkeleton() {
        return this.skeletons[this._clustidx - 1];
    }

    private void initSkeleton(Chromosome[] chromosomes) {
        this.skeletons[this._clustidx - 1] = this.getSkeleton(chromosomes);
    }

    private boolean isSkeleton(Chromosome chromosome, Chromosome skeleton) {
        if (skeleton == null) {
            return false;
        }
        return chromosome.hashCode() == skeleton.hashCode();
    }

    private int getQtlNumber(Chromosome[] chromosomes, Chromosome skeleton) {
        int nqtl = 0;
        int i = 0;
        while (i < chromosomes.length) {
            if (!this.isSkeleton(chromosomes[i], skeleton)) {
                nqtl += chromosomes[i].getQtlNumber();
            }
            ++i;
        }
        return nqtl;
    }

    private Chromosome getSkeleton(Chromosome[] chromosomes) {
        int i = 0;
        while (i < chromosomes.length) {
            if (chromosomes[i].skeleton) break;
            ++i;
        }
        if (i == chromosomes.length) {
            return null;
        }
        return chromosomes[i];
    }

    public void setRatio(double r) {
        this.ratio = r;
    }

    public void setPvalue(double p) {
        this.alpha = p;
    }
}

