/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity;

import org.metaqtl.bio.IBioAdapter;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.AlleleContainer;
import org.metaqtl.bio.entity.Marker;
import org.metaqtl.bio.entity.QTL;
import org.metaqtl.bio.entity.adapter.LocusBeanAdapter;
import org.metaqtl.bio.util.BioLocusTypes;
import org.metaqtl.bio.util.ILGroupPosition;
import org.metaqtl.bio.util.LGroupPosition;

public abstract class Locus
extends AlleleContainer
implements IBioLocus {
    protected ILGroupPosition position;

    public Locus() {
    }

    public Locus(String name, IBioEntity parent) {
        super(name, parent);
    }

    public static Locus newLocus(int locusType) {
        switch (locusType) {
            case 0: {
                return new Marker();
            }
            case 1: {
                return new QTL();
            }
        }
        return new Marker();
    }

    public static Locus newLocus(String string) {
        if (BioLocusTypes.parseType(string) == 0) {
            return new Marker();
        }
        if (BioLocusTypes.parseType(string) == 1) {
            return new QTL();
        }
        return new Marker();
    }

    public static IBioAdapter getLocusAdapter() {
        return new LocusBeanAdapter();
    }

    public IBioLGroup getGroup() {
        return (IBioLGroup)this.parent;
    }

    public void setGroup(IBioLGroup group) {
        this.parent = group;
    }

    public ILGroupPosition getPosition() {
        return this.position;
    }

    public void setPosition(ILGroupPosition position) {
        this.position = position;
    }

    public void setPosition(double position) {
        this.position = LGroupPosition.newStaticLocusPosition(position);
    }

    public void setPosition(double position, double sd) {
        this.position = LGroupPosition.newEstimatedLocusPosition(position, sd);
    }
}

