/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity.adapter;

import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.entity.Locus;
import org.metaqtl.bio.entity.adapter.BioEntityAdapter;
import org.metaqtl.bio.entity.bean.LocusBean;
import org.metaqtl.bio.util.BioLocusTypes;
import org.metaqtl.bio.util.LGroupPosition;

public class LocusBeanAdapter
extends BioEntityAdapter {
    public IBioEntity toEntity(Object bean) {
        if (bean instanceof LocusBean) {
            LocusBean locusBean = (LocusBean)bean;
            Locus locus = Locus.newLocus(locusBean.type);
            BioEntityAdapter.toEntity(locusBean, locus);
            if (locusBean.stderr == 0.0) {
                locus.setPosition(LGroupPosition.newStaticLocusPosition(locusBean.position));
            } else {
                locus.setPosition(LGroupPosition.newEstimatedLocusPosition(locusBean.position, locusBean.stderr));
            }
            return locus;
        }
        return null;
    }

    public Object fromEntity(IBioEntity obj) {
        if (obj instanceof Locus) {
            Locus locus = (Locus)obj;
            LocusBean markerBean = new LocusBean();
            BioEntityAdapter.fromEntity(locus, markerBean);
            if (locus.getPosition() != null) {
                markerBean.position = locus.getPosition().absolute();
                markerBean.stderr = locus.getPosition().standardError();
            }
            markerBean.type = BioLocusTypes.typeToString(locus.getLocusType());
            return markerBean;
        }
        return null;
    }
}

