/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.util;

import org.metaqtl.bio.util.EstimatedLocusPosition;
import org.metaqtl.bio.util.ILGroupPosition;
import org.metaqtl.bio.util.StaticLocusPosition;

public abstract class LGroupPosition
implements ILGroupPosition {
    protected double absolute = 0.0;
    protected double stderr = 0.0;

    public LGroupPosition(double d) {
        this.absolute = d;
    }

    public LGroupPosition(double absolute, double stderr) {
        this.absolute = absolute;
        this.stderr = stderr;
    }

    public static LGroupPosition newStaticLocusPosition(double value) {
        return new StaticLocusPosition(value);
    }

    public static LGroupPosition newEstimatedLocusPosition(double v, double s) {
        return new EstimatedLocusPosition(v, s);
    }

    public double absolute() {
        return this.absolute;
    }

    public double standardError() {
        return this.getType() != 1 ? this.stderr : 0.0;
    }

    public abstract int getType();
}

