/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

public class TabulatedWriter {
    private PrintWriter printWriter;
    private String[] keys;
    private String token = "\t";

    public TabulatedWriter(OutputStream stream) {
        this.printWriter = new PrintWriter(new OutputStreamWriter(stream));
    }

    public TabulatedWriter(Writer writer) {
        this.printWriter = new PrintWriter(writer);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
        int i = 0;
        while (i < keys.length - 1) {
            this.printWriter.print(String.valueOf(keys[i]) + this.token);
            ++i;
        }
        this.printWriter.print(keys[i]);
        this.printWriter.println();
    }

    public void nextValues(Hashtable values) {
        int i = 0;
        while (i < this.keys.length - 1) {
            this.printWriter.print(values.get(this.keys[i]) + "\t");
            ++i;
        }
        this.printWriter.print(values.get(this.keys[i]));
        this.printWriter.println();
        this.printWriter.flush();
    }

    public void nextValues(String[] values) {
        int i = 0;
        while (i < this.keys.length - 1) {
            this.printWriter.print(String.valueOf(values[i]) + "\t");
            ++i;
        }
        this.printWriter.print(values[i]);
        this.printWriter.println();
        this.printWriter.flush();
    }

    public void close() throws IOException {
        this.printWriter.close();
    }

    public int size() {
        return this.keys.length;
    }
}

