/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Color;

public final class PaletteColor {
    public static final Color[] base = new Color[]{Color.yellow, Color.green, Color.blue, Color.orange, Color.red, Color.lightGray, Color.cyan, Color.magenta};

    public static Color[] getPalette(int ncolor) {
        int nb = base.length;
        int nd = ncolor / nb;
        Color[] colors = new Color[ncolor];
        int i = 0;
        while (i < Math.min(nb, ncolor)) {
            colors[i] = base[i];
            ++i;
        }
        i = 0;
        int j = nb;
        while (i < nd) {
            int k = 0;
            while (k < ncolor - nd * nb) {
                colors[j] = i % 2 == 0 ? base[k].darker() : base[k].brighter();
                ++k;
                ++j;
            }
            ++i;
        }
        return colors;
    }

    public static Color[] getPaletteGradient(int nc, Color from, Color to) {
        Color[] palete = new Color[nc];
        palete[0] = from;
        palete[nc - 1] = to;
        int r = to.getRed() - from.getRed();
        int g = to.getGreen() - from.getGreen();
        int b = to.getBlue() - from.getBlue();
        int i = 1;
        while (i < nc - 1) {
            palete[i] = new Color(from.getRed() + i * r / (nc - 1), from.getGreen() + i * g / (nc - 1), from.getBlue() + i * b / (nc - 1));
            ++i;
        }
        return palete;
    }
}

