/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import org.metaqtl.QtlPartition;
import org.metaqtl.graph.ChromAxe;
import org.metaqtl.graph.Layer;
import org.metaqtl.graph.MetaGraphPar;
import org.metaqtl.graph.QtlLayer;
import org.metaqtl.graph.QtlLayerBuffer;
import org.metaqtl.graph.QtlTreeLayer;
import org.metaqtl.graph.QtlUnit;
import org.metaqtl.numrec.NumericalUtilities;

public class QtlPartitionLayer
extends Layer {
    private QtlLayer[] qtlLayers;
    private QtlTreeLayer qtlTreeLayer;
    private ChromAxe chromAxe;
    private QtlPartition qtlPartition;

    public QtlPartitionLayer(double x, double y) {
        super(x, y);
    }

    public void build(Graphics2D graph) {
        if (this.qtlPartition != null) {
            switch (this.qtlPartition.mode) {
                case 0: {
                    this.buildQtlTreeLayer(graph);
                    break;
                }
                case 1: {
                    this.buildQtlLayers(graph);
                    break;
                }
                default: {
                    this.buildQtlLayers(graph);
                }
            }
        }
    }

    private void buildQtlTreeLayer(Graphics2D graph) {
        this.qtlTreeLayer = new QtlTreeLayer(this.x, this.y);
        this.qtlTreeLayer.attach(this.qtlPartition);
        this.qtlTreeLayer.setChromAxe(this.chromAxe);
        this.qtlTreeLayer.build(graph);
        this.width = this.qtlTreeLayer.getWidth();
    }

    private void buildQtlLayers(Graphics2D graph) {
        ArrayList<QtlLayer> layerList = new ArrayList<QtlLayer>();
        int nqtl = this.qtlPartition.nqtl;
        if (nqtl == 0) {
            return;
        }
        boolean[] see = new boolean[nqtl + 1];
        double[] qpos = new double[nqtl + 1];
        double[] ci = new double[nqtl + 1];
        int[] idx = new int[nqtl + 1];
        int i = 0;
        while (i < nqtl) {
            if (this.chromAxe != null) {
                qpos[i + 1] = this.chromAxe.transformY(this.qtlPartition.qtlPos[i]);
                ci[i + 1] = this.chromAxe.scaleHeight(this.qtlPartition.qtlCI[i]);
            } else {
                qpos[i + 1] = this.qtlPartition.qtlPos[i];
                ci[i + 1] = this.qtlPartition.qtlCI[i];
            }
            see[i + 1] = false;
            ++i;
        }
        if (nqtl > 1) {
            NumericalUtilities.indexx(nqtl, qpos, idx);
        } else if (nqtl == 1) {
            idx[1] = 1;
        }
        double x_layer = this.x;
        block1: do {
            QtlLayerBuffer qtlBuffer = new QtlLayerBuffer();
            i = 1;
            while (i <= nqtl) {
                if (!see[idx[i]]) {
                    QtlUnit unit = new QtlUnit();
                    unit.name = this.qtlPartition.qtlNames[idx[i] - 1];
                    unit.partition = this.qtlPartition.proba[idx[i] - 1];
                    unit.from = Math.max(qpos[idx[i]] - ci[idx[i]] / 2.0, this.chromAxe.getYMin());
                    unit.to = Math.min(qpos[idx[i]] + ci[idx[i]] / 2.0, this.chromAxe.getYMax());
                    unit.pos = qpos[idx[i]];
                    unit.width = MetaGraphPar.QTL_CI_WIDTH;
                    see[idx[i]] = qtlBuffer.addQtl(graph, unit);
                    if (!qtlBuffer.canAddMoreQtl(this.chromAxe.getYMax())) break;
                }
                ++i;
            }
            QtlLayer layer = qtlBuffer.getLayer(x_layer, this.y);
            layer.build(graph);
            if (layer.getHeight() > this.height) {
                this.height = layer.getHeight();
            }
            layerList.add(layer);
            x_layer += MetaGraphPar.QTL_HSPACE;
            x_layer += layer.getWidth();
            i = 1;
            while (i <= nqtl) {
                if (!see[i]) continue block1;
                ++i;
            }
        } while (i <= nqtl);
        if (layerList != null) {
            this.qtlLayers = new QtlLayer[layerList.size()];
            layerList.toArray(this.qtlLayers);
        }
        this.width = x_layer - this.x;
    }

    public void draw(Graphics2D graph) {
        Color c = graph.getColor();
        AffineTransform t = graph.getTransform();
        AffineTransform trans = new AffineTransform();
        trans.translate(this.x, this.y);
        graph.transform(trans);
        if (this.qtlLayers != null) {
            int i = 0;
            while (i < this.qtlLayers.length) {
                if (this.qtlLayers[i] != null) {
                    this.qtlLayers[i].draw(graph);
                }
                ++i;
            }
        }
        if (this.qtlTreeLayer != null) {
            this.qtlTreeLayer.draw(graph);
        }
        graph.setTransform(t);
        graph.setColor(c);
    }

    public void setChromAxe(ChromAxe chromAxe) {
        this.chromAxe = chromAxe;
    }

    public ChromAxe getChromAxe() {
        return this.chromAxe;
    }

    public void attach(Object object) {
        if (object instanceof QtlPartition) {
            this.qtlPartition = (QtlPartition)object;
        }
    }

    public double getYMin() {
        double min = Double.POSITIVE_INFINITY;
        if (this.qtlLayers != null) {
            int i = 0;
            while (i < this.qtlLayers.length) {
                if (this.qtlLayers[i].getYMin() < min) {
                    min = this.y + this.qtlLayers[i].getYMin();
                }
                ++i;
            }
        }
        if (this.qtlTreeLayer != null) {
            min = Math.min(min, this.qtlTreeLayer.getYMin());
        }
        return min;
    }

    public double getYMax() {
        double max = Double.NEGATIVE_INFINITY;
        if (this.qtlLayers != null) {
            int i = 0;
            while (i < this.qtlLayers.length) {
                if (this.qtlLayers[i].getYMax() < max) {
                    max = this.y + this.qtlLayers[i].getYMax();
                }
                ++i;
            }
        }
        if (this.qtlTreeLayer != null) {
            max = Math.max(max, this.qtlTreeLayer.getYMax());
        }
        return max;
    }

    public ArrayList getQtlPartNames() {
        if (this.qtlPartition != null) {
            return this.qtlPartition.getPartNames();
        }
        return new ArrayList();
    }
}

