/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.metaqtl.QtlPartition;
import org.metaqtl.Tree;
import org.metaqtl.TreeNode;
import org.metaqtl.graph.ChromAxe;
import org.metaqtl.graph.Layer;
import org.metaqtl.graph.MetaGraphPar;
import org.metaqtl.numrec.NumericalUtilities;

public class QtlTreeLayer
extends Layer {
    private QtlPartition qtlPart;
    private double point_width;
    private double point_height;
    private double ci_max;
    private double x_ci_qtl;
    private boolean[] label_status;
    private int[] qtl_idx;
    private int[] rqtl_idx;
    private double[] x_qtls;
    private double[] x_label_qtls;
    private double[] y_qtls;
    private double[] y_label_qtls;
    private double[] ci_qtls;
    private double[][] pr_qtls;
    private TextLayout[] label_qtls;
    private ChromAxe chromAxe;
    private double x_pr_qtl;
    private double x_tree;

    public QtlTreeLayer(double x, double y) {
        super(x, y);
    }

    public void attach(Object object) {
        if (object instanceof QtlPartition) {
            this.qtlPart = (QtlPartition)object;
        }
    }

    public void build(Graphics2D graph) {
        this.x_qtls = new double[this.qtlPart.nqtl];
        this.y_qtls = new double[this.qtlPart.nqtl];
        this.y_label_qtls = new double[this.qtlPart.nqtl];
        this.x_label_qtls = new double[this.qtlPart.nqtl];
        double[] tmp = new double[this.qtlPart.nqtl + 1];
        this.qtl_idx = new int[this.qtlPart.nqtl + 1];
        this.rqtl_idx = new int[this.qtlPart.nqtl];
        int i = 0;
        while (i < this.qtlPart.nqtl) {
            tmp[i + 1] = this.chromAxe.transformY(this.qtlPart.qtlPos[i]);
            ++i;
        }
        NumericalUtilities.indexx(this.qtlPart.nqtl, tmp, this.qtl_idx);
        i = 0;
        while (i < this.qtlPart.nqtl) {
            this.y_qtls[i] = tmp[this.qtl_idx[i + 1]];
            this.x_qtls[i] = MetaGraphPar.QTL_PCH_SIZE / 2.0;
            this.y_label_qtls[i] = tmp[this.qtl_idx[i + 1]];
            this.qtl_idx[i] = this.qtl_idx[i + 1] - 1;
            this.rqtl_idx[this.qtl_idx[i]] = i;
            ++i;
        }
        this.label_qtls = new TextLayout[this.qtlPart.nqtl];
        i = 0;
        while (i < this.qtlPart.nqtl) {
            this.label_qtls[i] = new TextLayout(this.qtlPart.qtlNames[this.qtl_idx[i]], MetaGraphPar.QTL_NAME_FONT, graph.getFontRenderContext());
            int n = i;
            this.y_label_qtls[n] = this.y_label_qtls[n] - this.getLabelHeight(i) / 2.0;
            ++i;
        }
        this.ci_max = 0.0;
        this.ci_qtls = new double[this.qtlPart.nqtl];
        i = 0;
        while (i < this.qtlPart.nqtl) {
            this.ci_qtls[i] = this.chromAxe.scaleHeight(this.qtlPart.qtlCI[this.qtl_idx[i]]);
            if (this.ci_qtls[i] > this.ci_max) {
                this.ci_max = this.ci_qtls[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.qtlPart.nqtl) {
            int n = i++;
            this.ci_qtls[n] = this.ci_qtls[n] / this.ci_max;
        }
        if (this.qtlPart.proba != null) {
            i = 0;
            while (i < this.qtlPart.nqtl) {
                if (this.qtlPart.proba[this.qtl_idx[i]] == null || this.qtlPart.proba[this.qtl_idx[i]].length < 1) break;
                ++i;
            }
            if (i == this.qtlPart.nqtl) {
                this.pr_qtls = new double[this.qtlPart.nqtl][0];
                i = 0;
                while (i < this.qtlPart.nqtl) {
                    this.pr_qtls[i] = this.qtlPart.proba[this.qtl_idx[i]];
                    ++i;
                }
            }
        }
        this.updateLayerDimension();
    }

    private void updateLayerDimension() {
        Tree tree;
        this.width += MetaGraphPar.QTL_PCH_SIZE;
        this.width += MetaGraphPar.QTL_NAME_SPACE;
        double max = 0.0;
        int i = 0;
        while (i < this.x_label_qtls.length) {
            double w = this.getLabelWidth(i);
            if (w > max) {
                max = w;
            }
            ++i;
        }
        i = 0;
        while (i < this.x_label_qtls.length) {
            this.x_label_qtls[i] = this.width;
            ++i;
        }
        this.width += max;
        this.checkLabelLocation();
        this.resolveLabelLocation();
        this.height = this.getYMax() - this.getYMin();
        this.width += MetaGraphPar.QTL_NAME_SPACE;
        this.x_ci_qtl = this.width;
        this.width += MetaGraphPar.QTL_CI_WIDTH_CEX * this.ci_max;
        if (this.pr_qtls != null) {
            this.width += MetaGraphPar.QTL_CI_WIDTH_CEX * this.ci_max * 0.1;
            this.x_pr_qtl = this.width;
            this.width += MetaGraphPar.QTL_CI_WIDTH_CEX * this.ci_max;
            this.width += MetaGraphPar.QTL_CI_WIDTH_CEX * this.ci_max * 0.1;
        }
        if ((tree = this.qtlPart.tree) != null) {
            double[] hleaf = tree.getLeafHeights();
            max = 0.0;
            i = 0;
            while (i < hleaf.length) {
                if (max < hleaf[i]) {
                    max = hleaf[i];
                }
                ++i;
            }
            tree.updateLeafIdx(this.rqtl_idx);
            tree.initNodeIdx();
            TreeNode root = tree.getRoot();
            this.x_tree = this.width;
            this.width += MetaGraphPar.QTL_TREE_SCALE * max * 1.05;
            root.setX(this.width);
            root.setY(root.getCentroid(this.y_label_qtls, this.ci_qtls));
            this.initTreeXY(root, this.getYMin(), this.height);
        }
    }

    private double getLabelTotHeight() {
        return this.y_label_qtls[this.y_label_qtls.length - 1] - this.y_label_qtls[0];
    }

    private void checkLabelLocation() {
        this.label_status = new boolean[this.label_qtls.length];
        int i = 0;
        while (i < this.label_qtls.length) {
            this.label_status[i] = true;
            ++i;
        }
        i = 0;
        while (i < this.label_qtls.length - 1) {
            double y1 = this.y_label_qtls[i];
            y1 += this.getLabelHeight(i);
            y1 += y1 * 0.1;
            double y2 = this.y_label_qtls[i + 1];
            int n = i;
            this.label_status[n] = this.label_status[n] & y1 <= y2;
            int n2 = i + 1;
            this.label_status[n2] = this.label_status[n2] & y1 <= y2;
            ++i;
        }
    }

    private double getLabelHeight(int i) {
        return this.label_qtls[i].getBounds().getHeight();
    }

    private double getLabelWidth(int i) {
        return this.label_qtls[i].getBounds().getWidth();
    }

    private void resolveLabelLocation() {
        boolean ok = true;
        int i = 0;
        while (i < this.label_qtls.length) {
            int nl = 1;
            if (!this.label_status[i]) {
                double y_top = i > 0 ? this.y_label_qtls[i - 1] + this.getLabelHeight(i - 1) : this.y_label_qtls[i];
                int j = i + 1;
                while (j < this.label_qtls.length) {
                    if (this.label_status[j]) break;
                    ++j;
                    ++nl;
                }
                double y_bottom = i + nl < this.label_qtls.length ? this.y_label_qtls[i + nl] : this.y_label_qtls[i + nl - 1] + this.getLabelHeight(i + nl - 1);
                double space = y_bottom - y_top;
                double require = 0.0;
                j = i;
                while (j < i + nl) {
                    require += this.getLabelHeight(j);
                    ++j;
                }
                if (space < require) {
                    if (i + nl < this.label_qtls.length - 1) {
                        j = i - 1;
                        while (j >= 0) {
                            int n = j;
                            this.y_label_qtls[n] = this.y_label_qtls[n] - (require - space) / 2.0;
                            if (j <= 0 || !(this.y_label_qtls[j - 1] + this.getLabelHeight(j - 1) < this.y_label_qtls[j])) {
                                --j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        j = i;
                        while (j < this.label_qtls.length) {
                            int n = j++;
                            this.y_label_qtls[n] = this.y_label_qtls[n] + (require - space);
                        }
                    }
                    if (i > 0) {
                        j = i + nl;
                        while (j < this.label_qtls.length) {
                            int n = j;
                            this.y_label_qtls[n] = this.y_label_qtls[n] + (require - space) / 2.0;
                            if (j + 1 >= this.label_qtls.length || !(this.y_label_qtls[j + 1] > this.y_label_qtls[j] + this.getLabelHeight(j))) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        j = 0;
                        while (j < nl) {
                            int n = j++;
                            this.y_label_qtls[n] = this.y_label_qtls[n] - (require - space);
                        }
                    }
                    y_top = i > 0 ? this.y_label_qtls[i - 1] + this.getLabelHeight(i - 1) : this.y_label_qtls[i];
                    j = 0;
                    while (j < nl) {
                        this.y_label_qtls[i + j] = y_top;
                        y_top += this.getLabelHeight(i + j);
                        ++j;
                    }
                    y_bottom = y_top;
                    y_top = i > 0 ? this.y_label_qtls[i - 1] + this.getLabelHeight(i - 1) : this.y_label_qtls[i];
                } else {
                    double y_box = space / (double)nl;
                    j = 0;
                    while (j < nl) {
                        this.y_label_qtls[i + j] = y_top + (y_box - this.getLabelHeight(i + j)) / 2.0;
                        y_top += y_box;
                        ++j;
                    }
                }
            }
            i += nl;
        }
    }

    private void initTreeXY(TreeNode root, double ymin, double h) {
        if (root.leaf) {
            return;
        }
        TreeNode[] children = root.getChildren();
        double[] tmp = new double[children.length + 1];
        int[] idx = new int[children.length + 1];
        int i = 0;
        while (i < children.length) {
            tmp[i + 1] = children[i].getCentroid(this.y_label_qtls, this.ci_qtls);
            ++i;
        }
        NumericalUtilities.indexx(children.length, tmp, idx);
        double yold = ymin;
        int i2 = 1;
        while (i2 <= children.length) {
            children[idx[i2] - 1].setX(root.getX() - MetaGraphPar.QTL_TREE_SCALE * children[idx[i2] - 1].getDist());
            children[idx[i2] - 1].setY(tmp[idx[i2]]);
            this.initTreeXY(children[idx[i2] - 1], 0.0, 0.0);
            ++i2;
        }
    }

    private void drawTree(Graphics2D graph, TreeNode root) {
        graph.setColor(Color.BLACK);
        TreeNode[] children = root.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                GeneralPath edge = new GeneralPath(0, 3);
                edge.moveTo((float)root.getX(), (float)root.getY());
                edge.lineTo((float)root.getX(), (float)children[i].getY());
                edge.lineTo((float)children[i].getX(), (float)children[i].getY());
                graph.setStroke(new BasicStroke((float)this.getLabelHeight(0) / 2.0f));
                graph.draw(edge);
                if (children[i].leaf) {
                    graph.setColor(Color.GRAY);
                    Line2D.Double line = new Line2D.Double(children[i].getX(), children[i].getY(), this.x_tree, children[i].getY());
                    graph.draw(line);
                    graph.setColor(Color.BLACK);
                }
                this.drawTree(graph, children[i]);
                ++i;
            }
        }
    }

    public void draw(Graphics2D graph) {
        float xx;
        int i = 0;
        Color c = graph.getColor();
        AffineTransform t = graph.getTransform();
        AffineTransform trans = new AffineTransform();
        trans.translate(this.x, this.y);
        graph.transform(trans);
        graph.setColor(Color.BLACK);
        i = 0;
        while (i < this.y_qtls.length) {
            GeneralPath pos = new GeneralPath(0, 3);
            pos.moveTo((float)(this.x_qtls[i] + MetaGraphPar.QTL_PCH_SIZE), (float)(this.y_qtls[i] - this.getLabelHeight(i) / 2.0));
            pos.lineTo((float)this.x_qtls[i], (float)this.y_qtls[i]);
            pos.lineTo((float)(this.x_qtls[i] + MetaGraphPar.QTL_PCH_SIZE), (float)(this.y_qtls[i] + this.getLabelHeight(i) / 2.0));
            pos.closePath();
            graph.fill(pos);
            ++i;
        }
        i = 0;
        while (i < this.y_qtls.length) {
            GeneralPath conex = new GeneralPath(0, 4);
            xx = (float)(this.x_qtls[i] + MetaGraphPar.QTL_PCH_SIZE);
            float yy = (float)this.y_qtls[i];
            conex.moveTo(xx, yy);
            float tt = (float)Math.abs((double)xx - this.x_label_qtls[i]);
            xx = (float)((double)xx + (double)tt * 0.1);
            conex.lineTo(xx, yy);
            xx = (float)this.x_label_qtls[i];
            xx = (float)((double)xx - (double)tt * 0.1);
            yy = (float)this.y_label_qtls[i];
            conex.lineTo(xx, yy);
            xx = (float)this.x_label_qtls[i];
            conex.lineTo(xx, yy);
            graph.draw(conex);
            ++i;
        }
        i = 0;
        while (i < this.y_label_qtls.length) {
            this.label_qtls[i].draw(graph, (float)this.x_label_qtls[i], (float)this.y_label_qtls[i]);
            ++i;
        }
        i = 0;
        while (i < this.ci_qtls.length) {
            double max = MetaGraphPar.QTL_CI_WIDTH_CEX * this.ci_max;
            xx = (float)(max * this.ci_qtls[i]);
            Rectangle2D.Double ci = new Rectangle2D.Double(this.x_ci_qtl, this.y_label_qtls[i] - this.getLabelHeight(i), xx, this.getLabelHeight(i));
            graph.fill(ci);
            ci = new Rectangle2D.Double(this.x_ci_qtl, this.y_label_qtls[i] - this.getLabelHeight(i), max, this.getLabelHeight(i));
            graph.draw(ci);
            ++i;
        }
        if (this.pr_qtls != null) {
            double max = MetaGraphPar.QTL_CI_WIDTH_CEX * this.ci_max;
            i = 0;
            while (i < this.pr_qtls.length) {
                if (this.pr_qtls[i] != null) {
                    xx = (float)this.x_pr_qtl;
                    int j = 0;
                    while (j < this.pr_qtls[i].length) {
                        graph.setColor(MetaGraphPar.QTL_PALETTE[j]);
                        Rectangle2D.Double ci = new Rectangle2D.Double(xx, this.y_label_qtls[i] - this.getLabelHeight(i), max * this.pr_qtls[i][j], this.getLabelHeight(i));
                        graph.fill(ci);
                        xx = (float)((double)xx + max * this.pr_qtls[i][j]);
                        ++j;
                    }
                    graph.setColor(Color.BLACK);
                    Rectangle2D.Double ci = new Rectangle2D.Double((float)this.x_pr_qtl, this.y_label_qtls[i] - this.getLabelHeight(i), max, this.getLabelHeight(i));
                    graph.draw(ci);
                }
                ++i;
            }
        }
        if (this.qtlPart.tree != null) {
            this.drawTree(graph, this.qtlPart.tree.getRoot());
        }
        graph.setTransform(t);
        graph.setColor(c);
    }

    public double getYMin() {
        return this.y + this.y_label_qtls[0];
    }

    public double getYMax() {
        return this.y + this.y_label_qtls[this.y_label_qtls.length - 1];
    }

    public void setChromAxe(ChromAxe axe) {
        this.chromAxe = axe;
    }
}

