/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.metaqtl.Chromosome;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlModel;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.QtlPartition;
import org.metaqtl.adapter.ChromosomeAdapter;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.graph.ChromGraph;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public class MQTLView
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: MetaDraw [{-m, --map}]] [{-c, --chrom}]] [{-r, --clust}]] [{-b, --best}]] [{-t, --tree}]] [{--mode}]] [{-p, --par}][{--img}][{-o, --outstem}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        MetaMain.printLicense("TreeDraw", VERSION);
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-m, --map     : the XML file of the map");
        System.out.println("-c, --chrom   : the name of the chromosome (or a list seperated by comma)");
        System.out.println("-r, --clust   : the file location of the clustering result");
        System.out.println("-b, --best    : the file location of the best clusterings");
        System.out.println("-t, --tree    : the file location of the hierarchical clustering");
        System.out.println("    --mode    : the mode of representation");
        System.out.println("    --trait   : the name of the trait");
        System.out.println("-p, --par     : the file location of the plot parameters");
        System.out.println("-o, --outstem : the output stem");
        System.out.println("--img         : the format name of the image among this list");
        MetaMain.printImgFormat(16);
    }

    public static void main(String[] args) {
        ChromGraph[] chromGraphs;
        Chromosome[] chromosomes;
        Chromosome[] chrom2draws;
        MQTLView program = new MQTLView();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option amapFile = parser.addStringOption('m', "map");
        CmdLineParser.Option atreeFile = parser.addStringOption('t', "tree");
        CmdLineParser.Option aclustFile = parser.addStringOption('r', "clust");
        CmdLineParser.Option abestFile = parser.addStringOption('b', "best");
        CmdLineParser.Option achromList = parser.addStringOption('c', "chrom");
        CmdLineParser.Option aMode = parser.addIntegerOption("mode");
        CmdLineParser.Option atraitName = parser.addIntegerOption("trait");
        CmdLineParser.Option aparFile = parser.addStringOption('p', "par");
        CmdLineParser.Option aimgFormat = parser.addStringOption("img");
        CmdLineParser.Option aoutFile = parser.addStringOption('o', "outdir");
        program.parseCmdLine(args);
        String mapFile = (String)parser.getOptionValue(amapFile);
        String treeFile = (String)parser.getOptionValue(atreeFile);
        String clustFile = (String)parser.getOptionValue(aclustFile);
        String bestFile = (String)parser.getOptionValue(abestFile);
        String chromList = (String)parser.getOptionValue(achromList);
        Integer mode = (Integer)parser.getOptionValue(aMode, new Integer(1));
        String traitName = (String)parser.getOptionValue(atraitName);
        String parFile = (String)parser.getOptionValue(aparFile);
        String imgFormat = (String)parser.getOptionValue(aimgFormat, "jpeg");
        String outFile = (String)parser.getOptionValue(aoutFile);
        if (mapFile == null) {
            System.err.println("[ ERROR ] : No map file defined");
            System.exit(2);
        }
        if (clustFile == null && treeFile == null) {
            System.err.println("[ ERROR ] : No clustering result defined");
            System.exit(2);
        }
        if (clustFile != null && bestFile == null) {
            System.err.println("[ ERROR ] : No best clustering model file defined");
            System.exit(2);
        }
        if (clustFile == null && bestFile != null) {
            System.err.println("[ ERROR ] : No clustering result file defined");
            System.exit(2);
        }
        IBioGenome map = null;
        MetaQtlAnalysis treeAnalysis = null;
        MetaQtlAnalysis clustAnalysis = null;
        MetaQtlModel bestClust = null;
        String[] chromNames = null;
        try {
            map = MQTLView.getMap(mapFile);
            treeAnalysis = MQTLView.getResult(treeFile);
            clustAnalysis = MQTLView.getResult(clustFile);
            bestClust = MQTLView.getCluster(bestFile);
            chromNames = MQTLView.parseChromList(chromList);
            MQTLView.setParameter(parFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (map == null) {
            System.err.println("[ ERROR ] : Unable to load map from " + mapFile);
            System.exit(4);
        }
        if (clustAnalysis == null && treeAnalysis == null) {
            System.err.println("[ ERROR ] : Unable to load result");
            System.exit(4);
        }
        if (clustAnalysis == null && bestClust != null) {
            System.err.println("[ ERROR ] : Unable to load result from " + clustFile);
            System.exit(4);
        }
        if (clustAnalysis != null && bestClust == null) {
            System.err.println("[ ERROR ] : Unable to load best models from " + bestFile);
            System.exit(4);
        }
        if ((chrom2draws = MQTLView.getChromByNames(chromosomes = ChromosomeAdapter.toChromosomes(map), chromNames)) == null) {
            chrom2draws = chromosomes;
        }
        if ((chromGraphs = MQTLView.getChromGraph(chrom2draws, clustAnalysis, bestClust, treeAnalysis, traitName, mode)) != null) {
            try {
                File file = new File(String.valueOf(outFile) + "." + imgFormat);
                MQTLView.writeImg(chromGraphs, file, imgFormat);
                file = new File(String.valueOf(outFile) + ".par");
                MQTLView.writePar(file);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                System.exit(5);
            }
            System.exit(0);
        }
        System.err.println("[ ERROR ] : No chromosome to draw !");
        System.exit(6);
    }

    private static ChromGraph[] getChromGraph(Chromosome[] chromosomes, MetaQtlAnalysis clustAnalysis, MetaQtlModel bestClust, MetaQtlAnalysis treeAnalysis, String trait, int qtlMode) {
        ArrayList<ChromGraph> chromGraphList = new ArrayList<ChromGraph>();
        int i = 0;
        while (i < chromosomes.length) {
            ChromGraph chromGraph;
            int j;
            if (clustAnalysis != null) {
                String[] traits = bestClust.getTraitNames(chromosomes[i].getName());
                j = 0;
                while (j < traits.length) {
                    if (trait == null || trait.equals(traits[j])) {
                        chromGraph = new ChromGraph();
                        int kclust = bestClust.getModel(chromosomes[i].getName(), traits[j]);
                        QtlPartition qtlPart = MQTLView.getQtlPartition(chromosomes[i], clustAnalysis, traits[j], kclust, 'P');
                        if (treeAnalysis != null) {
                            qtlPart.tree = treeAnalysis.getResult(chromosomes[i].getName(), traits[j]).getQtlTree();
                        }
                        chromGraph.chromosome = chromosomes[i];
                        chromGraph.qtlPart = qtlPart;
                        chromGraph.qtlPart.mode = qtlPart.tree == null ? qtlMode : 0;
                        chromGraphList.add(chromGraph);
                    }
                    ++j;
                }
            } else {
                MetaQtlResult[] results = treeAnalysis.getResults(chromosomes[i].getName());
                j = 0;
                while (j < results.length) {
                    if (trait == null || trait.equals(results[j].trait)) {
                        chromGraph = new ChromGraph();
                        QtlPartition qtlPart = MQTLView.getQtlPartition(chromosomes[i], treeAnalysis, results[j].trait, 1, 'P');
                        chromGraph.chromosome = chromosomes[i];
                        chromGraph.qtlPart = qtlPart;
                        chromGraph.qtlPart.mode = 0;
                        chromGraphList.add(chromGraph);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (chromGraphList.size() > 0) {
            ChromGraph[] chromGraphs = new ChromGraph[chromGraphList.size()];
            chromGraphList.toArray(chromGraphs);
            return chromGraphs;
        }
        return null;
    }
}

