/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf;

import com.pdftech.fot2pdf.formatter.Formatter;
import com.pdftech.fot2pdf.formatter.FormatterParameters;
import com.pdftech.fot2pdf.parameters;
import com.pdftech.fot2pdf.pdf.PDFparameters;
import com.pdftech.fot2pdf.tools.Debugfile;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.ReplacementTable;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.tools.StringTools;
import com.pdftech.fot2pdf.xml.FOTfilereader;
import com.pdftech.fot2pdf.xml.FOTsaxreader;

public class app {
    public static void main(String[] args) {
        String inittext = "fot2pdf V" + parameters.getProgramVersion();
        Status.println(inittext);
        Status.println(StringTools.sumstring('=', inittext.length()));
        String infname = "";
        String outfname = "";
        String saxdriver = null;
        boolean multithreaded = false;
        String argerror = "";
        if (args.length == 0) {
            argerror = "No parameters!";
        } else {
            int i = 0;
            while (i < args.length) {
                if (args[i].charAt(0) == '-') {
                    block0 : switch (args[i].charAt(1)) {
                        case 'd': {
                            Debugfile.setdebugflag(true);
                            Status.println("Debugging enabled.");
                            break;
                        }
                        case 'D': {
                            if (i + 1 < args.length) {
                                parameters.setBaseDirectory(args[i + 1]);
                                ++i;
                                break;
                            }
                            argerror = "Directory-switch -D needs parameter <dir>!";
                            break;
                        }
                        case 'o': {
                            if (i + 1 < args.length) {
                                outfname = args[i + 1];
                                ++i;
                                break;
                            }
                            argerror = "Output-filename-switch -o needs parameter <file>!";
                            break;
                        }
                        case 'w': {
                            if (i + 1 < args.length) {
                                FormatterParameters.setLineBreakingWarnLevel(GenericTools.readint(args[i + 1]));
                                ++i;
                                break;
                            }
                            argerror = "warning-level-switch -w needs parameter <dir>!";
                            break;
                        }
                        case 'c': {
                            if (args[i].length() < 3) {
                                argerror = "Compression-Switch -c needs parameter 0, 1 or 2!";
                                break;
                            }
                            switch (args[i].charAt(2)) {
                                case '0': {
                                    PDFparameters.setDeflate(false);
                                    break block0;
                                }
                                case '1': {
                                    PDFparameters.setDeflate(true);
                                    PDFparameters.setDeflateText(false);
                                    break block0;
                                }
                            }
                            PDFparameters.setDeflate(true);
                            PDFparameters.setDeflateText(true);
                            break;
                        }
                        case 'm': {
                            if (args[i].length() < 3) {
                                argerror = "Multithreading-Switch -m needs parameter 0 or 1!";
                                break;
                            }
                            multithreaded = args[i].charAt(2) == '1';
                            break;
                        }
                        case 'e': {
                            if (args[i].length() < 3) {
                                argerror = "Font-Embedding-Switch -e needs parameter 0 or 1!";
                                break;
                            }
                            PDFparameters.setFontEmbeddingFlag(args[i].charAt(2) == '1');
                            break;
                        }
                        case 'l': {
                            if (args[i].length() < 3) {
                                argerror = "Link-Highlighting-Switch -l needs parameter 0 or 1!";
                                break;
                            }
                            FormatterParameters.setLinkHighlightingFlag(args[i].charAt(2) == '1');
                            break;
                        }
                        case 'b': {
                            if (args[i].length() < 3) {
                                argerror = "Balance-Pages-Switch -b needs parameter 0 or 1!";
                                break;
                            }
                            FormatterParameters.setBalancePagesFlag(args[i].charAt(2) == '1');
                            break;
                        }
                        case 'B': {
                            if (args[i].length() < 3) {
                                argerror = "Booklet-Switch -B needs parameter 0 or 1!";
                                break;
                            }
                            PDFparameters.setBookletFlag(args[i].charAt(2) == '1');
                            break;
                        }
                        case 's': {
                            if (i + 1 < args.length) {
                                saxdriver = args[i + 1];
                                ++i;
                                break;
                            }
                            argerror = "SAX-Switch -s needs class name as parameter!";
                            break;
                        }
                        default: {
                            argerror = "Unknown Switch: '" + args[i].charAt(1) + "'!";
                            break;
                        }
                    }
                } else {
                    infname = args[i];
                    if (outfname.length() == 0) {
                        outfname = infname;
                        int fotending = outfname.lastIndexOf(".fot");
                        if (fotending > -1) {
                            outfname = outfname.substring(0, fotending);
                        }
                        outfname = outfname + ".pdf";
                    }
                }
                ++i;
            }
            if (infname.length() == 0) {
                argerror = "No Inputfile given!";
            }
        }
        if (argerror.length() != 0) {
            Status.println(argerror + "\r\n");
            Status.println("Usage: fot2pdf <infile.fot> [switches]");
            Status.println("Switches (with defaults):");
            Status.println("-o [filename]      Sets filename for PDF file other than <infile.pdf>");
            Status.println("-D [dirname]       Sets base directory for auxiliary files");
            Status.println("-s [saxdriver]     Use SAX compliant XML parser to get flow object tree");
            Status.println("-l[0=default/1]    Highlight links with blue color (0=off, 1=on)");
            Status.println("-e[0/1=default]    Embed fonts into PDF (0=off, 1=on)");
            Status.println("-m[0=default/1]    Enables multithreading");
            Status.println("-b[0=default/1]    Balance pages' height, 1=enabled");
            Status.println("-B[0=default/1]    Booklet mode; sorts pages for 2up-duplex-printing");
            Status.println("-c[0/1/2=default]  Sets Deflate-Compression (Acrobat 3.0 and up)");
            Status.println("                   0=none (Acrobat 2 compatible), 1=all but contents, 2=all");
            Status.println("-w [warnlevel]     Warning message threshold (optimizing line-break algorithm)");
            Status.println("                   default=4; off=0; for more detailed warnings, use 2 or 1");
            System.exit(1);
        }
        Debugfile.start("debug.log");
        Status.println("Input: " + infname);
        Status.println("Output: " + outfname);
        ReplacementTable.load();
        long starttime = System.currentTimeMillis();
        if (saxdriver == null) {
            FOTfilereader fot = new FOTfilereader(infname);
            fot.run();
            Formatter pdfmaker = new Formatter(fot, outfname);
            pdfmaker.run();
        } else {
            FOTsaxreader fot = new FOTsaxreader(infname, saxdriver);
            fot.run();
            Formatter pdfmaker = new Formatter(fot, outfname);
            pdfmaker.run();
        }
        Debugfile.close();
        starttime = System.currentTimeMillis() - starttime;
        Status.println("\rfot2pdf done, elapsed " + starttime / 1000L + "s.");
        System.exit(0);
    }
}

