/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter;

import com.pdftech.fot2pdf.formatter.DSSSL_ParsedAttributes;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.ScoreMarker;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.SidelineMarker;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.StringTools;
import com.pdftech.fot2pdf.xml.xmlnode;

public class DSSSL_InheritedCharacteristics
extends DSSSL_ParsedAttributes {
    public double page_width = 595.0;
    public double page_height = 842.0;
    public double left_margin = 0.0;
    public double right_margin = 0.0;
    public double top_margin = 0.0;
    public double bottom_margin = 0.0;
    public double header_margin = 0.0;
    public double footer_margin = 0.0;
    public double color_r = 0.0;
    public double color_g = 0.0;
    public double color_b = 0.0;
    public double backgroundcolor_r = 0.0;
    public double backgroundcolor_g = 0.0;
    public double backgroundcolor_b = 0.0;
    public String font_name = null;
    public double font_size = 10.0;
    public double line_spacing = 12.0;
    public double min_pre_line_spacing = -1.0;
    public double min_post_line_spacing = -1.0;
    public double min_leading = -1.0;
    public String quadding = "start";
    public String font_family_name = "iso-serif";
    public String font_weight = "medium";
    public String font_posture = "upright";
    public String font_structure = "solid";
    public String font_proportionate_width = "medium";
    public double position_point_shift = 0.0;
    public double start_indent = 0.0;
    public double end_indent = 0.0;
    public double first_line_start_indent = 0.0;
    public double last_line_end_indent = 0.0;
    public String last_line_quadding = "relative";
    public double last_line_justify_limit = 0.0;
    public double justify_glyph_space_max_add = 0.0;
    public double justify_glyph_space_max_remove = 0.0;
    public boolean hanging_punct = false;
    public int widow_count = 2;
    public int orphan_count = 2;
    public int hyphenation_ladder_count = 0;
    public int hyphenation_remain_char_count = 2;
    public int hyphenation_push_char_count = 2;
    public boolean hyphenation_keep = false;
    public String line_breaking_method = "";
    public String line_composition_method = "";
    public double line_thickness = 1.0;
    public double line_sep = 1.0;
    public int line_repeat = 1;
    public String line_cap = "butt";
    public double field_width = 0.0;
    public String field_align = "start";
    public double cell_before_row_margin = 0.0;
    public double cell_after_row_margin = 0.0;
    public double cell_before_column_margin = 0.0;
    public double cell_after_column_margin = 0.0;
    public String box_type = "border";
    public String display_alignment = "start";
    public String internal_linkdestination = "";
    public SidelineMarker internal_sideline = null;
    public ScoreMarker internal_score = null;
    public String input_whitespace_treatment = "preserve";

    public void updatebyxmlnode(xmlnode o) {
        String a = o.getAttribute("page-width");
        if (a != null) {
            this.page_width = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("page-height")) != null) {
            this.page_height = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("left-margin")) != null) {
            this.left_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("right-margin")) != null) {
            this.right_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("top-margin")) != null) {
            this.top_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("bottom-margin")) != null) {
            this.bottom_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("header-margin")) != null) {
            this.header_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("footer-margin")) != null) {
            this.footer_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("font-name")) != null) {
            this.font_name = a;
        }
        if ((a = o.getAttribute("font-family-name")) != null) {
            this.font_family_name = a;
        }
        if ((a = o.getAttribute("font-weight")) != null) {
            this.font_weight = a;
        }
        if (this.font_weight.equals("false")) {
            this.font_weight = "medium";
        }
        if ((a = o.getAttribute("font-posture")) != null) {
            this.font_posture = a;
        }
        if ((a = o.getAttribute("font-structure")) != null) {
            this.font_structure = a;
        }
        if ((a = o.getAttribute("font-proportionate-width")) != null) {
            this.font_proportionate_width = a;
        }
        if ((a = o.getAttribute("quadding")) != null) {
            this.quadding = a;
        }
        if ((a = o.getAttribute("font-size")) != null) {
            this.font_size = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("line-spacing")) != null) {
            this.line_spacing = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("min-pre-line-spacing")) != null) {
            this.min_pre_line_spacing = a.equals("false") ? -1.0 : DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("min-post-line-spacing")) != null) {
            this.min_post_line_spacing = a.equals("false") ? -1.0 : DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("min-leading")) != null) {
            this.min_leading = a.equals("false") ? -1.0 : DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("position-point-shift")) != null) {
            this.position_point_shift = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("start-indent")) != null) {
            this.start_indent = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("end-indent")) != null) {
            this.end_indent = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("first-line-start-indent")) != null) {
            this.first_line_start_indent = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("last-line-end-indent")) != null) {
            this.last_line_end_indent = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("last-line-quadding")) != null) {
            this.last_line_quadding = a;
        }
        if ((a = o.getAttribute("last-line-justify-limit")) != null) {
            this.last_line_justify_limit = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("justify-glyph-space-max-add")) != null) {
            this.justify_glyph_space_max_add = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("justify-glyph-space-max-remove")) != null) {
            this.justify_glyph_space_max_add = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("hanging-punct")) != null) {
            this.hanging_punct = a.equals("true");
        }
        if ((a = o.getAttribute("widow-count")) != null) {
            this.widow_count = DSSSL_ParsedAttributes.readint(a);
        }
        if ((a = o.getAttribute("orphan-count")) != null) {
            this.orphan_count = DSSSL_ParsedAttributes.readint(a);
        }
        if ((a = o.getAttribute("hyphenation-ladder-count")) != null) {
            this.hyphenation_ladder_count = DSSSL_ParsedAttributes.readint(a);
        }
        if ((a = o.getAttribute("hyphenation-remain-char-count")) != null) {
            this.hyphenation_remain_char_count = DSSSL_ParsedAttributes.readint(a);
        }
        if ((a = o.getAttribute("hyphenation-push-char-count")) != null) {
            this.hyphenation_push_char_count = DSSSL_ParsedAttributes.readint(a);
        }
        if ((a = o.getAttribute("hyphenation-keep")) != null && !a.equals("false")) {
            this.hyphenation_keep = true;
        }
        if ((a = o.getAttribute("line-breaking-method")) != null) {
            this.line_breaking_method = a;
        }
        if ((a = o.getAttribute("line-composition-method")) != null) {
            this.line_composition_method = a;
        }
        if ((a = o.getAttribute("line-thickness")) != null) {
            this.line_thickness = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("line-sep")) != null) {
            this.line_sep = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("line-repeat")) != null) {
            this.line_repeat = DSSSL_ParsedAttributes.readint(a);
        }
        if ((a = o.getAttribute("line-cap")) != null) {
            this.line_cap = a;
        }
        if ((a = o.getAttribute("field-width")) != null) {
            this.field_width = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("field-align")) != null) {
            this.field_align = a;
        }
        if ((a = o.getAttribute("cell-before-row-margin")) != null) {
            this.cell_before_row_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("cell-after-row-margin")) != null) {
            this.cell_after_row_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("cell-before-column-margin")) != null) {
            this.cell_before_column_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("cell-after-column-margin")) != null) {
            this.cell_after_column_margin = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("display-alignment")) != null) {
            this.display_alignment = a;
        }
        if ((a = o.getAttribute("box-type")) != null) {
            this.box_type = a;
        }
        if ((a = o.getAttribute("color")) != null) {
            this.color_r = (double)StringTools.readHexByteString(a.substring(1, 3)) / 255.0;
            this.color_g = (double)StringTools.readHexByteString(a.substring(3, 5)) / 255.0;
            this.color_b = (double)StringTools.readHexByteString(a.substring(5, 7)) / 255.0;
        }
        if ((a = o.getAttribute("background-color")) != null) {
            this.backgroundcolor_r = (double)StringTools.readHexByteString(a.substring(1, 3)) / 255.0;
            this.backgroundcolor_g = (double)StringTools.readHexByteString(a.substring(3, 5)) / 255.0;
            this.backgroundcolor_b = (double)StringTools.readHexByteString(a.substring(5, 7)) / 255.0;
        }
        if ((a = o.getAttribute("input-whitespace-treatment")) != null) {
            this.input_whitespace_treatment = a;
        }
    }

    String getAnyColorString(double cr, double cg, double cb) {
        if (cr == 0.0 && cg == 0.0 && cb == 0.0) {
            return "0 0 0 ";
        }
        return GenericTools.round3(cr) + " " + GenericTools.round3(cg) + " " + GenericTools.round3(cb) + " ";
    }

    public String getColorString() {
        return this.getAnyColorString(this.color_r, this.color_g, this.color_b);
    }

    public String getBackgroundColorString() {
        return this.getAnyColorString(this.backgroundcolor_r, this.backgroundcolor_g, this.backgroundcolor_b);
    }

    public double getFullBoxWidth() {
        return this.page_width - this.left_margin - this.right_margin;
    }

    public double getIndentedBoxWidth() {
        return this.page_width - this.left_margin - this.right_margin - this.start_indent - this.end_indent;
    }

    public DSSSL_InheritedCharacteristics copy() {
        return (DSSSL_InheritedCharacteristics)this.clone();
    }
}

