/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter;

import com.pdftech.fot2pdf.formatter.DSSSL_DisplayNics;
import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.DSSSL_ParsedAttributes;
import com.pdftech.fot2pdf.formatter.FormatterParameters;
import com.pdftech.fot2pdf.formatter.LayoutParagraph;
import com.pdftech.fot2pdf.formatter.PageContainer;
import com.pdftech.fot2pdf.formatter.PageHeadersAndFooters;
import com.pdftech.fot2pdf.formatter.TextState;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.ScoreMarker;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.SidelineMarker;
import com.pdftech.fot2pdf.formatter.contentboxes.AnnotationContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.AnyContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.GraphicsContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.RawTextContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.TextContentBox;
import com.pdftech.fot2pdf.formatter.displayboxes.AnchorDisplayBox;
import com.pdftech.fot2pdf.formatter.displayboxes.DisplayBox;
import com.pdftech.fot2pdf.formatter.displayboxes.DisplayBoxList;
import com.pdftech.fot2pdf.formatter.displayboxes.GlueDisplayBox;
import com.pdftech.fot2pdf.formatter.displayboxes.GraphicsDisplayBox;
import com.pdftech.fot2pdf.formatter.displayboxes.PageBreakDisplayBox;
import com.pdftech.fot2pdf.formatter.displayboxes.TextDisplayBox;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineGroup;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineLeader;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObjectVector;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlinePageNumber;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlinePicture;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineRule;
import com.pdftech.fot2pdf.pdf.PDFlinkannotationobject;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.pdf.PDFpageobject;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.LinkedList;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.xml.FlowObjectTree;
import com.pdftech.fot2pdf.xml.xmlnode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class Formatter
extends Thread {
    private FlowObjectTree basefot;
    private String filename;
    private PDFoutfile pdf;
    private Vector pages = null;
    private int pagenumcnt;
    Hashtable AnchorList;

    public Formatter(ThreadGroup g, FlowObjectTree fot, String outFilename) {
        super(g, "Formatting");
        this.basefot = fot;
        this.filename = outFilename;
    }

    public Formatter(FlowObjectTree fot, String outFilename) {
        this.basefot = fot;
        this.filename = outFilename;
    }

    void makeHeaderFooter(LinkedList nl, DSSSL_InheritedCharacteristics ic, char toporbottom, char quadding, LinkedList headersandfooterslist) {
        Enumeration nlenum = nl.elements();
        while (nlenum.hasMoreElements()) {
            xmlnode o = (xmlnode)nlenum.nextElement();
            ic.updatebyxmlnode(o);
            TextState ts = new TextState();
            ts.updatebyicwithpdf(ic, this.pdf);
            ts.simplify();
            ts.setQuadding(quadding);
            DisplayBoxList dblist = this.makeSimpleParagraph(o, ic, ts);
            DisplayBox testbox = null;
            Enumeration enumeration = dblist.elements();
            while (testbox == null && enumeration.hasMoreElements()) {
                testbox = (DisplayBox)enumeration.nextElement();
                if (testbox instanceof TextDisplayBox) continue;
                testbox = null;
            }
            if (testbox == null) continue;
            TextDisplayBox b = (TextDisplayBox)testbox;
            if (toporbottom == 't') {
                b.setAbsolutePosition(0, ic.left_margin, ic.page_height - ic.header_margin + b.getHeight(1));
            } else {
                b.setAbsolutePosition(0, ic.left_margin, ic.footer_margin + b.getHeight(1));
            }
            String firstpageflag = "any";
            String frontpageflag = "any";
            String a = o.getAttribute("first");
            if (a != null) {
                firstpageflag = a;
            }
            if ((a = o.getAttribute("front")) != null) {
                frontpageflag = a;
            }
            headersandfooterslist.appendcheck(new HeaderFooterInfo(firstpageflag, frontpageflag, b));
        }
    }

    DisplayBoxList GlueBoxShooting(DisplayBoxList DisplayStream) {
        DisplayBox lastkeepdest = null;
        DisplayBoxList CheckStream = DisplayStream;
        DisplayStream = new DisplayBoxList();
        while (CheckStream.size() != 0) {
            DisplayBox b = CheckStream.pop();
            if (b instanceof GlueDisplayBox) {
                while (CheckStream.size() != 0 && !((GlueDisplayBox)b).isNonCompetitive()) {
                    DisplayBox nextb = CheckStream.pop();
                    while (nextb instanceof AnchorDisplayBox && CheckStream.size() > 0) {
                        DisplayStream.append(nextb);
                        nextb = CheckStream.pop();
                    }
                    boolean isfightingglue = nextb instanceof GlueDisplayBox;
                    if (isfightingglue) {
                        boolean bl = isfightingglue = !((GlueDisplayBox)nextb).isNonCompetitive();
                    }
                    if (isfightingglue) {
                        GlueDisplayBox b1 = (GlueDisplayBox)b;
                        GlueDisplayBox b2 = (GlueDisplayBox)nextb;
                        if (b1.hasForcePriority() && b2.hasForcePriority()) {
                            CheckStream.push(nextb);
                            break;
                        }
                        if (!(b1.getPriority() > b2.getPriority() || b1.getPriority() == b2.getPriority() && b1.getNominalHeight() > b2.getNominalHeight())) {
                            if (b1.getPriority() < b2.getPriority() || b1.getPriority() == b2.getPriority() && b1.getNominalHeight() < b2.getNominalHeight()) {
                                b1 = b2;
                            } else {
                                if (b2.getMinHeight() > b1.getMinHeight()) {
                                    b1.setMinHeight(b2.getMinHeight());
                                }
                                if (b2.getMaxHeight() < b1.getMaxHeight()) {
                                    b1.setMaxHeight(b2.getMaxHeight());
                                }
                            }
                        }
                        b = b1;
                        continue;
                    }
                    CheckStream.push(nextb);
                    break;
                }
            }
            DisplayStream.append(b);
            if (b.hasKeepWithPrevious() && lastkeepdest != null) {
                lastkeepdest.setLegalPageEnd(false);
            }
            if (!b.hasKeepWithNextApplied() && !b.isLegalPageEnd()) continue;
            lastkeepdest = b;
        }
        return DisplayStream;
    }

    public double compactDisplayBoxes(DisplayBoxList DisplayStream, LinkedList contentlist) {
        AnyContentBox ac;
        DisplayStream = this.GlueBoxShooting(DisplayStream);
        double akty = 0.0;
        Enumeration pageboxes = DisplayStream.elements();
        while (DisplayStream.size() > 0) {
            DisplayBox b = DisplayStream.remove();
            double h = b.getHeight(1);
            Enumeration contentenum = b.getContentBoxes().elements();
            while (contentenum.hasMoreElements()) {
                ac = (AnyContentBox)contentenum.nextElement();
                ac.moveby(0.0, akty);
                contentlist.append(ac);
            }
            akty += h;
        }
        Enumeration e = contentlist.elements();
        while (e.hasMoreElements()) {
            ac = (AnyContentBox)e.nextElement();
        }
        return akty;
    }

    public void paginate(xmlnode node, DisplayBoxList DisplayStream, DSSSL_InheritedCharacteristics ic, PageHeadersAndFooters phf) {
        int boxcnt = 0;
        double akty = 0.0;
        LinkedList headersandfooters = new LinkedList();
        this.makeHeaderFooter(phf.left_header, ic.copy(), 't', 'l', headersandfooters);
        this.makeHeaderFooter(phf.center_header, ic.copy(), 't', 'c', headersandfooters);
        this.makeHeaderFooter(phf.right_header, ic.copy(), 't', 'r', headersandfooters);
        this.makeHeaderFooter(phf.left_footer, ic.copy(), 'b', 'l', headersandfooters);
        this.makeHeaderFooter(phf.center_footer, ic.copy(), 'b', 'c', headersandfooters);
        this.makeHeaderFooter(phf.right_footer, ic.copy(), 'b', 'r', headersandfooters);
        DisplayStream = this.GlueBoxShooting(DisplayStream);
        String a = node.getAttribute("initial-page-count");
        if (a == null) {
            a = "any";
        }
        if (a.equals("even") && this.pagenumcnt % 2 == 1 || a.equals("odd") && this.pagenumcnt % 2 == 0) {
            PageContainer fillpage = new PageContainer(this.pagenumcnt++, ic.copy());
            this.pages.add(fillpage);
        }
        int localpagenumcnt = 0;
        PageContainer aktpage = null;
        while (DisplayStream.size() != 0) {
            double h;
            DisplayBox b;
            Status.print("...paginating...");
            aktpage = new PageContainer(this.pagenumcnt++, ic.copy());
            akty = ic.page_height - ic.top_margin;
            Enumeration hfenum = headersandfooters.elements();
            while (hfenum.hasMoreElements()) {
                HeaderFooterInfo hfinfo = (HeaderFooterInfo)hfenum.nextElement();
                if ((localpagenumcnt != 0 || !hfinfo.getIsFirst()) && (localpagenumcnt <= 0 || !hfinfo.getIsNonFirst()) || (!hfinfo.getIsOdd() || this.pagenumcnt % 2 != 0) && (!hfinfo.getIsEven() || this.pagenumcnt % 2 != 1)) continue;
                TextDisplayBox hfbox = hfinfo.getBox().copy();
                hfbox.setPositionPage(this.pagenumcnt - 1);
                aktpage.addDisplayBox(hfbox);
            }
            boxcnt = 0;
            ++localpagenumcnt;
            boolean pagebreak = false;
            boolean forcedpagebreak = true;
            DisplayBoxList aktpagedisplaystream = new DisplayBoxList();
            while (!pagebreak) {
                DisplayBoxList boxgroup = new DisplayBoxList();
                double groupheight = 0.0;
                double h2 = 0.0;
                boolean groupboxcnt = false;
                boolean groupstilltop = boxcnt == 0;
                while (DisplayStream.size() > 0) {
                    b = DisplayStream.remove();
                    boxgroup.push(b);
                    if (b.isLegalPageEnd() || DisplayStream.size() == 0) {
                        h2 = b.getHeight(2);
                    } else if (groupstilltop) {
                        h2 = b.getHeight(0);
                        groupstilltop = b instanceof GlueDisplayBox || b instanceof AnchorDisplayBox;
                    } else {
                        h2 = b.getHeight(1);
                    }
                    groupheight += h2;
                    if (b.isLegalPageEnd()) break;
                }
                if (DisplayStream.size() == 0) {
                    pagebreak = true;
                }
                if (groupheight > ic.page_height - ic.top_margin - ic.bottom_margin && boxcnt == 0) {
                    Status.println("\rWARNING! Keep-contraints exceed page-dimensions! Unproper pagination!");
                    while (boxgroup.size() > 1) {
                        DisplayStream.push(boxgroup.pop());
                    }
                    groupheight = 0.0;
                }
                if (akty - groupheight + 0.1 < ic.bottom_margin) {
                    while (boxgroup.size() > 0) {
                        DisplayStream.push(boxgroup.pop());
                    }
                    boxgroup.push(new PageBreakDisplayBox());
                    forcedpagebreak = false;
                }
                boxgroup.reverse();
                while (boxgroup.size() > 0) {
                    b = boxgroup.remove();
                    if (b instanceof PageBreakDisplayBox && boxcnt > 0) {
                        pagebreak = true;
                        continue;
                    }
                    if (!(b instanceof PageBreakDisplayBox) || boxcnt == 0) {
                        // empty if block
                    }
                    int n = --boxcnt;
                    ++boxcnt;
                    h2 = n == 0 ? b.getHeight(0) : b.getHeight(1);
                    if (b instanceof TextDisplayBox) {
                        // empty if block
                    }
                    if (b instanceof GlueDisplayBox && boxcnt == 1 && h2 == 0.0) {
                        --boxcnt;
                        b = null;
                    }
                    if (b instanceof AnchorDisplayBox) {
                        --boxcnt;
                    }
                    if (b instanceof GraphicsDisplayBox) {
                        // empty if block
                    }
                    if (b == null) continue;
                    aktpagedisplaystream.append(b);
                    akty -= h2;
                }
            }
            double GlueAdjustment = 0.0;
            int anzboxes = aktpagedisplaystream.size();
            if (FormatterParameters.getBalancePagesFlag() && !forcedpagebreak) {
                Enumeration pageboxes = aktpagedisplaystream.elements();
                double normheight = 0.0;
                double stretchsum = 0.0;
                int i = 0;
                while (i < anzboxes) {
                    b = (DisplayBox)pageboxes.nextElement();
                    h = i == 0 ? b.getHeight(0) : (i == anzboxes - 1 ? b.getHeight(2) : b.getHeight(1));
                    normheight += h;
                    if (b instanceof GlueDisplayBox) {
                        stretchsum += ((GlueDisplayBox)b).getMaxHeight() - h;
                        if (((GlueDisplayBox)b).getMaxHeight() - h != 0.0) {
                            // empty if block
                        }
                    }
                    ++i;
                }
                double wantheight = ic.page_height - ic.top_margin - ic.bottom_margin;
                if (normheight + stretchsum < wantheight) {
                    Status.println("\rWARNING! Page " + (this.pagenumcnt - 1) + " could not be balanced due to lacking stretchability!");
                } else {
                    GlueAdjustment = (wantheight - normheight) / stretchsum;
                }
            }
            Enumeration pageboxes = aktpagedisplaystream.elements();
            akty = ic.page_height - ic.top_margin;
            boxcnt = 0;
            while (aktpagedisplaystream.size() > 0) {
                b = aktpagedisplaystream.remove();
                b.setAbsolutePosition(this.pagenumcnt - 1, 0.0, akty);
                aktpage.addDisplayBox(b);
                h = boxcnt++ == 0 ? b.getHeight(0) : b.getHeight(1);
                akty -= h;
                if (!(b instanceof GlueDisplayBox) || GlueAdjustment == 0.0) continue;
                akty -= GlueAdjustment * (((GlueDisplayBox)b).getMaxHeight() - h);
            }
            if (DisplayStream.size() == 0 && boxcnt == 0) {
                --this.pagenumcnt;
                continue;
            }
            this.pages.add(aktpage);
        }
    }

    public void writepages() {
        System.gc();
        LinkedList pageannotations = new LinkedList();
        PDFpageobject aktpage = null;
        double aktx = 0.0;
        double akty = 0.0;
        double lasttextbox_xpos = 0.0;
        double lasttextbox_ypos = 0.0;
        int i = 0;
        while (i < this.pages.size()) {
            Status.print("\rWriting PDF, page " + (i + 1) + "...");
            PageContainer sourcepage = (PageContainer)this.pages.elementAt(i);
            DSSSL_InheritedCharacteristics ic = sourcepage.getic();
            aktpage = new PDFpageobject(this.pdf, ic.page_width, ic.page_height);
            sourcepage.setPDFobject(aktpage);
            aktx = ic.left_margin;
            akty = ic.page_height - ic.top_margin;
            lasttextbox_xpos = 0.0;
            lasttextbox_ypos = 0.0;
            StringBuffer textcontentstring = new StringBuffer("");
            StringBuffer restcontentstring = new StringBuffer("");
            TextState lasttextstate = null;
            int boxcnt = 0;
            Enumeration enumeration = sourcepage.elements();
            while (enumeration.hasMoreElements()) {
                DisplayBox b = (DisplayBox)enumeration.nextElement();
                double h = boxcnt++ == 0 ? b.getHeight(0) : b.getHeight(1);
                akty = b.getAbsolutePositionY();
                LinkedList aktcontent = b.getContentBoxes();
                aktcontent.reset();
                AnyContentBox box = null;
                while (aktcontent.hasMoreElements()) {
                    box = (AnyContentBox)aktcontent.currentElement();
                    if (box instanceof RawTextContentBox) {
                        RawTextContentBox rtcb = (RawTextContentBox)box;
                        aktcontent.remove();
                        rtcb.replacepagenums(i + 1, this.AnchorList);
                        rtcb.calc();
                        LinkedList newcontent = rtcb.getResultContentBoxes();
                        newcontent.reset();
                        while (newcontent.hasMoreElements()) {
                            aktcontent.insert(newcontent.nextElement());
                        }
                        aktcontent.reset();
                        continue;
                    }
                    aktcontent.nextElement();
                }
                if (b.getSidelineMarker() != null) {
                    b.getSidelineMarker().apply(b);
                }
                Enumeration contentenum = b.getContentBoxes().elements();
                while (contentenum.hasMoreElements()) {
                    AnyContentBox ac = (AnyContentBox)contentenum.nextElement();
                    if (ac instanceof TextContentBox) {
                        TextContentBox tc = (TextContentBox)ac;
                        if (lasttextstate == null) {
                            textcontentstring.append(tc.getStartTextState().getString());
                        } else {
                            textcontentstring.append(tc.getStartTextState().getDiffString(lasttextstate));
                        }
                        double lastx = lasttextbox_xpos;
                        double lasty = lasttextbox_ypos;
                        lasttextbox_xpos = aktx + tc.getRelativePositionX();
                        lasttextbox_ypos = akty - tc.getRelativePositionY();
                        textcontentstring.append(GenericTools.round3(lasttextbox_xpos - lastx) + " " + GenericTools.round3(lasttextbox_ypos - lasty) + " Td " + tc.getString() + "\r\n");
                        lasttextstate = tc.getEndTextState();
                    }
                    if (ac instanceof GraphicsContentBox) {
                        GraphicsContentBox gc = (GraphicsContentBox)ac;
                        restcontentstring.append("q 1 0 0 1 " + GenericTools.round3(aktx + ac.getRelativePositionX()) + " " + GenericTools.round3(akty - ac.getRelativePositionY()) + " cm " + gc.getGraphicsString() + " Q\r\n");
                    }
                    if (ac instanceof AnnotationContentBox) {
                        AnnotationContentBox a = (AnnotationContentBox)ac;
                        a.setX(aktx + ac.getRelativePositionX());
                        a.setY(akty - ac.getRelativePositionY());
                        a.setPDFobject(new PDFlinkannotationobject(this.pdf, aktpage));
                        pageannotations.append(a);
                    }
                    Iterator resiterator = ac.resourcesset.iterator();
                    while (resiterator.hasNext()) {
                        aktpage.AddResource(resiterator.next());
                    }
                }
                akty -= h;
            }
            if (textcontentstring.length() != 0) {
                if (restcontentstring.length() != 0) {
                    aktpage.AddContent(restcontentstring + "\r\nBT\r\n" + textcontentstring + "ET\r\n");
                } else {
                    aktpage.AddContent("BT\r\n" + textcontentstring + "ET");
                }
            } else if (textcontentstring.length() == 0 && restcontentstring.length() != 0) {
                aktpage.AddContent(restcontentstring.toString());
            }
            aktpage.write();
            sourcepage.clearBoxes();
            System.gc();
            ++i;
        }
        Status.print("\rWriting document-wide annotations...");
        Enumeration annotenum = pageannotations.elements();
        while (annotenum.hasMoreElements()) {
            AnnotationContentBox a = (AnnotationContentBox)annotenum.nextElement();
            PDFlinkannotationobject o = a.getPDFobject();
            o.setRectangle(a.getX(), a.getY(), a.getX() + a.getWidth(), a.getY() + a.getHeight());
            if (a.isPageRef()) {
                o.setDestination(((PageContainer)this.pages.elementAt(a.getPageRef() - 1)).getPDFobject(), 0.0);
            } else {
                Object anchordest = this.AnchorList.get(a.getLinkRef());
                if (anchordest != null && anchordest instanceof AnchorDisplayBox) {
                    AnchorDisplayBox anchor = (AnchorDisplayBox)anchordest;
                    o.setDestination(((PageContainer)this.pages.elementAt(anchor.getPositionPage() - 1)).getPDFobject(), anchor.getAbsolutePositionY());
                } else {
                    o.setURI(a.getLinkRef());
                }
            }
            o.write();
        }
        Status.print("\rPDF written.");
    }

    public void resolveAnchorList() {
        AnchorDisplayBox a = null;
        int j = 0;
        while (j < this.pages.size()) {
            PageContainer page = (PageContainer)this.pages.elementAt(j++);
            Enumeration enumeration = page.elements();
            while (enumeration.hasMoreElements()) {
                DisplayBox b = (DisplayBox)enumeration.nextElement();
                if (!(b instanceof AnchorDisplayBox) || !this.AnchorList.containsKey((a = (AnchorDisplayBox)b).getReference())) continue;
                this.AnchorList.put(a.getReference(), a);
            }
        }
    }

    private xmlnode fillContentByNode(InlineObjectVector ov, Stack statestack) {
        xmlnode e;
        xmlnode o = ((inobjectstatus)statestack.peek()).node;
        DSSSL_InheritedCharacteristics ic = ((inobjectstatus)statestack.peek()).ic;
        TextState ts = ((inobjectstatus)statestack.peek()).ts;
        xmlnode startwithnode = ((inobjectstatus)statestack.peek()).innernode;
        ic.updatebyxmlnode(o);
        ts.updatebyicwithpdf(ic, this.pdf);
        o.reset();
        if (startwithnode != null) {
            e = null;
            do {
                if (o.peekElement() instanceof xmlnode) {
                    e = (xmlnode)o.nextElement();
                    continue;
                }
                o.nextElement();
            } while (e != startwithnode);
        }
        while (o.hasNext()) {
            String a;
            if (!(o.peekElement() instanceof xmlnode)) {
                o.nextElement();
                if (!o.hasNext()) break;
            }
            if ((e = (xmlnode)o.nextElement()).getName().equals("text")) {
                e.reset();
                if (e.hasNext()) {
                    ov.add((String)e.nextElement(), ts);
                }
            }
            if (e.getName().equals("line-field")) {
                ov.add(this.makeLineField(e, ic.copy(), ts.copy()));
            }
            if (e.getName().equals("leader")) {
                InlineLeader newleader;
                InlineObjectVector leaderdata = this.makeContents(e, ic.copy(), ts.copy());
                boolean alignflag = true;
                a = e.getAttribute("align-leader");
                if (a != null) {
                    alignflag = a.equals("true");
                }
                if ((a = e.getAttribute("length")) != null) {
                    double wantlen = DSSSL_ParsedAttributes.readlen(a);
                    newleader = new InlineLeader(wantlen, alignflag, leaderdata);
                } else {
                    int minrepeat = 1;
                    a = e.getAttribute("min-leader-repeat");
                    if (a != null) {
                        minrepeat = DSSSL_ParsedAttributes.readint(a);
                    }
                    newleader = new InlineLeader(minrepeat, alignflag, leaderdata);
                }
                newleader.setLinkRef(ts.getLinkRef());
                ov.add(newleader);
            }
            if (e.getName().equals("page-number")) {
                String ref = e.getAttribute("ref");
                if (ref == null) {
                    ov.add(new InlinePageNumber(ts));
                } else {
                    ov.add(new InlinePageNumber(ref, ts));
                }
            }
            if (e.getName().equals("paragraph-break")) {
                ((inobjectstatus)statestack.peek()).innernode = e;
                return e;
            }
            if (e.getName().equals("paragraph") || e.getName().equals("display-group") || e.getName().equals("table") || e.getName().equals("box")) {
                ((inobjectstatus)statestack.peek()).innernode = e;
                return e;
            }
            if (e.getName().equals("rule")) {
                boolean displayit = false;
                a = e.getAttribute("orientation");
                if (a != null) {
                    boolean bl = displayit = a.equals("horizontal") || a.equals("vertical");
                }
                if (displayit) {
                    ((inobjectstatus)statestack.peek()).innernode = e;
                    return e;
                }
                ov.add(new InlineRule(ic.getFullBoxWidth(), ts.getSize(), e, ic.copy()));
            }
            if (e.getName().equals("external-graphic")) {
                boolean displayit = false;
                a = e.getAttribute("display");
                if (a != null) {
                    displayit = a.equals("true");
                }
                if (displayit) {
                    ((inobjectstatus)statestack.peek()).innernode = e;
                    return e;
                }
                ov.add(new InlinePicture(ic.getFullBoxWidth(), ts.getSize(), e, ic.copy(), this.pdf));
            }
            if (e.getName().equals("sequence")) {
                ((inobjectstatus)statestack.peek()).innernode = e;
                statestack.push(new inobjectstatus(e, ic.copy(), ts.copy(), null));
                return e;
            }
            if (e.getName().equals("a")) {
                ((inobjectstatus)statestack.peek()).innernode = e;
                return e;
            }
            if (e.getName().equals("link")) {
                DSSSL_InheritedCharacteristics newic = ic.copy();
                String ref = e.getAttribute("destination");
                if (ref != null) {
                    newic.internal_linkdestination = ref;
                    this.AnchorList.put(newic.internal_linkdestination, "");
                }
                ((inobjectstatus)statestack.peek()).innernode = e;
                statestack.push(new inobjectstatus(e, newic, ts.copy(), null));
                return e;
            }
            if (e.getName().equals("sideline")) {
                DSSSL_InheritedCharacteristics newic = ic.copy();
                newic.internal_sideline = new SidelineMarker(e);
                newic.updatebyxmlnode(e);
                ((inobjectstatus)statestack.peek()).innernode = e;
                statestack.push(new inobjectstatus(e, newic, ts.copy(), null));
                return e;
            }
            if (!e.getName().equals("score")) continue;
            DSSSL_InheritedCharacteristics newic = ic.copy();
            newic.internal_score = new ScoreMarker(e, ic.copy(), ts.copy());
            newic.updatebyxmlnode(e);
            ((inobjectstatus)statestack.peek()).innernode = e;
            statestack.push(new inobjectstatus(e, newic, ts.copy(), null));
            return e;
        }
        return null;
    }

    InlineObjectVector makeContents(xmlnode o, DSSSL_InheritedCharacteristics ic, TextState ts) {
        ic.updatebyxmlnode(o);
        ts.updatebyicwithpdf(ic, this.pdf);
        ts.simplify();
        InlineObjectVector ov = new InlineObjectVector();
        Stack<inobjectstatus> statestack = new Stack<inobjectstatus>();
        statestack.push(new inobjectstatus(o, ic.copy(), ts.copy(), null));
        xmlnode endnode = this.fillContentByNode(ov, statestack);
        ov.CheckWhitespaceTreatment(ic);
        if (endnode != null) {
            Status.println("\rWARNING! Pure InlineObject \"" + o.getName() + "\" contains displayed object (\"" + endnode.getName() + "\")! Check DSSSL-Script!");
        }
        return ov;
    }

    /*
     * Unable to fully structure code
     */
    public static String makeAlignedLineDrawStringXY(DSSSL_InheritedCharacteristics ic, double x, double y, double linelen, char orientation, char aligning) {
        block8: {
            s = new StringBuffer(ic.line_thickness + " w");
            if (ic.line_cap.equals("butt")) {
                s.append(" 0 J");
            }
            if (ic.line_cap.equals("round")) {
                s.append(" 1 J");
            }
            if (ic.line_cap.equals("square")) {
                s.append(" 2 J");
            }
            if (!ic.getColorString().equals("0 0 0 ")) {
                s.append(" " + ic.getColorString() + "RG");
            }
            i = ic.line_repeat;
            height = ic.line_thickness + (double)(ic.line_repeat - 1) * (ic.line_thickness + ic.line_sep);
            moveval = ic.line_thickness / 2.0;
            if (aligning == 'c') {
                moveval -= height / 2.0;
            }
            if (aligning == 'e') {
                moveval -= height;
            }
            if (orientation != 'h') ** GOTO lbl29
            while (--i >= 0) {
                s.append(" " + GenericTools.round3(x) + " " + GenericTools.round3(y - moveval - ic.line_sep * (double)i) + " m " + GenericTools.round3(x + linelen) + " " + GenericTools.round3(y - moveval - ic.line_sep * (double)i) + " l S");
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                s.append(" " + GenericTools.round3(x + moveval + ic.line_sep * (double)i) + " " + GenericTools.round3(y) + " m " + GenericTools.round3(x + moveval + ic.line_sep * (double)i) + " " + GenericTools.round3(y - linelen) + " l S");
lbl29:
                // 2 sources

                ** while (--i >= 0)
            }
        }
        return s.toString();
    }

    public static String makeAlignedLineDrawString(DSSSL_InheritedCharacteristics ic, double linelen, char orientation, char aligning) {
        return Formatter.makeAlignedLineDrawStringXY(ic, 0.0, 0.0, linelen, orientation, aligning);
    }

    public static String makeLineDrawString(DSSSL_InheritedCharacteristics ic, double linelen, char orientation) {
        return Formatter.makeAlignedLineDrawString(ic, linelen, orientation, 'c');
    }

    InlineGroup makeLineField(xmlnode o, DSSSL_InheritedCharacteristics ic, TextState ts) {
        InlineGroup g;
        ic.updatebyxmlnode(o);
        ts.updatebyicwithpdf(ic, this.pdf);
        ts.simplify();
        DisplayBoxList dblist = this.makeSimpleParagraph(o, ic, ts);
        double fieldlen = ic.field_width;
        double fieldheight = 0.0;
        DisplayBox testbox = null;
        Enumeration enumeration = dblist.elements();
        while (testbox == null && enumeration.hasMoreElements()) {
            testbox = (DisplayBox)enumeration.nextElement();
            if (testbox instanceof TextDisplayBox) continue;
            testbox = null;
        }
        if (testbox == null) {
            g = new InlineGroup(fieldlen, fieldheight);
        } else {
            TextDisplayBox b = (TextDisplayBox)testbox;
            boolean needbreak = false;
            if (b.getCalcedWidth() > fieldlen) {
                fieldlen = b.getCalcedWidth();
                needbreak = true;
            }
            fieldheight = b.getHeight(1);
            g = new InlineGroup(fieldlen, fieldheight);
            double moveval = 0.0;
            if (ic.field_align.equals("center")) {
                moveval = (fieldlen - b.getCalcedWidth()) / 2.0;
            }
            if (ic.field_align.equals("end")) {
                moveval = fieldlen - b.getCalcedWidth();
            }
            enumeration = b.getContentBoxes().elements();
            while (enumeration.hasMoreElements()) {
                AnyContentBox e = (AnyContentBox)enumeration.nextElement();
                e.moveby(moveval, 0.0);
                g.addContent(e);
            }
            if (needbreak) {
                g.setForceBreakAfter(true);
            }
        }
        g.setLinkRef(ts.getLinkRef());
        return g;
    }

    public DisplayBox makePageBreak() {
        return new PageBreakDisplayBox();
    }

    public DisplayBoxList makeConditionalSpaceBefore(DSSSL_DisplayNics d) {
        DisplayBoxList localstream = new DisplayBoxList();
        if (d.break_before) {
            localstream.append(this.makePageBreak());
            return localstream;
        }
        if (d.space_before_length != 0.0) {
            GlueDisplayBox b = new GlueDisplayBox(0.0, d.space_before_length, d.space_before_min, d.space_before_max);
            b.setConditional(d.space_before_conditional);
            if (d.space_before_priority_force) {
                b.setForcePriority();
            } else {
                b.setPriority(d.space_before_priority);
            }
            localstream.append(b);
        }
        return localstream;
    }

    public DisplayBoxList makeConditionalSpaceBefore(xmlnode o) {
        DSSSL_DisplayNics d = new DSSSL_DisplayNics();
        d.updatebyxmlnode(o);
        return this.makeConditionalSpaceBefore(d);
    }

    public DisplayBoxList makeConditionalSpaceAfter(DSSSL_DisplayNics d) {
        DisplayBoxList localstream = new DisplayBoxList();
        if (d.break_after) {
            localstream.append(this.makePageBreak());
            return localstream;
        }
        if (d.space_after_length != 0.0) {
            GlueDisplayBox b = new GlueDisplayBox(0.0, d.space_after_length, d.space_after_min, d.space_after_max);
            b.setConditional(d.space_after_conditional);
            if (d.space_after_priority_force) {
                b.setForcePriority();
            } else {
                b.setPriority(d.space_after_priority);
            }
            localstream.append(b);
        }
        return localstream;
    }

    public DisplayBoxList makeConditionalSpaceAfter(xmlnode o) {
        DSSSL_DisplayNics d = new DSSSL_DisplayNics();
        d.updatebyxmlnode(o);
        return this.makeConditionalSpaceAfter(d);
    }

    public DisplayBoxList makeSimpleParagraph(xmlnode o, DSSSL_InheritedCharacteristics ic, TextState ts) {
        DisplayBoxList localstream = new DisplayBoxList();
        Stack<inobjectstatus> statestack = new Stack<inobjectstatus>();
        statestack.push(new inobjectstatus(o, ic.copy(), ts.copy(), null));
        xmlnode curnode = null;
        InlineObjectVector ov = new InlineObjectVector();
        do {
            curnode = this.fillContentByNode(ov, statestack);
            ov.CheckWhitespaceTreatment(ic);
            if (curnode == null) {
                statestack.pop();
            }
            if (curnode == null && statestack.empty() || curnode != null && (curnode.getName().equals("external-graphic") || curnode.getName().equals("rule") || curnode.getName().equals("table") || curnode.getName().equals("display-group") || curnode.getName().equals("box") || curnode.getName().equals("paragraph") || curnode.getName().equals("paragraph-break"))) {
                LayoutParagraph p = new LayoutParagraph(ic.copy(), ts.copy(), ov);
                localstream.append(p.makeDisplayBoxes());
                ov = new InlineObjectVector();
            }
            if (curnode == null) continue;
            DSSSL_InheritedCharacteristics useic = ((inobjectstatus)statestack.peek()).ic.copy();
            if (curnode.getName().equals("a")) {
                localstream.append(new AnchorDisplayBox(curnode.getAttribute("name")));
            }
            if (curnode.getName().equals("link") || curnode.getName().equals("score") || curnode.getName().equals("sequence")) {
                // empty if block
            }
            if (curnode.getName().equals("external-graphic")) {
                localstream.append(this.makeDisplayedGraphic(curnode, useic));
            }
            if (curnode.getName().equals("rule")) {
                localstream.append(this.makeDisplayedRule(curnode, useic));
            }
            if (curnode.getName().equals("paragraph")) {
                localstream.append(this.makeDisplayedParagraph(curnode, useic));
            }
            if (curnode.getName().equals("display-group")) {
                localstream.append(this.makeDisplayGroup(curnode, useic));
            }
            if (curnode.getName().equals("table")) {
                localstream.append(this.makeTable(curnode, useic));
            }
            if (!curnode.getName().equals("box")) continue;
            localstream.append(this.makeBox(curnode, useic));
        } while (curnode != null || !statestack.empty());
        return localstream;
    }

    public DisplayBoxList makeDisplayedRule(xmlnode o, DSSSL_InheritedCharacteristics ic) {
        DisplayBoxList localstream = new DisplayBoxList();
        ic.updatebyxmlnode(o);
        boolean orientation = false;
        String a = o.getAttribute("orientation");
        if (a != null) {
            if (a.equals("horizontal")) {
                orientation = false;
            } else if (a.equals("vertical")) {
                orientation = true;
            } else {
                Status.println("\rWARNING! Displayed rule has abnormal orientation: " + a);
                return localstream;
            }
        }
        double len = 0.0;
        if (!orientation) {
            len = ic.getIndentedBoxWidth();
        }
        if ((a = o.getAttribute("length")) != null) {
            len = DSSSL_ParsedAttributes.readlen(a);
        } else if (orientation) {
            Status.println("\rWARNING! Vertical rule without length found?!");
            return localstream;
        }
        double boxwidth = len;
        double boxheight = ic.line_thickness + (double)(ic.line_repeat - 1) * (ic.line_thickness + ic.line_sep);
        int ochar = 104;
        if (orientation) {
            boxwidth = boxheight;
            boxheight = len;
            ochar = 118;
        }
        String s = Formatter.makeLineDrawString(ic, len, (char)ochar);
        GraphicsContentBox gcb = new GraphicsContentBox(s);
        double max_x = ic.getIndentedBoxWidth();
        double indent = ic.start_indent;
        if (ic.display_alignment.equals("end")) {
            indent += max_x - boxwidth;
        }
        if (ic.display_alignment.equals("center")) {
            indent += (max_x - boxwidth) / 2.0;
        }
        gcb.moveby(indent, 0.0);
        localstream.append(this.makeConditionalSpaceBefore(o));
        localstream.append(new GraphicsDisplayBox(ic.getFullBoxWidth(), boxheight, gcb));
        localstream.append(this.makeConditionalSpaceAfter(o));
        this.applyKeeps(o, localstream);
        return localstream;
    }

    public DisplayBoxList makeDisplayedGraphic(xmlnode o, DSSSL_InheritedCharacteristics ic) {
        DisplayBoxList localstream = new DisplayBoxList();
        ic.updatebyxmlnode(o);
        double max_x = ic.getIndentedBoxWidth();
        double max_y = ic.page_height - ic.top_margin - ic.bottom_margin;
        InlinePicture ip = new InlinePicture(max_x, max_y, o, ic, this.pdf);
        double dest_x = ip.getWidth();
        double dest_y = ip.getHeight();
        GraphicsContentBox contentbox = ip.getContent();
        double indent = ic.start_indent;
        if (ic.display_alignment.equals("end")) {
            indent += max_x - dest_x;
        }
        if (ic.display_alignment.equals("center")) {
            indent += (max_x - dest_x) / 2.0;
        }
        contentbox.moveby(indent, 0.0);
        localstream.append(this.makeConditionalSpaceBefore(o));
        GraphicsDisplayBox gdb = new GraphicsDisplayBox(max_x, dest_y, contentbox);
        if (!ic.internal_linkdestination.equals("")) {
            AnnotationContentBox ac = new AnnotationContentBox(0.0, dest_x, dest_y, ic.internal_linkdestination);
            ac.moveby(indent, dest_y);
            gdb.addContentBox(ac);
        }
        localstream.append(gdb);
        localstream.append(this.makeConditionalSpaceAfter(o));
        this.applyKeeps(o, localstream);
        return localstream;
    }

    public DisplayBoxList makeDisplayedParagraph(xmlnode o, DSSSL_InheritedCharacteristics ic) {
        DisplayBoxList localstream = new DisplayBoxList();
        ic.updatebyxmlnode(o);
        TextState ts = new TextState();
        ts.updatebyicwithpdf(ic, this.pdf);
        localstream.append(this.makeConditionalSpaceBefore(o));
        localstream.append(this.makeSimpleParagraph(o, ic, ts));
        localstream.append(this.makeConditionalSpaceAfter(o));
        this.applyKeeps(o, localstream);
        return localstream;
    }

    public DisplayBoxList makeTable(xmlnode o, DSSSL_InheritedCharacteristics ic) {
        DisplayBoxList localstream = new DisplayBoxList();
        ic.updatebyxmlnode(o);
        LayoutTable table = new LayoutTable(ic);
        String a = o.getAttribute("table-width");
        if (a != null) {
            table.setMaxWidth(DSSSL_ParsedAttributes.readlen(a));
        }
        localstream.append(this.makeConditionalSpaceBefore(o));
        table.parseAndAppendDisplayBoxes(localstream, o, ic.copy());
        localstream.append(this.makeConditionalSpaceAfter(o));
        this.applyKeeps(o, localstream);
        return localstream;
    }

    public static DisplayBoxList filterAnchorBoxes(DisplayBoxList inlist) {
        DisplayBoxList anchordisplayboxes = new DisplayBoxList();
        Enumeration e = inlist.elements();
        while (e.hasMoreElements()) {
            DisplayBox b = (DisplayBox)e.nextElement();
            if (!(b instanceof AnchorDisplayBox)) continue;
            anchordisplayboxes.append(b);
        }
        return anchordisplayboxes;
    }

    public DisplayBoxList makeBox(xmlnode o, DSSSL_InheritedCharacteristics ic) {
        ic.updatebyxmlnode(o);
        double boxwidth = ic.getIndentedBoxWidth();
        ic.left_margin += ic.start_indent;
        ic.right_margin += ic.end_indent;
        DisplayBoxList contentdisplayboxes = this.ProcessFlowObjectChildren(o, ic.copy());
        DisplayBoxList anchordisplayboxes = Formatter.filterAnchorBoxes(contentdisplayboxes);
        LinkedList contentboxes = new LinkedList();
        double boxheight = this.compactDisplayBoxes(contentdisplayboxes, contentboxes);
        Enumeration e = contentboxes.elements();
        while (e.hasMoreElements()) {
            ((AnyContentBox)e.nextElement()).moveby(ic.start_indent, 0.0);
        }
        DisplayBox boxbox = new DisplayBox(boxwidth, boxheight, true);
        boolean hasborder = ic.box_type.equals("border") || ic.box_type.equals("both");
        boolean hasbackground = ic.box_type.equals("background") || ic.box_type.equals("both");
        StringBuffer s = new StringBuffer(ic.line_thickness + " w");
        if (ic.line_cap.equals("butt")) {
            s.append(" 0 J");
        }
        if (ic.line_cap.equals("round")) {
            s.append(" 1 J");
        }
        if (ic.line_cap.equals("square")) {
            s.append(" 2 J");
        }
        if (!ic.getColorString().equals("0 0 0 ")) {
            s.append(" " + ic.getColorString() + "RG");
        }
        if (!ic.getBackgroundColorString().equals("0 0 0 ")) {
            s.append(" " + ic.getBackgroundColorString() + "rg");
        }
        s.append(" 0 0 " + GenericTools.round3(boxwidth) + " " + GenericTools.round3(-boxheight) + " re ");
        if (hasborder && hasbackground) {
            s.append("B");
        } else if (hasborder) {
            s.append("S");
        } else {
            s.append("f");
        }
        GraphicsContentBox gcb = new GraphicsContentBox(s.toString());
        gcb.moveby(ic.start_indent, 0.0);
        boxbox.addContentBox(gcb);
        e = contentboxes.elements();
        while (e.hasMoreElements()) {
            boxbox.addContentBox((AnyContentBox)e.nextElement());
        }
        DisplayBoxList localstream = new DisplayBoxList();
        localstream.append(this.makeConditionalSpaceBefore(o));
        localstream.append(anchordisplayboxes);
        localstream.append(boxbox);
        localstream.append(this.makeConditionalSpaceAfter(o));
        return localstream;
    }

    private void applyKeeps(xmlnode o, DisplayBoxList l) {
        DisplayBox b;
        Enumeration e;
        DSSSL_DisplayNics d = new DSSSL_DisplayNics();
        d.updatebyxmlnode(o);
        String a = o.getAttribute("keep");
        if (a != null && (a.equals("true") || a.equals("page"))) {
            e = l.elements();
            DisplayBox lastlegalbox = null;
            while (e.hasMoreElements()) {
                DisplayBox b2 = (DisplayBox)e.nextElement();
                if (b2.isLegalPageEnd()) {
                    lastlegalbox = b2;
                }
                b2.setLegalPageEnd(false);
            }
            if (lastlegalbox != null) {
                lastlegalbox.setLegalPageEnd(true);
            }
        }
        if ((a = o.getAttribute("keep-with-next")) != null && a.equals("true")) {
            e = l.elements();
            while (e.hasMoreElements()) {
                b = (DisplayBox)e.nextElement();
                b.setLegalPageEnd(false);
                b.setKeepWithNextApplied(true);
            }
        }
        if ((a = o.getAttribute("keep-with-previous")) != null && a.equals("true") && (e = l.elements()).hasMoreElements()) {
            b = (DisplayBox)e.nextElement();
            b.setKeepWithPrevious(true);
        }
    }

    public DisplayBoxList makeDisplayGroup(xmlnode o, DSSSL_InheritedCharacteristics ic) {
        DisplayBoxList localstream = new DisplayBoxList();
        ic.updatebyxmlnode(o);
        localstream.append(this.makeConditionalSpaceBefore(o));
        localstream.append(this.ProcessFlowObjectChildren(o, ic.copy()));
        localstream.append(this.makeConditionalSpaceAfter(o));
        this.applyKeeps(o, localstream);
        return localstream;
    }

    private void makeSimplePageSequence(xmlnode node, DSSSL_InheritedCharacteristics ic) {
        DisplayBoxList localstream = new DisplayBoxList();
        ic.updatebyxmlnode(node);
        PageHeadersAndFooters phf = new PageHeadersAndFooters();
        node.reset();
        while (node.hasNext()) {
            if (node.peekElement() instanceof xmlnode) {
                xmlnode e = (xmlnode)node.nextElement();
                if (e.getName().equals("simple-page-sequence.left-header")) {
                    phf.left_header.append(e);
                    continue;
                }
                if (e.getName().equals("simple-page-sequence.center-header")) {
                    phf.center_header.append(e);
                    continue;
                }
                if (e.getName().equals("simple-page-sequence.right-header")) {
                    phf.right_header.append(e);
                    continue;
                }
                if (e.getName().equals("simple-page-sequence.left-footer")) {
                    phf.left_footer.append(e);
                    continue;
                }
                if (e.getName().equals("simple-page-sequence.center-footer")) {
                    phf.center_footer.append(e);
                    continue;
                }
                if (e.getName().equals("simple-page-sequence.right-footer")) {
                    phf.right_footer.append(e);
                    continue;
                }
                localstream.append(this.ProcessFlowObject(e, ic));
                continue;
            }
            node.nextElement();
        }
        System.gc();
        this.paginate(node, localstream, ic, phf);
    }

    private DisplayBoxList ProcessFlowObject(xmlnode aktnode, DSSSL_InheritedCharacteristics ic) {
        if (this.basefot.getSumCount() > 0) {
            Status.print("\rProcessing FlowObjectTree..." + aktnode.getNodeCount() * 100 / this.basefot.getSumCount() + "%");
        }
        DisplayBoxList localstream = new DisplayBoxList();
        if (aktnode.getName().equals("simple-page-sequence")) {
            this.makeSimplePageSequence(aktnode, ic.copy());
        } else if (aktnode.getName().equals("display-group")) {
            localstream.append(this.makeDisplayGroup(aktnode, ic.copy()));
        } else if (aktnode.getName().equals("box")) {
            localstream.append(this.makeBox(aktnode, ic.copy()));
        } else if (aktnode.getName().equals("table")) {
            localstream.append(this.makeTable(aktnode, ic.copy()));
        } else if (aktnode.getName().equals("paragraph")) {
            localstream.append(this.makeDisplayedParagraph(aktnode, ic.copy()));
        } else if (aktnode.getName().equals("rule")) {
            localstream.append(this.makeDisplayedRule(aktnode, ic.copy()));
        } else if (aktnode.getName().equals("external-graphic")) {
            localstream.append(this.makeDisplayedGraphic(aktnode, ic.copy()));
        } else if (aktnode.getName().equals("sequence")) {
            DSSSL_InheritedCharacteristics ic2 = ic.copy();
            ic2.updatebyxmlnode(aktnode);
            localstream.append(this.ProcessFlowObjectChildren(aktnode, ic2));
        } else if (!(aktnode.getName().equals("table-cell.before-row-border") || aktnode.getName().equals("table-cell.after-row-border") || aktnode.getName().equals("table-cell.before-column-border") || aktnode.getName().equals("table-cell.after-column-border"))) {
            if (aktnode.getName().equals("a")) {
                localstream.append(new AnchorDisplayBox(aktnode.getAttribute("name")));
            } else if (aktnode.getName().equals("link")) {
                DSSSL_InheritedCharacteristics newic = ic.copy();
                String ref = aktnode.getAttribute("destination");
                if (ref != null) {
                    newic.internal_linkdestination = ref;
                    this.AnchorList.put(newic.internal_linkdestination, "");
                }
                localstream.append(this.ProcessFlowObjectChildren(aktnode, newic));
            } else if (aktnode.getName().equals("sideline") || aktnode.getName().equals("score")) {
                DSSSL_InheritedCharacteristics newic = ic.copy();
                newic.updatebyxmlnode(aktnode);
                if (aktnode.getName().equals("sideline")) {
                    newic.internal_sideline = new SidelineMarker(aktnode);
                } else {
                    DSSSL_InheritedCharacteristics sic = ic.copy();
                    TextState ts = new TextState();
                    ts.updatebyicwithpdf(sic, this.pdf);
                    newic.internal_score = new ScoreMarker(aktnode, sic, ts);
                }
                aktnode.reset();
                while (aktnode.hasNext()) {
                    xmlnode e = (xmlnode)aktnode.nextElement();
                    localstream.append(this.ProcessFlowObject(e, newic));
                }
            } else {
                Status.println("\rWARNING! Unsupported FlowObject '" + aktnode.getName() + "' skipped!");
            }
        }
        aktnode.clear();
        return localstream;
    }

    private DisplayBoxList ProcessFlowObjectChildren(xmlnode startnode, DSSSL_InheritedCharacteristics ic) {
        DisplayBoxList localstream = new DisplayBoxList();
        startnode.reset();
        while (startnode.hasNext()) {
            if (!(startnode.peekElement() instanceof xmlnode)) {
                startnode.nextElement();
                continue;
            }
            localstream.append(this.ProcessFlowObject((xmlnode)startnode.nextElement(), ic.copy()));
        }
        return localstream;
    }

    private void OutputNode(xmlnode aktnode, int level) {
        String prefixpart = "";
        int i = 0;
        while (i < level) {
            prefixpart = prefixpart + " ";
            ++i;
        }
        Status.print(prefixpart + "<" + aktnode.getName() + ">");
        Status.print("\n");
        aktnode.reset();
        while (aktnode.hasNext()) {
            if (aktnode.peekElement() instanceof xmlnode) {
                this.OutputNode((xmlnode)aktnode.nextElement(), level + 1);
                continue;
            }
            Status.println(prefixpart + "content follows..." + (String)aktnode.nextElement());
        }
        Status.print(prefixpart + "</" + aktnode.getName() + ">");
    }

    public void run() {
        if (this.basefot.getRootNode() == null) {
            return;
        }
        this.pdf = new PDFoutfile(this.filename);
        if (!this.pdf.start()) {
            Status.println("ERROR! Could not write to \"" + this.filename + "\"");
            return;
        }
        this.pages = new Vector();
        this.AnchorList = new Hashtable();
        this.pagenumcnt = 1;
        DSSSL_InheritedCharacteristics ic = new DSSSL_InheritedCharacteristics();
        this.ProcessFlowObjectChildren(this.basefot.getRootNode(), ic);
        this.resolveAnchorList();
        this.writepages();
        this.pdf.end();
        Status.print("\r");
    }

    class LayoutTable {
        int maxrows;
        double maxwidth;
        LayoutTableBorder b_top;
        LayoutTableBorder b_bottom;
        LayoutTableBorder b_left;
        LayoutTableBorder b_right;
        Vector columns;
        int anzcolumns;
        DSSSL_InheritedCharacteristics tableic;

        void setBorderTop(LayoutTableBorder b) {
            this.b_top = b;
        }

        void setBorderBottom(LayoutTableBorder b) {
            this.b_bottom = b;
        }

        void setBorderLeft(LayoutTableBorder b) {
            this.b_left = b;
        }

        void setBorderRight(LayoutTableBorder b) {
            this.b_right = b;
        }

        LayoutTableBorder fightBorders(LayoutTableBorder a, LayoutTableBorder b) {
            if (a.priority > b.priority || !b.present) {
                return a;
            }
            if (a.priority < b.priority || !a.present) {
                return b;
            }
            if (!a.equals(b)) {
                Status.println("\rERROR! Table-borders with identical priority but different content found!");
            }
            return a;
        }

        public LayoutTable(DSSSL_InheritedCharacteristics ic) {
            this.tableic = ic;
            this.columns = new Vector(5);
            this.addColumn();
            this.anzcolumns = 0;
            this.maxrows = 0;
            this.maxwidth = 0.0;
        }

        public void setMaxWidth(double w) {
            this.maxwidth = w;
        }

        public void addColumn() {
            this.columns.addElement(new TableColumn());
            ++this.anzcolumns;
        }

        public TableColumn col(int x) {
            this.ensureColumn(x);
            return (TableColumn)this.columns.elementAt(x);
        }

        public TableRow row(int x, int y) {
            this.ensureColumn(x);
            return ((TableColumn)this.columns.elementAt(x)).row(y);
        }

        public void ensureColumn(int no) {
            while (no > this.anzcolumns) {
                this.addColumn();
            }
        }

        public void setColumn(int no, double w) {
            this.ensureColumn(no);
            this.col((int)no).width = w;
        }

        public void setContent(xmlnode what, DSSSL_InheritedCharacteristics ic, int wantcol, int wantrow) {
            this.ensureColumn(wantcol);
            this.row(wantcol, wantrow).setContent(what, ic);
        }

        public DisplayBoxList makeDisplayBoxes() {
            DisplayBoxList localstream = new DisplayBoxList();
            double tablewidth = this.maxwidth;
            if (this.maxwidth <= 0.0) {
                tablewidth = this.tableic.getIndentedBoxWidth();
            }
            double sumwidth = 0.0;
            int emptycol = 0;
            int multi = 1;
            int i = 1;
            while (i <= this.anzcolumns) {
                if (this.col((int)i).width == 0.0) {
                    if (emptycol == 0) {
                        emptycol = i;
                    } else {
                        Status.println("WARNING! Multiple table-columns without width! No proper auto-width implemented!");
                        ++multi;
                    }
                }
                sumwidth += this.col((int)i).width;
                ++i;
            }
            if (sumwidth > tablewidth + 0.1) {
                Status.println("ERROR! Table with impossible widths found!");
            }
            if (emptycol != 0) {
                if (multi == 1) {
                    this.col((int)emptycol).width = tablewidth - sumwidth;
                    sumwidth = tablewidth;
                } else {
                    double setwidth = (tablewidth - sumwidth) / (double)multi;
                    int mscan = 1;
                    while (mscan <= this.anzcolumns) {
                        if (this.col((int)mscan).width == 0.0) {
                            this.col((int)mscan).width = setwidth;
                        }
                        ++mscan;
                    }
                }
            }
            DisplayBox rowbox = null;
            double startxpos = this.tableic.start_indent;
            if (this.tableic.display_alignment.equals("end")) {
                startxpos += this.tableic.getIndentedBoxWidth() - sumwidth;
            }
            if (this.tableic.display_alignment.equals("center")) {
                startxpos += (this.tableic.getIndentedBoxWidth() - sumwidth) / 2.0;
            }
            int j = 1;
            while (j <= this.maxrows) {
                rowbox = new DisplayBox(this.tableic.getFullBoxWidth(), 0.0, true);
                double maxheight = 0.0;
                double xpos = startxpos;
                i = 1;
                while (i <= this.anzcolumns) {
                    if (this.row((int)i, (int)j).contentnode != null) {
                        DSSSL_InheritedCharacteristics ic = this.row((int)i, (int)j).contentic.copy();
                        ic.start_indent = 0.0;
                        ic.first_line_start_indent = 0.0;
                        ic.last_line_end_indent = 0.0;
                        ic.end_indent = 0.0;
                        ic.left_margin = ic.cell_before_column_margin;
                        ic.right_margin = ic.page_width - this.col((int)i).width + ic.cell_after_column_margin;
                        DisplayBoxList contentdisplayboxes = Formatter.this.ProcessFlowObjectChildren(this.row((int)i, (int)j).contentnode, ic.copy());
                        DisplayBoxList anchordisplayboxes = Formatter.filterAnchorBoxes(contentdisplayboxes);
                        LinkedList contentboxes = new LinkedList();
                        double boxheight = Formatter.this.compactDisplayBoxes(contentdisplayboxes, contentboxes);
                        Enumeration e = contentboxes.elements();
                        while (e.hasMoreElements()) {
                            AnyContentBox cb = (AnyContentBox)e.nextElement();
                            cb.moveby(xpos + ic.cell_before_column_margin, ic.cell_before_row_margin);
                            rowbox.addContentBox(cb);
                        }
                        double localy = ic.cell_after_row_margin + boxheight + ic.cell_before_row_margin;
                        if (localy > maxheight) {
                            maxheight = localy;
                        }
                    }
                    xpos += this.col((int)i).width;
                    ++i;
                }
                rowbox.setHeight(maxheight);
                Enumeration e = rowbox.getContentBoxes().elements();
                while (e.hasMoreElements()) {
                    AnyContentBox cb = (AnyContentBox)e.nextElement();
                }
                xpos = startxpos;
                String s = "";
                i = 1;
                while (i <= this.anzcolumns) {
                    LayoutTableBorder b = null;
                    LayoutTableBorder c = null;
                    if (j == 1) {
                        b = this.row((int)i, (int)j).cb_top;
                        c = this.b_top;
                        b = this.fightBorders(b, c);
                        s = s + b.drawit(xpos, 0.0, this.col((int)i).width, 'h');
                    }
                    if (i == 1) {
                        b = this.row((int)i, (int)j).cb_left;
                        c = this.b_left;
                        b = this.fightBorders(b, c);
                        s = s + b.drawit(xpos, 0.0, maxheight, 'v');
                    }
                    b = this.row((int)i, (int)j).cb_right;
                    c = i == this.anzcolumns ? this.b_right : this.row((int)(i + 1), (int)j).cb_left;
                    b = this.fightBorders(b, c);
                    s = s + b.drawit(xpos + this.col((int)i).width, 0.0, maxheight, 'v');
                    b = this.row((int)i, (int)j).cb_bottom;
                    c = j == this.maxrows ? this.b_bottom : this.row((int)i, (int)(j + 1)).cb_top;
                    b = this.fightBorders(b, c);
                    s = s + b.drawit(xpos, -maxheight, this.col((int)i).width, 'h');
                    xpos += this.col((int)i).width;
                    ++i;
                }
                if (!s.equals("")) {
                    rowbox.addContentBox(new GraphicsContentBox(s));
                }
                localstream.append(rowbox);
                ++j;
            }
            if (rowbox != null) {
                rowbox.setLegalPageEnd(true);
            }
            return localstream;
        }

        void parseRow(DisplayBoxList localstream, xmlnode o, DSSSL_InheritedCharacteristics ic, int aktrow) {
            o.reset();
            while (o.hasNext()) {
                String a;
                double colwidth;
                xmlnode aktnode = (xmlnode)o.nextElement();
                if (aktnode.getName().equals("table.before-row-border")) {
                    this.setBorderTop(new LayoutTableBorder(aktnode, ic.copy()));
                }
                if (aktnode.getName().equals("table.after-row-border")) {
                    this.setBorderBottom(new LayoutTableBorder(aktnode, ic.copy()));
                }
                if (aktnode.getName().equals("table.before-column-border")) {
                    this.setBorderLeft(new LayoutTableBorder(aktnode, ic.copy()));
                }
                if (aktnode.getName().equals("table.after-column-border")) {
                    this.setBorderRight(new LayoutTableBorder(aktnode, ic.copy()));
                }
                if (aktnode.getName().equals("sequence")) {
                    DSSSL_InheritedCharacteristics ic2 = ic.copy();
                    ic2.updatebyxmlnode(aktnode);
                    this.parseRow(localstream, aktnode, ic2, aktrow);
                }
                if (aktnode.getName().equals("a")) {
                    localstream.append(new AnchorDisplayBox(aktnode.getAttribute("name")));
                }
                if (aktnode.getName().equals("link")) {
                    DSSSL_InheritedCharacteristics newic = ic.copy();
                    String ref = aktnode.getAttribute("destination");
                    if (ref != null) {
                        newic.internal_linkdestination = ref;
                        Formatter.this.AnchorList.put(newic.internal_linkdestination, "");
                    }
                    this.parseRow(localstream, aktnode, newic, aktrow);
                }
                if (aktnode.getName().equals("table-column")) {
                    int colno = 1;
                    colwidth = 0.0;
                    a = aktnode.getAttribute("column-number");
                    if (a != null) {
                        colno = DSSSL_ParsedAttributes.readint(a);
                    }
                    if ((a = aktnode.getAttribute("width")) != null) {
                        colwidth = DSSSL_ParsedAttributes.readlen(a);
                    }
                    this.setColumn(colno, colwidth);
                }
                if (aktnode.getName().equals("table-row")) {
                    this.parseRow(localstream, aktnode, ic.copy(), ++aktrow);
                }
                if (!aktnode.getName().equals("table-cell")) continue;
                int colno = 1;
                colwidth = 0.0;
                a = aktnode.getAttribute("column-number");
                if (a != null) {
                    colno = DSSSL_ParsedAttributes.readint(a);
                }
                this.setContent(aktnode, ic.copy(), colno, aktrow);
            }
        }

        public void parseAndAppendDisplayBoxes(DisplayBoxList localstream, xmlnode o, DSSSL_InheritedCharacteristics ic) {
            this.parseRow(localstream, o, ic, 0);
            localstream.append(this.makeDisplayBoxes());
        }

        class TableColumn {
            double width = 0.0;
            Vector rows = new Vector(10);
            int anzrows;

            TableColumn() {
                this.addRow();
                this.anzrows = 0;
            }

            void addRow() {
                this.rows.addElement(new TableRow());
                ++this.anzrows;
            }

            TableRow row(int x) {
                while (x > this.anzrows) {
                    this.addRow();
                }
                if (x > LayoutTable.this.maxrows) {
                    LayoutTable.this.maxrows = x;
                }
                return (TableRow)this.rows.elementAt(x);
            }
        }

        class TableRow {
            LayoutTableBorder cb_top;
            LayoutTableBorder cb_bottom;
            LayoutTableBorder cb_left;
            LayoutTableBorder cb_right;
            xmlnode contentnode = null;
            DSSSL_InheritedCharacteristics contentic;

            TableRow() {
                this.cb_left = this.cb_right = new LayoutTableBorder();
                this.cb_bottom = this.cb_right;
                this.cb_top = this.cb_right;
            }

            public void setContent(xmlnode o, DSSSL_InheritedCharacteristics ic) {
                this.contentnode = o;
                this.contentic = ic;
                o.reset();
                while (o.hasNext()) {
                    xmlnode aktnode = (xmlnode)o.nextElement();
                    if (aktnode.getName().equals("table-cell.before-row-border")) {
                        this.setCellBorderTop(new LayoutTableBorder(aktnode, ic.copy()));
                    }
                    if (aktnode.getName().equals("table-cell.after-row-border")) {
                        this.setCellBorderBottom(new LayoutTableBorder(aktnode, ic.copy()));
                    }
                    if (aktnode.getName().equals("table-cell.before-column-border")) {
                        this.setCellBorderLeft(new LayoutTableBorder(aktnode, ic.copy()));
                    }
                    if (!aktnode.getName().equals("table-cell.after-column-border")) continue;
                    this.setCellBorderRight(new LayoutTableBorder(aktnode, ic.copy()));
                }
            }

            void setCellBorderTop(LayoutTableBorder b) {
                this.cb_top = b;
            }

            void setCellBorderBottom(LayoutTableBorder b) {
                this.cb_bottom = b;
            }

            void setCellBorderLeft(LayoutTableBorder b) {
                this.cb_left = b;
            }

            void setCellBorderRight(LayoutTableBorder b) {
                this.cb_right = b;
            }
        }

        class LayoutTableBorder {
            DSSSL_InheritedCharacteristics baseic;
            int priority;
            char align;
            boolean present;
            boolean omitatbreak;

            public LayoutTableBorder() {
                this.present = false;
            }

            public LayoutTableBorder(xmlnode o, DSSSL_InheritedCharacteristics ic) {
                this.baseic = ic;
                this.baseic.updatebyxmlnode(o);
                this.priority = 0;
                this.align = (char)99;
                this.present = true;
                this.omitatbreak = false;
                String a = o.getAttribute("border-priority");
                if (a != null) {
                    this.priority = DSSSL_ParsedAttributes.readint(a);
                }
                if ((a = o.getAttribute("border-alignment")) != null) {
                    if (a.equals("start")) {
                        this.align = (char)115;
                    }
                    if (a.equals("end")) {
                        this.align = (char)101;
                    }
                }
                if ((a = o.getAttribute("border-present")) != null) {
                    this.present = a.equals("true");
                }
                if ((a = o.getAttribute("border-omit-at-break")) != null) {
                    this.omitatbreak = a.equals("true");
                }
            }

            String drawit(double x, double y, double len, char whereto) {
                if (!this.present) {
                    return "";
                }
                return Formatter.makeAlignedLineDrawStringXY(this.baseic, x, y, len, whereto, this.align) + " ";
            }

            boolean equals(LayoutTableBorder b) {
                return this.align == b.align && this.present == b.present && this.omitatbreak == b.omitatbreak && this.baseic.line_thickness == b.baseic.line_thickness && this.baseic.line_repeat == b.baseic.line_repeat;
            }
        }
    }

    private class inobjectstatus {
        public xmlnode node;
        public DSSSL_InheritedCharacteristics ic;
        public TextState ts;
        public xmlnode innernode;

        public inobjectstatus(xmlnode a, DSSSL_InheritedCharacteristics b, TextState c, xmlnode d) {
            this.node = a;
            this.ic = b;
            this.ts = c;
            this.innernode = d;
        }
    }

    private class HeaderFooterInfo {
        private String first;
        private String front;
        private TextDisplayBox box;

        public HeaderFooterInfo(String dofirst, String dofront, TextDisplayBox headerbox) {
            this.first = dofirst;
            this.front = dofront;
            this.box = headerbox;
        }

        public boolean getIsFirst() {
            return this.first.equals("any") || this.first.equals("true");
        }

        public boolean getIsNonFirst() {
            return this.first.equals("any") || this.first.equals("false");
        }

        public boolean getIsOdd() {
            return this.front.equals("any") || this.front.equals("true");
        }

        public boolean getIsEven() {
            return this.front.equals("any") || this.front.equals("false");
        }

        public TextDisplayBox getBox() {
            return this.box;
        }
    }
}

