/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter;

import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.FormatterParameters;
import com.pdftech.fot2pdf.formatter.TextState;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.SidelineMarker;
import com.pdftech.fot2pdf.formatter.contentboxes.AnyContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.RawTextContentBox;
import com.pdftech.fot2pdf.formatter.displayboxes.DisplayBox;
import com.pdftech.fot2pdf.formatter.displayboxes.DisplayBoxList;
import com.pdftech.fot2pdf.formatter.displayboxes.GlueDisplayBox;
import com.pdftech.fot2pdf.formatter.displayboxes.TextDisplayBox;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineCharacter;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineLeader;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObject;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObjectVector;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlinePageNumber;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineSpace;
import com.pdftech.fot2pdf.tools.LinkedList;
import com.pdftech.fot2pdf.tools.PublicID;
import com.pdftech.fot2pdf.tools.Status;
import java.util.Enumeration;
import java.util.Vector;

public class LayoutParagraph {
    private InlineObjectVector content;
    private DSSSL_InheritedCharacteristics baseic;
    private TextState basetextstate;
    static double infinity = Double.MAX_VALUE;
    private double destwidth;
    private char usequadding;

    public LayoutParagraph(DSSSL_InheritedCharacteristics ic, TextState ts, InlineObjectVector v) {
        this.basetextstate = ts;
        this.baseic = ic;
        this.content = v;
    }

    private boolean isBreakForHyphen(p_contentvector pdata, int pos) {
        boolean ishyphen = false;
        p_element x = pdata.elementAt(pos);
        while (pos > 0 && x.getRefNum() < 0) {
            --pos;
        }
        if (x.getRefNum() >= 0 && this.content.elementAt(x.getRefNum()) instanceof InlineCharacter && ((InlineCharacter)this.content.elementAt(x.getRefNum())).isHyphen()) {
            ishyphen = true;
        }
        return ishyphen;
    }

    private void applyFirstFitAlgorithm(DisplayBoxList dbl, p_contentvector pdata) {
        int hyphenatedlinecounter = 0;
        int lastbreakindex = 0;
        double aktwidth = 0.0;
        int i = 0;
        while (i < pdata.size()) {
            p_element p = pdata.elementAt(i);
            if (p instanceof p_box) {
                if (aktwidth + p.getWidth() > this.destwidth) {
                    if (lastbreakindex > 0) {
                        pdata.elementAt(lastbreakindex).setBreak();
                        hyphenatedlinecounter = this.isBreakForHyphen(pdata, lastbreakindex) ? ++hyphenatedlinecounter : 0;
                    }
                    aktwidth = 0.0;
                    i = ++lastbreakindex;
                    --i;
                } else {
                    aktwidth += p.getWidth();
                }
            }
            if (p instanceof p_glue && i > 0) {
                p_element p2 = pdata.elementAt(i - 1);
                if (p2 instanceof p_box) {
                    lastbreakindex = i;
                }
                p_glue g = (p_glue)p;
                aktwidth += g.getWidth() - g.getShrinkability();
            }
            if (p instanceof p_penalty && aktwidth + p.getWidth() <= this.destwidth && ((p_penalty)p).getCost() < infinity) {
                if (this.isBreakForHyphen(pdata, i)) {
                    boolean hyphenationallowed;
                    boolean bl = hyphenationallowed = hyphenatedlinecounter < this.baseic.hyphenation_ladder_count || this.baseic.hyphenation_ladder_count == 0;
                    if (hyphenationallowed) {
                        lastbreakindex = i;
                    }
                } else {
                    lastbreakindex = i;
                }
            }
            ++i;
        }
    }

    private void applyOptimizingAlgorithm(DisplayBoxList dbl, p_contentvector pdata, olb_parameters aktparams) {
        olb_node bestnode;
        int i = 0;
        while (i < pdata.size()) {
            ++i;
        }
        olb_node ActiveListStart = new olb_node(0, 0, 1, 0.0, 0.0, 0.0, 0.0, null, null);
        olb_node PassiveListStart = null;
        double sum_width = 0.0;
        double sum_stretch = 0.0;
        double sum_shrink = 0.0;
        double maxtolerance = 0.0;
        int b = 0;
        while (b < pdata.size()) {
            p_element aktb = pdata.elementAt(b);
            boolean islegalbreak = false;
            if (aktb instanceof p_box) {
                sum_width += aktb.getWidth();
            }
            if (aktb instanceof p_glue && b > 0 && pdata.elementAt(b - 1) instanceof p_box) {
                islegalbreak = true;
            }
            if (aktb instanceof p_penalty) {
                boolean bl = islegalbreak = ((p_penalty)aktb).getCost() < infinity;
            }
            if (islegalbreak) {
                if (!(aktb instanceof p_penalty) || ((p_penalty)aktb).getCost() <= -infinity) {
                    // empty if block
                }
                olb_node a = ActiveListStart;
                olb_node preva = null;
                do {
                    int j;
                    olb_node nexta;
                    double mind;
                    double[] d = new double[4];
                    olb_node[] besta = new olb_node[4];
                    d[3] = mind = infinity;
                    d[2] = mind;
                    d[1] = mind;
                    d[0] = mind;
                    do {
                        nexta = a.link;
                        double adjustmentratio = 0.0;
                        double linewidth = sum_width - a.totalwidth;
                        if (aktb instanceof p_penalty) {
                            linewidth += aktb.getWidth();
                        }
                        j = a.line + 1;
                        if (linewidth < this.destwidth) {
                            double aktstretch = sum_stretch - a.totalstretch;
                            adjustmentratio = aktstretch > 0.0 ? (this.destwidth - linewidth) / aktstretch : infinity;
                        } else if (linewidth > this.destwidth) {
                            double aktshrink = sum_shrink - a.totalshrink;
                            adjustmentratio = aktshrink > 0.0 ? (this.destwidth - linewidth) / aktshrink : infinity;
                        }
                        if (adjustmentratio < -1.0 || aktb instanceof p_penalty && ((p_penalty)aktb).getCost() <= -infinity) {
                            if (preva == null) {
                                ActiveListStart = nexta;
                            } else {
                                preva.link = nexta;
                            }
                            a.link = PassiveListStart;
                            PassiveListStart = a;
                        } else {
                            preva = a;
                        }
                        boolean hyphenationallowed = true;
                        if (this.baseic.hyphenation_ladder_count > 0 && this.isBreakForHyphen(pdata, b)) {
                            int hyphenatedlinecounter = 0;
                            olb_node check = a;
                            while (check != null && this.isBreakForHyphen(pdata, check.position)) {
                                ++hyphenatedlinecounter;
                                check = check.previous;
                            }
                            boolean bl = hyphenationallowed = hyphenatedlinecounter < this.baseic.hyphenation_ladder_count;
                        }
                        if (!(adjustmentratio >= -1.0) || !(adjustmentratio <= aktparams.akttolerance) || !hyphenationallowed) continue;
                        if (adjustmentratio > maxtolerance) {
                            maxtolerance = adjustmentratio;
                        }
                        double aktd = 0.0;
                        double aktcost = aktb.getCost();
                        aktd = aktcost >= 0.0 ? Math.pow(aktparams.linepenalty + 100.0 * Math.pow(Math.abs(adjustmentratio), 3.0), 2.0) + Math.pow(aktcost, 2.0) : (aktcost > -infinity ? Math.pow(aktparams.linepenalty + 100.0 * Math.pow(Math.abs(adjustmentratio), 3.0), 2.0) - Math.pow(aktcost, 2.0) : Math.pow(aktparams.linepenalty + 100.0 * Math.pow(Math.abs(adjustmentratio), 3.0), 2.0));
                        aktd += aktparams.flagdemerits * (double)aktb.getFlagged() * (double)pdata.elementAt(a.position).getFlagged();
                        int fitnessclass = adjustmentratio < -0.5 ? 0 : (adjustmentratio <= 0.5 ? 1 : (adjustmentratio <= 1.0 ? 2 : 3));
                        if (Math.abs(fitnessclass - a.fitness) > 1) {
                            aktd += aktparams.wrongclassdemerits;
                        }
                        if (!((aktd += a.totaldemerits) < d[fitnessclass])) continue;
                        d[fitnessclass] = aktd;
                        besta[fitnessclass] = a;
                        if (!(aktd < mind)) continue;
                        mind = aktd;
                    } while ((a = nexta) != null && (a.line < j || aktparams.the_q == 0));
                    if (!(mind < infinity)) continue;
                    double tw = sum_width;
                    double ty = sum_stretch;
                    double tz = sum_shrink;
                    for (int i2 = b; i2 < pdata.size() && !(pdata.elementAt(i2) instanceof p_box); ++i2) {
                        if (pdata.elementAt(i2) instanceof p_glue) {
                            p_glue thisglue = (p_glue)pdata.elementAt(i2);
                            tw += thisglue.getWidth();
                            ty += thisglue.getStretchability();
                            tz += thisglue.getShrinkability();
                            continue;
                        }
                        if (pdata.elementAt(i2).getCost() <= -infinity && i2 > b) break;
                    }
                    int aktclass = 0;
                    while (aktclass < 4) {
                        if (d[aktclass] <= mind + aktparams.wrongclassdemerits) {
                            olb_node s = new olb_node(b, besta[aktclass].line + 1, aktclass, tw, ty, tz, d[aktclass], besta[aktclass], a);
                            if (preva == null) {
                                ActiveListStart = s;
                            } else {
                                preva.link = s;
                            }
                            preva = s;
                        }
                        ++aktclass;
                    }
                } while (a != null);
                if (ActiveListStart != null) {
                    // empty if block
                }
                if (ActiveListStart == null) break;
            }
            if (aktb instanceof p_glue) {
                p_glue gluebox = (p_glue)aktb;
                sum_width += gluebox.getWidth();
                sum_stretch += gluebox.getStretchability();
                sum_shrink += gluebox.getShrinkability();
            }
            ++b;
        }
        if (ActiveListStart == null) {
            int i3 = 0;
            int olen = 0;
            StringBuffer outtext = new StringBuffer("");
            while (olen < 52 && i3 < pdata.size()) {
                p_element x;
                if ((x = pdata.elementAt(i3++)).getRefNum() < 0 || !(this.content.elementAt(x.getRefNum()) instanceof InlineCharacter)) continue;
                outtext.append(((InlineCharacter)this.content.elementAt(x.getRefNum())).getChar());
                ++olen;
            }
            if (i3 < pdata.size()) {
                outtext.append("...");
            }
            if (!aktparams.didwarn && aktparams.akttolerance >= FormatterParameters.getLineBreakingWarnLevel() && FormatterParameters.getLineBreakingWarnLevel() > 0.0) {
                Status.println("\rWARNING! Opt. line-breaking algorithm found no solution with tolerance " + aktparams.akttolerance + "!");
                Status.println("\r         Paragraph is: " + outtext.toString());
                aktparams.didwarn = true;
            }
            if (aktparams.akttolerance < 16.0) {
                aktparams.akttolerance *= 2.0;
                this.applyOptimizingAlgorithm(dbl, pdata, aktparams);
            } else {
                Status.println("\r         Using simple line-breaking algorithm!");
                this.applyFirstFitAlgorithm(dbl, pdata);
            }
            return;
        }
        olb_node a = bestnode = ActiveListStart;
        double aktd = a.totaldemerits;
        while (a.link != null) {
            a = a.link;
            if (!(a.totaldemerits < aktd)) continue;
            aktd = a.totaldemerits;
            bestnode = a;
        }
        int k = bestnode.line;
        if (aktparams.the_q != 0) {
            a = ActiveListStart;
            int s = 0;
            do {
                int delta;
                if (aktparams.the_q <= (delta = a.line - k) && delta < s || s < delta && delta <= aktparams.the_q) {
                    s = delta;
                    aktd = a.totaldemerits;
                    bestnode = a;
                    continue;
                }
                if (delta != s || !(a.totaldemerits < aktd)) continue;
                aktd = a.totaldemerits;
                bestnode = a;
            } while ((a = a.link) != null);
            k = bestnode.line;
        }
        int j = k;
        while (j > 0) {
            pdata.elementAt(bestnode.position).setBreak();
            bestnode = bestnode.previous;
            --j;
        }
    }

    public DisplayBoxList makeDisplayBoxes() {
        DisplayBoxList dbl = new DisplayBoxList();
        if (this.content.size() == 0) {
            return dbl;
        }
        this.usequadding = this.basetextstate.getQuadding();
        this.destwidth = this.basetextstate.getWidth() - (this.basetextstate.getStartIndent() + this.basetextstate.getEndIndent());
        olb_parameters olbparameters = new olb_parameters();
        olbparameters.the_q = 0;
        olbparameters.linepenalty = 10.0;
        olbparameters.akttolerance = 1.0;
        olbparameters.flagdemerits = 50.0;
        olbparameters.wrongclassdemerits = 10.0;
        olbparameters.hyphenpenalty = 50.0;
        boolean usesimple = this.usequadding != 'b';
        olbparameters.hyphenpenalty = this.usequadding == 'b' ? 50.0 : 500.0;
        PublicID breakmethod = new PublicID(this.baseic.line_breaking_method);
        if (breakmethod.isCorrect() && breakmethod.getHeader().equalsIgnoreCase("UNREGISTERED::Christof Drescher//fot2pdf") && breakmethod.getType().equalsIgnoreCase("line-breaking-method")) {
            if (breakmethod.getValue().equalsIgnoreCase("simple") || breakmethod.getValue().equalsIgnoreCase("first-fit")) {
                usesimple = true;
            } else if (breakmethod.getValue().equalsIgnoreCase("optimizing")) {
                usesimple = false;
                if (breakmethod.hasAttribute("tolerance")) {
                    olbparameters.akttolerance = breakmethod.getAttributeValue("tolerance");
                }
                if (breakmethod.hasAttribute("hyphenpenalty")) {
                    olbparameters.hyphenpenalty = breakmethod.getAttributeValue("hyphenpenalty");
                }
                if (breakmethod.hasAttribute("changelength")) {
                    olbparameters.the_q = (int)breakmethod.getAttributeValue("changelength");
                }
            } else {
                Status.println("\rWARNING! Unknown line-breaking algorithm \"" + breakmethod.getValue() + "\" requested!");
                Status.println("         Using default!");
            }
        } else if (!breakmethod.isEmpty()) {
            Status.println("\rWARNING! Characteristic for line-breaking algorithm could not be parsed!");
        }
        char compositionmethod = 'f';
        double compositionflexthreshold = -1000.0;
        double compositionglyphspacemaxadd = this.baseic.justify_glyph_space_max_add;
        PublicID compmethod = new PublicID(this.baseic.line_composition_method);
        if (compmethod.isCorrect() && compmethod.getHeader().equalsIgnoreCase("UNREGISTERED::Christof Drescher//fot2pdf") && compmethod.getType().equalsIgnoreCase("line-composition-method")) {
            if (compmethod.getValue().equalsIgnoreCase("wordspacing")) {
                compositionmethod = 'w';
            } else if (compmethod.getValue().equalsIgnoreCase("charspacing")) {
                compositionmethod = 'c';
            } else if (compmethod.getValue().equalsIgnoreCase("flexible")) {
                compositionmethod = 'f';
            } else {
                Status.println("\rWARNING! Unknown line-composition algorithm \"" + compmethod.getValue() + "\" requested!");
                Status.println("         Using default!");
            }
            if (compmethod.hasAttribute("threshold")) {
                compositionflexthreshold = compmethod.getAttributeValue("threshold");
            }
        } else if (!compmethod.isEmpty()) {
            Status.println("\rWARNING! Characteristic for line-composition algorithm could not be parsed!");
        }
        p_contentvector pdata = new p_contentvector(this.content.size() + 10);
        double raggedstretch = this.destwidth / 10.0;
        if (this.usequadding == 'c') {
            pdata.add(new p_glue(-1, 0.0, raggedstretch, 0.0));
        } else {
            if (this.basetextstate.getFirstLineStartIndent() != 0.0) {
                this.content.insertElementAt(new InlineSpace(this.basetextstate.getFirstLineStartIndent()), 0);
            }
            if (this.basetextstate.getLastLineEndIndent() != 0.0) {
                this.content.add(new InlineSpace(this.basetextstate.getLastLineEndIndent()));
            }
        }
        this.content.doKerning();
        int i = 0;
        while (i < this.content.size()) {
            InlineObject o = (InlineObject)this.content.elementAt(i);
            if (o instanceof InlineCharacter) {
                InlineCharacter c = (InlineCharacter)o;
                if (c.isHyphenInsert()) {
                    double pwidth = c.getWidth();
                    switch (this.usequadding) {
                        case 'b': {
                            if (this.baseic.hanging_punct) {
                                pwidth = 0.0;
                            }
                            pdata.add(new p_penalty(i, pwidth, olbparameters.hyphenpenalty, true));
                            break;
                        }
                        case 'l': 
                        case 'r': {
                            pdata.add(new p_penalty(-1, 0.0, infinity, false));
                            pdata.add(new p_glue(-1, 0.0, raggedstretch, 0.0));
                            pdata.add(new p_penalty(i, pwidth, olbparameters.hyphenpenalty, true));
                            pdata.add(new p_glue(-1, 0.0, -raggedstretch, 0.0));
                            break;
                        }
                    }
                } else if (c.isSpace()) {
                    if (c.getChar() == InlineCharacter.ExtraCharNoBreakSpace) {
                        if (this.usequadding == 'b') {
                            pdata.add(new p_penalty(-1, 0.0, infinity, false));
                            pdata.add(new p_glue(i, c.getWidth(), c.getWidth() / 2.0, c.getWidth() / 3.0));
                        } else {
                            pdata.add(new p_penalty(-1, 0.0, infinity, false));
                            pdata.add(new p_glue(i, c.getWidth(), 0.0, 0.0));
                        }
                    } else {
                        switch (this.usequadding) {
                            case 'b': {
                                pdata.add(new p_glue(i, c.getWidth(), c.getWidth() / 2.0, c.getWidth() / 3.0));
                                break;
                            }
                            case 'c': {
                                pdata.add(new p_glue(-1, 0.0, raggedstretch, 0.0));
                                pdata.add(new p_penalty(-1, 0.0, 0.0, false));
                                pdata.add(new p_glue(i, c.getWidth(), -2.0 * raggedstretch, 0.0));
                                pdata.add(new p_box(-1, 0.0));
                                pdata.add(new p_penalty(-1, 0.0, infinity, false));
                                pdata.add(new p_glue(-1, 0.0, raggedstretch, 0.0));
                                break;
                            }
                            case 'l': 
                            case 'r': {
                                pdata.add(new p_glue(-1, 0.0, raggedstretch, 0.0));
                                pdata.add(new p_penalty(-1, 0.0, 0.0, false));
                                pdata.add(new p_glue(i, c.getWidth(), -raggedstretch, 0.0));
                            }
                        }
                    }
                } else {
                    double kernval = (double)c.getKernValue() * c.getTextState().getSize() / 1000.0;
                    if (this.baseic.hanging_punct && c.isHanging()) {
                        pdata.add(new p_box(i, -kernval));
                        pdata.add(new p_glue(-1, c.getWidth(), 0.0, 0.0));
                    } else {
                        pdata.add(new p_box(i, c.getWidth() - kernval));
                    }
                }
                if (c.isHyphenOrDash() && this.usequadding != 'c') {
                    pdata.add(new p_penalty(-1, 0.0, 0.0, true));
                }
                if (c.isPossibleLineEnd() && !c.isHyphenOrDash()) {
                    pdata.add(new p_penalty(-1, 0.0, 0.0, false));
                }
            } else if (o instanceof InlineLeader) {
                pdata.add(new p_box(i, 0.0));
            } else {
                pdata.add(new p_box(i, o.getWidth()));
            }
            ++i;
        }
        if (this.usequadding == 'c') {
            pdata.add(new p_glue(-1, 0.0, raggedstretch, 0.0));
        } else {
            pdata.add(new p_penalty(-1, 0.0, infinity, false));
            if (this.basetextstate.getLastLineQuadding() != 'b') {
                pdata.add(new p_glue(-1, 0.0, 1000000.0, 0.0));
            }
        }
        pdata.add(new p_penalty(-1, 0.0, -infinity, false));
        pdata.elementAt(pdata.size() - 1).setBreak();
        if (usesimple) {
            this.applyFirstFitAlgorithm(dbl, pdata);
        } else {
            this.applyOptimizingAlgorithm(dbl, pdata, olbparameters);
        }
        int pstep = 0;
        int linecnt = 0;
        while (pstep < pdata.size()) {
            GlueDisplayBox glue;
            InlineObject o;
            p_element p;
            int linestartindex;
            SidelineMarker SidelineMarker2 = null;
            int lineendindex = linestartindex = pdata.getInlineObjectRef(pstep);
            boolean glueskip = true;
            do {
                if ((p = pdata.elementAt(pstep++)).getRefNum() < 0) continue;
                o = (InlineObject)this.content.elementAt(p.getRefNum());
                if (o.getSidelineMarker() != null) {
                    SidelineMarker2 = o.getSidelineMarker();
                }
                if (p instanceof p_glue) {
                    if (glueskip && linestartindex == pdata.getInlineObjectRef(pstep - 1)) {
                        ++linestartindex;
                    }
                } else {
                    glueskip = false;
                }
                lineendindex = p.getRefNum();
            } while (!p.isBreak());
            int pbackstep = pstep - 1;
            while (pdata.elementAt(pbackstep) instanceof p_glue && pbackstep > 0) {
                --pbackstep;
            }
            while (pstep < pdata.size() && pdata.elementAt(pstep) instanceof p_glue) {
                ++pstep;
            }
            while ((lineendindex = pdata.elementAt(pbackstep--).getRefNum()) < 0) {
            }
            InlineObjectVector line = new InlineObjectVector();
            boolean haspagenumflag = false;
            double presize = this.baseic.min_pre_line_spacing;
            double postsize = this.baseic.min_post_line_spacing;
            double calcedheight = 0.0;
            double calcedup = 0.0;
            double calceddown = 0.0;
            i = linestartindex;
            while (i <= lineendindex) {
                o = (InlineObject)this.content.elementAt(i);
                boolean skipthis = false;
                if (o instanceof InlineCharacter) {
                    InlineCharacter c = (InlineCharacter)o;
                    double a = (double)c.getTextState().getFont().LogicalFont().GetAscent() * c.getTextState().getSize() / 1000.0;
                    double d = (double)(-c.getTextState().getFont().LogicalFont().GetDescent()) * c.getTextState().getSize() / 1000.0;
                    if (a > calcedheight) {
                        calcedheight = a;
                    }
                    if (a > calcedup) {
                        calcedup = a;
                    }
                    if (d > calceddown) {
                        calceddown = d;
                    }
                    if (c.isHyphenInsert() && i < lineendindex) {
                        skipthis = true;
                    }
                } else if (o.getHeight() > presize) {
                    calcedheight = o.getHeight();
                }
                if (!skipthis) {
                    line.add(o);
                    if (o instanceof InlinePageNumber) {
                        haspagenumflag = true;
                    }
                }
                ++i;
            }
            if (presize < 0.0) {
                presize = calcedup;
            }
            if (postsize < 0.0) {
                postsize = calceddown;
            }
            if (this.baseic.min_leading >= 0.0 && calcedheight > presize) {
                presize = calcedheight;
            }
            double leadingdiff = this.baseic.line_spacing - presize - postsize;
            line.trimToSize();
            double aktwidth = line.getWidth();
            if (lineendindex == this.content.size() - 1 && aktwidth < this.destwidth) {
                if (this.basetextstate.getLastLineQuadding() != 'x') {
                    this.usequadding = this.basetextstate.getLastLineQuadding();
                } else if (this.usequadding == 'b' && this.destwidth - aktwidth > this.basetextstate.getLastLineJustifyLimit()) {
                    this.usequadding = (char)108;
                }
            }
            double extraindent = this.basetextstate.getStartIndent();
            if (presize + postsize + this.baseic.line_spacing < this.baseic.min_leading) {
                leadingdiff = this.baseic.min_leading - presize - postsize;
            }
            if (leadingdiff > 0.0) {
                GlueDisplayBox glue2 = new GlueDisplayBox(this.basetextstate.getWidth(), leadingdiff / 2.0, true);
                glue2.setSidelineMarker(SidelineMarker2);
                dbl.append(glue2);
            }
            boolean lastlinehyphenated = false;
            o = (InlineObject)this.content.elementAt(lineendindex);
            if (o instanceof InlineCharacter) {
                InlineCharacter c = (InlineCharacter)o;
                lastlinehyphenated = c.isHyphen();
                if (this.baseic.hanging_punct && c.isHanging()) {
                    c.setForceHangingWidth();
                }
            }
            boolean canbelegalpageend = true;
            if (this.baseic.hyphenation_keep && lastlinehyphenated) {
                canbelegalpageend = false;
            }
            if (compositionflexthreshold == -1000.0) {
                compositionflexthreshold = calcedheight * 3.0;
            }
            TextDisplayBox box = new TextDisplayBox(this.basetextstate.getWidth(), presize, canbelegalpageend, aktwidth);
            RawTextContentBox rawbox = new RawTextContentBox(presize, this.usequadding, this.destwidth, extraindent, compositionmethod, compositionflexthreshold, compositionglyphspacemaxadd, line);
            if (haspagenumflag) {
                box.addContentBox(rawbox);
            } else {
                rawbox.calc();
                LinkedList rawcontent = rawbox.getResultContentBoxes();
                rawcontent.reset();
                while (rawcontent.hasMoreElements()) {
                    box.addContentBox((AnyContentBox)rawcontent.nextElement());
                }
            }
            box.setSidelineMarker(SidelineMarker2);
            dbl.append(box);
            if (postsize > 0.0) {
                glue = new GlueDisplayBox(this.basetextstate.getWidth(), postsize, true);
                glue.setSidelineMarker(SidelineMarker2);
                dbl.append(glue);
            }
            if (leadingdiff > 0.0) {
                glue = new GlueDisplayBox(this.basetextstate.getWidth(), leadingdiff / 2.0, true);
                glue.setSidelineMarker(SidelineMarker2);
                dbl.append(glue);
            }
            ++linecnt;
        }
        Vector<DisplayBox> breaker = new Vector<DisplayBox>();
        Enumeration e = dbl.elements();
        while (e.hasMoreElements()) {
            DisplayBox b = (DisplayBox)e.nextElement();
            if (!(b instanceof TextDisplayBox)) continue;
            breaker.addElement(b);
        }
        i = 0;
        while (i < breaker.size() - 1) {
            if (i < this.baseic.orphan_count) {
                ((DisplayBox)breaker.elementAt(i)).setLegalPageEnd(false);
            }
            if (i > breaker.size() - 1 - this.baseic.widow_count) {
                ((DisplayBox)breaker.elementAt(i)).setLegalPageEnd(false);
            }
            ++i;
        }
        return dbl;
    }

    private class olb_parameters {
        int the_q = 0;
        double linepenalty = 1.0;
        double akttolerance = 2.0;
        double flagdemerits = 50.0;
        double wrongclassdemerits = 10.0;
        double hyphenpenalty = 50.0;
        boolean didwarn = false;

        olb_parameters() {
        }
    }

    private class olb_node {
        int position = 0;
        int line = 0;
        int fitness = 1;
        double totalwidth = 0.0;
        double totalstretch = 0.0;
        double totalshrink = 0.0;
        double totaldemerits = 0.0;
        olb_node previous = null;
        olb_node link = null;

        olb_node(int inposition, int inline, int infitness, double intotalwidth, double intotalstretch, double intotalshrink, double intotaldemerits, olb_node inprevious, olb_node inlink) {
            this.position = inposition;
            this.line = inline;
            this.fitness = infitness;
            this.totalwidth = intotalwidth;
            this.totalstretch = intotalstretch;
            this.totalshrink = intotalshrink;
            this.totaldemerits = intotaldemerits;
            this.previous = inprevious;
            this.link = inlink;
        }
    }

    class p_penalty
    extends p_element {
        private boolean flagged = false;
        private double cost = 0.0;

        p_penalty(int inrefnum, double inwidth, double incost, boolean inflagged) {
            super(inrefnum, inwidth);
            this.cost = incost;
            this.flagged = inflagged;
        }

        int getFlagged() {
            if (this.flagged) {
                return 1;
            }
            return 0;
        }

        double getCost() {
            return this.cost;
        }

        boolean isforced() {
            return this.width <= -infinity;
        }

        boolean isprohibited() {
            return this.width >= infinity;
        }
    }

    class p_glue
    extends p_element {
        private double stretchability = 0.0;
        private double shrinkability = 0.0;

        p_glue(int inrefnum, double inwidth, double instretch, double inshrink) {
            super(inrefnum, inwidth);
            this.stretchability = instretch;
            this.shrinkability = inshrink;
        }

        double getStretchability() {
            return this.stretchability;
        }

        double getShrinkability() {
            return this.shrinkability;
        }
    }

    class p_box
    extends p_element {
        p_box(int inrefnum, double inwidth) {
            super(inrefnum, inwidth);
        }
    }

    class p_element {
        protected double width;
        private int refnum;
        private boolean breakflag = false;

        p_element(int inrefnum, double inwidth) {
            this.width = inwidth;
            this.refnum = inrefnum;
        }

        int getRefNum() {
            return this.refnum;
        }

        double getCost() {
            return 0.0;
        }

        int getFlagged() {
            return 0;
        }

        double getWidth() {
            return this.width;
        }

        void setBreak() {
            this.breakflag = true;
        }

        boolean isBreak() {
            return this.breakflag;
        }
    }

    class p_contentvector {
        Vector v;

        p_contentvector(int initialsize) {
            this.v = new Vector(initialsize);
        }

        void add(p_element o) {
            this.v.add(o);
        }

        p_element elementAt(int i) {
            return (p_element)this.v.elementAt(i);
        }

        int size() {
            return this.v.size();
        }

        int getInlineObjectRef(int index) {
            while (index < this.size()) {
                p_element x = this.elementAt(index);
                if (x.getRefNum() >= 0) {
                    return x.getRefNum();
                }
                ++index;
            }
            return LayoutParagraph.this.content.size() - 1;
        }
    }
}

