/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter;

import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.FormatterParameters;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.ScoreMarker;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.SidelineMarker;
import com.pdftech.fot2pdf.pdf.PDFfontobject;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.tools.StringTools;

public class TextState
implements Cloneable {
    private PDFfontobject font = null;
    private double size = 12.0;
    private String aktref;
    private SidelineMarker aktsideline;
    private ScoreMarker aktscore = null;
    private String colorstring;
    private int rendering = 0;
    private double textrise = 0.0;
    private double wordspace = 0.0;
    private double charspace = 0.0;
    private char quadding;
    private char lastquadding;
    private double leading;
    private double width;
    private double lastjustifylimit;
    private double start_indent;
    private double end_indent;
    private double first_line_start_indent;
    private double last_line_end_indent;

    public TextState() {
        this.setQuadding('l');
        this.setLeading(14.4);
        this.setWidth(1000.0);
        this.setIndents(0.0, 0.0, 0.0, 0.0);
        this.setLastLineQuadding('x');
        this.setLastLineJustifyLimit(0.0);
        this.setColorString("0 0 0 ");
        this.aktref = "";
        this.aktsideline = null;
    }

    public PDFfontobject setFont(PDFfontobject newfont2) {
        this.font = newfont2;
        return this.font;
    }

    public PDFfontobject getFont() {
        return this.font;
    }

    public double setSize(double newsize) {
        this.size = newsize;
        return this.size;
    }

    public double getSize() {
        return this.size;
    }

    public void setWordspace(double newWordspaceVal) {
        this.wordspace = newWordspaceVal;
    }

    public double getWordspace() {
        return this.wordspace;
    }

    public void addWordspace(double addWordspaceVal) {
        this.wordspace += addWordspaceVal;
    }

    public void setCharspace(double newCharspaceVal) {
        this.charspace = newCharspaceVal;
    }

    public double getCharspace() {
        return this.charspace;
    }

    public void addCharspace(double addCharspaceVal) {
        this.charspace += addCharspaceVal;
    }

    public double setTextrise(double newTextrise) {
        this.textrise = newTextrise;
        return this.textrise;
    }

    public double getTextrise() {
        return this.textrise;
    }

    public int setRendering(int newRendering) {
        this.rendering = newRendering;
        return this.rendering;
    }

    public int getRendering() {
        return this.rendering;
    }

    public void setLinkRef(String s) {
        this.aktref = s;
    }

    public String getLinkRef() {
        return this.aktref;
    }

    public void setSidelineMarker(SidelineMarker o) {
        this.aktsideline = o;
    }

    public SidelineMarker getSidelineMarker() {
        return this.aktsideline;
    }

    public void setScoreMarker(ScoreMarker o) {
        this.aktscore = o;
    }

    public ScoreMarker getScoreMarker() {
        return this.aktscore;
    }

    public void setColorString(String s) {
        this.colorstring = s;
    }

    public String getColorString() {
        return this.colorstring;
    }

    public void setLeading(double newLeading) {
        this.leading = newLeading;
    }

    public double getLeading() {
        return this.leading;
    }

    public void setQuadding(char q) {
        this.quadding = q;
    }

    public char getQuadding() {
        return this.quadding;
    }

    public void setLastLineQuadding(char q) {
        this.lastquadding = q;
    }

    public char getLastLineQuadding() {
        return this.lastquadding;
    }

    public void setLastLineJustifyLimit(double w) {
        this.lastjustifylimit = w;
    }

    public double getLastLineJustifyLimit() {
        return this.lastjustifylimit;
    }

    public void setWidth(double w) {
        this.width = w;
    }

    public double getWidth() {
        return this.width;
    }

    public void setIndents(double si, double ei, double fsi, double lei) {
        this.start_indent = si;
        this.end_indent = ei;
        this.first_line_start_indent = fsi;
        this.last_line_end_indent = lei;
    }

    public double getStartIndent() {
        return this.start_indent;
    }

    public double getEndIndent() {
        return this.end_indent;
    }

    public double getFirstLineStartIndent() {
        return this.first_line_start_indent;
    }

    public double getLastLineEndIndent() {
        return this.last_line_end_indent;
    }

    void updatebyicwithpdf(DSSSL_InheritedCharacteristics ic, PDFoutfile pdf) {
        if (ic.font_name != null) {
            this.setFont(pdf.getFont(ic.font_name));
        } else {
            this.setFont(pdf.getFont(ic.font_family_name, ic.font_weight, ic.font_posture, ic.font_structure, ic.font_proportionate_width));
        }
        if (ic.font_structure.equals("outline")) {
            this.setRendering(1);
        } else {
            this.setRendering(0);
        }
        this.setSize(ic.font_size);
        this.setLinkRef(ic.internal_linkdestination);
        this.setSidelineMarker(ic.internal_sideline);
        this.setScoreMarker(ic.internal_score);
        this.setTextrise(ic.position_point_shift);
        this.setColorString(ic.getColorString());
        if (ic.quadding.equals("start")) {
            this.setQuadding('l');
        } else if (ic.quadding.equals("end")) {
            this.setQuadding('r');
        } else if (ic.quadding.equals("center")) {
            this.setQuadding('c');
        } else if (ic.quadding.equals("justify")) {
            this.setQuadding('b');
        } else {
            Status.println("\rWARNING! Unsupported Quadding \"" + ic.quadding + "\" ignored!");
        }
        if (ic.last_line_quadding.equals("start")) {
            this.setLastLineQuadding('l');
        }
        if (ic.last_line_quadding.equals("end")) {
            this.setLastLineQuadding('r');
        }
        if (ic.last_line_quadding.equals("center")) {
            this.setLastLineQuadding('c');
        }
        if (ic.last_line_quadding.equals("justify")) {
            this.setLastLineQuadding('b');
        }
        if (ic.last_line_quadding.equals("relative")) {
            this.setLastLineQuadding('x');
        }
        this.setLastLineJustifyLimit(ic.last_line_justify_limit);
        this.setIndents(ic.start_indent, ic.end_indent, ic.first_line_start_indent, ic.last_line_end_indent);
        this.setLeading(ic.line_spacing);
        this.setWidth(ic.getFullBoxWidth());
    }

    public boolean equalsforkerning(TextState comp) {
        return this.size == comp.getSize() && this.textrise == comp.getTextrise() && this.font == comp.getFont();
    }

    public boolean equalsfortextline(TextState comp) {
        return this.size == comp.getSize() && this.textrise == comp.getTextrise() && this.font == comp.getFont() && this.rendering == comp.getRendering() && this.getLinkRef().equals(comp.getLinkRef()) && this.colorstring.equals(comp.getColorString());
    }

    public String getString() {
        String l = this.font.getName() + " " + GenericTools.round3(this.size) + " Tf";
        if (this.rendering != 0) {
            l = StringTools.AddSpacedString(l, this.rendering + " Tr " + GenericTools.round3(this.size / 50.0) + " w");
        }
        if (this.wordspace != 0.0) {
            l = StringTools.AddSpacedString(l, GenericTools.round3(this.wordspace) + " Tw");
        }
        if (this.charspace != 0.0) {
            l = StringTools.AddSpacedString(l, GenericTools.round3(this.charspace) + " Tc");
        }
        if (this.textrise != 0.0) {
            l = StringTools.AddSpacedString(l, GenericTools.round3(this.textrise) + " Ts");
        }
        String localcolorstring = this.colorstring;
        if (!this.getLinkRef().equals("") && FormatterParameters.getLinkHighlightingFlag()) {
            localcolorstring = "0 0 0.8 ";
        }
        if (!localcolorstring.equals("0 0 0 ")) {
            l = this.rendering == 0 ? StringTools.AddSpacedString(l, localcolorstring + "rg") : StringTools.AddSpacedString(l, localcolorstring + "RG");
        }
        l = l + " ";
        return l;
    }

    public String getDiffString(TextState previous) {
        String localcolorstring;
        boolean docolorstring;
        String l = "";
        if (this.size != previous.getSize() || this.font != previous.getFont()) {
            l = StringTools.AddSpacedString(l, this.font.getName() + " " + GenericTools.round3(this.size) + " Tf");
        }
        if (this.rendering != previous.getRendering()) {
            l = StringTools.AddSpacedString(l, this.rendering + " Tr " + GenericTools.round3(this.size / 50.0) + " w");
        }
        if (this.wordspace != previous.getWordspace()) {
            l = StringTools.AddSpacedString(l, GenericTools.round3(this.wordspace) + " Tw");
        }
        if (this.charspace != previous.getCharspace()) {
            l = StringTools.AddSpacedString(l, GenericTools.round3(this.charspace) + " Tc");
        }
        if (this.textrise != previous.getTextrise()) {
            l = StringTools.AddSpacedString(l, GenericTools.round3(this.textrise) + " Ts");
        }
        boolean bl = docolorstring = !(localcolorstring = this.colorstring).equals(previous.getColorString());
        if (!this.getLinkRef().equals(previous.getLinkRef())) {
            if (!this.getLinkRef().equals("") && FormatterParameters.getLinkHighlightingFlag()) {
                localcolorstring = "0 0 0.8 ";
            }
            docolorstring = true;
        }
        if (docolorstring) {
            l = this.rendering == 0 ? StringTools.AddSpacedString(l, localcolorstring + "rg") : StringTools.AddSpacedString(l, localcolorstring + "RG");
        }
        if (!l.equals("")) {
            l = l + " ";
        }
        return l;
    }

    void simplify() {
        this.setIndents(0.0, 0.0, 0.0, 0.0);
        this.setQuadding('l');
        this.setLastLineQuadding('x');
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public TextState copy() {
        return (TextState)this.clone();
    }
}

