/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter.attachmentmarkers;

import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.DSSSL_ParsedAttributes;
import com.pdftech.fot2pdf.formatter.Formatter;
import com.pdftech.fot2pdf.formatter.contentboxes.GraphicsContentBox;
import com.pdftech.fot2pdf.formatter.displayboxes.DisplayBox;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.xml.xmlnode;

public class SidelineMarker {
    private double slsep = 4.0;
    private String slside = "start";
    private DSSSL_InheritedCharacteristics ic = new DSSSL_InheritedCharacteristics();

    public SidelineMarker(xmlnode o) {
        this.ic.updatebyxmlnode(o);
        String a = o.getAttribute("sideline-sep");
        if (a != null) {
            this.slsep = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("sideline-side")) != null) {
            this.slside = a;
        }
    }

    public void apply(DisplayBox box) {
        String s = "";
        if (this.slside.equals("start") || this.slside.equals("both")) {
            s = s + " q 1 0 0 1 " + GenericTools.round6string(-this.slsep) + " 0 cm " + Formatter.makeLineDrawString(this.ic, box.getHeight(1), 'v') + " Q";
        }
        if (this.slside.equals("end") || this.slside.equals("both")) {
            s = s + " q 1 0 0 1 " + GenericTools.round6string(box.getWidth() + this.slsep) + " 0 cm " + Formatter.makeLineDrawString(this.ic, box.getHeight(1), 'v') + " Q";
        }
        box.addContentBox(new GraphicsContentBox(s));
    }
}

