/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter.contentboxes;

import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.DSSSL_ParsedAttributes;
import com.pdftech.fot2pdf.formatter.Formatter;
import com.pdftech.fot2pdf.formatter.TextState;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.ScoreMarker;
import com.pdftech.fot2pdf.formatter.contentboxes.AnnotationContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.AnyContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.FlowingContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.GraphicsContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.ScoreContentBox;
import com.pdftech.fot2pdf.formatter.contentboxes.TextContentBox;
import com.pdftech.fot2pdf.formatter.displayboxes.AnchorDisplayBox;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineCharacter;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineGroup;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineLeader;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObject;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObjectVector;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlinePageNumber;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlinePicture;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineRule;
import com.pdftech.fot2pdf.pdf.PDFfontobject;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.LinkedList;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.xml.xmlnode;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

public class RawTextContentBox
extends AnyContentBox
implements Cloneable {
    private double boxheight;
    private char quadding;
    private double calceddestwidth;
    private double extraindent;
    private char compositionmethod = (char)102;
    private double compositionflexthreshold = 24.0;
    private double compositionglyphspacemaxadd = 2.0;
    private InlineObjectVector objectcontent;
    private LinkedList resultcontent;

    public RawTextContentBox(double inBoxHeight, char inQuadding, double inCWidth, double inExIndent, char inCompositionMethod, double inCompositionFlexThreshold, double inCompositionGlyphSpaceMaxAdd, InlineObjectVector c) {
        this.boxheight = inBoxHeight;
        this.quadding = inQuadding;
        this.calceddestwidth = inCWidth;
        this.extraindent = inExIndent;
        this.compositionmethod = inCompositionMethod;
        this.compositionflexthreshold = inCompositionFlexThreshold;
        this.compositionglyphspacemaxadd = inCompositionGlyphSpaceMaxAdd;
        this.setObjectContent(c);
    }

    public void setObjectContent(InlineObjectVector c) {
        this.objectcontent = c;
    }

    private void addContentBox(AnyContentBox newbox) {
        newbox.moveby(this.getRelativePositionX(), this.getRelativePositionY());
        this.resultcontent.append(newbox);
    }

    public LinkedList getResultContentBoxes() {
        return this.resultcontent;
    }

    public void replacepagenums(int thispagenum, Hashtable AnchorList) {
        int i = 0;
        while (i < this.objectcontent.size()) {
            InlineObject o = (InlineObject)this.objectcontent.elementAt(i);
            if (o instanceof InlinePageNumber) {
                String number;
                InlinePageNumber c = (InlinePageNumber)o;
                this.objectcontent.removeElementAt(i);
                if (c.getPageNumRef().equals("")) {
                    number = Integer.toString(thispagenum);
                } else {
                    Object ao = AnchorList.get(c.getPageNumRef());
                    if (ao != null && ao instanceof AnchorDisplayBox) {
                        AnchorDisplayBox a = (AnchorDisplayBox)ao;
                        number = Integer.toString(a.getPositionPage());
                        if (c.getLinkRef().equals("")) {
                            c.setLinkRef(InlineCharacter.ExtraCharPageNum + number);
                        }
                    } else {
                        Status.println("\rWARNING! Reference '" + c.getPageNumRef() + "' could not be found!");
                        number = "??";
                    }
                }
                int j = 0;
                while (j < number.length()) {
                    InlineCharacter nc = new InlineCharacter(number.charAt(j), c.getTextState());
                    this.objectcontent.insertElementAt(nc, i++);
                    ++j;
                }
                this.objectcontent.doKerning();
            }
            ++i;
        }
    }

    public void calc() {
        InlineObject o;
        this.resultcontent = new LinkedList();
        if (this.objectcontent.size() == 0) {
            return;
        }
        double calcedindent = 0.0;
        StringBuffer line = new StringBuffer();
        double aktwidth = 0.0;
        int countspaces = 0;
        int countcharacters = 0;
        HashSet<TextContentBox> theseboxes = new HashSet<TextContentBox>();
        FlowingLink lastlink = new FlowingLink();
        FlowingScore lastflowscore = new FlowingScore();
        boolean addstart = true;
        TextState tstate = null;
        TextState tstate_start = null;
        Object tstate_end = null;
        double akttextboxstart = 0.0;
        int akttextboxstartspaces = 0;
        int akttextboxstartcharacters = 0;
        boolean closetextbox = false;
        HashSet<PDFfontobject> aktresourcesset = null;
        double preaktwidth = 0.0;
        InlineLeader foundleader = null;
        int foundleaderpos = -1;
        int i = 0;
        while (i < this.objectcontent.size()) {
            o = (InlineObject)this.objectcontent.elementAt(i);
            aktwidth += o.getWidth();
            if (o instanceof InlineLeader) {
                foundleader = (InlineLeader)o;
                foundleaderpos = i;
            }
            ++i;
        }
        if (foundleader != null) {
            foundleader.insertIntoVector(this.objectcontent, foundleaderpos, this.calceddestwidth - this.objectcontent.getWidth());
        }
        aktwidth = 0.0;
        int i2 = 0;
        while (i2 < this.objectcontent.size()) {
            double shifting;
            o = (InlineObject)this.objectcontent.elementAt(i2);
            if (!o.getLinkRef().equals(lastlink.getRef())) {
                lastlink.finish(aktwidth, countspaces, countcharacters);
                lastlink.setRef(o.getLinkRef());
                shifting = 0.0;
                if (o instanceof InlineCharacter) {
                    shifting = ((InlineCharacter)o).getTextState().getTextrise();
                }
                lastlink.setStartPosition(aktwidth, o.getHeight(), shifting, countspaces, countcharacters);
            } else if (!lastlink.ref.equals("") && o.getHeight() > lastlink.getHeight()) {
                lastlink.setHeight(o.getHeight());
            }
            if (o.getScoreMarker() != lastflowscore.getScoreMarker()) {
                lastflowscore.finish(aktwidth, countspaces, countcharacters);
                lastflowscore.setScoreMarker(o.getScoreMarker());
                shifting = 0.0;
                if (o instanceof InlineCharacter) {
                    shifting = ((InlineCharacter)o).getTextState().getTextrise();
                }
                lastflowscore.setStartPosition(aktwidth, o.getHeight(), shifting, countspaces, countcharacters);
            }
            if (o instanceof InlineCharacter) {
                char charval;
                InlineCharacter c = (InlineCharacter)o;
                if (tstate == null) {
                    tstate = c.getTextState();
                    tstate_start = tstate.copy();
                    akttextboxstart = aktwidth;
                    aktresourcesset = new HashSet<PDFfontobject>();
                    aktresourcesset.add(c.getTextState().getFont());
                    akttextboxstartspaces = countspaces;
                    akttextboxstartcharacters = countcharacters;
                } else if (!c.getTextState().equalsfortextline(tstate)) {
                    if (!addstart) {
                        line.append(")] TJ ");
                    }
                    line.append(c.getTextState().getDiffString(tstate));
                    aktresourcesset.add(c.getTextState().getFont());
                    tstate = c.getTextState();
                    addstart = true;
                }
                if (addstart) {
                    line.append("[(");
                    addstart = false;
                }
                if ((charval = c.getMacRomanChar()) <= '\u007f') {
                    switch (charval) {
                        case '(': {
                            line.append("\\(");
                            break;
                        }
                        case ')': {
                            line.append("\\)");
                            break;
                        }
                        case '\\': {
                            line.append("\\\\");
                            break;
                        }
                        default: {
                            line.append(charval);
                            break;
                        }
                    }
                } else {
                    line.append('\\' + Integer.toString(charval, 8));
                }
                int kernadd = c.getKernValue();
                if (kernadd != 0) {
                    line.append(")" + Integer.toString(kernadd) + "(");
                    aktwidth -= (double)kernadd * c.getTextState().getSize() / 1000.0;
                }
                if (c.isSpace() && lastflowscore.getScoreMarker() != null && !lastflowscore.getScoreSpaces()) {
                    lastflowscore.finish(aktwidth, countspaces, countcharacters);
                    lastflowscore.setScoreMarker(null);
                }
                ++countcharacters;
                if (c.isSpace()) {
                    ++countspaces;
                }
            } else {
                closetextbox = true;
            }
            preaktwidth = aktwidth;
            aktwidth += o.getWidth();
            if ((closetextbox || i2 + 1 == this.objectcontent.size()) && tstate != null) {
                if (!addstart) {
                    line.append(")] TJ");
                }
                TextContentBox tbox = new TextContentBox(line.toString(), tstate_start.copy(), tstate.copy());
                tbox.moveby(akttextboxstart, this.boxheight);
                tbox.setSpaces(akttextboxstartspaces, 0);
                tbox.setCharacters(akttextboxstartcharacters, 0);
                tbox.addResources(aktresourcesset);
                this.addContentBox(tbox);
                theseboxes.add(tbox);
                tstate = null;
                line = new StringBuffer();
                addstart = true;
            }
            closetextbox = false;
            if (o instanceof InlineGroup) {
                InlineGroup ig = (InlineGroup)o;
                Enumeration enumeration = ig.getGroupContent().elements();
                while (enumeration.hasMoreElements()) {
                    AnyContentBox anybox = (AnyContentBox)enumeration.nextElement();
                    anybox.moveby(preaktwidth, 0.0);
                    anybox.setSpaces(countspaces, 0);
                    anybox.setCharacters(countcharacters, 0);
                    this.addContentBox(anybox);
                }
            }
            if (o instanceof InlinePicture || o instanceof InlineRule) {
                GraphicsContentBox gb;
                if (o instanceof InlinePicture) {
                    gb = ((InlinePicture)o).getContent();
                } else {
                    gb = ((InlineRule)o).getContent();
                    gb.moveby(0.0, this.boxheight);
                }
                gb.moveby(preaktwidth, 0.0);
                gb.setSpaces(countspaces, 0);
                gb.setCharacters(countcharacters, 0);
                this.addContentBox(gb);
            }
            ++i2;
        }
        lastlink.finish(aktwidth, countspaces, countcharacters);
        lastflowscore.finish(aktwidth, countspaces, countcharacters);
        calcedindent = this.extraindent;
        if (this.quadding == 'b') {
            double addwordspacing = 0.0;
            double addcharspacing = 0.0;
            if (countspaces == 0 && this.compositionmethod == 'f') {
                this.compositionmethod = (char)99;
            }
            switch (this.compositionmethod) {
                case 'w': {
                    if (countspaces > 0) {
                        addwordspacing = (this.calceddestwidth - aktwidth) / (double)countspaces;
                        break;
                    }
                    this.quadding = (char)108;
                    break;
                }
                case 'c': {
                    if (countcharacters > 0) {
                        addcharspacing = (this.calceddestwidth - aktwidth) / (double)(countcharacters - 1);
                        if (!(addcharspacing > this.compositionglyphspacemaxadd)) break;
                        addcharspacing = this.compositionglyphspacemaxadd;
                        break;
                    }
                    this.quadding = (char)108;
                    break;
                }
                case 'f': {
                    addwordspacing = (this.calceddestwidth - aktwidth) / (double)countspaces;
                    if (!(addwordspacing > this.compositionflexthreshold)) break;
                    addwordspacing = this.compositionflexthreshold;
                    double nowspacing = this.compositionflexthreshold * (double)countspaces;
                    addcharspacing = (this.calceddestwidth - nowspacing - aktwidth) / (double)(countcharacters - 1);
                    if (!(addcharspacing > this.compositionglyphspacemaxadd)) break;
                    addcharspacing = this.compositionglyphspacemaxadd;
                    addwordspacing = (this.calceddestwidth - addcharspacing * (double)(countcharacters - 1) - aktwidth) / (double)countspaces;
                }
            }
            String xl = "";
            int ii = 0;
            while (ii < this.objectcontent.size()) {
                InlineObject xo = (InlineObject)this.objectcontent.elementAt(ii);
                if (xo instanceof InlineCharacter) {
                    xl = xl + ((InlineCharacter)xo).getChar();
                }
                ++ii;
            }
            if (addwordspacing >= 1.5) {
                // empty if block
            }
            Enumeration boxenum = this.getResultContentBoxes().elements();
            while (boxenum.hasMoreElements()) {
                FlowingContentBox acb;
                AnyContentBox b = (AnyContentBox)boxenum.nextElement();
                if (b instanceof TextContentBox && theseboxes.contains((TextContentBox)b)) {
                    TextContentBox tcb = (TextContentBox)b;
                    tcb.getStartTextState().addWordspace(addwordspacing);
                    tcb.getStartTextState().addCharspace(addcharspacing);
                    tcb.getEndTextState().addWordspace(addwordspacing);
                    tcb.getEndTextState().addCharspace(addcharspacing);
                }
                if (b.getSpacesBefore() != 0) {
                    b.moveby((double)b.getSpacesBefore() * addwordspacing, 0.0);
                }
                if (b.getCharactersBefore() != 0) {
                    b.moveby((double)b.getCharactersBefore() * addcharspacing, 0.0);
                }
                if (b.getSpacesInbetween() != 0 && b instanceof FlowingContentBox) {
                    acb = (FlowingContentBox)b;
                    acb.setWidth(acb.getWidth() + (double)acb.getSpacesInbetween() * addwordspacing);
                }
                if (b.getCharactersInbetween() == 0 || !(b instanceof FlowingContentBox)) continue;
                acb = (FlowingContentBox)b;
                acb.setWidth(acb.getWidth() + (double)acb.getCharactersInbetween() * addcharspacing);
            }
        } else {
            if (this.quadding == 'c') {
                calcedindent += (this.calceddestwidth - aktwidth) / 2.0;
            }
            if (this.quadding == 'r') {
                calcedindent += this.calceddestwidth - aktwidth;
            }
        }
        if (calcedindent != 0.0) {
            Enumeration boxenum = this.getResultContentBoxes().elements();
            while (boxenum.hasMoreElements()) {
                AnyContentBox b = (AnyContentBox)boxenum.nextElement();
                b.moveby(calcedindent, 0.0);
            }
        }
        Enumeration boxenum = this.getResultContentBoxes().elements();
        while (boxenum.hasMoreElements()) {
            AnyContentBox b = (AnyContentBox)boxenum.nextElement();
            if (!(b instanceof ScoreContentBox)) continue;
            ScoreContentBox sb = (ScoreContentBox)b;
            this.getResultContentBoxes().delete(sb);
            ScoreMarker so = sb.getScoreMarker();
            DSSSL_InheritedCharacteristics ic = so.getScoreIC();
            TextState ts = so.getScoreTS();
            xmlnode snode = so.getScoreNode();
            String stype = "after";
            String a = snode.getAttribute("type");
            if (a != null) {
                stype = a;
            }
            if (stype.equals("char")) {
                Status.println("\rWARNING! Scoring by Char not implemented!");
                continue;
            }
            GraphicsContentBox gb = new GraphicsContentBox();
            gb.moveby(sb.getRelativePositionX(), sb.getRelativePositionY());
            gb.moveby(-this.getRelativePositionX(), -this.getRelativePositionY());
            double moveval = 0.0;
            double thick = 1.0;
            if (stype.equals("before") || stype.equals("through") || stype.equals("after")) {
                if (stype.equals("after")) {
                    moveval += this.boxheight;
                    moveval -= (double)ts.getFont().LogicalFont().GetUnderlinePosition() * ts.getSize() / 1000.0;
                }
                if (stype.equals("through")) {
                    moveval += this.boxheight;
                    moveval -= (double)ts.getFont().LogicalFont().GetXHeight() * ts.getSize() / 1000.0 / 2.0;
                }
                thick = (double)ts.getFont().LogicalFont().GetUnderlineThickness() * ts.getSize() / 1000.0;
                gb.setGraphicsString(" " + GenericTools.round3(thick) + " w " + ts.getColorString() + "RG 0 0 m " + GenericTools.round3(sb.getWidth()) + " 0 l S");
            } else {
                double offset = DSSSL_ParsedAttributes.readlen(stype);
                gb.setGraphicsString(Formatter.makeLineDrawString(ic, sb.getWidth(), 'h'));
                moveval += this.boxheight;
                moveval += offset;
            }
            gb.moveby(0.0, moveval);
            this.addContentBox(gb);
        }
    }

    /*
     * WARNING - void declaration
     */
    public RawTextContentBox copy() {
        try {
            void e;
            RawTextContentBox newbox = (RawTextContentBox)super.clone();
            newbox.setObjectContent(this.objectcontent.copy());
            return e;
        }
        catch (CloneNotSupportedException e) {
            Status.println("\rERROR! Could not duplicate TextDisplayBox!");
            return null;
        }
    }

    class FlowingScore
    extends InlineFlowingObject {
        ScoreMarker ScoreMarker = null;
        boolean scorespaces = true;

        FlowingScore() {
        }

        void setScoreMarker(ScoreMarker o) {
            this.ScoreMarker = o;
            this.scorespaces = true;
            if (o == null) {
                return;
            }
            xmlnode snode = o.getScoreNode();
            String a = snode.getAttribute("score-spaces");
            if (a != null) {
                this.scorespaces = a.equals("true");
            }
        }

        ScoreMarker getScoreMarker() {
            return this.ScoreMarker;
        }

        boolean getScoreSpaces() {
            return this.scorespaces;
        }

        void finish(double aktwidth, int countspaces, int countcharacters) {
            if (this.ScoreMarker == null) {
                return;
            }
            ScoreContentBox a = new ScoreContentBox(this.startpos, aktwidth - this.startpos, this.flowheight, this.ScoreMarker);
            a.setSpaces(this.beforespaces, countspaces - this.beforespaces);
            a.setCharacters(this.beforecharacters, countcharacters - this.beforecharacters);
            RawTextContentBox.this.addContentBox(a);
        }
    }

    class FlowingLink
    extends InlineFlowingObject {
        private String ref = "";

        FlowingLink() {
            this.setRef("");
        }

        String getRef() {
            return this.ref;
        }

        void setRef(String r) {
            this.ref = r;
        }

        void finish(double aktwidth, int countspaces, int countcharacters) {
            if (this.ref.equals("")) {
                return;
            }
            double needheight = this.flowheight * 1.2;
            AnnotationContentBox a = this.ref.charAt(0) != InlineCharacter.ExtraCharPageNum ? new AnnotationContentBox(this.startpos, aktwidth - this.startpos, needheight, this.ref) : new AnnotationContentBox(this.startpos, aktwidth - this.startpos, needheight, GenericTools.readint(this.ref.substring(1, this.ref.length())));
            a.moveby(0.0, RawTextContentBox.this.boxheight - this.positionshift + this.flowheight * 0.3);
            a.setSpaces(this.beforespaces, countspaces - this.beforespaces);
            a.setCharacters(this.beforecharacters, countcharacters - this.beforecharacters);
            RawTextContentBox.this.addContentBox(a);
        }
    }

    abstract class InlineFlowingObject {
        protected double startpos = 0.0;
        protected double flowheight = 0.0;
        protected double positionshift = 0.0;
        protected int beforespaces = 0;
        protected int beforecharacters = 0;

        InlineFlowingObject() {
        }

        void setStartPosition(double newstartpos, double newheight, double newpositionshift, int newbeforespaces, int newbeforecharacters) {
            this.startpos = newstartpos;
            this.flowheight = newheight;
            this.positionshift = newpositionshift;
            this.beforespaces = newbeforespaces;
            this.beforecharacters = newbeforecharacters;
        }

        void setHeight(double h) {
            this.flowheight = h;
        }

        double getHeight() {
            return this.flowheight;
        }
    }
}

