/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter.inlineobjects;

import com.pdftech.fot2pdf.formatter.TextState;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.ScoreMarker;
import com.pdftech.fot2pdf.formatter.attachmentmarkers.SidelineMarker;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObject;
import com.pdftech.fot2pdf.tools.Encoding;

public class InlineCharacter
extends InlineObject {
    public static char ExtraCharHyphen = (char)65535;
    public static char ExtraCharPageNum = (char)65534;
    public static char ExtraCharNoBreakSpace = (char)160;
    private TextState textstate;
    private char thechar;
    private char thechar_macroman;
    private boolean hangingflag;
    private boolean forcewhite;
    private double charwidth;
    private int kernvalue;

    public InlineCharacter(char c, TextState wantstate) {
        this.thechar = c;
        this.thechar_macroman = (char)Encoding.MapUnicodeToMacRoman(this.thechar);
        if (this.isHyphenInsert()) {
            this.thechar_macroman = (char)Encoding.MapUnicodeToMacRoman(45);
        }
        this.textstate = wantstate;
        this.kernvalue = 0;
        this.hangingflag = false;
        this.forcewhite = false;
        this.charwidth = this.textstate.getSize() * (double)this.textstate.getFont().LogicalFont().getCharWidth(this.thechar_macroman) / 1000.0;
    }

    public boolean isWhitespace() {
        return this.isSpace() || this.thechar == '\t' || this.forcewhite;
    }

    public void setWhitespace() {
        this.forcewhite = true;
    }

    public boolean isHyphen() {
        return this.thechar == '-' || this.isHyphenInsert();
    }

    public boolean isHyphenOrDash() {
        return this.thechar == '-' || this.thechar == '\u2013' || this.thechar == '\u2014';
    }

    public boolean isHyphenInsert() {
        return this.thechar == ExtraCharHyphen;
    }

    public boolean isSpace() {
        return this.thechar == ' ' || this.thechar == ExtraCharNoBreakSpace;
    }

    public boolean isHanging() {
        return this.isHyphen() || this.isHyphenOrDash() || this.isPunct();
    }

    public boolean isPunct() {
        return this.thechar == '.' || this.thechar == ';' || this.thechar == ',';
    }

    public boolean isPossibleLineEnd() {
        return this.thechar == '/' || this.thechar == '\\';
    }

    public char getMacRomanChar() {
        return this.thechar_macroman;
    }

    public char getChar() {
        return this.thechar;
    }

    public TextState getTextState() {
        return this.textstate;
    }

    public double getWidth() {
        if (this.isHanging() && this.hangingflag) {
            return 0.0;
        }
        return this.charwidth;
    }

    public void setForceHangingWidth() {
        this.hangingflag = true;
    }

    public double getHeight() {
        return this.textstate.getSize();
    }

    public String getLinkRef() {
        return this.textstate.getLinkRef();
    }

    public SidelineMarker getSidelineMarker() {
        return this.textstate.getSidelineMarker();
    }

    public ScoreMarker getScoreMarker() {
        return this.textstate.getScoreMarker();
    }

    public void setKernValue(int newkerning) {
        this.kernvalue = newkerning;
    }

    public int getKernValue() {
        return this.kernvalue;
    }
}

