/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter.inlineobjects;

import com.pdftech.fot2pdf.formatter.inlineobjects.InlineCharacter;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObject;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObjectVector;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineSpace;

public class InlineLeader
extends InlineObject {
    private int mincount;
    private boolean doaligngrid;
    private InlineObjectVector leadercontent;
    private boolean lengthleader;

    public InlineLeader(int mincnt, boolean alignit, InlineObjectVector content) {
        this.lengthleader = false;
        this.width = 0.0;
        this.mincount = mincnt;
        this.doaligngrid = alignit;
        content.trimToSize();
        this.leadercontent = content;
        this.leadercontent.doKerning();
    }

    public InlineLeader(double wantlength, boolean alignit, InlineObjectVector content) {
        this.lengthleader = true;
        this.width = wantlength;
        this.doaligngrid = alignit;
        content.trimToSize();
        this.leadercontent = content;
        this.leadercontent.doKerning();
    }

    public boolean isLengthLeader() {
        return this.lengthleader;
    }

    public int getMinimumRepetition() {
        return this.mincount;
    }

    public boolean getAlignToGrid() {
        return this.doaligngrid;
    }

    public void insertIntoVector(InlineObjectVector destcontent, int leaderpos, double leaderdestwidth) {
        destcontent.removeElementAt(leaderpos);
        if (this.isLengthLeader()) {
            leaderdestwidth = this.width;
        } else if (this.leadercontent.getWidth() * (double)this.mincount > leaderdestwidth) {
            destcontent.insertElementAt(new InlineSpace(leaderdestwidth, this), leaderpos++);
            return;
        }
        if (this.doaligngrid) {
            double beforewidth = 0.0;
            int i = 0;
            while (i < leaderpos) {
                beforewidth += ((InlineObject)destcontent.elementAt(i)).getWidth();
                if (destcontent.elementAt(i) instanceof InlineCharacter) {
                    InlineCharacter c = (InlineCharacter)destcontent.elementAt(i);
                    beforewidth -= (double)c.getKernValue() * c.getTextState().getSize() / 1000.0;
                }
                ++i;
            }
            double insertwidth = (double)((int)(beforewidth / this.leadercontent.getWidth() + 1.0)) * this.leadercontent.getWidth() - beforewidth;
            InlineSpace space = new InlineSpace(insertwidth, this);
            destcontent.insertElementAt(space, leaderpos++);
            leaderdestwidth -= insertwidth;
        } else {
            InlineSpace space = new InlineSpace(0.0, this);
            destcontent.insertElementAt(space, leaderpos++);
        }
        while (this.leadercontent.getWidth() > 0.0 && leaderdestwidth - this.leadercontent.getWidth() > 0.0) {
            destcontent.insertElementAt(new InlineSpace(0.0, this), leaderpos++);
            int j = 0;
            while (j < this.leadercontent.size()) {
                destcontent.insertElementAt(this.leadercontent.elementAt(j), leaderpos++);
                ++j;
            }
            leaderdestwidth -= this.leadercontent.getWidth();
        }
        destcontent.insertElementAt(new InlineSpace(leaderdestwidth, this), leaderpos++);
    }
}

