/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter.inlineobjects;

import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.TextState;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineCharacter;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineGroup;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineLeader;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObject;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineSpace;
import com.pdftech.fot2pdf.tools.ReplacementTable;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.tools.StringTools;
import java.util.Vector;

public class InlineObjectVector
implements Cloneable {
    private Vector data = new Vector();
    private double width = -1.0;

    public Object elementAt(int index) {
        return this.data.elementAt(index);
    }

    public int size() {
        return this.data.size();
    }

    public void trimToSize() {
        this.data.trimToSize();
    }

    public void insertElementAt(Object obj, int index) {
        this.data.insertElementAt(obj, index);
        this.setChanged();
    }

    public void removeElementAt(int index) {
        this.data.removeElementAt(index);
        this.setChanged();
    }

    public void setChanged() {
        this.width = -1.0;
    }

    public InlineObjectVector() {
        this.setChanged();
    }

    public void add(InlineObject o) {
        this.data.addElement(o);
        this.setChanged();
    }

    public void add(InlineObjectVector ov) {
        int i = 0;
        while (i < ov.size()) {
            this.add((InlineObject)ov.elementAt(i));
            ++i;
        }
    }

    public void add(String line, TextState ts) {
        line = StringTools.ReplaceEscapedUnicodeString(line);
        if ((line = ReplacementTable.exchange(line)).length() == 0) {
            return;
        }
        int i = 0;
        while (i < line.length()) {
            this.add(new InlineCharacter(line.charAt(i), ts));
            ++i;
        }
    }

    public void CheckWhitespaceTreatment(DSSSL_InheritedCharacteristics ic) {
        int i = 0;
        while (i < this.size()) {
            InlineCharacter c;
            InlineObject o = (InlineObject)this.elementAt(i);
            if (o instanceof InlineCharacter && (c = (InlineCharacter)o).getChar() == '\t') {
                TextState savets = c.getTextState();
                this.removeElementAt(i);
                this.insertElementAt(new InlineCharacter(' ', savets), i);
            }
            ++i;
        }
        if (ic.input_whitespace_treatment.equals("preserve")) {
            return;
        }
        if (ic.input_whitespace_treatment.equals("collapse")) {
            boolean lastwhite = true;
            int i2 = 0;
            while (i2 < this.size()) {
                InlineObject o = (InlineObject)this.elementAt(i2);
                if (o instanceof InlineCharacter) {
                    InlineCharacter c = (InlineCharacter)o;
                    if (c.isWhitespace()) {
                        if (lastwhite) {
                            this.removeElementAt(i2);
                            --i2;
                        }
                        lastwhite = true;
                    } else {
                        lastwhite = false;
                    }
                } else {
                    lastwhite = o instanceof InlineGroup || o instanceof InlineLeader || o instanceof InlineSpace;
                }
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.size()) {
                InlineCharacter c;
                InlineObject o = (InlineObject)this.elementAt(i3);
                if (o instanceof InlineCharacter && (c = (InlineCharacter)o).isWhitespace()) {
                    this.removeElementAt(i3);
                    --i3;
                }
                ++i3;
            }
        }
    }

    public double getWidth() {
        if (this.width < 0.0) {
            this.doKerning();
        }
        return this.width;
    }

    public void doKerning() {
        this.width = 0.0;
        int i = 0;
        while (i < this.size()) {
            InlineObject o = (InlineObject)this.elementAt(i);
            this.width += o.getWidth();
            if (o instanceof InlineCharacter) {
                int kernadd;
                InlineCharacter c = (InlineCharacter)o;
                InlineCharacter foundkern = null;
                boolean stillsearch = true;
                int j = i;
                while (foundkern == null && stillsearch) {
                    if (++j == this.size()) {
                        stillsearch = false;
                        continue;
                    }
                    InlineObject o2 = (InlineObject)this.elementAt(j);
                    if (o2 instanceof InlineCharacter) {
                        InlineCharacter c2 = (InlineCharacter)o2;
                        if (c2.isHyphenInsert()) {
                            if (j + 1 != this.size()) continue;
                            foundkern = c2;
                            continue;
                        }
                        foundkern = c2;
                        continue;
                    }
                    stillsearch = false;
                }
                c.setKernValue(0);
                if (foundkern != null && c.getTextState().equalsforkerning(foundkern.getTextState()) && (kernadd = c.getTextState().getFont().LogicalFont().kernvalue(c.getMacRomanChar(), foundkern.getMacRomanChar())) != 0) {
                    c.setKernValue(kernadd);
                }
                this.width -= (double)c.getKernValue() * c.getTextState().getSize() / 1000.0;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InlineObjectVector copy() {
        try {
            void e;
            InlineObjectVector newvector = (InlineObjectVector)super.clone();
            newvector.data = (Vector)this.data.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            Status.println("\rERROR! Could not duplicate InlineContentVector!");
            return null;
        }
    }
}

