/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter.inlineobjects;

import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.DSSSL_ParsedAttributes;
import com.pdftech.fot2pdf.formatter.contentboxes.GraphicsContentBox;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObject;
import com.pdftech.fot2pdf.pdf.PDFincludedimage;
import com.pdftech.fot2pdf.pdf.PDFincludedpdf;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.tools.Debugfile;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.xml.xmlnode;

public class InlinePicture
extends InlineObject {
    double shift_x = 0.0;
    double shift_y = 0.0;
    private PDFincludedimage image;
    private PDFincludedpdf subpdf;
    private boolean ispdf;

    public InlinePicture(double maxwidth, double maxheight, xmlnode o, DSSSL_InheritedCharacteristics ic, PDFoutfile pdf) {
        double checkmax;
        this.setLinkRef(ic.internal_linkdestination);
        this.image = null;
        this.ispdf = false;
        String filename = o.getAttribute("entity-system-id");
        String fileformat = o.getAttribute("notation-system-id");
        Debugfile.add("fileformat: " + fileformat);
        Debugfile.add("filename: " + filename);
        if (filename == null || fileformat == null) {
            Status.println("\rERROR! Graphics need entity-system-id and notation-system-id!");
            return;
        }
        if (fileformat.equals("") || fileformat.equals("*")) {
            fileformat = new String(filename);
            int lastdot = fileformat.lastIndexOf(".");
            Debugfile.add("- empty fileformat, getting out of filename (lastdot=" + lastdot + ")");
            if (lastdot > 0) {
                fileformat = fileformat.substring(lastdot + 1);
            }
            Debugfile.add("new fileformat: " + fileformat);
        }
        if (fileformat.equalsIgnoreCase("GIF") || fileformat.equalsIgnoreCase("JPG") || fileformat.equalsIgnoreCase("JPEG")) {
            this.image = new PDFincludedimage(pdf, filename);
            if (!this.image.isOK()) {
                Status.println("\rERROR! Needed ImageFile <" + filename + "> could not be loaded!");
                return;
            }
        } else if (fileformat.equalsIgnoreCase("PDF")) {
            this.subpdf = new PDFincludedpdf(pdf, filename);
            this.ispdf = true;
        } else if (fileformat.length() >= 9 && fileformat.substring(0, 7).equalsIgnoreCase("PDFPAGE")) {
            int pagenum = DSSSL_ParsedAttributes.readint(fileformat.substring(8));
            this.subpdf = new PDFincludedpdf(pdf, filename, pagenum);
            this.ispdf = true;
        } else {
            Status.println("\rWARNING! Unsupported graphics-format (" + fileformat + ") for " + filename + ". Please check!");
        }
        double dest_x = 0.0;
        double dest_y = 0.0;
        String a = o.getAttribute("max-width");
        if (a != null && (checkmax = DSSSL_ParsedAttributes.readlen(a)) < maxwidth) {
            maxwidth = checkmax;
        }
        if ((a = o.getAttribute("max-height")) != null && (checkmax = DSSSL_ParsedAttributes.readlen(a)) < maxheight) {
            maxheight = checkmax;
        }
        if ((a = o.getAttribute("position-point-x")) != null) {
            this.shift_x = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("position-point-y")) != null) {
            this.shift_y = -DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("scale")) != null) {
            if (a.equals("max")) {
                dest_x = maxwidth;
                dest_y = maxheight;
            } else if (a.equals("max-uniform")) {
                dest_x = maxwidth;
                dest_y = !this.ispdf ? dest_x * (double)this.image.getPixelsY() / (double)this.image.getPixelsX() : dest_x * this.subpdf.getHeight() / this.subpdf.getWidth();
                if (dest_y > maxheight) {
                    dest_y = maxheight;
                    dest_x = !this.ispdf ? dest_y * (double)this.image.getPixelsX() / (double)this.image.getPixelsY() : dest_y * this.subpdf.getWidth() / this.subpdf.getHeight();
                }
            } else {
                Status.println("\rWARNING! ExternalGraphics-scale not implemented: " + a);
                return;
            }
        }
        this.width = dest_x;
        this.height = dest_y;
    }

    public void setHeight(double val) {
        this.height = val;
    }

    public GraphicsContentBox getContent() {
        GraphicsContentBox gb = new GraphicsContentBox();
        if (!this.ispdf) {
            if (this.image == null) {
                gb.setGraphicsString("");
            } else {
                gb.setGraphicsString(this.image.getPaintString(this.shift_x, this.shift_y, this.width, this.height));
                gb.addResource(this.image.getPDFobject());
            }
        } else {
            gb.setGraphicsString(this.subpdf.getPaintString(this.shift_x, this.shift_y, this.width, this.height));
            gb.addResources(this.subpdf.getResources());
        }
        return gb;
    }
}

