/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.formatter.inlineobjects;

import com.pdftech.fot2pdf.formatter.DSSSL_InheritedCharacteristics;
import com.pdftech.fot2pdf.formatter.DSSSL_ParsedAttributes;
import com.pdftech.fot2pdf.formatter.Formatter;
import com.pdftech.fot2pdf.formatter.contentboxes.GraphicsContentBox;
import com.pdftech.fot2pdf.formatter.inlineobjects.InlineObject;
import com.pdftech.fot2pdf.xml.xmlnode;

public class InlineRule
extends InlineObject {
    private DSSSL_InheritedCharacteristics savedic;
    private double length;
    private double shift_y;
    private boolean ishorizontal;

    public InlineRule(double maxwidth, double maxheight, xmlnode o, DSSSL_InheritedCharacteristics ic) {
        this.savedic = ic;
        this.setLinkRef(ic.internal_linkdestination);
        String orientation = o.getAttribute("orientation");
        this.ishorizontal = orientation.equals("escapement");
        this.length = this.ishorizontal ? maxwidth : maxheight;
        this.shift_y = 0.0;
        String a = o.getAttribute("length");
        if (a != null) {
            this.length = DSSSL_ParsedAttributes.readlen(a);
        }
        if ((a = o.getAttribute("position-point-shift")) != null) {
            this.shift_y = -DSSSL_ParsedAttributes.readlen(a);
        }
        this.width = 0.0;
        if (this.ishorizontal) {
            this.width = this.length;
        }
        this.height = 0.0;
    }

    public void setLength(double newlength) {
        this.length = newlength;
    }

    public boolean isHorizontal() {
        return this.ishorizontal;
    }

    public GraphicsContentBox getContent() {
        GraphicsContentBox gb = new GraphicsContentBox();
        char ochar = 'h';
        if (!this.ishorizontal) {
            ochar = 'v';
        }
        gb.setGraphicsString(Formatter.makeLineDrawString(this.savedic, this.length, ochar));
        gb.moveby(0.0, this.shift_y);
        return gb;
    }
}

