/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.pdf;

import com.pdftech.fot2pdf.pdf.PDFascii85encodestream;
import com.pdftech.fot2pdf.pdf.PDFencodestream;
import com.pdftech.fot2pdf.pdf.PDFflateencodestream;
import com.pdftech.fot2pdf.pdf.PDFnumobject;
import com.pdftech.fot2pdf.pdf.PDFobject;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.pdf.PDFparameters;
import com.pdftech.fot2pdf.tools.Status;
import java.io.IOException;
import java.io.RandomAccessFile;

class PDFfontfileobject
extends PDFobject {
    public PDFfontfileobject(PDFoutfile motherfile, String basefile) {
        super(motherfile);
        PDFnumobject KeyLength = new PDFnumobject(motherfile);
        this.SetKey("/Length", KeyLength.getRefID());
        try {
            RandomAccessFile pfbfile = new RandomAccessFile(basefile + ".pfb", "r");
            pfbfile.seek(2L);
            int part1len = pfbfile.read() + 256 * pfbfile.read() + 65536 * pfbfile.read() + 0x1000000 * pfbfile.read();
            this.SetKey("/Length1", Integer.toString(part1len));
            pfbfile.seek(6 + part1len + 2);
            int part2len = pfbfile.read() + 256 * pfbfile.read() + 65536 * pfbfile.read() + 0x1000000 * pfbfile.read();
            this.SetKey("/Length2", Integer.toString(part2len));
            this.SetKey("/Length3", "0");
            pfbfile.close();
            if (PDFparameters.getDeflate()) {
                this.SetKey("/Filter", "[/ASCII85Decode /FlateDecode]");
            } else {
                this.SetKey("/Filter", "/ASCII85Decode");
            }
            this.write_start();
            PDFencodestream s = new PDFascii85encodestream(this);
            if (PDFparameters.getDeflate()) {
                s = new PDFflateencodestream(s);
            }
            this.writefiletostream(s, basefile + ".pfb", 6, part1len);
            this.writefiletostream(s, basefile + ".pfb", 6 + part1len + 6, part2len);
            int streamlen = s.end();
            this.write_end();
            KeyLength.setNum(streamlen);
            KeyLength.write();
            boolean error = false;
        }
        catch (IOException e) {
            Status.println("\rWARNING! Type1-Fontfile '" + basefile + ".pfb' could not be embedded!");
            boolean error = true;
        }
    }
}

