/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.pdf;

import com.pdftech.fot2pdf.pdf.PDFascii85encodestream;
import com.pdftech.fot2pdf.pdf.PDFencodestream;
import com.pdftech.fot2pdf.pdf.PDFflateencodestream;
import com.pdftech.fot2pdf.pdf.PDFnumobject;
import com.pdftech.fot2pdf.pdf.PDFobject;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.pdf.PDFparameters;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.Status;
import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;

class PDFimageobject
extends PDFobject {
    private boolean okflag = false;
    private String name;
    private int iw;
    private int ih;

    public boolean isOK() {
        return this.okflag;
    }

    public PDFimageobject(PDFoutfile motherfile, String Filename) {
        super(motherfile);
        int cj;
        int pixel;
        this.SetKey("/Type", "/XObject");
        this.SetKey("/Subtype", "/Image");
        this.name = motherfile.GetNextXObjectName();
        this.SetKey("/Name", this.name);
        if (PDFparameters.getDeflate()) {
            this.SetKey("/Filter", "[/ASCII85Decode /FlateDecode]");
        } else {
            this.SetKey("/Filter", "/ASCII85Decode");
        }
        Status.print("...embedding image...");
        Image i = Toolkit.getDefaultToolkit().createImage(Filename);
        Container trackerc = new Container();
        MediaTracker tracker = new MediaTracker(trackerc);
        tracker.addImage(i, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            Status.println("\rERROR! Java could not fetch image " + Filename + "...Interrupted!");
            this.abort();
            return;
        }
        this.iw = i.getWidth(null);
        this.ih = i.getHeight(null);
        if (this.iw == -1 || this.ih == -1) {
            Status.println("\rERROR! Java could not fetch image " + Filename + "!");
            this.abort();
            return;
        }
        this.SetKey("/Width", Integer.toString(this.iw));
        this.SetKey("/Height", Integer.toString(this.ih));
        int[] pixels = new int[this.iw * this.ih];
        PixelGrabber pg = new PixelGrabber(i, 0, 0, this.iw, this.ih, pixels, 0, this.iw);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("\rERROR! Java was interrupted waiting for pixels!");
            this.abort();
            return;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("\rERROR! Image fetch aborted or errored!");
            this.abort();
            return;
        }
        boolean bitmap = true;
        boolean grayscale = true;
        int cj2 = 0;
        while (cj2 < this.ih) {
            int ci = 0;
            while (ci < this.iw) {
                pixel = pixels[cj2 * this.iw + ci];
                int c1 = pixel >> 16 & 0xFF;
                int c2 = pixel >> 8 & 0xFF;
                int c3 = pixel & 0xFF;
                if (c1 != c2 || c2 != c3 || c3 != c1) {
                    grayscale = false;
                }
                if (pixel != -1 && pixel != -16777216) {
                    bitmap = false;
                }
                if (!grayscale && !bitmap) break;
                ++ci;
            }
            ++cj2;
        }
        if (bitmap || grayscale) {
            this.SetKey("/ColorSpace", "/DeviceGray");
            if (bitmap) {
                this.SetKey("/BitsPerComponent", "1");
            } else {
                this.SetKey("/BitsPerComponent", "8");
            }
        } else {
            this.SetKey("/ColorSpace", "/DeviceRGB");
            this.SetKey("/BitsPerComponent", "8");
        }
        PDFnumobject KeyLength = new PDFnumobject(motherfile);
        this.SetKey("/Length", KeyLength.getRefID());
        this.write_start();
        PDFencodestream s = new PDFascii85encodestream(this);
        if (PDFparameters.getDeflate()) {
            s = new PDFflateencodestream(s);
        }
        if (bitmap) {
            cj = 0;
            while (cj < this.ih) {
                int sumbyte = 0;
                int sumpos = 8;
                int ci = 0;
                while (ci < this.iw) {
                    sumbyte <<= 1;
                    if (pixels[cj * this.iw + ci] == -1) {
                        ++sumbyte;
                    }
                    if (--sumpos == 0) {
                        s.pushbyte(sumbyte);
                        sumbyte = 0;
                        sumpos = 8;
                    }
                    ++ci;
                }
                if (sumpos < 8) {
                    s.pushbyte(sumbyte << sumpos);
                }
                ++cj;
            }
        } else {
            cj = 0;
            while (cj < this.ih) {
                int ci = 0;
                while (ci < this.iw) {
                    pixel = pixels[cj * this.iw + ci];
                    if (!grayscale) {
                        s.pushbyte(pixel >> 16 & 0xFF);
                        s.pushbyte(pixel >> 8 & 0xFF);
                    }
                    s.pushbyte(pixel & 0xFF);
                    ++ci;
                }
                ++cj;
            }
        }
        int streamlen = s.end();
        this.write_end();
        i.flush();
        KeyLength.setNum(streamlen);
        KeyLength.write();
        this.okflag = true;
    }

    void abort() {
        this.iw = 1;
        this.ih = 1;
        this.SetKey("/ColorSpace", "/DeviceGray");
        this.SetKey("/Width", "1");
        this.SetKey("/Height", "1");
        this.SetKey("/BitsPerComponent", "1");
        this.SetKey("/Filter", "/ASCII85Decode");
        this.SetKey("/Length", "1");
        this.write_start();
        PDFascii85encodestream s = new PDFascii85encodestream(this);
        ((PDFencodestream)s).pushbyte(0);
        ((PDFencodestream)s).end();
        this.write_end();
    }

    public String getName() {
        return this.name;
    }

    public int getPixelsX() {
        return this.iw;
    }

    public int getPixelsY() {
        return this.ih;
    }

    public String getPaintString(double x, double y, double size_x, double size_y) {
        return new String("q " + GenericTools.round6string(size_x) + " 0 0 " + GenericTools.round6string(size_y) + " " + GenericTools.round6string(x) + " " + GenericTools.round6string(y - size_y) + " cm " + this.getName() + " Do Q");
    }
}

