/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.pdf;

import com.pdftech.fot2pdf.pdf.PDFascii85streamdecoder;
import com.pdftech.fot2pdf.pdf.PDFasciihexstreamdecoder;
import com.pdftech.fot2pdf.pdf.PDFflatestreamdecoder;
import com.pdftech.fot2pdf.pdf.PDFobject;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.pdf.PDFstreamdecoder;
import com.pdftech.fot2pdf.pdf.PDFtextobject;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.tools.StringTools;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class PDFincludedpdf {
    HashSet NeededResources;
    String workfilename;
    String content;
    double w;
    double h;
    int startxref;
    boolean error;
    private RandomAccessFile inpdf;

    public PDFincludedpdf(PDFoutfile pdf, String filename) {
        this(pdf, filename, 1);
    }

    public PDFincludedpdf(PDFoutfile pdf, String filename, int pagenum) {
        this.workfilename = filename;
        Status.print("...reading included PDF...");
        this.h = 1.0;
        this.w = 1.0;
        this.content = "";
        this.NeededResources = new HashSet();
        this.error = false;
        if (pagenum == 0) {
            Status.println("\rWARNING! Included PDF - internal error (#1): No page no. 0 possible!");
            this.error = true;
            return;
        }
        try {
            Enumeration e;
            pdfdict properties;
            pdfdict pattern;
            pdfdict colorspace;
            pdfdict xobject;
            pdfdict font;
            int i;
            this.inpdf = new RandomAccessFile(filename, "r");
            if (!this.inpdf.readLine().substring(0, 6).equals("%PDF-1")) {
                Status.println("\rERROR! File \"" + filename + "\" is not a valid PDF-file!");
                return;
            }
            long l = this.inpdf.length();
            do {
                this.inpdf.seek(--l);
            } while (!this.inpdf.readLine().equals("startxref"));
            this.startxref = PDFincludedpdf.readint(this.inpdf.readLine());
            this.seek(this.startxref);
            while (!this.inpdf.readLine().equals("trailer")) {
            }
            pdfdict trailer = this.readdictionary();
            pdfobjectref rootref = (pdfobjectref)trailer.get("/Root");
            if (rootref == null) {
                Status.println("\rWARNING! Included PDF - internal error (#2)");
                return;
            }
            rootref.follow();
            pdfdict root = this.readdictionary();
            pdfobjectref pagesref = (pdfobjectref)root.get("/Pages");
            if (pagesref == null) {
                Status.println("\rWARNING! Included PDF - internal error (#3)");
                return;
            }
            pagesref.follow();
            pdfarray cropbox = null;
            pdfarray mediabox = null;
            Object resources = null;
            boolean ispage = false;
            pdfdict pageobj = this.readdictionary();
            int levelstartpage = 1;
            block12: while (!this.error && !ispage) {
                if (pageobj.get("/CropBox") != null) {
                    cropbox = (pdfarray)pageobj.get("/CropBox");
                }
                if (pageobj.get("/MediaBox") != null) {
                    mediabox = (pdfarray)pageobj.get("/MediaBox");
                }
                if (pageobj.get("/Resources") != null) {
                    resources = pageobj.get("/Resources");
                }
                if (pageobj.get("/Count") == null) {
                    Status.println("\rWARNING! Included PDF - internal error (#10)");
                    this.error = true;
                    return;
                }
                int thiscount = PDFincludedpdf.readint((String)pageobj.get("/Count"));
                if (pagenum > levelstartpage + thiscount - 1) {
                    Status.println("\rWARNING! Included PDF - internal error (#11): Desired page not available!");
                    this.error = true;
                    return;
                }
                Object check = pageobj.get("/Kids");
                if (!(check instanceof pdfarray)) {
                    Status.println("\rWARNING! Included PDF - internal error (#4): Pages-object does not have Kids?");
                    this.error = true;
                    return;
                }
                pdfarray kidsarray = (pdfarray)check;
                int j = 0;
                while (j < kidsarray.size()) {
                    ((pdfobjectref)kidsarray.elementAt(j)).follow();
                    ++j;
                    pageobj = this.readdictionary();
                    check = pageobj.get("/Type");
                    boolean bl = ispage = check instanceof String && ((String)check).equals("/Page");
                    if (ispage) {
                        if (levelstartpage == pagenum) {
                            ispage = true;
                            continue block12;
                        }
                        ++levelstartpage;
                        continue;
                    }
                    int count = PDFincludedpdf.readint((String)pageobj.get("/Count"));
                    if (pagenum <= levelstartpage + count - 1) continue block12;
                    levelstartpage += count;
                }
            }
            if (pageobj.get("/CropBox") != null) {
                cropbox = (pdfarray)pageobj.get("/CropBox");
            }
            if (pageobj.get("/MediaBox") != null) {
                mediabox = (pdfarray)pageobj.get("/MediaBox");
            }
            if (pageobj.get("/Resources") != null) {
                resources = pageobj.get("/Resources");
            }
            double x1 = PDFincludedpdf.readdouble((String)mediabox.elementAt(0));
            double y1 = PDFincludedpdf.readdouble((String)mediabox.elementAt(1));
            double x2 = PDFincludedpdf.readdouble((String)mediabox.elementAt(2));
            double y2 = PDFincludedpdf.readdouble((String)mediabox.elementAt(3));
            if (cropbox != null) {
                double x3 = PDFincludedpdf.readdouble((String)cropbox.elementAt(0));
                double y3 = PDFincludedpdf.readdouble((String)cropbox.elementAt(1));
                double x4 = PDFincludedpdf.readdouble((String)cropbox.elementAt(2));
                double y4 = PDFincludedpdf.readdouble((String)cropbox.elementAt(3));
                if (x3 > x1) {
                    x1 = x3;
                }
                if (y3 > y1) {
                    y1 = y3;
                }
                if (x4 < x2) {
                    x2 = x4;
                }
                if (y4 < y2) {
                    y2 = y4;
                }
            }
            this.w = x2 - x1;
            this.h = y2 - y1;
            Object o = pageobj.get("/Contents");
            if (o == null) {
                Status.println("\rWARNING! Included PDF is an empty page!");
                return;
            }
            String c = "";
            if (cropbox != null) {
                c = c + "0 0 " + this.w + " " + this.h + " re W n ";
            }
            if (x1 != 0.0 || y1 != 0.0) {
                c = c + "1 0 0 1 " + GenericTools.round6string(-x1) + " " + GenericTools.round6string(-y1) + " cm ";
            }
            if (o instanceof pdfarray) {
                pdfarray contentsarr = (pdfarray)o;
                i = 0;
                while (i < contentsarr.size()) {
                    c = c + this.getstream((pdfobjectref)contentsarr.elementAt(i)) + " ";
                    ++i;
                }
            } else {
                c = c + this.getstream((pdfobjectref)o) + " ";
            }
            pdfdict res = this.readdict(resources);
            pdfarray procset = this.readarray(res.get("/ProcSet"));
            if (procset != null) {
                i = 0;
                while (i < procset.size()) {
                    this.NeededResources.add(new String("p" + procset.elementAt(i)));
                    ++i;
                }
            }
            Hashtable<String, String> namemapper = new Hashtable<String, String>();
            pdfdict extgstate = (pdfdict)res.get("/ExtGState");
            if (extgstate != null) {
                Enumeration e2 = extgstate.keys();
                while (e2.hasMoreElements()) {
                    String name = (String)e2.nextElement();
                    String newname = pdf.GetNextExtGStateName();
                    pdfobjectref dest = (pdfobjectref)extgstate.get(name);
                    namemapper.put(new String("g" + name), newname);
                    PDFobject gscopy = this.copy_anything_complete(pdf, dest);
                    this.NeededResources.add(new String("g" + newname + " " + gscopy.getRefID()));
                }
            }
            if ((font = (pdfdict)res.get("/Font")) != null) {
                Enumeration e3 = font.keys();
                while (e3.hasMoreElements()) {
                    String name = (String)e3.nextElement();
                    String newname = pdf.GetNextFontName();
                    pdfobjectref dest = (pdfobjectref)font.get(name);
                    namemapper.put(new String("f" + name), newname);
                    PDFobject fontcopy = this.copy_font(pdf, dest, newname);
                    this.NeededResources.add(new String("f" + newname + " " + fontcopy.getRefID()));
                }
            }
            if ((xobject = (pdfdict)res.get("/XObject")) != null) {
                Enumeration e4 = xobject.keys();
                while (e4.hasMoreElements()) {
                    String name = (String)e4.nextElement();
                    String newname = pdf.GetNextXObjectName();
                    pdfobjectref dest = (pdfobjectref)xobject.get(name);
                    namemapper.put(new String("x" + name), newname);
                    PDFobject xobjectcopy = this.copy_anything_complete(pdf, dest);
                    this.NeededResources.add(new String("x" + newname + " " + xobjectcopy.getRefID()));
                }
            }
            if ((colorspace = (pdfdict)res.get("/ColorSpace")) != null) {
                Enumeration e5 = colorspace.keys();
                while (e5.hasMoreElements()) {
                    String name = (String)e5.nextElement();
                    String newname = pdf.GetNextColorSpaceName();
                    pdfobjectref dest = (pdfobjectref)colorspace.get(name);
                    namemapper.put(new String("c" + name), newname);
                    PDFobject colorspacecopy = this.copy_anything_complete(pdf, dest);
                    this.NeededResources.add(new String("c" + newname + " " + colorspacecopy.getRefID()));
                }
            }
            if ((pattern = (pdfdict)res.get("/Pattern")) != null) {
                Enumeration e6 = pattern.keys();
                while (e6.hasMoreElements()) {
                    String name = (String)e6.nextElement();
                    String newname = pdf.GetNextPatternName();
                    pdfobjectref dest = (pdfobjectref)pattern.get(name);
                    namemapper.put(new String("a" + name), newname);
                    PDFobject patterncopy = this.copy_anything_complete(pdf, dest);
                    this.NeededResources.add(new String("a" + newname + " " + patterncopy.getRefID()));
                }
            }
            if ((properties = (pdfdict)res.get("/Properties")) != null) {
                e = properties.keys();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    String newname = pdf.GetNextPropertiesName();
                    if (!(properties.get(name) instanceof pdfobjectref)) continue;
                    pdfobjectref dest = (pdfobjectref)properties.get(name);
                    namemapper.put(new String("r" + name), newname);
                    PDFobject propertiescopy = this.copy_anything_complete(pdf, dest);
                    this.NeededResources.add(new String("r" + newname + " " + propertiescopy.getRefID()));
                }
            }
            e = namemapper.keys();
            while (e.hasMoreElements()) {
                int found;
                String searchstring = (String)e.nextElement();
                String replacestring = (String)namemapper.get(searchstring);
                char type = searchstring.charAt(0);
                searchstring = searchstring.substring(1, searchstring.length());
                replacestring = "/<<<//>>>" + replacestring.substring(1, replacestring.length());
                int last = -1;
                while ((found = c.indexOf(searchstring, last)) != -1) {
                    char checkchar = c.charAt(found + searchstring.length());
                    boolean replaceit = true;
                    int bs = found;
                    while (bs > 0) {
                        if (c.charAt(--bs) == ')' && c.charAt(bs - 1) != '\\') break;
                        if (c.charAt(bs) != '(' || c.charAt(bs - 1) == '\\') continue;
                        replaceit = false;
                        break;
                    }
                    if (!PDFincludedpdf.iswhite(checkchar)) {
                        replaceit = false;
                    }
                    if (replaceit) {
                        int pos = found;
                        while (pos > 0 && !PDFincludedpdf.iswhite(c.charAt(pos))) {
                            --pos;
                        }
                        while (pos > 0 && PDFincludedpdf.iswhite(c.charAt(pos))) {
                            --pos;
                        }
                        while (pos > 0 && !PDFincludedpdf.iswhite(c.charAt(pos))) {
                            --pos;
                        }
                        while (pos > 0 && PDFincludedpdf.iswhite(c.charAt(pos))) {
                            ++pos;
                        }
                        String pt = this.getNextToken(c, pos);
                        pos = found;
                        while (pos < c.length() && !PDFincludedpdf.iswhite(c.charAt(pos))) {
                            ++pos;
                        }
                        while (pos < c.length() && PDFincludedpdf.iswhite(c.charAt(pos))) {
                            ++pos;
                        }
                        String nt = this.getNextToken(c, pos);
                        while (pos < c.length() && !PDFincludedpdf.iswhite(c.charAt(pos))) {
                            ++pos;
                        }
                        while (pos < c.length() && PDFincludedpdf.iswhite(c.charAt(pos))) {
                            ++pos;
                        }
                        String nt2 = this.getNextToken(c, pos);
                        switch (type) {
                            case 'g': {
                                replaceit = nt.equals("gs");
                                break;
                            }
                            case 'c': {
                                replaceit = nt.equals("cs") || nt.equals("CS") || pt.equals("/CS") || pt.equals("/ColorSpace");
                                break;
                            }
                            case 'f': {
                                replaceit = nt2.equals("Tf");
                                break;
                            }
                            case 'x': {
                                replaceit = nt.equals("Do");
                                break;
                            }
                            case 'a': {
                                replaceit = nt.equals("SCN") || nt.equals("scn");
                                break;
                            }
                            case 'r': {
                                boolean bl = replaceit = nt.equals("DP") || nt.equals("BDC");
                            }
                        }
                    }
                    if (replaceit) {
                        c = c.substring(0, found) + replacestring + c.substring(found + searchstring.length(), c.length());
                    }
                    last = found + 1;
                }
            }
            this.content = c = PDFincludedpdf.replaceall(c, "<<<//>>>", "");
        }
        catch (IOException e) {
            Status.println("\rERROR! Could not read " + filename);
        }
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public HashSet getResources() {
        return this.NeededResources;
    }

    public String getPaintString(double x, double y, double size_x, double size_y) {
        return new String("q " + size_x / this.w + " 0 0 " + size_y / this.h + " " + x + " " + (y - size_y) + " cm " + this.content + " Q");
    }

    private static boolean iswhite(char c) {
        return c == '\r' || c == '\n' || c == '\t' || c == ' ';
    }

    private String getNextToken(String c, int pos) {
        StringBuffer s = new StringBuffer();
        while (!PDFincludedpdf.iswhite(c.charAt(pos))) {
            s.append(c.charAt(pos++));
        }
        return s.toString();
    }

    private static String replaceall(String c, String searchstring, String replacestring) {
        int found;
        int last = -1;
        while ((found = c.indexOf(searchstring, last)) != -1) {
            c = c.substring(0, found) + replacestring + c.substring(found + searchstring.length(), c.length());
            last = found;
        }
        return c;
    }

    private PDFobject copy_font(PDFoutfile pdf, pdfobjectref ref, String newname) {
        PDFobject o = this.copy_anything(pdf, ref);
        o.SetKey("/Name", newname);
        this.copy_complete(pdf, o);
        return o;
    }

    private void copy_stream(PDFoutfile pdf) {
        long fp;
        String l = "";
        do {
            fp = this.getFilePointer();
        } while (!(l = this.readLine()).equals("stream") && !l.equals("endobj"));
        long startcopy = fp;
        if (l.equals("endobj")) {
            return;
        }
        while (!(l = this.readLine()).equals("endstream")) {
        }
        long endcopy = this.getFilePointer();
        this.seek(startcopy);
        int i = 0;
        while ((long)i < endcopy - startcopy) {
            try {
                pdf.write(this.inpdf.read());
            }
            catch (IOException e) {
                break;
            }
            ++i;
        }
    }

    void copy_arraycontent(PDFoutfile pdf, pdfarray arr) {
        int ai = 0;
        while (ai < arr.size()) {
            if (arr.elementAt(ai) instanceof pdfobjectref) {
                long savefp = this.getFilePointer();
                PDFobject copyref = this.copy_anything_complete(pdf, arr.elementAt(ai));
                this.seek(savefp);
                arr.setElementAt(copyref.getRefID(), ai);
            }
            ++ai;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    PDFobject copy_anything(PDFoutfile pdf, Object dest) {
        pdfdict d;
        block6: {
            if (dest instanceof pdfobjectref) {
                ((pdfobjectref)dest).follow();
                Object xo = this.readnextentity();
                if (xo instanceof pdfdict) {
                    d = (pdfdict)xo;
                    break block6;
                } else {
                    if (!(xo instanceof pdfarray)) return new PDFtextobject(pdf, xo.toString());
                    this.copy_arraycontent(pdf, (pdfarray)xo);
                    return new PDFtextobject(pdf, xo.toString());
                }
            }
            d = (pdfdict)dest;
        }
        PDFobject o = new PDFobject(pdf);
        Enumeration e = d.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object keydata = d.get(name);
            if (keydata instanceof pdfobjectref) {
                long savefp = this.getFilePointer();
                PDFobject copyref = this.copy_anything_complete(pdf, keydata);
                this.seek(savefp);
                keydata = copyref.getRefID();
            }
            if (keydata instanceof pdfarray) {
                this.copy_arraycontent(pdf, (pdfarray)keydata);
            }
            o.SetKey(name, keydata.toString());
        }
        return o;
    }

    void copy_complete(PDFoutfile pdf, PDFobject o) {
        o.write_start();
        this.copy_stream(pdf);
        o.write_end();
    }

    PDFobject copy_anything_complete(PDFoutfile pdf, Object dest) {
        PDFobject precopy;
        if (dest instanceof pdfobjectref && (precopy = pdf.getCopiedObject(this.workfilename, ((pdfobjectref)dest).getObjectNum())) != null) {
            return precopy;
        }
        PDFobject o = this.copy_anything(pdf, dest);
        this.copy_complete(pdf, o);
        if (dest instanceof pdfobjectref) {
            pdf.addCopiedObject(this.workfilename, ((pdfobjectref)dest).getObjectNum(), o);
        }
        return o;
    }

    private int firstint(String x) {
        int i = 0;
        while (x.charAt(i) != ' ') {
            ++i;
        }
        String y = x.substring(0, i);
        return PDFincludedpdf.readint(y);
    }

    private int secondint(String x) {
        String[] entries = StringTools.SplitSpacedLine(x);
        return PDFincludedpdf.readint(entries[1]);
    }

    private void seek(long where) {
        try {
            this.inpdf.seek(where);
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    private long getFilePointer() {
        try {
            return this.inpdf.getFilePointer();
        }
        catch (IOException e) {
            this.error = true;
            return 0L;
        }
    }

    private String readLine() {
        try {
            return this.inpdf.readLine();
        }
        catch (IOException e) {
            this.error = true;
            return "";
        }
    }

    private String getstream(pdfobjectref streamref) {
        String x;
        streamref.follow();
        pdfdict streaminfo = this.readdictionary();
        long fp = this.getFilePointer();
        int len = this.readlength(streaminfo.get("/Length"));
        this.seek(fp);
        Object filtertype = streaminfo.get("/Filter");
        pdfarray filters = null;
        if (filtertype != null) {
            if (filtertype instanceof pdfarray) {
                filters = (pdfarray)filtertype;
            } else {
                filters = new pdfarray();
                filters.add((String)filtertype);
            }
        }
        PDFstreamdecoder decoder = new PDFstreamdecoder();
        if (filters != null) {
            int i = filters.size();
            while (i > 0) {
                if (filters.elementAt(--i).equals("/ASCII85Decode")) {
                    decoder = new PDFascii85streamdecoder(decoder);
                }
                if (filters.elementAt(i).equals("/ASCIIHexDecode")) {
                    decoder = new PDFasciihexstreamdecoder(decoder);
                }
                if (filters.elementAt(i).equals("/FlateDecode")) {
                    decoder = new PDFflatestreamdecoder(decoder);
                }
                if (!filters.elementAt(i).equals("/LZWDecode")) continue;
                Status.println("\rWARNING! Included PDF uses patented LZWDecode - cannot import it!");
                return "";
            }
        }
        while (!(x = this.readLine()).equals("stream")) {
        }
        try {
            int i = 0;
            while (i < len) {
                decoder.pushencodedbyte(this.inpdf.read());
                ++i;
            }
        }
        catch (IOException e) {
            Status.println("\rWARNING! Included PDF - internal error (#5)");
        }
        decoder.end();
        return decoder.getdecodedstring();
    }

    private pdfdict readdict(Object o) {
        if (o instanceof pdfobjectref) {
            ((pdfobjectref)o).follow();
            return this.readdictionary();
        }
        return (pdfdict)o;
    }

    private pdfarray readarray(Object o) {
        if (o instanceof pdfobjectref) {
            ((pdfobjectref)o).follow();
            return (pdfarray)this.readnextentity();
        }
        return (pdfarray)o;
    }

    private int readlength(Object o) {
        if (o instanceof pdfobjectref) {
            ((pdfobjectref)o).follow();
            return PDFincludedpdf.readint(this.readnextstring());
        }
        return PDFincludedpdf.readint((String)o);
    }

    private void goobject(int onum) {
        this.seek(this.startxref);
        String x = this.readLine();
        boolean found = false;
        while (!found) {
            int i;
            x = this.readLine();
            if (x.equals("trailer")) {
                pdfdict trailer = this.readdictionary();
                Object preventry = trailer.get("/Prev");
                if (preventry == null) {
                    Status.println("\rWARNING! Included PDF - internal error (#98): Objectref not found!");
                    this.error = true;
                    return;
                }
                int prevstartxref = PDFincludedpdf.readint((String)preventry);
                this.seek(prevstartxref);
                x = this.readLine();
                continue;
            }
            int startno = this.firstint(x);
            int anzrefs = this.secondint(x);
            if (onum >= startno && onum <= startno + anzrefs - 1) {
                i = 0;
                while (i < onum - startno + 1) {
                    x = this.readLine();
                    ++i;
                }
                found = true;
                continue;
            }
            i = 0;
            while (i < anzrefs) {
                x = this.readLine();
                ++i;
            }
        }
        this.seek(this.firstint(x));
        String string = this.readLine();
    }

    private static int readint(String info) {
        int val = 0;
        try {
            val = Integer.parseInt(info.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    private static double readdouble(String info) {
        double val = 0.0;
        try {
            val = Double.parseDouble(info.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    private char readnextchar() {
        char x = '\u0000';
        try {
            x = (char)this.inpdf.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return x;
    }

    /*
     * Unable to fully structure code
     */
    private String readnextstring() {
        s = new StringBuffer();
        started = false;
        x = this.readnextchar();
        ** GOTO lbl13
        {
            x = this.readnextchar();
            do {
                if (x == '\r' || x == ' ' || x == '\n') continue block0;
                if (x == '%') ** GOTO lbl12
                started = true;
                continue;
lbl-1000:
                // 1 sources

                {
                    x = this.readnextchar();
lbl12:
                    // 2 sources

                    ** while (x != '\r' && x != '\n')
                }
lbl13:
                // 3 sources

            } while (!started);
        }
        if (x == '/') {
            do {
                s.append(x);
                x = this.readnextchar();
            } while (!this.error && x != ' ' && x != '\r' && x != '\n' && x != '%' && x != '(' && x != ')' && x != '[' && x != ']' && x != '<' && x != '>' && x != '{' && x != '}' && x != '/');
            if (x != ' ') {
                this.seek(this.getFilePointer() - 1L);
            }
        } else if (x == '(') {
            escapenext = false;
            do {
                escapenext = false;
                s.append(x);
                x = this.readnextchar();
                if (x != '\\') continue;
                escapenext = true;
            } while (!this.error && escapenext || x != ')');
            s.append(x);
        } else if (x == '[') {
            s.append(x);
        } else {
            do {
                s.append(x);
                x = this.readnextchar();
            } while (!this.error && x != '\r' && x != ' ' && x != '\n');
        }
        return new String(s);
    }

    private Object readnextentity() {
        String s = this.readnextstring();
        Object outobject = null;
        char x = s.charAt(0);
        if (s.equals("[")) {
            pdfarray arr = new pdfarray();
            boolean done = false;
            while (!done) {
                Object e = this.readnextentity();
                if (this.error) break;
                if (!(e instanceof String)) {
                    arr.add(e);
                    continue;
                }
                String es = (String)e;
                if (es.charAt(es.length() - 1) == ']') {
                    if (es.length() > 1) {
                        arr.add(es.substring(0, es.length() - 1));
                    }
                    done = true;
                    continue;
                }
                arr.add(e);
            }
            outobject = arr;
        } else if (s.equals("]")) {
            outobject = s;
        } else if (s.length() >= 2 && s.substring(0, 2).equals("<<")) {
            pdfdict dict = new pdfdict();
            s = s.length() == 2 ? this.readnextstring() : s.substring(2, s.length());
            while (!this.error && !s.equals(">>")) {
                dict.addpair(s, this.readnextentity());
                s = this.readnextstring();
            }
            outobject = dict;
        } else {
            long fp = this.getFilePointer();
            String s2 = this.readnextstring();
            String s3 = this.readnextstring();
            if (s3.equals("R]")) {
                this.seek(fp);
                try {
                    while (this.inpdf.read() != 82) {
                    }
                }
                catch (IOException e) {
                    this.error = true;
                }
                s3 = "R";
            }
            if (s3.equals("R")) {
                outobject = new pdfobjectref(new String(s + " " + s2 + " " + s3));
            } else {
                this.seek(fp);
                outobject = s;
            }
        }
        return outobject;
    }

    private pdfdict readdictionary() {
        Object o = this.readnextentity();
        if (o instanceof pdfdict) {
            return (pdfdict)o;
        }
        Status.println("\rWARNING! Included PDF - internal error (#1)");
        return new pdfdict();
    }

    class pdfobjectref {
        int refto;

        pdfobjectref(String data) {
            this.refto = PDFincludedpdf.this.firstint(data);
        }

        void follow() {
            PDFincludedpdf.this.goobject(this.refto);
        }

        int getObjectNum() {
            return this.refto;
        }
    }

    class pdfarray {
        Vector data = new Vector();

        pdfarray() {
        }

        void add(Object x) {
            this.data.addElement(x);
        }

        Object elementAt(int i) {
            return this.data.elementAt(i);
        }

        void setElementAt(Object o, int i) {
            this.data.setElementAt(o, i);
        }

        int size() {
            return this.data.size();
        }

        public String toString() {
            StringBuffer s = new StringBuffer("[ ");
            int i = 0;
            while (i < this.size()) {
                s.append(this.elementAt(i).toString() + " ");
                ++i;
            }
            return s.append("]").toString();
        }
    }

    class pdfdict {
        Hashtable table = new Hashtable();

        pdfdict() {
        }

        void addpair(String key, Object value) {
            this.table.put(key, value);
        }

        Object get(String key) {
            return this.table.get(key);
        }

        Enumeration keys() {
            return this.table.keys();
        }

        public String toString() {
            StringBuffer s = new StringBuffer("<< ");
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                s.append(name + " " + this.get(name).toString() + " ");
            }
            s.append(">>");
            return s.toString();
        }
    }
}

