/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.pdf;

import com.pdftech.fot2pdf.pdf.PDFencodestream;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.tools.Status;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;

class PDFobject {
    protected PDFoutfile mother;
    private int streamcount;
    private int streamsubcount;
    private byte[] streambuff;
    private int ObjectID;
    private Hashtable data;

    public PDFobject(PDFoutfile motherfile) {
        this.ObjectID = motherfile.GetNextObjectID();
        this.data = new Hashtable();
        this.mother = motherfile;
    }

    public int GetID() {
        return this.ObjectID;
    }

    public String getRefID() {
        return Integer.toString(this.ObjectID) + " 0 R";
    }

    public void SetKey(String inKey, String inData) {
        this.data.put(inKey, inData);
    }

    public String GetDataByKey(String inKey) {
        return (String)this.data.get(inKey);
    }

    protected void write_start() {
        this.mother.addxref(this);
        this.mother.writeln(Integer.toString(this.GetID()) + " 0 obj");
        if (!this.data.isEmpty()) {
            this.mother.writeln("<<");
            if (this.data.containsKey("/Type")) {
                this.mother.writeln("/Type " + this.GetDataByKey("/Type"));
                this.data.remove("/Type");
            }
            if (this.data.containsKey("/Subtype")) {
                this.mother.writeln("/Subtype " + this.GetDataByKey("/Subtype"));
                this.data.remove("/Subtype");
            }
            if (this.data.containsKey("/BaseEncoding")) {
                this.mother.writeln("/BaseEncoding " + this.GetDataByKey("/BaseEncoding"));
                this.data.remove("/BaseEncoding");
            }
            Enumeration e_keys = this.data.keys();
            Enumeration e_data = this.data.elements();
            while (e_keys.hasMoreElements()) {
                this.mother.writeln((String)e_keys.nextElement() + " " + (String)e_data.nextElement());
            }
            this.mother.writeln(">>");
        }
    }

    protected void write_end() {
        this.mother.writeln("endobj");
    }

    public void write() {
        this.write_start();
        this.write_end();
    }

    public void startstream() {
        this.mother.writeln("stream");
        this.streamcount = 0;
        this.streambuff = new byte[1000];
        this.streamsubcount = 0;
    }

    public int getstreamcount() {
        return this.streamcount;
    }

    private void flushstream() {
        this.mother.write(this.streambuff, 0, this.streamsubcount);
        this.streamcount += this.streamsubcount;
        this.streamsubcount = 0;
    }

    public void pushstreamchar(char x) {
        this.streambuff[this.streamsubcount++] = (byte)x;
        if (this.streamsubcount == this.streambuff.length) {
            this.flushstream();
        }
    }

    public int closestream() {
        this.flushstream();
        this.mother.writeln("\rendstream");
        this.streambuff = null;
        return this.streamcount + 1;
    }

    public void writefiletostream(PDFencodestream s, String filename, int startoffset, int len) {
        try {
            RandomAccessFile f = new RandomAccessFile(filename, "r");
            if (len == -1) {
                len = (int)f.length();
            }
            f.seek(startoffset);
            int i = 0;
            byte[] buff = new byte[1000];
            while (i < len) {
                int toread = len - i;
                if (toread > buff.length) {
                    toread = buff.length;
                }
                int didread = f.read(buff, 0, toread);
                i += didread;
                int j = 0;
                while (j < didread) {
                    if (buff[j] >= 0) {
                        s.pushbyte(buff[j]);
                    } else {
                        s.pushbyte(256 + buff[j]);
                    }
                    ++j;
                }
            }
            f.close();
        }
        catch (IOException e) {
            Status.println("\rERROR! Could not read from file " + filename + ", reason: " + e);
        }
    }

    public void writefiletostream(PDFencodestream s, String filename) {
        this.writefiletostream(s, filename, 0, -1);
    }

    public static String MakePDFString(String inText) {
        String x = "(";
        int i = 0;
        while (i < inText.length()) {
            switch (inText.charAt(i)) {
                case '(': {
                    x = x + "\\(";
                    break;
                }
                case '\\': {
                    x = x + "\\\\";
                    break;
                }
                case ')': {
                    x = x + "\\)";
                    break;
                }
                default: {
                    x = x + inText.charAt(i);
                }
            }
            ++i;
        }
        x = x + ")";
        return x;
    }
}

