/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.pdf;

import com.pdftech.fot2pdf.pdf.PDFcatalogobject;
import com.pdftech.fot2pdf.pdf.PDFfontobject;
import com.pdftech.fot2pdf.pdf.PDFinfoobject;
import com.pdftech.fot2pdf.pdf.PDFobject;
import com.pdftech.fot2pdf.pdf.PDFoutlinesobject;
import com.pdftech.fot2pdf.pdf.PDFpageobject;
import com.pdftech.fot2pdf.pdf.PDFpagesobject;
import com.pdftech.fot2pdf.pdf.PDFparameters;
import com.pdftech.fot2pdf.tools.Encoding;
import com.pdftech.fot2pdf.tools.LogicalFont;
import com.pdftech.fot2pdf.tools.Status;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class PDFoutfile {
    private int ObjectCounter;
    private int FontCounter;
    private int XObjectCounter;
    private int ExtGStateCounter;
    private int ColorSpaceCounter;
    private int PatternCounter;
    private int PropertiesCounter;
    private Hashtable FontList;
    private long FilePosCounter;
    private Vector xreflist;
    private long XRefFilePos;
    private PDFobject EncodingObject;
    private Hashtable CopiedObjects;
    private BufferedOutputStream out;
    private String name;
    private PDFcatalogobject catalog;
    private PDFpagesobject pages;
    private PDFoutlinesobject outlines;
    private PDFinfoobject info;

    public PDFoutfile(String _name) {
        this.name = _name;
        this.ObjectCounter = 1;
        this.PropertiesCounter = 1;
        this.PatternCounter = 1;
        this.ColorSpaceCounter = 1;
        this.ExtGStateCounter = 1;
        this.XObjectCounter = 1;
        this.FontCounter = 1;
        this.EncodingObject = null;
    }

    public String GetEncodingObjectRef() {
        if (this.EncodingObject == null) {
            this.EncodingObject = new PDFobject(this);
            this.EncodingObject.SetKey("/Type", "/Encoding");
            this.EncodingObject.SetKey("/Differences", Encoding.getMacRomanDifferences());
            this.EncodingObject.write();
        }
        return this.EncodingObject.getRefID();
    }

    public int GetNextObjectID() {
        this.xreflist.addElement("");
        return this.ObjectCounter++;
    }

    public String GetNextFontName() {
        return new String("/F" + Integer.toString(this.FontCounter++));
    }

    public String GetNextXObjectName() {
        return new String("/IM" + Integer.toString(this.XObjectCounter++));
    }

    public String GetNextExtGStateName() {
        return new String("/GS" + Integer.toString(this.ExtGStateCounter++));
    }

    public String GetNextColorSpaceName() {
        return new String("/CS" + Integer.toString(this.ColorSpaceCounter++));
    }

    public String GetNextPatternName() {
        return new String("/PT" + Integer.toString(this.PatternCounter++));
    }

    public String GetNextPropertiesName() {
        return new String("/PROP" + Integer.toString(this.PropertiesCounter++));
    }

    public PDFfontobject getFont(String FontName) {
        if (this.FontList.get(FontName) != null) {
            return (PDFfontobject)this.FontList.get(FontName);
        }
        PDFfontobject newfont = new PDFfontobject(this, new LogicalFont(FontName));
        this.FontList.put(FontName, newfont);
        return newfont;
    }

    public PDFfontobject getFont(String FontName, String w, String p, String s, String pw) {
        return this.getFont(LogicalFont.getBaseName(FontName, w, p, s, pw));
    }

    public void addCopiedObject(String filename, int oldobjectid, PDFobject ref) {
        this.CopiedObjects.put(new String(Integer.toString(oldobjectid) + "#" + filename), ref);
    }

    public PDFobject getCopiedObject(String filename, int oldobjectid) {
        String checkstring = new String(Integer.toString(oldobjectid) + "#" + filename);
        if (this.CopiedObjects.get(checkstring) != null) {
            return (PDFobject)this.CopiedObjects.get(checkstring);
        }
        return null;
    }

    public boolean start() {
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(this.name));
        }
        catch (IOException e) {
            return false;
        }
        this.FilePosCounter = 0L;
        this.xreflist = new Vector();
        this.xreflist.insertElementAt("0000000000 65535 f", 0);
        if (PDFparameters.getDeflate()) {
            this.WriteComment("PDF-1.2");
        } else {
            this.WriteComment("PDF-1.1");
        }
        this.WriteComment("\u00e2\u00e3\u00cf\u00d3");
        this.catalog = new PDFcatalogobject(this);
        this.pages = new PDFpagesobject(this);
        this.outlines = new PDFoutlinesobject(this);
        this.info = new PDFinfoobject(this);
        this.FontList = new Hashtable();
        this.CopiedObjects = new Hashtable();
        return true;
    }

    public void AddPage(PDFpageobject inNewPage) {
        this.pages.AddKid(inNewPage);
    }

    public void write(int _what) {
        try {
            this.out.write(_what);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.FilePosCounter;
    }

    public void write(String _what) {
        int i = 0;
        while (i < _what.length()) {
            this.write(_what.charAt(i));
            ++i;
        }
    }

    public void writeln(String _what) {
        this.write(_what + "\r\n");
    }

    public void write(byte[] buff) {
        this.write(buff, 0, buff.length);
    }

    public void write(byte[] buff, int off, int len) {
        try {
            this.out.write(buff, off, len);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.FilePosCounter += (long)len;
    }

    public void WriteComment(String _comment) {
        this.writeln("%" + _comment);
    }

    public void addxref(PDFobject inObj) {
        String outstring = Long.toString(this.FilePosCounter);
        while (outstring.length() < 10) {
            outstring = "0" + outstring;
        }
        this.xreflist.setElementAt(outstring + " 00000 n", inObj.GetID());
    }

    private void WriteCrossReferenceTable() {
        this.XRefFilePos = this.FilePosCounter;
        this.writeln("xref");
        this.writeln("0 " + Integer.toString(this.xreflist.size()));
        int i = 0;
        while (i < this.xreflist.size()) {
            this.writeln((String)this.xreflist.elementAt(i));
            if (((String)this.xreflist.elementAt(i)).equals("")) {
                Status.println("\rERROR (internal)! Empty PDF-Object at Crossref found!");
            }
            ++i;
        }
    }

    private void WriteTrailer() {
        this.writeln("trailer");
        this.writeln("<<");
        this.writeln("/Size " + Integer.toString(this.xreflist.size()));
        this.writeln("/Root " + this.catalog.getRefID());
        this.writeln("/Info " + this.info.getRefID());
        this.writeln(">>");
        this.writeln("startxref");
        this.writeln(Long.toString(this.XRefFilePos));
        this.writeln("%%EOF");
    }

    public void end() {
        this.pages.write();
        this.outlines.write();
        this.info.write();
        this.catalog.SetPages(this.pages);
        this.catalog.SetOutlines(this.outlines);
        this.catalog.write();
        this.WriteCrossReferenceTable();
        this.WriteTrailer();
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

