/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.pdf;

import com.pdftech.fot2pdf.pdf.PDFascii85encodestream;
import com.pdftech.fot2pdf.pdf.PDFencodestream;
import com.pdftech.fot2pdf.pdf.PDFflateencodestream;
import com.pdftech.fot2pdf.pdf.PDFfontobject;
import com.pdftech.fot2pdf.pdf.PDFimageobject;
import com.pdftech.fot2pdf.pdf.PDFlinkannotationobject;
import com.pdftech.fot2pdf.pdf.PDFnumobject;
import com.pdftech.fot2pdf.pdf.PDFobject;
import com.pdftech.fot2pdf.pdf.PDFoutfile;
import com.pdftech.fot2pdf.pdf.PDFparameters;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.StringTools;
import java.util.HashSet;
import java.util.Iterator;

public class PDFpageobject
extends PDFobject {
    private double width;
    private double height;
    private String contents;
    private String annotations;
    private HashSet Resources;

    public PDFpageobject(PDFoutfile motherfile, double inWidth, double inHeight) {
        super(motherfile);
        this.width = inWidth;
        this.height = inHeight;
        this.SetKey("/Type", "/Page");
        this.SetKey("/MediaBox", "[0 0 " + GenericTools.round3(this.width) + " " + GenericTools.round3(this.height) + "]");
        motherfile.AddPage(this);
        this.contents = new String("");
        this.annotations = new String("");
        this.Resources = new HashSet();
        this.Resources.add("p/PDF");
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void AddContent(PDFobject contentstream) {
        this.contents = StringTools.AddSpacedString(this.contents, contentstream.getRefID());
    }

    public void AddContent(String contentstring) {
        PDFobject streamobject = new PDFobject(this.mother);
        if (PDFparameters.getDeflateText()) {
            streamobject.SetKey("/Filter", "[/ASCII85Decode /FlateDecode]");
            PDFnumobject KeyLength = new PDFnumobject(this.mother);
            streamobject.SetKey("/Length", KeyLength.getRefID());
            streamobject.write_start();
            PDFflateencodestream s = new PDFflateencodestream(new PDFascii85encodestream(streamobject));
            int i = 0;
            while (i < contentstring.length()) {
                ((PDFencodestream)s).pushbyte(contentstring.charAt(i));
                ++i;
            }
            int streamlen = ((PDFencodestream)s).end();
            streamobject.write_end();
            KeyLength.setNum(streamlen);
            KeyLength.write();
        } else {
            streamobject.SetKey("/Length", Integer.toString(contentstring.length() + 2));
            streamobject.write_start();
            this.mother.writeln("stream");
            this.mother.writeln(contentstring);
            this.mother.writeln("endstream");
            streamobject.write_end();
        }
        this.AddContent(streamobject);
    }

    public void AddAnnotation(PDFlinkannotationobject inObject) {
        this.annotations = StringTools.AddSpacedString(this.annotations, inObject.getRefID());
    }

    public void write() {
        if (this.contents.length() != 0) {
            this.SetKey("/Contents", "[" + this.contents + "]");
        }
        if (this.annotations.length() != 0) {
            this.SetKey("/Annots", "[" + this.annotations + "]");
        }
        String rr = "";
        String ra = "";
        String rc = "";
        String rg = "";
        String rx = "";
        String rp = "";
        String rf = "";
        Iterator i = this.Resources.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            char c = s.charAt(0);
            s = s.substring(1, s.length());
            switch (c) {
                case 'f': {
                    rf = rf + s + " ";
                    break;
                }
                case 'p': {
                    rp = rp + s + " ";
                    break;
                }
                case 'x': {
                    rx = rx + s + " ";
                    break;
                }
                case 'g': {
                    rg = rg + s + " ";
                    break;
                }
                case 'c': {
                    rc = rc + s + " ";
                    break;
                }
                case 'a': {
                    ra = ra + s + " ";
                    break;
                }
                case 'r': {
                    rr = rr + s + " ";
                }
            }
        }
        StringBuffer resstring = new StringBuffer();
        resstring.append("<< ");
        if (rf.length() > 0) {
            resstring.append("/Font << " + rf + ">> ");
        }
        if (rp.length() > 0) {
            resstring.append("/ProcSet [ " + rp + "] ");
        }
        if (rx.length() > 0) {
            resstring.append("/XObject << " + rx + ">> ");
        }
        if (rg.length() > 0) {
            resstring.append("/ExtGState << " + rg + ">> ");
        }
        if (rc.length() > 0) {
            resstring.append("/ColorSpace << " + rc + ">> ");
        }
        if (ra.length() > 0) {
            resstring.append("/Pattern << " + ra + ">> ");
        }
        if (rr.length() > 0) {
            resstring.append("/Properties << " + rr + ">> ");
        }
        resstring.append(">>");
        this.SetKey("/Resources", resstring.toString());
        super.write();
    }

    public void AddResource(Object o) {
        if (o instanceof PDFfontobject) {
            PDFfontobject xFont = (PDFfontobject)o;
            this.Resources.add("f" + xFont.getName() + " " + xFont.getRefID());
            this.Resources.add("p/Text");
        }
        if (o instanceof PDFimageobject) {
            PDFimageobject xImage = (PDFimageobject)o;
            this.Resources.add("x" + xImage.getName() + " " + xImage.getRefID());
            this.Resources.add("p/ImageB");
            this.Resources.add("p/ImageC");
        }
        if (o instanceof String) {
            this.Resources.add(o);
        }
    }

    public void AddFontResource(PDFfontobject inFont) {
        this.AddResource(inFont);
    }

    public void AddImageResource(PDFimageobject inObject) {
        this.AddResource(inObject);
    }
}

