/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.tools;

import com.pdftech.fot2pdf.tools.Status;

public class Encoding {
    private static String[] NameToMacRomanTable = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "", "AE", "Oslash", "multiply", "plusminus", "brokenbar", "minus", "yen", "mu", "onehalf", "onequarter", "onesuperior", "threequarters", "threesuperior", "ordfeminine", "ordmasculine", "twosuperior", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "", "florin", "", "", "guillemotleft", "guillemotright", "ellipsis", "space", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron"};
    private static int[] UpperMacRomanToUnicodeTable = new int[]{196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232, 234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252, 8224, 176, 162, 163, 167, 8226, 10081, 223, 174, 169, 8482, 180, 168, 0, 198, 216, 215, 177, 166, 8722, 165, 956, 189, 188, 185, 190, 179, 170, 186, 178, 230, 248, 191, 161, 172, 0, 402, 0, 0, 171, 187, 8230, 32, 192, 195, 213, 338, 339, 8211, 8212, 8220, 8221, 8216, 8217, 247, 0, 255, 376, 8260, 164, 8249, 8250, 64257, 64258, 8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212, 0, 210, 218, 219, 217, 305, 94, 126, 175, 728, 729, 730, 184, 733, 731, 711};

    public static int MapUnicodeToMacRoman(int i) {
        if (i <= 126) {
            return i;
        }
        int j = 0;
        while (j < UpperMacRomanToUnicodeTable.length) {
            if (UpperMacRomanToUnicodeTable[j] == i) {
                return 128 + j;
            }
            ++j;
        }
        if (i == 160) {
            return 32;
        }
        if (i < 65534) {
            Status.println("\rWARNING! Non-Printing character found (Unicode: " + i + ")!");
        }
        return 0;
    }

    public static String MapUnicodeToMacRoman(String line) {
        char[] newdata = new char[line.length()];
        int i = 0;
        while (i < line.length()) {
            newdata[i] = (char)Encoding.MapUnicodeToMacRoman(line.charAt(i));
            ++i;
        }
        return new String(newdata);
    }

    public static boolean IsMacRomanEncoding(String charname, int i) {
        if (i < 0 || i >= NameToMacRomanTable.length) {
            return false;
        }
        return NameToMacRomanTable[i].equals(charname);
    }

    public static int MapNameToMacRomanEncoding(String charname) {
        charname = charname.trim();
        int i = 0;
        while (i < NameToMacRomanTable.length) {
            if (charname.equals(NameToMacRomanTable[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getMacRomanDifferences() {
        String l = "[32";
        int i = 32;
        while (i <= 255) {
            l = NameToMacRomanTable[i].equals("") ? l + "/.notdef" : l + "/" + NameToMacRomanTable[i];
            ++i;
        }
        return l + "]";
    }
}

