/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.tools;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class LinkedList {
    private Link head = null;
    private Link tail = null;
    private Link pre = null;
    private int len = 0;

    public void reset() {
        this.pre = null;
    }

    public boolean hasMoreElements() {
        return this.cursor() != null;
    }

    public Object nextElement() {
        this.pre = this.pre == null ? this.head : this.pre.next;
        if (this.pre == null) {
            throw new NoSuchElementException();
        }
        return this.pre.data;
    }

    public Object currentElement() {
        Link cur = this.cursor();
        if (cur == null) {
            throw new NoSuchElementException();
        }
        return cur.data;
    }

    public void insert(Object o) {
        Link p = new Link(o, this.cursor());
        if (this.pre != null) {
            this.pre.next = p;
            if (this.pre == this.tail) {
                this.tail = p;
            }
        } else {
            if (this.head == null) {
                this.tail = p;
            }
            this.head = p;
        }
        this.pre = p;
        ++this.len;
    }

    public void appendcheck(Object o) {
        if (o != null) {
            this.append(o);
        }
    }

    public void append(Object o) {
        Link p = new Link(o, null);
        if (this.head == null) {
            this.head = this.tail = p;
        } else {
            this.tail.next = p;
            this.tail = p;
        }
        ++this.len;
    }

    public void append(LinkedList l) {
        Enumeration e = l.elements();
        while (e.hasMoreElements()) {
            this.append(e.nextElement());
        }
    }

    public Object remove() {
        Link cur = this.cursor();
        if (cur == null) {
            throw new NoSuchElementException();
        }
        if (this.tail == cur) {
            this.tail = this.pre;
        }
        if (this.pre != null) {
            this.pre.next = cur.next;
        } else {
            this.head = cur.next;
        }
        --this.len;
        return cur.data;
    }

    public void delete(Object o) {
        this.reset();
        while (this.hasMoreElements()) {
            if (this.currentElement() == o) {
                this.remove();
                break;
            }
            this.nextElement();
        }
    }

    public int size() {
        return this.len;
    }

    public Enumeration elements() {
        return new ListEnumeration(this.head);
    }

    private Link cursor() {
        if (this.pre == null) {
            return this.head;
        }
        return this.pre.next;
    }

    class Link {
        Object data;
        Link next;

        Link(Object o, Link n) {
            this.data = o;
            this.next = n;
        }
    }

    class ListEnumeration
    implements Enumeration {
        private Link cursor;

        public ListEnumeration(Link l) {
            this.cursor = l;
        }

        public boolean hasMoreElements() {
            return this.cursor != null;
        }

        public Object nextElement() {
            if (this.cursor == null) {
                throw new NoSuchElementException();
            }
            Object r = this.cursor.data;
            this.cursor = this.cursor.next;
            return r;
        }
    }
}

