/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.tools;

import com.pdftech.fot2pdf.parameters;
import com.pdftech.fot2pdf.tools.Debugfile;
import com.pdftech.fot2pdf.tools.Encoding;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.Status;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class LogicalFont {
    private static String MappingFilename = "fontmap.txt";
    private static boolean fontmaperrorwarned = false;
    private boolean correct;
    private String filename;
    private Hashtable kerntable;
    private String BaseName;
    private String PostscriptFontName;
    private boolean symbolfontflag;
    private String BBox;
    private int[] widths;
    private int CapHeight;
    private int Ascent;
    private int Descent;
    private int Flags;
    private int StemV;
    private int ItalicAngle;
    private int UnderlinePosition;
    private int UnderlineThickness;
    private int xheight;

    public LogicalFont(String inBaseName) {
        Debugfile.add("LogicalFont: Init starting..." + inBaseName);
        this.BaseName = inBaseName;
        this.widths = new int[256];
        this.kerntable = new Hashtable();
        this.correct = false;
        this.symbolfontflag = false;
        this.filename = this.MapBaseFontToFilename(this.BaseName);
        if (this.filename == null) {
            this.BaseName = "Courier";
            this.filename = this.MapBaseFontToFilename(this.BaseName);
            this.load();
        } else if (this.load()) {
            this.correct = true;
        } else {
            this.BaseName = "Courier";
            this.filename = this.MapBaseFontToFilename(this.BaseName);
            this.load();
        }
        Debugfile.add("LogicalFont: Init done, correct = " + this.correct);
    }

    public LogicalFont(String inFamilyName, String inWeight, String inPosture, String inStructure, String inPropWidth) {
        this(LogicalFont.getBaseName(inFamilyName, inWeight, inPosture, inStructure, inPropWidth));
    }

    public boolean isOK() {
        return this.correct;
    }

    public int kernvalue(char c1, char c2) {
        Integer x = (Integer)this.kerntable.get(new Integer(c1 * 256 + c2));
        if (x != null) {
            return x;
        }
        return 0;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isBase14() {
        if (this.BaseName.equalsIgnoreCase("Courier") || this.BaseName.equalsIgnoreCase("Courier-Bold") || this.BaseName.equalsIgnoreCase("Courier-Oblique") || this.BaseName.equalsIgnoreCase("Courier-BoldOblique")) {
            return true;
        }
        if (this.BaseName.equalsIgnoreCase("Helvetica") || this.BaseName.equalsIgnoreCase("Helvetica-Bold") || this.BaseName.equalsIgnoreCase("Helvetica-Oblique") || this.BaseName.equalsIgnoreCase("Helvetica-BoldOblique")) {
            return true;
        }
        if (this.BaseName.equalsIgnoreCase("Times-Roman") || this.BaseName.equalsIgnoreCase("Times-Bold") || this.BaseName.equalsIgnoreCase("Times-Italic") || this.BaseName.equalsIgnoreCase("Times-BoldItalic")) {
            return true;
        }
        return this.BaseName.equalsIgnoreCase("Symbol") || this.BaseName.equalsIgnoreCase("ZapfDingbats");
    }

    public boolean isSymbolfont() {
        return this.symbolfontflag;
    }

    public static String getBaseName(String inFamilyName, String inWeight, String inPosture, String inStructure, String inPropWidth) {
        Debugfile.add("LogicalFont: GetBaseName <" + inFamilyName + "/" + inWeight + "/" + inPosture + "/" + inStructure + "/" + inPropWidth + ">");
        if (inPosture.length() == 0 || inPosture.equalsIgnoreCase("normal")) {
            inPosture = "upright";
        }
        String name = inFamilyName.trim() + "-";
        name = name + inWeight.trim();
        if (!inPosture.equals("upright")) {
            name = name + inPosture;
        }
        Debugfile.add("LogicalFont: GetBaseName mapped to " + name);
        return name;
    }

    private String MapBaseFontToFilename(String lookBaseFontName) {
        Debugfile.add("LogicalFont: Mapping started, searching: " + lookBaseFontName);
        lookBaseFontName = lookBaseFontName.toLowerCase();
        this.filename = null;
        boolean correct = false;
        String usefilename = MappingFilename;
        if (!GenericTools.existsFile(usefilename)) {
            usefilename = parameters.getBaseDirectory() + MappingFilename;
        }
        if (!GenericTools.existsFile(usefilename)) {
            if (!fontmaperrorwarned) {
                Status.println("\rERROR!   No fontmapping possible! Fontmap.txt is missing or path (-D) not set?");
                Status.println("\r         Using Courier...");
                fontmaperrorwarned = true;
            }
            return null;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(usefilename));
            while (!correct) {
                String line = in.readLine();
                if (line == null) break;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == ';' || line.indexOf(32) == -1 && line.indexOf(61) == -1) continue;
                Debugfile.add("Checking line: <" + line + ">");
                String part1 = "";
                String part2 = "";
                boolean issubst = false;
                int removechars = line.indexOf(" ");
                if (line.indexOf("=") < removechars && line.indexOf("=") > -1 || removechars == -1) {
                    removechars = line.indexOf("=");
                }
                if (line.startsWith("\"")) {
                    part1 = line.substring(1, line.indexOf(34, 1));
                    removechars = part1.length() + 2;
                } else if (line.startsWith("'")) {
                    part1 = line.substring(1, line.indexOf(39, 1));
                    removechars = part1.length() + 2;
                } else {
                    part1 = line.substring(0, removechars);
                }
                line = line.substring(removechars).trim();
                boolean bl = issubst = line.charAt(0) == '=';
                if (issubst) {
                    line = line.substring(1).trim();
                }
                part2 = line.startsWith("\"") ? line.substring(1, line.indexOf(34, 1)) : (line.startsWith("'") ? line.substring(1, line.indexOf(39, 1)) : line);
                part1 = part1.toLowerCase();
                int startfilename = line.indexOf(" ");
                int posequals = line.indexOf(61);
                if (issubst) {
                    Debugfile.add("Substitution..." + line);
                    String stext = part1;
                    String rtext = part2.toLowerCase();
                    int p = lookBaseFontName.indexOf(stext);
                    if (p < 0) continue;
                    lookBaseFontName = lookBaseFontName.substring(0, p) + rtext + lookBaseFontName.substring(p + stext.length(), lookBaseFontName.length());
                    Debugfile.add("Yap, now: <" + lookBaseFontName + ">");
                    continue;
                }
                String nameline = part1;
                Debugfile.add("Nameline: <" + nameline + ">");
                if (nameline.compareTo(lookBaseFontName) == 0) {
                    Debugfile.add("Font-Loading: Found! Taking filename...");
                    this.filename = part2;
                    this.BaseName = nameline;
                    correct = true;
                    continue;
                }
                Debugfile.add("Font-Loading: not found, next please...");
            }
            in.close();
            Debugfile.add("Fontmap done, result: " + correct);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.filename == null) {
            if (this.isBase14()) {
                Status.println("\rWARNING! A base14 font (" + lookBaseFontName + ") could not be found!");
                Status.println("\r         Maybe wrong path/filename in fontmap.txt? Using Courier...");
            } else {
                Status.println("\rWARNING! No font mapping for '" + lookBaseFontName + "' found!");
                Status.println("\r         Please check fontmap.txt! Using Courier...");
            }
        } else {
            if (!GenericTools.existsFile(this.filename + ".afm")) {
                this.filename = parameters.getBaseDirectory() + this.filename;
            }
            if (!GenericTools.existsFile(this.filename + ".afm")) {
                Status.println("\rWARNING! Font-mapping for '" + lookBaseFontName + "' did not give correct filename!");
                Status.println("\r         Maybe wrong path/filename in fontmap.txt? Using Courier...");
                this.filename = null;
            }
        }
        return this.filename;
    }

    public boolean load() {
        Debugfile.add("LogicalFont: Loading started..." + this.BaseName);
        try {
            this.Flags = 32;
            Debugfile.add("Yep, Font available! Reading it...<" + this.filename + ">");
            BufferedReader afmfile = new BufferedReader(new FileReader(this.filename + ".afm"));
            boolean done = false;
            while (!done) {
                int p;
                String line = afmfile.readLine();
                if (line == null) break;
                if (line.startsWith("EncodingScheme") && !line.substring(15, line.length()).equals("AdobeStandardEncoding")) {
                    this.Flags = 4;
                    this.symbolfontflag = true;
                }
                if (line.startsWith("FontName")) {
                    this.PostscriptFontName = line.substring(9, line.length());
                }
                if (line.startsWith("FontBBox")) {
                    this.BBox = "[" + line.substring(9, line.length()).trim() + "]";
                }
                if (line.startsWith("Ascender")) {
                    try {
                        this.Ascent = Integer.parseInt(line.substring(9, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (line.startsWith("Descender")) {
                    try {
                        this.Descent = Integer.parseInt(line.substring(10, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (this.Descent > 0) {
                        this.Descent = -this.Descent;
                    }
                }
                if (line.startsWith("CapHeight")) {
                    try {
                        this.CapHeight = Integer.parseInt(line.substring(10, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (line.startsWith("XHeight")) {
                    try {
                        this.xheight = Integer.parseInt(line.substring(8, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (line.startsWith("UnderlinePosition")) {
                    try {
                        this.UnderlinePosition = Integer.parseInt(line.substring(18, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (line.startsWith("UnderlineThickness")) {
                    try {
                        this.UnderlineThickness = Integer.parseInt(line.substring(19, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (line.startsWith("ItalicAngle")) {
                    try {
                        this.ItalicAngle = (int)Double.parseDouble(line.substring(11, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (line.startsWith("StdVW")) {
                    try {
                        this.StemV = Integer.parseInt(line.substring(6, line.length()).trim());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (line.startsWith("C ") && (p = line.indexOf(";")) > 0) {
                    int charnum;
                    try {
                        charnum = Integer.parseInt(line.substring(2, p).trim());
                    }
                    catch (NumberFormatException e) {
                        charnum = 0;
                    }
                    p = line.indexOf("; N ");
                    if (p > 0) {
                        String charname = line.substring(p + 4, line.indexOf(" ", p + 4)).trim();
                        p = line.indexOf("; WX ");
                        if (p > 0) {
                            int width;
                            try {
                                width = Integer.parseInt(line.substring(p + 5, line.indexOf(" ", p + 5)).trim());
                            }
                            catch (NumberFormatException e) {
                                width = 1000;
                            }
                            if (this.symbolfontflag) {
                                Debugfile.add("symbol-map for " + charnum);
                                if (charnum > 0 && charnum < 256) {
                                    this.widths[charnum] = width;
                                }
                            } else if (Encoding.IsMacRomanEncoding(charname, charnum)) {
                                Debugfile.add("id-mapping for '" + charname + "' to " + Integer.toString(width));
                                this.widths[charnum] = width;
                            } else {
                                int c = Encoding.MapNameToMacRomanEncoding(charname);
                                if (c > 0) {
                                    this.widths[c] = width;
                                } else {
                                    Debugfile.add("Could not look up '" + charname + "'");
                                }
                            }
                        }
                    }
                }
                if (!line.startsWith("KPX ")) continue;
                p = 4;
                while (line.charAt(p) == ' ') {
                    ++p;
                }
                String char1 = line.substring(p, line.indexOf(" ", p));
                while (line.charAt(p) != ' ') {
                    ++p;
                }
                while (line.charAt(p) == ' ') {
                    ++p;
                }
                String char2 = line.substring(p, line.indexOf(" ", p));
                while (line.charAt(p) != ' ') {
                    ++p;
                }
                while (line.charAt(p) == ' ') {
                    ++p;
                }
                int kernval = 0;
                try {
                    kernval = -Integer.parseInt(line.substring(p, line.length()).trim());
                }
                catch (NumberFormatException e) {
                    kernval = 0;
                }
                if (kernval == 0) continue;
                Debugfile.add("- Adding to Kerntable: -" + char1 + "- / -" + char2 + "- value: " + kernval);
                int c1 = Encoding.MapNameToMacRomanEncoding(char1);
                int c2 = Encoding.MapNameToMacRomanEncoding(char2);
                if (c1 <= 0 || c2 <= 0) continue;
                this.kerntable.put(new Integer(c1 * 256 + c2), new Integer(kernval));
            }
            afmfile.close();
        }
        catch (IOException e) {
            if (!fontmaperrorwarned) {
                Status.println("\rERROR!   Parsing AFM-file for '" + this.BaseName + "' failed! Using Courier...");
            }
            return false;
        }
        return true;
    }

    public int GetFirstChar() {
        int i = 0;
        while (this.widths[i] == 0 && i < 255) {
            ++i;
        }
        return i;
    }

    public int GetLastChar() {
        int i = 255;
        while (this.widths[i] == 0 && i > 0) {
            --i;
        }
        return i;
    }

    public String GetWidthsArray() {
        String line = "";
        int c = 0;
        int i = this.GetFirstChar();
        while (i < this.GetLastChar()) {
            line = line + Integer.toString(this.widths[i]) + " ";
            if (++c % 16 == 0) {
                line = line + "\r\n";
            }
            ++i;
        }
        return new String("[\r\n" + line + Integer.toString(this.widths[this.GetLastChar()]) + "\r\n]");
    }

    public String GetPostscriptFontName() {
        if (this.correct && this.PostscriptFontName != null) {
            return this.PostscriptFontName;
        }
        return "Courier";
    }

    public int GetAscent() {
        if (this.correct) {
            return this.Ascent;
        }
        return 629;
    }

    public int GetDescent() {
        if (this.correct) {
            return this.Descent;
        }
        return -157;
    }

    public int GetCapHeight() {
        if (this.correct) {
            return this.CapHeight;
        }
        return 562;
    }

    public int GetStemV() {
        if (this.correct) {
            return this.StemV;
        }
        return 100;
    }

    public int GetItalicAngle() {
        if (this.correct) {
            return this.ItalicAngle;
        }
        return 0;
    }

    public int GetFlags() {
        if (this.correct) {
            return this.Flags;
        }
        return 64;
    }

    public int GetUnderlinePosition() {
        if (this.correct) {
            return this.UnderlinePosition;
        }
        return -100;
    }

    public int GetUnderlineThickness() {
        if (this.correct) {
            return this.UnderlineThickness;
        }
        return 50;
    }

    public int GetXHeight() {
        if (this.correct) {
            return this.xheight;
        }
        return 425;
    }

    public String GetBBox() {
        if (this.correct && this.BBox != null) {
            return this.BBox;
        }
        return "[-28 -250 628 805]";
    }

    public int getCharWidth(char c) {
        if (this.correct) {
            return this.widths[c];
        }
        return 600;
    }
}

