/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.tools;

import java.util.Hashtable;

public class PublicID {
    private boolean correct = false;
    private boolean empty = false;
    private String id_header;
    private String id_type;
    private String id_value;
    private Hashtable id_attributes;

    public PublicID(String inData) {
        this.correct = this.parse(inData);
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String getHeader() {
        return this.id_header;
    }

    public String getType() {
        return this.id_type;
    }

    public String getValue() {
        return this.id_value;
    }

    public boolean hasAttribute(String inAttributeName) {
        return this.id_attributes.get(inAttributeName) != null;
    }

    public double getAttributeValue(String inAttributeName) {
        if (this.hasAttribute(inAttributeName)) {
            return (Double)this.id_attributes.get(inAttributeName);
        }
        return 0.0;
    }

    private boolean parse(String inData) {
        this.id_value = "";
        this.id_type = "";
        this.id_header = "";
        this.id_attributes = new Hashtable();
        if (inData.length() == 0) {
            this.empty = true;
            return true;
        }
        int pos = inData.lastIndexOf("//");
        if (pos == -1) {
            return false;
        }
        this.id_header = inData.substring(0, pos);
        int pos2 = inData.indexOf("::", pos + 2);
        if (pos2 == -1) {
            return false;
        }
        this.id_type = inData.substring(pos + 2, pos2);
        pos = pos2;
        if ((pos2 = inData.indexOf("::", pos + 2)) == -1) {
            pos2 = inData.length();
        }
        this.id_value = inData.substring(pos + 2, pos2);
        if (pos2 == inData.length()) {
            return true;
        }
        do {
            if ((pos2 = inData.indexOf("::", pos = pos2 + 2)) == -1) {
                pos2 = inData.length();
            }
            String this_attribute = inData.substring(pos, pos2);
            int pos3 = this_attribute.lastIndexOf("=");
            Double thisvalue = new Double(0.0);
            try {
                thisvalue = new Double(Double.parseDouble(this_attribute.substring(pos3 + 1, this_attribute.length())));
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.id_attributes.put(this_attribute.substring(0, pos3), thisvalue);
        } while (pos2 < inData.length());
        return true;
    }
}

