/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.tools;

import com.pdftech.fot2pdf.parameters;
import com.pdftech.fot2pdf.tools.GenericTools;
import com.pdftech.fot2pdf.tools.LinkedList;
import com.pdftech.fot2pdf.tools.MappingEntry;
import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.tools.StringTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReplacementTable {
    private static String DictionaryFilename = "hyphen.txt";
    private static Hashtable wordtable = new Hashtable();
    private static LinkedList phrasetable = new LinkedList();
    private static LinkedList anytable = new LinkedList();
    private static String delimtable = " !\"/()\\.:,;+-\u00a0";

    public static void load() {
        Status.print("\rLoading Dictionary...");
        String usefilename = DictionaryFilename;
        if (!GenericTools.existsFile(usefilename)) {
            usefilename = parameters.getBaseDirectory() + DictionaryFilename;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(usefilename));
            block8: while ((line = in.readLine()) != null) {
                if (line.length() == 0) {
                    line = ";";
                }
                switch (line.charAt(0)) {
                    case ';': {
                        break;
                    }
                    case 'W': 
                    case 'w': {
                        String[] s = StringTools.SplitSpacedLine(line);
                        if (s.length != 3) continue block8;
                        boolean ok = true;
                        s[1] = StringTools.ReplaceEscapedUnicodeString(s[1]);
                        int i = 0;
                        while (i < s[1].length()) {
                            ok &= !ReplacementTable.isdelim(s[1].charAt(i));
                            ++i;
                        }
                        if (ok) {
                            wordtable.put(s[1], ReplacementTable.ReplaceHyphenAndUnicode(s[2]));
                            break;
                        }
                        phrasetable.append(new MappingEntry(s[1], ReplacementTable.ReplaceHyphenAndUnicode(s[2])));
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        String[] s = StringTools.SplitSpacedLine(line);
                        if (s.length != 3) continue block8;
                        s[1] = StringTools.ReplaceEscapedUnicodeString(s[1]);
                        phrasetable.append(new MappingEntry(s[1], ReplacementTable.ReplaceHyphenAndUnicode(s[2])));
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        String[] s = StringTools.SplitSpacedLine(line);
                        if (s.length != 3) break;
                        s[1] = StringTools.ReplaceEscapedUnicodeString(s[1]);
                        anytable.append(new MappingEntry(s[1], ReplacementTable.ReplaceHyphenAndUnicode(s[2])));
                    }
                }
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Status.println("Done.");
    }

    public static String exchange(String line) {
        int l;
        String test;
        int i;
        Enumeration entrylist = anytable.elements();
        block0: while (entrylist.hasMoreElements()) {
            i = 0;
            MappingEntry testelement = (MappingEntry)entrylist.nextElement();
            test = testelement.from;
            while (true) {
                i = line.indexOf(test, i);
                l = test.length();
                if (i == -1) continue block0;
                line = line.substring(0, i) + testelement.to + line.substring(i + l);
                i += testelement.to.length();
            }
        }
        entrylist = phrasetable.elements();
        block2: while (entrylist.hasMoreElements()) {
            i = 0;
            MappingEntry testelement = (MappingEntry)entrylist.nextElement();
            test = testelement.from;
            while (true) {
                i = line.indexOf(test, i);
                l = test.length();
                if (i == -1) continue block2;
                boolean doit = false;
                if (i == 0) {
                    if (line.length() == l) {
                        doit = true;
                    } else if (ReplacementTable.isdelim(line.charAt(l))) {
                        doit = true;
                    }
                } else if (i + l >= line.length()) {
                    doit = true;
                } else {
                    boolean bl = doit = ReplacementTable.isdelim(line.charAt(i - 1)) && ReplacementTable.isdelim(line.charAt(i + l));
                }
                if (doit) {
                    line = line.substring(0, i) + testelement.to + line.substring(i + l);
                    i += testelement.to.length();
                    continue;
                }
                i += l;
            }
        }
        StringBuffer newline = new StringBuffer();
        i = 0;
        while (i < line.length()) {
            if (ReplacementTable.isdelim(line.charAt(i))) {
                newline.append(line.charAt(i++));
                continue;
            }
            test = "";
            while (i < line.length() && !ReplacementTable.isdelim(line.charAt(i))) {
                test = test + line.charAt(i++);
            }
            if (wordtable.containsKey(test)) {
                newline.append((String)wordtable.get(test));
                continue;
            }
            newline.append(test);
        }
        return newline.toString();
    }

    private static boolean isdelim(char what) {
        return delimtable.indexOf(what) != -1;
    }

    private static String ReplaceHyphenAndUnicode(String line) {
        StringBuffer word = new StringBuffer();
        int i = 0;
        while (i < line.length()) {
            switch (line.charAt(i)) {
                case '-': {
                    word.append('\uffff');
                    break;
                }
                case '\\': {
                    if (i + 1 >= line.length()) break;
                    word.append(line.charAt(++i));
                    break;
                }
                default: {
                    word.append(line.charAt(i));
                }
            }
            ++i;
        }
        return StringTools.ReplaceEscapedUnicodeString(word.toString());
    }
}

