/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.xml;

import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.xml.FlowObjectTree;
import com.pdftech.fot2pdf.xml.MarkupFileReader;
import com.pdftech.fot2pdf.xml.xmlnode;
import java.io.IOException;

public class FOTfilereader
extends Thread
implements FlowObjectTree {
    private xmlnode root = null;
    private String filename;
    private String saxdriver = null;
    private int nodesumcount;

    public FOTfilereader(String inFilename) {
        this.filename = inFilename;
    }

    public FOTfilereader(ThreadGroup g, String inFilename) {
        super(g, "Loading FOT");
        this.filename = inFilename;
    }

    public xmlnode getRootNode() {
        return this.root;
    }

    public int getSumCount() {
        return this.nodesumcount;
    }

    public void run() {
        String s;
        MarkupFileReader fotfile;
        long starttime = System.currentTimeMillis();
        int outputcount = 0;
        Status.print("\rReading FlowObjectTree by direct file access...");
        try {
            fotfile = new MarkupFileReader(this.filename);
        }
        catch (IOException e) {
            Status.println("\rERROR! Could not read " + this.filename + "!");
            return;
        }
        xmlnode aktnode = null;
        while ((s = fotfile.nextString()).length() != 0) {
            if (aktnode == null) {
                if (e.length() >= 5 && e.substring(0, 4).equals("<fot")) {
                    aktnode = this.root = new xmlnode((String)e, null);
                }
                if (e.length() < 9 || !e.substring(0, 8).equals("<fo:root")) continue;
                aktnode = this.root = new xmlnode((String)e, null);
                continue;
            }
            if (e.charAt(0) == '<') {
                if (fotfile.count() - outputcount > 102400) {
                    Status.print("\rReading FlowObjectTree..." + fotfile.count() / 1024 + " KB");
                    outputcount += 102400;
                }
                if (e.charAt(1) == '/') {
                    aktnode.finish();
                    if (aktnode == this.root) continue;
                    aktnode = aktnode.getFather();
                    continue;
                }
                xmlnode newnode = new xmlnode((String)e, aktnode);
                newnode.setNodeCount(fotfile.count());
                aktnode.addContent(newnode);
                aktnode = newnode;
                if (e.charAt(e.length() - 2) != '/') continue;
                aktnode.finish();
                aktnode = aktnode.getFather();
                continue;
            }
            aktnode.addContent(e);
        }
        if (aktnode != null) {
            this.root.finish();
        } else {
            Status.println("\rERROR! File did not contain DSSSL/XSL flow object tree!");
        }
        this.nodesumcount = fotfile.count();
        fotfile.close();
    }
}

