/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.xml;

import com.pdftech.fot2pdf.tools.Status;
import com.pdftech.fot2pdf.xml.FlowObjectTree;
import com.pdftech.fot2pdf.xml.saxhandler;
import com.pdftech.fot2pdf.xml.xmlnode;
import java.io.FileReader;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public class FOTsaxreader
extends Thread
implements FlowObjectTree {
    private String filename;
    private String saxdriver;
    private saxhandler handler;

    public FOTsaxreader(String inFilename, String inSaxname) {
        this.filename = inFilename;
        this.saxdriver = inSaxname;
    }

    public FOTsaxreader(ThreadGroup g, String inFilename, String inSaxname) {
        super(g, "Loading FOT");
        this.saxdriver = inSaxname;
        this.filename = inFilename;
    }

    public void run() {
        long starttime = System.currentTimeMillis();
        boolean outputcount = false;
        Status.print("\rReading FlowObjectTree using SAX...");
        XMLReader xr = FOTsaxreader.getSAXdriver(this.saxdriver);
        if (xr != null) {
            this.handler = new saxhandler();
            xr.setContentHandler(this.handler);
            xr.setErrorHandler(this.handler);
            try {
                FileReader r = new FileReader(this.filename);
                xr.parse(new InputSource(r));
            }
            catch (IOException e) {
                Status.println("\rERROR! Could not read " + this.filename + " (i/o error)!");
                return;
            }
            catch (SAXException e) {
                Status.println("\rERROR! XML parsing failed! SAX: " + e + "!");
                return;
            }
        }
        starttime = System.currentTimeMillis() - starttime;
    }

    public xmlnode getRootNode() {
        if (this.handler != null) {
            return this.handler.getRootNode();
        }
        return null;
    }

    public int getSumCount() {
        if (this.handler != null) {
            return this.handler.getSumCount();
        }
        return 0;
    }

    static XMLReader getSAXdriver(String className) {
        try {
            Object obj = Class.forName(className).newInstance();
            if (obj instanceof XMLReader) {
                return (XMLReader)obj;
            }
            if (obj instanceof Parser) {
                return new ParserAdapter((Parser)obj);
            }
            Status.println("\rERROR! Class " + className + " is neither a SAX1 Parser nor a SAX2 XMLReader");
        }
        catch (ClassNotFoundException e) {
            Status.println("\rERROR! SAX parser class '" + className + "' not found!");
        }
        catch (IllegalAccessException e) {
            Status.println("\rERROR! SAX parser " + className + ": no permission to use!");
        }
        catch (InstantiationException e) {
            Status.println("\rERROR! SAX parser " + className + ": InstantiationException!");
        }
        catch (ClassCastException e) {
            Status.println("\rERROR! SAX parser " + className + ": no SAX interface!");
        }
        return null;
    }
}

