/*
 * Decompiled with CFR 0.152.
 */
package com.pdftech.fot2pdf.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

class MarkupFileReader {
    private BufferedInputStream basefile;
    private int countread;
    char[] sbuff2;
    int sbuff2cnt;
    private boolean nextismarkupflag = false;

    public MarkupFileReader(String inFName) throws IOException {
        this.basefile = new BufferedInputStream(new FileInputStream(inFName));
        this.sbuff2 = new char[1000];
        this.countread = 0;
    }

    public int count() {
        return this.countread;
    }

    public void close() {
        try {
            this.basefile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int read() {
        int ch = -1;
        try {
            ++this.countread;
            ch = this.basefile.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ch;
    }

    private void addCharToBuff(char x) {
        this.sbuff2[this.sbuff2cnt++] = x;
        if (this.sbuff2cnt == this.sbuff2.length) {
            char[] sbuffnew = new char[this.sbuff2.length + 100];
            int i = 0;
            while (i < this.sbuff2cnt) {
                sbuffnew[i] = this.sbuff2[i];
                ++i;
            }
            this.sbuff2 = sbuffnew;
        }
    }

    private void resetBuff() {
        this.sbuff2cnt = 0;
    }

    private String getBuffString() {
        return new String(this.sbuff2, 0, this.sbuff2cnt);
    }

    public String nextString() {
        int ch;
        this.resetBuff();
        if (this.nextismarkupflag) {
            ch = 60;
            this.nextismarkupflag = false;
        } else {
            while ((ch = this.read()) == 13 || ch == 10) {
            }
        }
        if (ch == -1) {
            this.close();
        } else {
            char c = (char)ch;
            this.addCharToBuff(c);
            if (c == '<') {
                while ((ch = this.read()) != -1) {
                    c = (char)ch;
                    if (c == '\r' || c == '\n') {
                        c = ' ';
                    }
                    this.addCharToBuff(c);
                    if (c != 62) continue;
                    break;
                }
            } else {
                boolean justkilledspace = false;
                while ((char)(ch = this.read()) != '<' && ch != -1) {
                    c = (char)ch;
                    switch (c) {
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            c = !justkilledspace ? (char)' ' : '\uffff';
                            justkilledspace = true;
                            break;
                        }
                        default: {
                            justkilledspace = false;
                        }
                    }
                    if (c == 65535) continue;
                    this.addCharToBuff(c);
                }
                if (ch != -1) {
                    this.nextismarkupflag = true;
                }
            }
        }
        return this.getBuffString();
    }
}

