package com.pdftech.fot2pdf;

import com.pdftech.fot2pdf.parameters;
import com.pdftech.fot2pdf.pdf.PDFparameters;
import com.pdftech.fot2pdf.formatter.FormatterParameters;

import com.pdftech.fot2pdf.xml.saxhandler;
import com.pdftech.fot2pdf.formatter.Formatter;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;


public class sampleproducer
{
	public static void main(String[] args)
	{
		saxhandler fotreader = new saxhandler();

		EventProducer p = new EventProducer(fotreader);
		p.run();

		Formatter pdfmaker = new Formatter(fotreader,"sampleproducer-output.pdf");
		pdfmaker.run();
	}
}


class EventProducer
{
	ContentHandler fotreceiver;

	public EventProducer(ContentHandler dest)
	{
		fotreceiver=dest;
	}

	public void run()
	{
		try {
			AttributesImpl emptyatts = new AttributesImpl();

			fotreceiver.startDocument();

			fotreceiver.startElement("","","fot",emptyatts);

				AttributesImpl spsatts = new AttributesImpl();
				spsatts.addAttribute("","","left-margin","CDATA","50pt");
				spsatts.addAttribute("","","top-margin","CDATA","100pt");
				fotreceiver.startElement("","","simple-page-sequence",spsatts);

					fotreceiver.startElement("","","paragraph",emptyatts);

						fotreceiver.startElement("","","text",emptyatts);

						String text = "Simplest flow object tree possible.";
						fotreceiver.characters(text.toCharArray(),0,text.length());

						fotreceiver.endElement("","","text");

					fotreceiver.endElement("","","paragraph");

				fotreceiver.endElement("","","simple-page-sequence");

			fotreceiver.endElement("","","fot");

			fotreceiver.endDocument();
		} catch (SAXException e) {};
	}


}
