<!doctype style-sheet system "style-sheet.dtd" >
<!-- doctype was PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN"> -->

;; some Jade-Extensions we need:

(define if-first-page (external-procedure "UNREGISTERED::James Clark//Procedure::if-first-page"))
(define if-front-page (external-procedure "UNREGISTERED::James Clark//Procedure::if-front-page"))

(define *unpublishedflag* "unpublished")

;; now some defaults

(define *mono-font* "Courier")
(define *basefont* "Times")

(define *standard-para-space* (display-space 3mm min: 2mm max: 10mm conditional?: #t priority: 0))
(define *standard-para-size* 12pt)
(define *standard-para-linespace* 15pt)

(define rgb (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB"))

(declare-initial-value font-family-name *basefont*)
(declare-initial-value font-weight 'normal)
(declare-initial-value last-line-justify-limit 10mm)

(declare-initial-value hyphenation-ladder-count 3)
(declare-initial-value hyphenation-remain-char-count 5)
(declare-initial-value hyphenation-push-char-count 5)
(declare-initial-value hyphenation-keep 'page)

(declare-initial-value page-width 210mm)
(declare-initial-value page-height 297mm)
(declare-initial-value left-margin 20mm)
(declare-initial-value right-margin 20mm)
(declare-initial-value top-margin 30mm)
(declare-initial-value bottom-margin 30mm)
(declare-initial-value header-margin 15mm)
(declare-initial-value footer-margin 15mm)


;; --------------------------------------------------------------------------------------
;;
;;  Root-Element: Diplomathesis
;;
;; --------------------------------------------------------------------------------------


(element usage
	(make sequence
		(process-matching-children "colophon")

		(make simple-page-sequence
			(make paragraph
				break-before: 'page
				break-after: 'page
				font-size: 18pt
				font-weight: 'bold
				space-after: (display-space 4mm min: 4mm max: 6mm conditional?: #f priority: 0)
				;;space-after: 4mm
				(literal "Table of Contents:")
				(with-mode toc (process-matching-children 'section))
				(with-mode toc (process-matching-children 'appendix))
			)

		)

		(process-matching-children "section")
		(process-matching-children "appendix")
	)
)

(mode toc
	(element section
		(if (equal? (attribute-string "status") *unpublishedflag*)
			(empty-sosofo)
			(make sequence
				(make link
					destination: (node-list-address (current-node))
					(make paragraph
						font-size: 14pt
						line-spacing: (* 1.2 14pt)
						font-weight: 'bold
						space-before: 3mm
						space-after: 1mm
						keep-with-next?: #t
						(make line-field
							field-width: 10mm
							(literal (format-number (child-number) "1"))
						)
						(process-first-descendant 'title)
						(make leader
							align-leader?: #t
							(literal ".")
						)
						(current-node-page-number-sosofo)
					)
				)
				(with-mode toc (process-matching-children 'section 'subsection))
			)		
		)
	)
	(element subsection
		(make paragraph
			font-size: 12pt
			line-spacing: (* 1.2 12pt)
			font-weight: 'normal
			(make line-field field-width: 10mm (literal " "))
			(make link
				destination: (node-list-address (current-node))
				(make line-field
					field-width: 10mm
					(literal (format-number (child-number (parent)) "1"))
					(literal ".")
					(literal (format-number (child-number) "1"))
				)
				(process-first-descendant 'title)
				(literal " ... ")
				(current-node-page-number-sosofo)
			)
			(with-mode toc (process-matching-children 'section 'subsection))
		)
	)
	(element (subsection subsection)
		(make paragraph
			font-size: 10pt
			line-spacing: (* 1.2 10pt)
			font-weight: 'normal
			(make line-field field-width: 20mm (literal " "))
			(make link
				destination: (node-list-address (current-node))
				(make line-field
					field-width: 10mm
					(literal (format-number (child-number (parent (parent))) "1"))
					(literal ".")
					(literal (format-number (child-number (parent)) "1"))
					(literal ".")
					(literal (format-number (child-number) "1"))
				)
				(process-first-descendant 'title)
				(literal " ... ")
				(current-node-page-number-sosofo)
			)
		)
	)
	(element appendix
		(make link
			destination: (node-list-address (current-node))
			(make paragraph
				font-size: 12pt
				line-spacing: (* 1.2 12pt)
				font-weight: 'bold
				space-before: 4mm
				space-after: 1mm
				(literal "Appendix ")
				(literal (format-number (child-number) "A"))
				(literal ": ")
				(process-first-descendant 'title)
				(make leader
					align-leader?: #t
					(literal ".")
				)
				(current-node-page-number-sosofo)
			)
		)
	)
	(element title
		(process-children)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Front-page: The colophon
;;
;; --------------------------------------------------------------------------------------


(element colophon
	(make sequence
		(make simple-page-sequence
			(make paragraph
				font-weight: 'extra-bold
				line-spacing: 48pt
				quadding: 'center
				font-size: 24pt
				space-before: (display-space 25mm min: 25mm max: 25mm conditional?: #f priority: 0)
				(process-matching-children 'worktitle)
				(make paragraph-break)
				(make sequence
					font-size: 18pt
					font-weight: 'bold
					line-spacing: 24pt

					(make paragraph space-before: 5mm
						(process-matching-children 'subtitle)
					)
					(make paragraph space-before: 30mm
						(process-matching-children 'author)
					)
					(make paragraph
						space-before: 2mm
						font-size: 12pt
						font-weight: 'normal
						(process-matching-children 'company)
					)
					(make paragraph
						space-before: 10mm
						font-size: 12pt
						(process-matching-children 'date)
					)
				)
			)
		)
		
	)
)

(element author
	(make link
		destination: (idref-address (attribute-string "email"))
		(process-children)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Section
;;
;; --------------------------------------------------------------------------------------

(element section

	;; sections are the main divisions; we put the title in the center-header!
	(if (equal? (attribute-string "status") *unpublishedflag*)
		(empty-sosofo)

		(make simple-page-sequence

			center-header:
				(if-first-page
					(empty-sosofo)
					(with-mode headersandfooters
						(make sequence
							font-size: 8pt
							(process-first-descendant 'title)
						)
					)
			)
			left-footer:
				(make sequence font-size: 8pt (literal "fot2pdf by C. Drescher"))
			right-footer:
					(make sequence font-size: 8pt (page-number-sosofo))

		)
	)
)

(element appendix
	;; sections are the main divisions; we put the title in the center-header!
	(if (equal? (attribute-string "status") *unpublishedflag*)
		(empty-sosofo)

		(make simple-page-sequence

			center-header:
				(if-first-page
					(empty-sosofo)
					(with-mode headersandfooters
						(make sequence
							font-size: 8pt
							(process-first-descendant 'title)
						)
					)
			)
			left-footer:
				(make sequence font-size: 8pt (literal "fot2pdf by C. Drescher"))
			right-footer:
				(make sequence font-size: 8pt (page-number-sosofo))
		)
	)
)

(mode headersandfooters
	(element title
		(process-children)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  A simple paragraph
;;
;; --------------------------------------------------------------------------------------


(element p
	(if (equal? (attribute-string "marked") "side")
		;; if sidelined... sideline
		(make sideline
			sideline-sep: 5mm
			sideline-side: 'both
			line-thickness: 3pt
			(make paragraph
				font-weight: 'normal
				font-size: *standard-para-size*
				line-spacing: *standard-para-linespace*
				quadding: 'justify
				space-before: *standard-para-space*
				space-after: *standard-para-space*
			)
		)
		;; without sideline
		(make paragraph
			font-weight: 'normal
			font-size: *standard-para-size*
			line-spacing: *standard-para-linespace*
			quadding: 'justify
			space-before: *standard-para-space*
			space-after: *standard-para-space*
		)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Figures and Graphics
;;
;; --------------------------------------------------------------------------------------


(element figure
	(make display-group
		space-before: (display-space 5mm min: 5mm max: 20mm conditional?: #t priority: 0)
		space-after: (display-space 5mm min: 5mm max: 20mm conditional?: #t priority: 0)
		keep: 'page
		(make external-graphic
			scale: 'max-uniform
			max-height: 10cm
			display-alignment: 'center
			start-indent: 10mm
			end-indent: 10mm
			entity-system-id: (attribute-string "filename")
			notation-system-id: (attribute-string "format")
		)
		(make paragraph
			space-before: 2mm
			font-size: 9pt
			quadding: 'center
			start-indent: 20mm
			end-indent: 20mm
			(literal "Fig.&#160;")
			(literal (format-number (figure-number) "1"))
			(literal ": ")
			(process-children)
		)
	)
)

(define (figure-number)
	(element-number (current-node))
)


(element texlogo
	(make external-graphic
		entity-system-id: "Figure - Logo TEX.pdf"
		notation-system-id: "pdf"
		max-width: 50pt
		max-height: 16pt
	)
)


(element (section title)

	(make paragraph
		font-weight: 'bold
		font-size: 24pt
		line-spacing: (* 1.2 24pt)
		quadding: 'center
		space-after: 20mm
		break-before: 'page
		keep-with-next?: #t

		(make line-field
			field-width: 15mm
			field-align: 'start
			(literal (format-number (child-number(parent)) "1"))
		)
		(process-children)
	)
)

(element (subsection title)
	(make paragraph
		font-weight: 'bold
		font-size: 14pt
		line-spacing: (* 1.2 14pt)
		quadding: 'start
		space-before: (display-space 5mm min: 5mm max: 15mm conditional?: #t priority: 0)
		space-after: 5mm
		keep-with-next?: #t
		(make line-field
			field-width: 15mm
			field-align: 'start
			(literal (format-number (child-number(parent (parent))) "1"))
			(literal ".")
			(literal
				(format-number
					(child-number (parent)) "1"
				)
			)
		)
		(process-children)
	)
)

(element (subsection subsection title)
	(make paragraph
		font-weight: 'bold
		font-size: 12pt
		line-spacing: (* 1.2 12pt)
		quadding: 'start
		space-before: (display-space 5mm min: 5mm max: 15mm conditional?: #t priority: 0)
		space-after: 2mm
		keep-with-next?: #t
		(make line-field
			field-width: 15mm
			field-align: 'start
			(literal (format-number (child-number(parent (parent (parent)))) "1"))
			(literal ".")
			(literal (format-number (child-number(parent (parent))) "1"))
			(literal ".")
			(literal (format-number (child-number (parent)) "1"))
		)
		(process-children)
	)
)

(element (appendix title)

	(make paragraph
		font-weight: 'bold
		font-size: 18pt
		line-spacing: (* 1.2 18pt)
		quadding: 'start
		break-before: 'page
		space-after: 10mm
		keep-with-next?: #t

		(literal "Appendix ")
		(literal (format-number (child-number(parent)) "A"))
		(literal ": ")
		(process-children)
	)
)

(element em
	(make sequence
		font-weight: 'bold
	)
)

(element italic
	(make sequence
		font-weight: 'italic
	)
)

(element internetaddress
	(make sequence
		font-weight: 'bold
		(make link
			destination: (idref-address (attribute-string "target"))
			(literal (attribute-string "target"))
		)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Book
;;
;; --------------------------------------------------------------------------------------

(element book
	(make sequence
		(make paragraph
			font-weight: 'normal
			font-size: 12pt
			space-before: 5mm
			start-indent: 20mm
			first-line-start-indent: -20mm

			(make line-field
				field-width: 20mm
				(literal "[")
				(literal (attribute-string "refname" ))
				(literal "]")
			)
			(process-matching-children 'author)
			(literal ": ")
			(make sequence
				font-posture: 'italic
				(process-matching-children 'title)
			)
		)
		(make paragraph
			font-weight: 'normal
			font-size: 10pt
			start-indent: 20mm
			space-after: 1mm
			first-line-start-indent: 0mm
			(process-matching-children 'published)
			(process-matching-children 'isbn)
		)
		(make paragraph
			font-weight: 'normal
			font-size: 10pt
			start-indent: 20mm
			;space-after: 5mm
			first-line-start-indent: 0mm
			(process-matching-children 'info)
			(process-matching-children 'online)
			(if (equal? (attribute-string "included") "true")
				(make sequence
					font-posture: 'italic
					(make paragraph-break)
					(literal "Included on cd-rom")
				)
				(empty-sosofo)
			)
		)
	)
)

(element (book published)
	(make sequence
		(process-children-trim)
		(literal ". ")
	)
)

(element (book isbn)
	(make sequence
		(literal "ISBN: ")
		(process-children-trim)
	)
)

(element (book online)
	(make sequence
		(make paragraph-break)
		(literal "Available online: ")
		(make sequence
			font-weight: 'bold
			(make link
				destination: (idref-address (attribute-string "target"))
				(literal (attribute-string "target"))
			)
		)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  References in general
;;
;; --------------------------------------------------------------------------------------

(element sectionref (with-mode xref (process-node-list (element-with-id (attribute-string "target")))))
(element shortsectionref (with-mode shortref (process-node-list (element-with-id (attribute-string "target")))))
(element bookref (with-mode xref (process-node-list (element-with-id (attribute-string "target")))))

;; References to pages are made easy...

(element pageref
	(with-mode pageref
		(process-node-list
			(element-with-id
				(attribute-string "target")
			)
		)
	)
)

(mode pageref
	(default
		(make link
			destination: (node-list-address (current-node))
			(current-node-page-number-sosofo)
		)
	)
)

;; --------------------------------------------------------------------------------------
;;
;;  an xref is a long refererence
;;
;; --------------------------------------------------------------------------------------


(element xref
	(with-mode xref
		(process-node-list
			(element-with-id
				(attribute-string "target")
			)
		)
	)
)

(mode xref
	(element book
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "[")
				(literal (attribute-string "refname" ))
				(literal "]")
			)
		)
	)
	(element figure
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "Figure&#160;"
						(format-number (figure-number) "1")
				)
			)
		)
	)
	(element section
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "Chapter&#160;"
						(format-number (child-number) "1")
						", "
				)
				(make sequence
					font-posture: 'italic
					(process-first-descendant 'title)
				)
				(literal ", page&#160;")
				(current-node-page-number-sosofo)
			)
		)
	)
	(element subsection
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "Chapter&#160;"
						(format-number (child-number (parent)) "1")
						"."
						(format-number (child-number) "1")
						", "
				)

				(make sequence
					font-posture: 'italic
					(process-first-descendant 'title)
				)
				(literal ", page&#160;")
				(current-node-page-number-sosofo)
			)
		)
	)
	(element annotation
		(make link
			destination: (node-list-address (current-node))
			($ss-seq$ + (literal (attribute-string "number")))
		)
	)
	(element appendix
		(make link
			destination: (node-list-address (current-node))
			(literal "Appendix&#160;")
			(literal (format-number (child-number) "A"))
		)
	)
	(element title
		(process-children)
	)
)

;; --------------------------------------------------------------------------------------
;;
;;  shortref is a shorter version of xref
;;
;; --------------------------------------------------------------------------------------

(element shortref
	(with-mode shortref
		(process-node-list
			(element-with-id
				(attribute-string "target")
			)
		)
	)
)

(mode shortref
	(element book
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "[")
				(literal (attribute-string "refname" ))
				(literal "]")
			)
		)
	)
	(element figure
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "Figure&#160;"
						(format-number (figure-number) "1")
				)
			)
		)
	)
	(element section
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "Chapter&#160;"
						(format-number (child-number) "1")
				)
			)
		)
	)
	(element subsection
		(make sequence
			(make link
				destination: (node-list-address (current-node))
				(literal "Chapter&#160;"
						(format-number (child-number (parent)) "1")
						"."
						(format-number (child-number) "1")
				)
			)
		)
	)
	(element annotation
		(make link
			destination: (node-list-address (current-node))
			($ss-seq$ + (literal (attribute-string "number")))
		)
	)
	(element appendix
		(make link
			destination: (node-list-address (current-node))
			(literal "Appendix&#160;")
			(literal (format-number (child-number) "A"))
		)
	)
	(element title
		(process-children)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Enumerations
;;
;; --------------------------------------------------------------------------------------


(define *enum-numindent* 3mm)

(element enum
	(make sequence
		first-line-start-indent: (- 0mm *enum-numindent*)
    		start-indent: 	(+ *enum-numindent* (inherited-start-indent))
          	font-size: *standard-para-size*
		line-spacing: *standard-para-linespace*
		line-breaking-method: "UNREGISTERED::Christof Drescher//fot2pdf//line-breaking-method::optimizing::tolerance=4"

		(process-children)
	)
)

(element (enum line)
	(make paragraph
    		start-indent: 	(+ 4mm (inherited-start-indent))
		font-weight: 'normal
		space-before: 1mm
		(make line-field
			field-width: *enum-numindent*
			field-align: 'start
			(literal "\bullet;")
		)
		(process-children)
	)
)

(element (enum followline)
	(make paragraph
    		start-indent: 	(+ 4mm (inherited-start-indent))
		font-weight: 'normal
		space-before: 0mm
		(make line-field
			field-width: *enum-numindent*
			field-align: 'start
			(literal " ")
		)
		(process-children)
	)
)


(element (enum enum line)
	(make display-group
		keep: 'page
		(make paragraph
         		start-indent: 	(+ 4mm (inherited-start-indent))
			font-weight: 'normal
			(make line-field
				field-width: *enum-numindent*
				field-align: 'start
				(literal "\en-dash;")
			)
			(process-children)
		)
	)
)

(element lineenum
	(make sequence
		first-line-start-indent: (- 0mm *enum-numindent*)
    		start-indent: 	(+ *enum-numindent* (inherited-start-indent))
          	font-size: *standard-para-size*
		line-spacing: *standard-para-linespace*
          (process-children)
     )
)

(element (lineenum line)
	(make paragraph
		space-before: (display-space 0.5mm min: 0.5mm max: 0.5mm conditional?: #f priority: 1)
		space-after: (display-space 0.5mm min: 0.5mm max: 0.5mm conditional?: #f priority: 1)
		font-weight: 'normal
		(make line-field
			field-width: *enum-numindent*
			field-align: 'start
			(literal "\en-dash;")
		)
		(process-children)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Lines and blocks of code (mono-font)
;;
;; --------------------------------------------------------------------------------------

(element code
	(make sequence
		font-family-name: *mono-font*
		;;font-size: (* 0.9 (inherited-font-size))
		font-weight: 'bold
		(process-children)
	)
)

(element codeblock
	(make display-group
      		start-indent: 10mm
      		(make sideline
			sideline-sep: 0mm
			sideline-side: 'start
			line-thickness: 2pt
			(process-children)
		)
	)
)

;; procedure to return a numeric attribute; returns 0 if not available
(define (get-numeric-attr attr-nm #!optional (osnl (current-node)))
  (let ((a-str (attribute-string attr-nm osnl)))
    (if a-str (string->number a-str)  0) ))


(element codeline
	(make paragraph
		font-family-name: *mono-font*
		start-indent: 	(+ 	(inherited-start-indent)
					(* 10mm (get-numeric-attr "level"))
				)
		(process-children)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  A couple of things from docbook, slightly edited...
;;
;; --------------------------------------------------------------------------------------

(define ($charseq$ #!optional (sosofo (process-children)))
  (make sequence
    sosofo))

(element reg
  (make sequence
    ($charseq$)
	  (make sequence
		font-size:
		  (* (inherited-font-size) 0.5)
		position-point-shift: (+ (* (inherited-font-size) 0.4))
    (literal "\registered-sign;")))
	)

(element trademark
  (make sequence
    ($charseq$)
		(literal "\trade-mark-sign;")))

(element lineannotation
  (make sequence
    font-posture: 'italic
    (process-children)))

(define %ss-size-factor% 0.5)
(define %ss-shift-factor% 0.5)
(define ($ss-seq$ plus-or-minus #!optional (sosofo (process-children)))
  (make sequence
	font-size:
	  (* (inherited-font-size) %ss-size-factor%)
	position-point-shift:
	  (plus-or-minus (* (inherited-font-size) %ss-shift-factor%))
	sosofo))

(element superscript ($ss-seq$ +))
(element subscript ($ss-seq$ -))

;; --------------------------------------------------------------------------------------
;;
;;  Annotations (instead of footnotes), if sectionwide including a header
;;
;; --------------------------------------------------------------------------------------


(element annotationheader
	(make sequence
		(make rule
			;;break-before: 'page
			space-before: 10mm
			orientation: 'horizontal
			line-thickness: 2pt
		)
		(make paragraph
			font-size: 14pt
			font-weight: 'bold
			space-before: 5mm
			space-after: 5mm
			(literal "Annotations")
		)
	)
)


(element annotation
	(make paragraph
		start-indent: 20mm
		first-line-start-indent: -20mm
		space-after: 1mm
		(make sequence
	  		(make line-field
				field-width: 20mm
				(literal "Note ")
	  			(literal (attribute-string "number" (current-node)))
  			)
			(process-children)
		)
	)
)

;; --------------------------------------------------------------------------------------
;;
;;  FlowObject-Table
;;
;; --------------------------------------------------------------------------------------

(element fotable
	(make sequence
		font-family-name: *mono-font*
		font-size: 8pt
		line-spacing: 9pt
		cell-after-row-border: (make table-border line-thickness: 1pt)

		cell-before-column-margin: 2mm
		cell-after-column-margin: 2mm
		cell-before-row-margin: 1.5mm
		cell-after-row-margin: 1.5mm

		(make table
			space-before:           5mm
			space-after:           	5mm

			(make table-column
			    	column-number:      1
			    	width:              42mm
				cell-after-column-border: (make table-border line-thickness: 0.5pt)
			)
			(make table-row
				(make sequence
					font-weight: 'bold
					cell-after-row-border: (make table-border line-thickness: 2pt)
					(make table-cell column-number: 1 (make paragraph (literal "object")))
					(make table-cell column-number: 2 (make paragraph (literal "characteristics")))
				)
			)

			(with-mode fotable
				(process-children)
			)
		)
	)
)

(mode fotable
	(element fodata (make table-row (process-children)))
	(element fodata.flowobject (make table-cell column-number: 1 (make paragraph (process-children))))
	(element fodata.characteristics
		(make table-cell
			column-number: 2
			(process-matching-children 'generalinfo)
			(process-matching-children 'fodata.supported)
			(process-matching-children 'fodata.notapplicable)
			(process-matching-children 'fodata.unsupported)
		)
	)
	(element fodata.supported
		(make paragraph
			(make sequence
				font-weight: 'bold
				(literal "Supported: ")
			)
			(process-children)
		)
	)
	(element fodata.notapplicable
		(make paragraph
			space-before: 1mm
			(make sequence
				font-weight: 'bold
				(literal "Not applicable: ")
			)
			(process-children)
		)
	)
	(element fodata.unsupported
		(make paragraph
			space-before: 1mm
			(make sequence
				font-weight: 'bold
				(literal "Not supported: ")
			)
			(process-children)
		)
	)
	(element fodata.name
	 	(if (= (child-number) 1)
			(process-children-trim)
			(make sequence
				(literal ", ");
				(process-children-trim)
			)
		)
	)
	(element generalinfo
		(make paragraph
			font-family-name: *basefont*
			font-posture: 'italic
			(literal "(")
			(process-children)
			(literal ")")
		)
	)
	(element info
		(make sequence
			font-family-name: *basefont*
			font-posture: 'italic
			(literal "(")
			(process-children)
			(literal ")")
		)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Directory Table (Appendix)
;;
;; --------------------------------------------------------------------------------------


(define *dirtable-indent* 55mm)

(element dirtable
	(make sequence
		(make paragraph
			space-before: 1mm
			start-indent: *dirtable-indent*
			first-line-start-indent: (- 0mm *dirtable-indent*)
			(make line-field
				field-width: *dirtable-indent*
				font-weight: 'bold
				(literal (attribute-string "name"))
			)
			(if (attribute-string "info")
				(make sequence
					font-posture: 'italic
					(literal (attribute-string "info"))
				)
				(empty-sosofo)
			)
		)
		(process-children)
		(if (attribute-string "header")
			(make rule
				orientation: 'horizontal
				line-thickness: 1.5pt
				space-before: 1mm
				space-after: 0.5mm
			)
			(make rule
				orientation: 'horizontal
				line-thickness: 0.2pt
				color: (color rgb 0.6 0.6 0.6)
				space-before: 0.5mm
				space-after: 1mm
			)
		)
	)
)

(element (dirtable dirtable.entry)
	(make paragraph
		start-indent: *dirtable-indent*
		(process-children)
	)
)


;; --------------------------------------------------------------------------------------
;;
;;  Small Table (Appendix)
;;
;; --------------------------------------------------------------------------------------

(element smalltable
	(make sequence
		font-size: 9pt
		line-spacing: 10pt

		cell-before-column-margin: 1mm
		cell-after-column-margin: 1mm
		cell-before-row-margin: 1mm
		cell-after-row-margin: 1mm

		(make table
			space-before:           2mm
			space-after:           	2mm
			keep: (if (attribute-string "keep") 'page #f)
			(make table-column
			    	column-number:	1
			    	width:		(* 1mm (get-numeric-attr "col1width"))
				;cell-after-column-border: (make table-border line-thickness: 0.5pt)
			)
			(make table-row
				cell-after-row-border: (make table-border line-thickness: 2pt border-priority: 4 line-cap: 'square)

				(make sequence
					font-weight: 'bold
					(make table-cell column-number: 1 
						(make paragraph (literal (attribute-string "header1")))
					)
					(make table-cell column-number: 2 
						(make paragraph (literal (attribute-string "header2")))
					)
				)
			)

			(with-mode smalltable
				(process-children)
			)
		)
	)
)

(mode smalltable
	(element smalltable.entry (make table-row 		
		cell-before-row-border: (make table-border line-thickness: 0.5pt)
		(process-children))
	)
	(element smalltable.what (make table-cell column-number: 1 (make paragraph (process-children))))
	(element smalltable.text (make table-cell column-number: 2 (process-children)))
	(element p
		(make paragraph
			;space-after: 1mm
			(process-children)
		)
	)
)

