
// pcb2png version 0.10
// This program is (c) 2003 Anatoly M. Verkhovsky
// This program is licenesed with GNU GPL v2

// To make the program use somthing like this:
// gcc pcb2png.cxx -o pcb2png -lpng -lstdc++
// libpng and png headers must be in some directories
// where compilers and linker can find them

// if your image bitdepth is greater then 8 but less then 16
// make sure to normalize contrast of the resulting png image
// with some graphics editor like GIMP.


#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <png.h>
#define BUFSIZE 300

int rawcount=0;
int rawedge=0;

void write_row_callback(png_structp png_ptr, png_uint_32 row, int pass) {
	rawcount++;
	if (rawcount>rawedge){
		rawcount=0;
		printf("*");
		fflush(stdout);
	}
;  /* put your code here */
}


bool savePNG(char*filename, int width, int height, int depth,unsigned char*data){   // this only saves grayscale stuff

FILE *fp = fopen(filename, "wb");
    if (!fp) return false;
	 png_structp png_ptr = png_create_write_struct (PNG_LIBPNG_VER_STRING, (png_voidp)NULL,
			NULL, NULL);
	if (!png_ptr) return false;

	png_infop info_ptr = png_create_info_struct(png_ptr);
	if (!info_ptr) {
		png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
		return false;
	}
	if (setjmp(png_ptr->jmpbuf)) {
		png_destroy_write_struct(&png_ptr, &info_ptr);
		fclose(fp);
		return false;
	}
	png_init_io(png_ptr, fp);
	png_set_write_status_fn(png_ptr, write_row_callback);
	png_set_IHDR(png_ptr, info_ptr, width, height, depth,PNG_COLOR_TYPE_GRAY,
	PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);
	png_write_info(png_ptr, info_ptr);
	png_byte *rows[height];
	for (int i=0;i<height;i++) rows[i]=(png_byte *)&(data[i*width*(depth/8)]);
	png_write_image(png_ptr, rows);
	png_write_end(png_ptr, info_ptr);
	png_destroy_write_struct(&png_ptr, &info_ptr);
	return true;
}

int main(int argc, char* argv[]){
	int width=0, height=0, rotate=0, graylevel=0, bitdepth=0;

	if(argc!=2){
		 printf("Usage: %s NAME \n\t where NAME is the common part of the filename of .pcb and .img\n",argv[0]);
		return 0;
	}
	char *ch1, *ch=new char[BUFSIZE];

	sprintf(ch,"%s.pcb",argv[1]);
	FILE *pcb = fopen(ch,"ra");
	if (!pcb){
		printf("Couldn't open %s.\n",ch);
		return 0;
	}
	while((ch) && (strncmp(ch,"[Raw data]",10)!=0))
		ch=fgets(ch,BUFSIZE,pcb);

	if (!ch) {
		printf("Couldn't find image dimensions in file\n");
		return 0;
	}
	while(ch1 && *ch!='\n') { //&&((width==0) || (height==0))){
		ch1=fgets(ch,BUFSIZE,pcb);
		if (ch1){
			if (strncmp(ch,"height =",8)==0) sscanf(&(ch[8]),"%d",&height);
			if (strncmp(ch,"width =",7)==0) sscanf(&(ch[7]),"%d",&width);
			if (strncmp(ch,"Rotation =",10)==0) sscanf(&(ch[10]),"%d",&rotate);
			if (strncmp(ch,"GradLevels =",12)==0) sscanf(&(ch[12]),"%d",&graylevel);
		}
	}

	if (graylevel<266) bitdepth=8;
	else bitdepth=16;

	if ((height>0) and (width>0)){
		printf("Image dimensions : %dx%d, rotation: %d, graylevels: %d, bitdepth %d \n",
			width, height,rotate,graylevel, bitdepth);
	} else{
		printf("Couldn't find image dimensions in file\n");
		return 0;
	}
	fclose(pcb);
	sprintf(ch,"%s.img",argv[1]);
	struct stat mstat;
	if ((stat(ch,&mstat)!=0) ||(mstat.st_size<=0)) {
		printf("Cannot find file: %s\n", ch);
		return 0;
	}
	unsigned char *img_data=new unsigned char[mstat.st_size];
	int i;
	FILE *img=fopen(ch,"rb");
	if (!img) {
		printf("Cannot find file: %s\n", ch);
		return 0;
	}
	if ((i=fread(img_data,1,mstat.st_size,img))!=mstat.st_size){
		printf("Couldn't read file.\n Read %d bytes of %d \n",i,mstat.st_size);
		fclose(img);
		delete(img_data);
		return 0;
	}
	fclose(img);
	sprintf(ch,"%s.png",argv[1]);
//	savePNG(char*filename, int width, int height, char*data)
	rawedge=height/60;
	printf("Writing png: ");

	if ((rotate==90) || (rotate==270)) // this is a quick hack, room for improvement
		savePNG(ch, height, width,bitdepth, img_data);
	else
		savePNG(ch, width, height,bitdepth, img_data);
	printf("\n");
	return 1;
}
