(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63668,       1386]*)
(*NotebookOutlinePosition[     64372,       1410]*)
(*  CellTagsIndexPosition[     64328,       1406]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ \ Author : \ \ \ \ \ R . \ 
          Urbanczik, \[IndentingNewLine]\ \ \ Load\ \(with : \ \ << \
"\<SNAsym.m\>"\)\[IndentingNewLine]*) \)], "Input",
  CellLabel->"In[1]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(defaultpath\  = \ "\<~/SNA/mathcode/\>";\)\), "\[IndentingNewLine]", 
    \(\(Get[
        If[$Input\  \[Equal] \ "\<\>", defaultpath, 
            DirectoryName[$Input]] <> "\<SNAmat.m\>"];\)\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(LinkObject["/home/robert/SNA/mathcode/../pairelvs/pairelvsIFsh", 2, 
      2]\)], "Print",
  CellLabel->"From In[1]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stuff", "SectionFirst",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(BeginPackage["\<SNAsym`\>", \
{"\<SNAmat`\>", "\<Global`\>"}];\)\(\[IndentingNewLine]\)
    \)\)\)], "Input",
  CellLabel->"In[3]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(iwith[pat_List, l_List]\  := \ 
        Module[{mark}, \[IndentingNewLine]iwith[mark, \ 
            l\  /. \ Map[\ \((# \[Rule] \ mark)\) &, pat]]];\)\), "\n", 
    \(\(iwith[pat_, l_List]\  := \ 
        Map[First, Position[l, pat]]\  // Union;\)\), "\n", 
    \(\(with[pat_, l_List]\  := \ l[\([iwith[pat, l]]\)];\)\)}], "Input",
  CellLabel->"In[4]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(with\\)\\\" is similar to existing symbols \
\\!\\({iwith, With}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[4]:="]
}, Open  ]],

Cell[BoxData[{
    \(\(Trp[a_]\  := \ Transpose[a];\)\), "\[IndentingNewLine]", 
    \(\(Trp[{}]\  := \ {};\)\)}], "Input",
  CellLabel->"In[7]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(gcd[x___]\  := \ 
        If\ [\ x\  \[Equal] \ 0\ x, \ 1, \ GCD[x]];\)\)], "Input",
  CellLabel->"In[10]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(gcd\\)\\\" is similar to existing symbol \
\\\"\\!\\(GCD\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[10]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beautifying reaction and metabolite syntax", "SectionFirst",
  InitializationCell->True],

Cell[BoxData[{
    \(\(meta\  /: \ 
        MakeBoxes[meta[Int, species_String, compartment_String], 
          StandardForm]\  := \ 
        SuperscriptBox[\[IndentingNewLine]MakeBoxes[species, 
            StandardForm], \[IndentingNewLine]MakeBoxes[
            compartment]];\)\), "\n", 
    \(\(meta\  /: \ 
        MakeBoxes[meta[role_, species_String, compartment_String], 
          StandardForm]\  := \ 
        SubsuperscriptBox[\[IndentingNewLine]MakeBoxes[species, 
            StandardForm], \[IndentingNewLine]MakeBoxes[role, 
            StandardForm], \[IndentingNewLine]MakeBoxes[
            compartment]];\)\), "\n", 
    \(\(MakeExpression[\[IndentingNewLine]\ 
          SubsuperscriptBox[species_String, role_, 
            compartment_String], \[IndentingNewLine]StandardForm]\  \
:= \[IndentingNewLine]MakeExpression[\[IndentingNewLine]RowBox[{"\<meta\>", "\
\<[\>", role, "\<,\>", species, "\<,\>", 
              compartment, "\<]\>"}], \[IndentingNewLine]StandardForm];\)\), \
"\n", 
    \(\ \(MakeExpression[\ \[IndentingNewLine]SuperscriptBox[species_String, 
            compartment_String], 
          StandardForm]\  := \[IndentingNewLine]MakeExpression[\
\[IndentingNewLine]RowBox[{"\<meta\>", "\<[\>", Int, "\<,\>", 
              species, "\<,\>", 
              compartment, "\<]\>"}], \
\[IndentingNewLine]StandardForm];\)\)}], "Input",
  CellLabel->"In[11]:=",
  InitializationCell->True],

Cell[BoxData[{
    RowBox[{
      TagBox[
        StyleBox["RightVector",
          ShowSpecialCharacters->False,
          ShowStringCharacters->True,
          NumberMarks->True],
        FullForm], " ", "/:", " ", 
      RowBox[{"MakeBoxes", "[", " ", 
        RowBox[{
          TagBox[
            StyleBox[\(RightVector[a_, b_]\),
              ShowSpecialCharacters->False,
              ShowStringCharacters->True,
              NumberMarks->True],
            FullForm], ",", "StandardForm"}], "]"}], ":=", 
      "\[IndentingNewLine]", \(RowBox[{MakeBoxes[a, StandardForm], 
          StyleBox["\<\[RightVector]\>", 
            FontSize \[Rule] \(Options[Notebook, FontSize]\)[\([1, 2]\)] + 
                6], MakeBoxes[b, StandardForm]}]\)}], "\n", 
    RowBox[{
      " ", \(Equilibrium\  /: \ \ MakeBoxes[Equilibrium[a_, b_], 
          StandardForm] := \[IndentingNewLine]RowBox[{MakeBoxes[a, 
              StandardForm], 
            StyleBox["\<\[Equilibrium]\>", 
              FontSize \[Rule] \(Options[Notebook, FontSize]\)[\([1, 2]\)] + 
                  6], MakeBoxes[b, StandardForm]}]\)}]}], "Input",
  CellLabel->"In[15]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["mnet: Basic operations", "SectionFirst",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(roles\  = \ {Int, Xt, Xtin, Xtout};\)\)], "Input",
  CellLabel->"In[17]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(roles\\)\\\" is similar to existing symbol \
\\\"\\!\\(role\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[17]:="]
}, Open  ]],

Cell[BoxData[{
    \(\(makemnet[reacs_, tags_]\  := \ 
        Block[\ {t}, \[IndentingNewLine]t\  = \ \(\({reacs, tags}\  // 
                  Transpose\)\  // Sort\)\  // 
              Transpose; \[IndentingNewLine]Apply[mnet, \ 
            t]];\)\), "\[IndentingNewLine]", 
    \(\(makemnet[\ {}, \ {}]\  = \ 
        mnet[\ {}, {}];\)\), "\[IndentingNewLine]", 
    \(\)}], "Input",
  CellLabel->"In[18]:=",
  InitializationCell->True],

Cell[BoxData[{
    \(\(metabolites[
          mnet[reacs_, tags_]]\  := \ \[IndentingNewLine]Cases[reacs, 
            meta[___], \[Infinity]] // Union;\)\), "\[IndentingNewLine]", 
    \(\(reactions[mnet[reacs_, tags_]]\  := \ 
        reacs;\)\), "\[IndentingNewLine]", 
    \(\(tags[mnet[reacs_, tgs_]]\ \  := \ tgs;\)\), "\[IndentingNewLine]", 
    \(trpairs[mnet[reacs_, tgs_]]\  := \ {tgs, reacs} // 
        Transpose\)}], "Input",
  CellLabel->"In[20]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(roleQ[x_]\  := \ 
        MemberQ[roles, x]\  || \ \((Head[x]\  === \ Xt)\);\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(setrole::"\<norole\>"\  = \ "\<`1` not in `2`\>";\)\), "\n", 
    \(\(setrole[net_mnet, metas_List, 
          role_]\  := \ \[IndentingNewLine]Block[\ {x, y, nm, 
            tmp}, \[IndentingNewLine]nm\  = \ 
            metas /. \ meta[_, x_, y_]\  \[Rule] \ 
                meta[role, x, y]; \[IndentingNewLine]tmp\  = \ \ reactions[
                net]\  /. \ 
              MapThread[Rule, {metas, nm}]; \[IndentingNewLine]makemnet[
              tmp, \ net // tags]\[IndentingNewLine] /; \[IndentingNewLine]If[
              roleQ[role], True, \ 
              Message[setrole::"\<norole\>", role, 
                roles]]\[IndentingNewLine]];\)\), "\n", 
    \(\(setrole[net_mnet, met_meta, role_]\  := \ 
        setrole[net, {met}, role];\)\)}], "Input",
  CellLabel->"In[24]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(roleQ\\)\\\" is similar to existing symbol \
\\\"\\!\\(role\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[24]:="]
}, Open  ]],

Cell[BoxData[
    \(\(mnet2stoich[net_mnet]\  := \ 
        Block[\ {rr, intsl, nrev, rep, mat, fac}, \[IndentingNewLine]rr\  = \ 
            reactions[
              net]; \[IndentingNewLine]nrev\  = \(({0} \[Union] 
                  Position[rr, x_\  \[Equilibrium] \ y_])\) // 
              Max; \[IndentingNewLine]intsl = \ 
            metabolites[net]; \[IndentingNewLine]If[\ 
            intsl\  \[Equal] \ {}, \ 
            Return[\ {{0\ rr}, 
                nrev}]]; \[IndentingNewLine]rrl\  = \ \(rr /. \ \ \((x_\  \
\[Equilibrium] y_\ )\) \[Rule] \ \ y - x\  + \ 
                    fac\ intsl[\([1]\)]\)\  /. \ \((x_\  \[RightVector] \ 
                    y_\ )\) \[Rule] \ \ y - x\  + 
                  fac\ intsl[\([1]\)]\ ; \[IndentingNewLine]rep\  = \ 
            MapThread[
              Rule, {intsl, 
                IdentityMatrix[
                  Length[intsl]]}]; \[IndentingNewLine]mat\  = \ \(rrl\  /. \ 
                rep\)\  /. \ fac\  \[Rule] \ 0; \[IndentingNewLine]{mat\  // 
              Trp, \ nrev}\ ];\)\)], "Input",
  CellLabel->"In[28]:=",
  InitializationCell->True],

Cell[BoxData[{
    \(\(stoich2reacs[mm_, ints_, \ nr_]\  := \ 
        Block[\ {rr, arrsimp, x, y}, \[IndentingNewLine]arrsimp[\ b_]\  := \ 
            Module[\ {ins}, \[IndentingNewLine]ins\  = 
                Plus @@ Cases[b, \ 
                    x_\ \ y_ /; \ x < \ 0, {0, 
                      1}]; \[IndentingNewLine]\((\(-ins\))\)\  \[RightVector] \
\ \((b - ins)\)\ \[IndentingNewLine]]; \[IndentingNewLine]rr\  = \ 
            Transpose[mm] . ints; \[IndentingNewLine]rr\  = \ 
            Map[arrsimp, rr]\ ; \[IndentingNewLine]MapIndexed[\ 
            If[#2[\([1]\)]\  > \ 
                  nr, #1, \ #1\  /. \ \((x_\  \[RightVector] \ 
                        y_)\)\  \[Rule] \ \((x\  \[Equilibrium] \ y)\)] &, 
            rr]\[IndentingNewLine]];\)\), "\[IndentingNewLine]", 
    \(\(stoich2reacs[{}, _, \ 0]\ \  := \ {};\)\ \), "\[IndentingNewLine]", 
    \(\(stoich2reacs[mm_, {}, \ nr_]\  := \ 
        stoich2reacs[0\ mm, {dummy}, nr];\)\)}], "Input",
  CellLabel->"In[29]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(constructmnet::"\<Length\>"\ \  = \ \
"\<Length[reacs] \[NotEqual] Length[tagnames]\>";\)\[IndentingNewLine]
    \(constructmnet::"\<Metabolite Syntax\>"\  = \ "\<Errors in `1`\>";\)\
\[IndentingNewLine]
    \(constructmnet::"\<Reaction Syntax\>"\  = \ "\<Errors in `1`\>";\)\
\[IndentingNewLine]
    \(constructmnet::"\<Stoichiometric Factors\>"\  = \ "\<`1` illegal\>";\)\
\[IndentingNewLine]
    \(constructmnet[reacs_List, 
          tagnames_List]\  := \ \[IndentingNewLine]Block[\ {nn, mets, 
            badmets, r, mm, nrev, mml, a, b}, \[IndentingNewLine]If[\ 
            Length[reacs]\  \[NotEqual] \ Length[tagnames], \ 
            Message[constructmnet::"\<Length\>"]; \ 
            Return[$Failed]]; \[IndentingNewLine]nn = 
            makemnet[reacs, Map[R, tagnames]]; \[IndentingNewLine]mets\  = \ 
            metabolites@nn; \[IndentingNewLine]badmets\  = \ 
            DeleteCases[mets, \ 
              meta[r_\  /; \ \ roleQ[
                    r], \ _String, \ _String]]; \[IndentingNewLine]If[
            badmets\  \[NotEqual] \ {}, \ 
            Message[constructmnet::"\<Metabolite Syntax\>", badmets]; \ 
            Return[$Failed]]; \[IndentingNewLine]mml\  = \ \(\((reactions@
                    nn)\)\  /. \ 
                meta[___]\  \[Rule] \ 
                  0\)\  /. \ \((a_\  \[Equilibrium] \ 
                    b_)\)\  \[Rule] \ \((a\  \[RightVector] \ 
                    b)\); \[IndentingNewLine]mml\  = \ {mml, \ 
                reactions@nn}\  // Trp; \[IndentingNewLine]mml\  = \ 
            DeleteCases[
              mml, \ {0\  \[RightVector] \ 0, \ _}]; \n\ \ \ \ \ \ \ If[
            mml\  \[NotEqual] \ {}, \ \[IndentingNewLine]\ \ Message[
              constructmnet::"\<Reaction Syntax\>", Map[Last, mml]]; \ 
            Return[$Failed]]; \[IndentingNewLine]{mm, nrev}\  = \ 
            mnet2stoich[nn]; \[IndentingNewLine]mml\  = \ 
            DeleteCases[
              DeleteCases[
                Flatten[mm], _Integer], _Rational]; \[IndentingNewLine]If[
            mml\  \[NotEqual] \ {}, \ \[IndentingNewLine]Message[
              constructmnet::"\<Stoichiometric Factors\>", mml // Union]; \ 
            Return[$Failed]]; \[IndentingNewLine]makemnet[\ 
            stoich2reacs[mm, mets, nrev], \ 
            tags@nn]\[IndentingNewLine]];\)\)\)\)], "Input",
  CellLabel->"In[32]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(mets\\)\\\" is similar to existing symbols \
\\!\\({met, meta, metas}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[32]:="]
}, Open  ]],

Cell[BoxData[{
    \(\(exch[
          ext_meta]\ \  := \[IndentingNewLine]Switch[
            ext[\([1]\)], \ \[IndentingNewLine]Xt, \ \ \ \ \ \ \ \ Rx[\ 
              ext\  \[Equilibrium] \ 0], \[IndentingNewLine]Xtin, \ \ \ Rx[
              0\ \  \[RightVector] \ ext], \[IndentingNewLine]Xtout, \ 
            Rx\ [ext\ \ \  \[RightVector] \ 
                0], \[IndentingNewLine]\ _\ \ \ \ \ \ \ \ , \ 
            Hold[Sequence[]]]\  // ReleaseHold;\)\), "\n", 
    \(\(\(SetAttributes[exch, Listable];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(addexchanges::"\<double\>" = "\<Exchange reactions already previously \
added\>"; 
    addexchanges[net_mnet, mRx_]\  := \ 
      Block[{ex, 
          a}, \[IndentingNewLine]If[\ {}\  \[NotEqual] \ 
            iwith[Rx[_], tags@net], \[IndentingNewLine]Message[
            addexchanges::"\<double\>"\ ]; \ 
          Return[net]]; \[IndentingNewLine]ex\  = \ 
          with[{Xt, Xtin, Xtout}, metabolites@net] // 
            exch; \[IndentingNewLine]ex\  = \ 
          ex\  /. \ Rx[a_]\  \[Rule] \ a; \[IndentingNewLine]makemnet[
          Join[reactions[net], ex], \ 
          Join[tags[net], \ Map[mRx, ex]]]\[IndentingNewLine]]\), "\n", 
    \(\(addexchanges[net_mnet]\  := addexchanges[net, Rx];\)\), "\n", 
    \(\)}], "Input",
  CellLabel->"In[37]:=",
  InitializationCell->True],

Cell[BoxData[
    \(\(irrevmnet[net_mnet]\  := \ 
        Block[{\ x, y, revpos, revrev, r, t}, \[IndentingNewLine]r\  = \ 
            reactions[net]; \[IndentingNewLine]t\  = \ 
            tags[net]; \[IndentingNewLine]revpos\  = \ 
            Position[r, \ x_\  \[Equilibrium] \ y_\ ]\  // 
              Flatten; \[IndentingNewLine]revrev\  = \ 
            r[\([revpos]\)]\  /. \ 
              x_\  \[Equilibrium] \ y_\  \[Rule] \ 
                y\  \[RightVector] \ x; \[IndentingNewLine]r\  = \ 
            r\  /. \ x_\  \[Equilibrium] \ y_\  \[Rule] \ 
                x\  \[RightVector] \ y; \[IndentingNewLine]makemnet[\ 
            Join[r, revrev], \ 
            Join[t, \(-t[\([revpos]\)]\)]]\[IndentingNewLine]];\)\)], "Input",\

  CellLabel->"In[41]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(revmnet[net_mnet]\  := \ 
        Block[\ {x, y, z, abs, pairs, inet, rpairs, 
            rr}, \[IndentingNewLine]abs[{z_, 
                x_\ \  \[RightVector] \ y_}]\  := \ 
            Sort[{x, y, z, \(-z\)}]; \[IndentingNewLine]inet\  = \ 
            irrevmnet[
              net]; \[IndentingNewLine]pairs\  = \ {tags[inet], 
                reactions[inet]}\  // Transpose; \[IndentingNewLine]pairs\  = 
            pairs[\([\ 
                Ordering[
                  Map[abs, pairs]]\ ]\)]; \[IndentingNewLine]pairs\  = \ 
            Split[pairs, \((abs[#1]\  \[Equal] \ 
                    abs[#2])\) &]; \[IndentingNewLine]pairs\  = \ 
            Map[Sort, pairs]; \[IndentingNewLine]rpairs\  = \ 
            Map[Last, pairs]; \[IndentingNewLine]rr\  = \ 
            Map[Last, rpairs]; \[IndentingNewLine]revpos\  = \ 
            Position[pairs, \ x_\  /; \ Length[x]\  > \ 1, {1}] // 
              Flatten; \[IndentingNewLine]rr[\([revpos]\)]\  = \ 
            rr[\([revpos]\)]\  /. \ 
              x_\ \  \[RightVector] \ y_\  \[Rule] \ 
                x\  \[Equilibrium] y; \[IndentingNewLine]makemnet[rr, 
            Map[First, rpairs]]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \)\)], "Input",
  CellLabel->"In[42]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(abs\\)\\\" is similar to existing symbol \
\\\"\\!\\(Abs\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[42]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(inet\\)\\\" is similar to existing symbols \
\\!\\({mnet, net}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[42]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(rpairs\\)\\\" is similar to existing symbols \
\\!\\({pairs, trpairs}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[42]:="]
}, Open  ]],

Cell[BoxData[{
    \(submnet[net_mnet, keep_]\ \  := 
      makemnet[\(reactions[net]\)[\([keep]\)], \(tags[net]\)[\([keep]\)]]; 
    submnetwith[metas_, net_mnet]\ \  := \[IndentingNewLine]submnet[net, 
        iwith[metas, \ reactions[net]]];\), "\[IndentingNewLine]", 
    \(splitmnet[net_mnet, \ onmets_]\  := \ 
      Block[\ {hasis}, \[IndentingNewLine]hasis\  = \ 
          iwith[onmets, \ reactions[net]]; \[IndentingNewLine]{submnet[net, 
            hasis], \[IndentingNewLine]submnet[net, 
            Complement[\ \(\(net // reactions\) // Length\) // Range, 
              hasis]]}]\)}], "Input",
  CellLabel->"In[43]:=",
  InitializationCell->True],

Cell[BoxData[
    \(\(joinmnet[net1_mnet, \ net2_mnet]\  := \ \[IndentingNewLine]makemnet[\ 
          Join[reactions[net1], 
            reactions[
              net2]], \ \ \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ Join[tags[net1], tags[net2]]];\)\)], "Input",
  CellLabel->"In[45]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplifications that preserve the flux cone", "SectionFirst",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(fixduplicates[net_mnet]\  := \ 
        Block[\ {rr, tgs, reacs, a, 
            b}, \[IndentingNewLine]rr\  = \ {reactions@net, \ tags@net}\  // 
              Transpose; \[IndentingNewLine]rr = \ 
            Split[rr, \((\ \((First[#1]\  \[Equal] \ First[#2])\) && 
                    MatchQ[First[#1], \ 
                      a_\  \[RightVector] \ 
                        b_])\) &]; \[IndentingNewLine]reacs\  = \ 
            Map[\((First@\(First@#\))\) &, rr]; \[IndentingNewLine]tgs\  = \ 
            Map[Last, rr, {2}]; \[IndentingNewLine]tgs\  = \ 
            Replace[tgs\ , \ {\ {a_}\  \[Rule] \ a\ , \ {a__}\  \[Rule] \ 
                  ALT[a]}, {1}]; \[IndentingNewLine]makemnet[reacs, 
            tgs]\[IndentingNewLine]];\)\[IndentingNewLine]
    fixdeadend[net_mnet]\  := \ 
      Block[\ {rr, tgs, duds, duds1, dudreacs, mr, mrt, posm, negm\ , pmm, 
          nrev, keep, y}, \[IndentingNewLine]{mr, nrev}\  = \ 
          mnet2stoich[net]; \ \[IndentingNewLine]mr\  = \ 
          Sign[mr]; \[IndentingNewLine]duds\  = \ 
          Position[\ Map[Count[#, \ x_\  /; \ x\  \[NotEqual] \ 0] &, mr], \ 
            1]; \ \[IndentingNewLine]mrt\  = \ 
          Trp[mr]; \[IndentingNewLine]posm\  = \ 
          Position[
            Map[\((Max @@ #)\) &, \ \ \ \ \ \ \ \ \ Trp[Drop[mrt, nrev]]], 
            1]; \[IndentingNewLine]negm\  = \ 
          Position[
            Map[\((Min @@ #)\) &, \ \ \ \ \ \ \ \ \ Trp[
                Drop[mrt, nrev]]], \(-1\)]; \[IndentingNewLine]pmm\ \ \  = \ 
          Position[Map[\((Max @@ #)\) &, Abs[Trp[Take[mrt, nrev]]]], 
            1]; \[IndentingNewLine]pmm\  = \ 
          pmm \[Union] \((posm\  \[Intersection] 
                negm\ )\); \[IndentingNewLine]duds1\  = \ 
          Complement[posm \[Union] negm, 
            pmm]; \[IndentingNewLine]duds\  = \ \((duds \[Union] duds1)\)\  // 
            Flatten; \[IndentingNewLine]msg[{"\<fixdeadend\>", \(metabolites[
                  net]\)[\([duds]\)]} // 
            needsboxes]; \[IndentingNewLine]dudreacs\  = \ 
          Map[\(Position[\ mr[\([#]\)], \ 
                  y_ /; \ y\  \[NotEqual] \ 0]\)[\([1]\)] &, 
            duds]; \[IndentingNewLine]dudreacs\  = \ 
          Position[\ Plus @@ Abs[mr[\([duds]\)]], 
              x_\  /; \ x\  \[NotEqual] 0]\  // 
            Flatten; \[IndentingNewLine]\[IndentingNewLine]rr\  = \ 
          reactions[net]; \ tgs\  = \ tags[net]; 
        keep\  = \ 
          Complement[Range[Length[rr]], 
            dudreacs]; \[IndentingNewLine]makemnet[rr[\([keep]\)], 
          tgs[\([keep]\)]]\[IndentingNewLine]]\)\)\)], "Input",
  CellLabel->"In[46]:=",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(fixsingles[mnet[{}, {}], keepext_]\  := \ 
      mnet[{}, {}]; 
    fixsingles[net_mnet, keepext_]\  := \ 
      Block[\ {m, mT, nrev, rrnew, i, combs, 
          maxmet}, \[IndentingNewLine]msg["\<fixsingles\>"]; \
\[IndentingNewLine]{m, nrev}\  = \ 
          mnet2stoich[net]; \ \[IndentingNewLine]m\  = \ 
          Join[m, {tags[net]}]; \[IndentingNewLine]maxmet\  = \ 
          If[keepext, \ \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ iwith[Int, metabolites[net]] // 
              Length, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ First[Dimensions[m]] - 1]; \[IndentingNewLine]Do[
          m\  = \ simp[m, i, nrev], {i, maxmet}]; \[IndentingNewLine]mT\  = \ 
          Trp[m]; \[IndentingNewLine]mT = 
          Map[\ \((#/gcd @@ Drop[#, \(-1\)])\) &, 
            mT]; \[IndentingNewLine]m\  = \ 
          Trp[mT]; \[IndentingNewLine]rrnew\  = \ 
          stoich2reacs[Drop[m, \(-1\)], metabolites[net], 
            nrev]; \ \[IndentingNewLine]combs\  = \ 
          Expand[Last[m]]\ ; \[IndentingNewLine]FixedPoint[
          fixdeadend, \[IndentingNewLine]makemnet[rrnew, combs] // 
            fixduplicates]\[IndentingNewLine]];\[IndentingNewLine]
    \(simp[m_, i_, nrev_]\  := \ 
        Block[\ {nz1, nz2, nzr, j, vl, vk, l, k, mmT, vli, 
            vki}, \[IndentingNewLine]nzr\  = \ 
            Position[Take[m[\([i]\)], nrev], \ x_ /; \ x\  \[NotEqual] 0] // 
              Flatten; \[IndentingNewLine]If[Length[nzr]\  > \ 1, \ 
            Return[m]]; \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\[IndentingNewLine]nz1\  = \ 
            nrev + Position[Drop[m[\([i]\)], nrev], \ x_ /; \ x\  > 0] // 
              Flatten; \[IndentingNewLine]nz2\  = \ 
            nrev + Position[Drop[m[\([i]\)], nrev], \ x_ /; \ x\  < 0] // 
              Flatten; \[IndentingNewLine]If[
            Length[nz1]\ *Length[nz2]*Length[nzr]\  > \ 0, \ 
            Return[m]]; \[IndentingNewLine]If[
            Length[nz1]\ \  > \ 
              Length[nz2]\ , \ {nz1, nz2}\  = \ {nz2, 
                nz1}]; \[IndentingNewLine]nz1 = 
            Join[nzr, nz1]; \[IndentingNewLine]If[
            Length[nz1]\ \  \[NotEqual] \ 
              1, \ {nz1, nz2}\  = \ {nz2, nz1}]; \[IndentingNewLine]If[\ 
            Length[nz1]\ \  \[NotEqual] \ 1, \ \ \ \ Return[
              m], \ \ \ \[IndentingNewLine]l\  = \ 
              nz1[\([1]\)]; \[IndentingNewLine]mmT\  = \ 
              Trp[m]; \[IndentingNewLine]vl\  = \ 
              mmT[\([l]\)]; \[IndentingNewLine]Do[\[IndentingNewLine]k\ \  = \
\ nz2[\([j]\)]; \[IndentingNewLine]vk\  = \ 
                mmT[\([k]\)]; \[IndentingNewLine]{vli, 
                  vki}\  = \ {vl[\([i]\)], vk[\([i]\)]\ }/
                  GCD[vl[\([i]\)], 
                    vk[\([i]\)]]; \[IndentingNewLine]mmT[\([k]\)]\  = 
                Sign[\(-vki\)\ vli] Abs[vki]\ vl\  + 
                  Abs[vli] vk\ , \[IndentingNewLine]{j, 
                Length[nz2]}]; \[IndentingNewLine]Transpose[
              mmT]\[IndentingNewLine]]\[IndentingNewLine]];\)\)\)\)], "Input",\

  CellLabel->"In[48]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(firstnz[x_]\  := \ 
        If[\ x\  \[Equal] \ 0\ x, \ 1, First@DeleteCases[x, 0]\ ];\)\(\n\)
    \)\), "\n", 
    \(linksimp[mnet[{}, {}]]\  := \ mnet[{}, {}]; 
    linksimp[net_mnet]\  := \ 
      Block[{mm, nrev, K, sub, pp, gr, grf, first, nmmT, irr, nirr, nmm, 
          nnrev}, \[IndentingNewLine]{mm, nrev}\  = \ 
          mnet2stoich[net]; \ \n\ \ \ \ \ K\  = 
          NullSpace[mm] // Transpose; \[IndentingNewLine]mm\  = \ 
          Join[mm, {tags@net}]; \[IndentingNewLine]first\  = \ 
          Map[firstnz, K]; \n\ \ \ \ sub = K/first; \[IndentingNewLine]pp = 
          Ordering[sub]; \n\ \ \ \ gr = 
          Split[pp, \((sub[\([#1]\)]\  \[Equal] \ 
                  sub[\([#2]\)])\) &]; \[IndentingNewLine]grf\  = \ 
          Map[\((\ first[\([#]\)])\) &, gr]; \[IndentingNewLine]grf\  = \ 
          Map[\ \((Sign[Last[#]] #)\) &, grf]; \[IndentingNewLine]cc = 
          MapThread[\ 
            MapThread[
                Function[{a, b}, 
                  If[\ b \[LessEqual] nrev, Abs[a], 
                    a]], {#1, #2}] &\ , \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {grf, gr}]; \[IndentingNewLine]cc = 
          Map[Min, cc]; \[IndentingNewLine]gr = 
          MapThread[\ 
            If[#2\  < \ 0, Sequence @@ Transpose[{#1}], #1] &, \ {gr, cc}]; 
        grf\  = \ 
          Map[\((\ first[\([#]\)])\) &, gr]; \[IndentingNewLine]grf\  = \ 
          Map[\((#/gcd @@ #)\) &, grf]; \[IndentingNewLine]grf\  = \ 
          Map[\ \((Sign[Last[#]] #)\) &, grf]; \[IndentingNewLine]nmmT = 
          MapThread[
            Plus @@ \((\(Transpose[mm]\)[\([#1]\)]*#2)\) &, \ {gr, grf}]; 
        irr\  = \ 
          Table[i\  > \ nrev, {i, 
              Last@\(Dimensions@mm\)}]; \[IndentingNewLine]nirr\  = 
          Map[\ \((Or @@ irr[\([#]\)])\) &, gr]; \[IndentingNewLine]nmm\  = \ 
          nmmT[\([Ordering[nirr]]\)] // 
            Transpose; \[IndentingNewLine]nnrev\  = \ 
          Count[nirr, 
            False]; \[IndentingNewLine]msg[{"\<linksimp\>", 
              Map[\((\((tags@net)\)[\([#]\)])\) &, Cases[gr, \ {_, __}]]} // 
            needsboxes]; \[IndentingNewLine]makemnet[\ \
\[IndentingNewLine]stoich2reacs[Drop[nmm, \(-1\)], metabolites@net, 
            nnrev], \[IndentingNewLine]Expand@\(Last@
              nmm\)]\[IndentingNewLine]]\)}], "Input",
  CellLabel->"In[50]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(first\\)\\\" is similar to existing symbol \
\\\"\\!\\(First\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[50]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(nmmT\\)\\\" is similar to existing symbol \\\
\"\\!\\(mmT\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[50]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(nirr\\)\\\" is similar to existing symbol \\\
\"\\!\\(irr\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[50]:="],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(General :: \\\"spell1\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[50]:="]
}, Open  ]],

Cell[BoxData[{
    \(\(kersimp[mnet[{}, {}]]\  := \ 
        mnet[{}, {}];\)\), "\[IndentingNewLine]", 
    \(\(kersimp[net_mnet]\  := \ 
        Block[\[IndentingNewLine]\ {mm, nrev, K, Kir, box, cc, constr, vv, \ 
            keep, l, m}, \[IndentingNewLine]{mm, nrev}\  = \ 
            mnet2stoich[net]; \ \[IndentingNewLine]K\  = 
            NullSpace[mm]; \[IndentingNewLine]If[K\  \[Equal] \ {}, \ 
            Return[\ mnet[{}, {}]]]; \[IndentingNewLine]Kir\  = \ 
            Drop[Trp[K], nrev] // Trp; \[IndentingNewLine]If[
            Kir\  \[Equal] \ {}, \ 
            Return[\ net]]; \[IndentingNewLine]{m, l} = 
            Dimensions[Kir]; \[IndentingNewLine]cc\  = \ 
            Table[1, {i, l}]; \[IndentingNewLine]constr\  = \ 
            Table[{0, 0}, {i, m}]; \[IndentingNewLine]box\  = \ \ Table[{0, 
                1}, {i, l}]; \[IndentingNewLine]vv = 
            LinearProgramming[\(-cc\), Kir, constr, box\ , 
              Method -> "\<RevisedSimplex\>"]; \[IndentingNewLine]keep = \ 
            Position[vv, \ 0]\  // Flatten; \[IndentingNewLine]keep\  = \ 
            Join[Range[1, nrev], \ 
              nrev + keep]; \[IndentingNewLine]msg[{"\<kersimp\>", \ 
                Complement[tags@net, \(tags[net]\)[\([keep]\)]]} // 
              needsboxes]; \[IndentingNewLine]submnet[net, 
            keep]];\)\), "\[IndentingNewLine]", 
    \(\)}], "Input",
  CellLabel->"In[15]:=",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(feasiblereac[net_mnet, 
          target_]\  := \[IndentingNewLine]Block[\ {targetl, K, Kir, m, n, 
            constr, box, mm, nrev, cc, res, 
            check}, \[IndentingNewLine]targetl\  = \ 
            If[AtomQ[target], {target}, target]; \[IndentingNewLine]{mm, 
              nrev}\  = \ \ \ mnet2stoich[net]; \[IndentingNewLine]K\  = \ 
            NullSpace[mm] // Trp; \[IndentingNewLine]If[
            K\ \  \[Equal] \ {}, \ 
            Return@Map[\ If[\ #\ \  \[LessEqual] \ nrev, \ {0, 0}, 0] &, 
                targetl]]; \[IndentingNewLine]Kir\  = \ 
            Drop[K, nrev]; \[IndentingNewLine]If[Kir\  \[Equal] \ {}, \ 
            Return@Table[{1, \(-1\)}, {Length@
                    target}]]; \[IndentingNewLine]m\  = 
            First@\ \(Dimensions@
                Kir\); \[IndentingNewLine]n\  = \ \ Last@\(Dimensions@
                Kir\); \[IndentingNewLine]constr\  = \ 
            Table[{0, 1}, {m}]; \[IndentingNewLine]box\  = \ \ Table[{\(-1\), 
                1}, {n}]; \[IndentingNewLine]check[
              targt_]\  := \ \((\[IndentingNewLine]cc\  = \ 
                K[\([targt]\)]; \[IndentingNewLine]res\  = 
                cc . LinearProgramming[\(-cc\), Kir, constr, box, 
                    Method -> "\<RevisedSimplex\>"]; \[IndentingNewLine]If[
                targt\  \[LessEqual] \ nrev, \[IndentingNewLine]{res, 
                  cc . LinearProgramming[cc, Kir, constr, box, 
                      Method -> "\<RevisedSimplex\>"]}, \
\[IndentingNewLine]res])\); \[IndentingNewLine]Map[check, 
            targetl]\ \[IndentingNewLine]];\)\[IndentingNewLine]
    \(revsimp[net_mnet]\  := \ 
        Module[{nrev, checks, keep, ir1, ir2, trs, x, y, 
            z}, \[IndentingNewLine]nrev\  = \(({0} \[Union] 
                  Position[reactions@net, x_\  \[Equilibrium] \ y_])\) // 
              Max; \[IndentingNewLine]checks\  = \ 
            feasiblereac[net, Range[nrev]]; \[IndentingNewLine]keep\  = \ 
            Position[checks, \ x_\  /; \ x\  \[NotEqual] \ {0, 0}, {1}] // 
              Flatten; \[IndentingNewLine]ir1\  = \ \ Position[checks, \ 
                x_List\  /; \ x[\([2]\)]\  \[Equal] \ \ 0, {1}] // Flatten; 
          ir2\  = \ \ Position[checks, \ 
                x_List\  /; \ x[\([1]\)]\  \[Equal] \ \ 0, {1}] // 
              Flatten; \[IndentingNewLine]msg[{"\<revsimp\>", \(tags[
                    net]\)[\([ir1]\)], \(tags[net]\)[\([ir2]\)]} // 
              needsboxes]; \[IndentingNewLine]trs\  = \ 
            trpairs@net; \[IndentingNewLine]trs[\([ir1]\)]\  = \ 
            trs[\([ir1]\)]\  /. \ {z_, 
                  x_ \[Equilibrium] \ y_}\  \[Rule] \ {z, \ 
                  x\  \[RightVector] 
                    y}; \[IndentingNewLine]trs[\([ir2]\)]\  = \ 
            trs[\([ir2]\)]\  /. \ {z_, 
                  x_ \[Equilibrium] \ y_}\  \[Rule] \ {z, \ 
                  y\  \[RightVector] x}; \[IndentingNewLine]keep\  = \ 
            Join[keep, \ 
              Range[nrev + 1, Length@trs]]\ ; \[IndentingNewLine]trs\  = \ 
            If[\ keep\  \[NotEqual] \ {}, 
              trs[\([keep]\)]\  // 
                Transpose, \ \ {\ {}, {}\ }\ ]; \[IndentingNewLine]makemnet[
            Last@trs, First@trs]\[IndentingNewLine]];\)\)\)\)], "Input",
  CellLabel->"In[51]:=",
  InitializationCell->True],

Cell[BoxData[{
    \(\(fluxsimp[net_mnet, keepext_]\  := \ 
        Block[\ {s}, \[IndentingNewLine]s\  = \ \(net // fixduplicates\) // 
              fixdeadend; \[IndentingNewLine]s\  = \ 
            FixedPoint[fixsingles[#, keepext] &, s]; \[IndentingNewLine]s = 
            If[keepext, \[IndentingNewLine]FixedPoint[
                Composition[fixsingles[#, keepext] &, 
                  kersimp\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ], 
                s], FixedPoint[
                Composition[fixsingles[#, keepext] &, kersimp\ , linksimp], 
                s]]; \[IndentingNewLine]s = revsimp[s]; \[IndentingNewLine]If[
            keepext, \[IndentingNewLine]FixedPoint[fixsingles[#, keepext] &, 
              s], \[IndentingNewLine]FixedPoint[
              Composition[linksimp, fixsingles[#, keepext] &], 
              s]]\[IndentingNewLine]];\)\), "\[IndentingNewLine]", 
    \(\(fluxsimp[net_mnet]\  := \ 
        fluxsimp[net, False];\)\), "\[IndentingNewLine]", 
    \(\)}], "Input",
  CellLabel->"In[53]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(feasiblemnet0[net_mnet]\  := \ 
        Block[\ {fn, fr, x}, \[IndentingNewLine]fr\  = \ 
            reactions@net; \[IndentingNewLine]fn\  = \ 
            makemnet[\ fr, \ 
              Map[R, Range@\(Length@fr\)]]; \[IndentingNewLine]fn\  = \ 
            fluxsimp[fn, False]; \[IndentingNewLine]fn\  = \ 
            Cases[tags@fn, \ R[x_]\  \[Rule] x, {0, \[Infinity]}]\  // 
              Union; \[IndentingNewLine]makemnet[
            fr[\([fn]\)], \ \((tags@
                  net)\)[\([fn]\)]]\[IndentingNewLine]];\)\), "\n", 
    \(\(feasiblemnet[net_mnet]\  := \ 
        Block[\ {fn, tgs, keep}, \ 
          Module[{myRx}, \[IndentingNewLine]\ 
            fn\  = \ feasiblemnet0[
                addexchanges[net, myRx]]; \[IndentingNewLine]tgs\  = \ 
              tags[fn]; \[IndentingNewLine]keep\  = \ 
              Complement[Range[Length[tgs]], \ 
                iwith[myRx, tgs]]; \[IndentingNewLine]submnet[fn, 
              keep\ ]]];\)\)}], "Input",
  CellLabel->"In[56]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(myRx\\)\\\" is similar to existing symbol \\\
\"\\!\\(mRx\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[56]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the flux cone", "SectionFirst",
  InitializationCell->True],

Cell[BoxData[{
    \(\(ALTexp[sf_]\  := \ 
        Block[{first, trans}, \[IndentingNewLine]first\  = \ 
            Cases[sf\  // Expand, ALT[__], {0, 2}]\ ; \[IndentingNewLine]If[\ 
            first\  \[Equal] \ \ {}, \ 
            Return[{sf}]]; \[IndentingNewLine]first\  = \ 
            First[first]; \[IndentingNewLine]trans\  = \ 
            List @@ first; \[IndentingNewLine]{\((sf\  /. \ 
                  first\  \[Rule] \ trans)\)\  // 
              Expand}\[IndentingNewLine]];\)\), "\[IndentingNewLine]", 
    \(ALTexp[sf_List]\  := \ Map[ALTexp, sf] // Flatten; 
    ALTexpfull[sf_]\  := \ FixedPoint[ALTexp, sf];\)}], "Input",
  CellLabel->"In[58]:=",
  InitializationCell->True],

Cell[BoxData[{
    \(\(symflux[net_mnet, \ elvsorgset_]\  := \ 
        Block[{t, m, nrev, res}, \[IndentingNewLine]t\  = \ 
            fluxsimp[addexchanges[net], False]; \[IndentingNewLine]{m, 
              nrev}\  = \ mnet2stoich[t]; \[IndentingNewLine]If[
            m\  \[Equal] \ {{}}, \ 
            Return[{{}, 0}]]; \[IndentingNewLine]{res\ , nrev}\  = \ 
            elvsorgset[m, nrev]; \[IndentingNewLine]res\  = \ 
            Map[\((#/gcd @@ #)\) &, res]; \[IndentingNewLine]res\  = \ 
            res . tags[t]\  // Expand; \[IndentingNewLine]res\  = \ 
            Map[ALTexpfull, res]; \[IndentingNewLine]nrev\  = \ 
            Plus @@ Map[Length, 
                res[\([nrev\  // 
                      Range]\)]\ ]; \[IndentingNewLine]res\  = \
\[IndentingNewLine]\ 
            Map[\[IndentingNewLine]\ 
              Expand[#/
                    gcd @@ \((Cases[#, 
                          x_. \ y_ /; \ NumberQ[x] \[Rule] 
                            x, {1}])\)] &, \ \[IndentingNewLine]\ 
              res // Flatten]; \[IndentingNewLine]{res\ , 
            nrev}];\)\), "\[IndentingNewLine]", 
    \(\(symfluxelvs[net_mnet]\  := \ 
        symflux[net, fluxelvs];\)\), "\[IndentingNewLine]", 
    \(\(symfluxgset[net_mnet]\  := \ symflux[net, fluxgset];\)\)}], "Input",
  CellLabel->"In[18]:=",
  InitializationCell->True],

Cell[BoxData[{
    \(\(factorsof[names_List, sum_]\  := \ 
        Block[\ {sum0, res}, \ 
          Module[\ {zero}, \[IndentingNewLine]sum0\  = \ 
              sum\  /. \ Map[\((#\  \[Rule] \ 0)\) &, 
                  names]; \[IndentingNewLine]res\  = \ 
              Expand[sum\  - \ sum0\  + zero]; \[IndentingNewLine]res\ \  = \ 
              res\ \  /. \[IndentingNewLine]Join[\ {zero\  \[Rule] \ 
                      Table[0, {Length@
                            names}]}, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \
MapThread[Rule, {names\ , 
                      IdentityMatrix@\(Length@
                          names\)}]]\[IndentingNewLine]]];\)\), "\
\[IndentingNewLine]", 
    \(factorsof[name_, sum_List]\  := \ \ factorsof[{name}, sum]\  // 
        Flatten; 
    factorsof[name_, sum_]\  := \ \ factorsof[{name}, sum]\  // 
        First;\)}], "Input",
  CellLabel->"In[63]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplifications that preserve the conversion cone", "SectionFirst",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(fixrevints[mnet[{}, {}]]\  := \ mnet[{}, {}]; 
    fixrevints[net_mnet]\  := \ 
      Block[\ {m, nrev, rrnew, i, combs, maxint, drop, 
          keep}, \[IndentingNewLine]msg["\<fixrevints\>"]; \
\[IndentingNewLine]{m, nrev}\  = \ 
          mnet2stoich[net]; \ \[IndentingNewLine]m\  = \ 
          Join[m, {tags[net]}]; \[IndentingNewLine]maxint\  = \ \ iwith[Int, 
              metabolites[net]] // Length; \[IndentingNewLine]m = \ 
          revsimpint[m, nrev, maxint]; \[IndentingNewLine]rrnew\  = \ 
          stoich2reacs[Drop[m, \(-1\)], metabolites[net], 
            nrev]; \ \[IndentingNewLine]combs\  = \ 
          Expand[Last[m]]\ ; \[IndentingNewLine]makemnet[rrnew, combs] // 
          fixdeadend];\), "\[IndentingNewLine]", 
    \(revsimpint[m_, nrev_, maxpiv_]\  := \ 
      Block[\ {mmT, l, k, piv, i, vli, vki, 
          nrm}, \ \[IndentingNewLine]mmT\  = \ 
          Trp[m]; \[IndentingNewLine]For[\ l\  = 1, \ 
          l\  \[LessEqual] \ nrev, \ \(l++\), \[IndentingNewLine]vl\  = \ 
            mmT[\([l]\)]; \[IndentingNewLine]piv\  = \ 
            Position[vl, \ x_\  /; x\  \[NotEqual] 0, {1}]\  // 
              Flatten; \ \[IndentingNewLine]piv\  = \ 
            Cases[piv, 
              x_\  /; \ x\  \[LessEqual] \ maxpiv]; \[IndentingNewLine]If[\ 
            Length[piv]\ \  > \ \ 0, \[IndentingNewLine]i\  = \ 
              First[piv]; \[IndentingNewLine]For[k\  = \ l + 1, \ 
              k \[LessEqual] \ 
                Length[mmT], \ \(k++\), \ \[IndentingNewLine]vk\  = \ 
                mmT[\([k]\)]; \ \[IndentingNewLine]If[
                vk[\([i]\)]\  \[NotEqual] \ 
                  0, \ \[IndentingNewLine]{vli, 
                    vki}\  = \ {vl[\([i]\)], vk[\([i]\)]\ }/
                    GCD[vl[\([i]\)], vk[\([i]\)]]; \[IndentingNewLine]vk\  = 
                  Expand[Sign[\(-vki\)\ vli] Abs[vki]\ vl\  + 
                      Abs[vli] vk\ ]; \ \[IndentingNewLine]mmT[\([k]\)]\  = \ 
                  vk/gcd @@ 
                      Drop[vk, \(-1\)];\[IndentingNewLine]]]]]; \
\[IndentingNewLine]Trp[mmT]]\), "\[IndentingNewLine]", 
    \(\)}], "Input",
  CellLabel->"In[65]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(drop\\)\\\" is similar to existing symbol \\\
\"\\!\\(Drop\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[65]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(convsimp[net_mnet\ ]\  := \ 
        Block[{snet, keep, tgs}, 
          Module[{myRx}, \[IndentingNewLine]snet = \ 
              fluxsimp[addexchanges[net, myRx], True]\  // 
                fixrevints; \[IndentingNewLine]snet = 
              FixedPoint[fixsingles[#, True] &, 
                snet]; \[IndentingNewLine]tgs\  = \ 
              tags[snet]; \[IndentingNewLine]keep\  = \ 
              Complement[Range[Length[tgs]], \ 
                iwith[myRx, tgs]]; \[IndentingNewLine]submnet[snet, 
              keep\ ]\[IndentingNewLine]]];\)\)], "Input",
  CellLabel->"In[67]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(snet\\)\\\" is similar to existing symbols \
\\!\\({inet, mnet, net}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[67]:="]
}, Open  ]],

Cell[BoxData[{
    \(\(nonredl[vecl_]\ \  := \ 
        Block[\ {keep, K, i, j, opt, l, m, box, constr, 
            v}, \[IndentingNewLine]keep\  = \ 
            Range[Length[vecl]]; \[IndentingNewLine]red\  = \ 
            True; \[IndentingNewLine]For[j\  = \ Length[vecl], \ 
            j\  \[GreaterEqual] \ 1, \ \(j--\), \[IndentingNewLine]If[
              red, \ \[IndentingNewLine]K\  = \ 
                NullSpace[Trp[vecl[\([keep]\)]]] // 
                  Trp; \ \[IndentingNewLine]If[\ K\  \[Equal] {}, \ 
                Return[keep]]; \[IndentingNewLine]{m, l}\  = \ 
                Dimensions[K]; \ \[IndentingNewLine]red = 
                False]; \[IndentingNewLine]opt\  = \ 
              K[\([j]\)]; \[IndentingNewLine]box\  = \ \ Table[{\(-1\), 
                  1}, {i, l}]; \[IndentingNewLine]constr\  = \ 
              Table[{0, 1}, {i, 
                  m}]; \[IndentingNewLine]constr[\([j]\)]\  = \ {0, \(-1\)}; \
\[IndentingNewLine]\ 
            v = LinearProgramming[opt, K // N, constr, box\ , 
                Method \[Rule] InteriorPoint]; \ \[IndentingNewLine]\ 
            If[\[Not] VectorQ[\ v, NumericQ]\ , \ msg[{"\<nonredl x\>", j}]; 
              v\  = \ \(-opt\)]; \[IndentingNewLine]\ 
            If[\ opt . v \[LessEqual] \ \(-0.0003\), \[IndentingNewLine]\ 
              v = LinearProgramming[opt, K, constr, box\ , 
                  Method \[Rule] RevisedSimplex]; 
              If[\[Not] VectorQ[\ v, NumericQ], \ 
                v\  = \ 0\ opt]; \[IndentingNewLine]vv = \ 
                K . v; \[IndentingNewLine]cv\  = \ 
                vv . vecl[\([keep]\)]; \[IndentingNewLine]vv[\([j]\)] = \
\(-vv[\([j]\)]\); \[IndentingNewLine]red\  = \ \((vv[\([j]\)]\ \  > \ 
                      0)\)\  && \ \((cv\  \[Equal] \ 
                      0\ cv)\)\  && \((Min[vv]\  \[GreaterEqual] \ 
                      0)\); \[IndentingNewLine]If[
                red, \[IndentingNewLine]keep\  = 
                  Drop[keep, {j}]; \[IndentingNewLine]msg[{"\<nonredl\>", j, 
                    Length[keep]}]]];\[IndentingNewLine]]; \
\[IndentingNewLine]keep];\)\), "\[IndentingNewLine]", 
    \(\(nonredmnet[mnet[{}, {}]]\  := \ 
        mnet[{}, {}];\)\), "\[IndentingNewLine]", 
    \(\(nonredmnet[net__mnet]\  := \ 
        Block[\ {inet, mreac, nrev, keep, 
            nnrev}, \[IndentingNewLine]inet\  = \ 
            irrevmnet[net]; \[IndentingNewLine]{mreac, nrev}\  = \ 
            mnet2stoich[inet]; \[IndentingNewLine]keep\  = \ 
            nonredl[Trp[mreac]]; \[IndentingNewLine]revmnet[
            submnet[inet, keep]]];\)\)}], "Input",
  CellLabel->"In[68]:=",
  InitializationCell->True],

Cell[BoxData[
    \(\(convfullsimp[net_mnet\ ]\ \  := \[IndentingNewLine]FixedPoint[
          Composition[nonredmnet, convsimp], net];\)\)], "Input",
  CellLabel->"In[71]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculating the conversion cone", "SectionFirst",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(conversions[mnet[{}, {}], _]\  := \ 
        mnet[{}, {}];\)\), "\[IndentingNewLine]", 
    \(\(conversions[net_mnet\ , ZH2gsetorelvs_\ ]\  := \ 
        Block[\ {m, nrev, dg, drev, intnum, xtmet, id, newconstr, 
            oprun}, \[IndentingNewLine]{m, nrev}\  = \ 
            mnet2stoich[net]; \[IndentingNewLine]m\  = \ 
            Trp[m]; \[IndentingNewLine]{dg, drev}\  = \ 
            ZH2gset[Take[m, nrev], 
              Drop[m, nrev]]; \[IndentingNewLine]intnum\  = \ 
            iwith[Int, metabolites[net]]\  // 
              Length; \[IndentingNewLine]xtmet\  = \ 
            Drop[metabolites[net], intnum]; \[IndentingNewLine]dg\  = \ 
            Map[Drop[#, intnum] &, dg]; \[IndentingNewLine]dg\  = \ 
            Map[\((#/\((gcd @@ #)\))\) &, dg]; \[IndentingNewLine]id\  = \ 
            IdentityMatrix[
              Length[xtmet]]; \[IndentingNewLine]newconstr\  = \ \
\((\(-id[\([iwith[Xtin, xtmet]]\)]\))\) \[Union] 
              id[\([iwith[Xtout, xtmet]]\)]; \[IndentingNewLine]dg\  = \ 
            Join[dg, newconstr]; \[IndentingNewLine]oprun\  = \ pruning; \ 
          pruning\  = \ 
            intnum\  > \ 0; \[IndentingNewLine]{dg, 
              drev}\ \  = \[IndentingNewLine]\ 
            If[dg\ \  \[NotEqual] \ {}, 
              ZH2gsetorelvs\ [Take[dg, drev], 
                Drop[dg, 
                  drev]], \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ {id, Length[id]}]; \[IndentingNewLine]pruning\  = \ 
            oprun; \[IndentingNewLine]dg\  = \ 
            Map[\((#/\((gcd @@ #)\))\) &, 
              dg]; \[IndentingNewLine]makemnet[\[IndentingNewLine]\
stoich2reacs[Trp[dg], xtmet, 
              drev], \[IndentingNewLine]MapIndexed[\((\(Unique[
                      dummy]\)[#2])\) &, 
              dg]]\[IndentingNewLine]];\)\)}], "Input",
  CellLabel->"In[72]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(drev\\)\\\" is similar to existing symbol \\\
\"\\!\\(nrev\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[72]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(partialconversions[mnet[{}, {}], _List]\  := \ mnet[{}, {}]; 
    partialconversions[net_mnet\ , \ intmets_List]\  := \ 
      Block[\[IndentingNewLine]{metas, iintmets, effxt, teffxt, part, rest, 
          pc}, \[IndentingNewLine]metas\  = \ 
          metabolites[net]; \[IndentingNewLine]iintmets\  = \ 
          with[Int, metas]\  \[Intersection] \ 
            intmets; \[IndentingNewLine]{part, rest}\  = \ 
          splitmnet[net, iintmets]; \[IndentingNewLine]effxt\  = \ 
          Complement[metabolites[part], 
            iintmets]; \[IndentingNewLine]teffxt\ \  = \ 
          effxt\  /. \ 
            meta[a_, b_, c_]\  \[Rule] \ 
              meta[Xt[ToString[a]], b, c]; \[IndentingNewLine]part\  = \ 
          part\  /. \ MapThread[
              Rule, {effxt, teffxt}]; \[IndentingNewLine]pc\  = \ 
          conversions[part, ZH2gset]\  /. \ \ MapThread[
              Rule, {teffxt, effxt}]; \[IndentingNewLine]joinmnet[pc, 
          rest]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)\(\
\[IndentingNewLine]\)
    \)\)], "Input",
  CellLabel->"In[74]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(iintmets\\)\\\" is similar to existing \
symbol \\\"\\!\\(intmets\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[74]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(teffxt\\)\\\" is similar to existing symbol \
\\\"\\!\\(effxt\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[74]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(part\\)\\\" is similar to existing symbols \
\\!\\({Apart, Part, pat}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[74]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(rest\\)\\\" is similar to existing symbols \
\\!\\({res, Rest}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[74]:="]
}, Open  ]],

Cell[BoxData[{
    \(\(conversiongset[net_mnet]\  := \ 
        conversions[convfullsimp[net], ZH2gset]\  // reactions;\)\), "\n", 
    \(\(conversionelvs[net_mnet]\  := \ 
        conversions[convfullsimp[net], ZH2elvs]\  // reactions;\)\)}], "Input",\

  CellLabel->"In[75]:=",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["FBA", "SectionFirst",
  InitializationCell->True],

Cell[BoxData[
    \(\(FBAsimp[
          net_mnet, {simplification_, 
            exchonly_\ }]\  := \ \[IndentingNewLine]Block[\ {res, tgs, 
            keep}, \ Module[\ {myRx}, \[IndentingNewLine]If[
              simplification\  \[Equal] \ 0, \ 
              Return[net]]; \[IndentingNewLine]res\  = 
              addexchanges[net, 
                myRx]; \[IndentingNewLine]If[\[Not] exchonly, \
\[IndentingNewLine]res\  = \ \ FixedPoint[fixdeadend, 
                  res]; \[IndentingNewLine]If[simplification\  > \ 1, \ 
                res\  = \ \ feasiblemnet0[
                    res]];\[IndentingNewLine], \[IndentingNewLine]If[
                simplification\  \[Equal] \ 
                  1, \[IndentingNewLine]\ \ \ \ res\  = \ 
                  FixedPoint[fixdeadend, 
                    fixduplicates@res]\ ; \[IndentingNewLine]\ \ \ \ res = 
                  fixrevints@
                    FixedPoint[fixsingles[#, True] &, 
                      res]\[IndentingNewLine]]; \[IndentingNewLine]If[
                simplification\  == \ 2, \[IndentingNewLine]\ \ res\ \  = \ 
                  fluxsimp[res, True]; \ \[IndentingNewLine]\ \ res\  = 
                  FixedPoint[fixsingles[#, True] &, \ 
                    fixrevints@
                      res]\[IndentingNewLine]]; \[IndentingNewLine]If[
                simplification\  > \ 
                  2, \[IndentingNewLine]\ \ \ \ \(res = 
                    convfullsimp[
                      net];\)\[IndentingNewLine]];\[IndentingNewLine]]; \
\[IndentingNewLine]tgs\  = \ tags[res]; \[IndentingNewLine]keep\  = \ 
              Complement[Range[Length[tgs]], \ 
                iwith[myRx, tgs]]; \[IndentingNewLine]res = 
              submnet[res, keep\ ]; \[IndentingNewLine]msg[{"\<FBAsimp\>", \ 
                Length@\(reactions@res\), 
                Length@\(metabolites@
                    res\)}]; \
\[IndentingNewLine]res\[IndentingNewLine]]];\)\)], "Input",
  CellLabel->"In[77]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Options[
          FBAprep]\  = \ {simplification\  \[Rule] \ 
            1, \ \ exchonly\  \[Rule] \ False, \ 
          numeric\  \[Rule] \ False};\)\), "\[IndentingNewLine]", 
    \(\(FBAprep[inet_mnet, \ 
          opts___]\  := \ \[IndentingNewLine]Block[\ {m, nrev, ints, Kint, 
            extmat, rconstr, mconstr, extmet, tmp, 
            xlat, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ simplification\
\ , \ exchonly\ , \ numeric, 
            net}, \[IndentingNewLine]{simplification\ , exchonly\ , \ 
              numeric}\  = \ \[IndentingNewLine]\({simplification\ , \ 
                  exchonly\ , \ numeric}\ \  /. \ {opts}\)\  /. \ 
              Options[FBAprep]; \[IndentingNewLine]net\  = \ 
            FBAsimp[inet, {simplification\ , \ 
                exchonly\ }]; \[IndentingNewLine]{m, nrev}\  = \ 
            mnet2stoich[net]; \[IndentingNewLine]ints\  = \ 
            iwith[Int, metabolites@net]; \[IndentingNewLine]Kint\  = \ 
            NullSpace[\ m[\([ints]\)]\ ] // 
              Trp; \[IndentingNewLine]extmet\  = \ 
            with[{Xt, Xtin, Xtout}, 
              metabolites@net]\ ; \[IndentingNewLine]extmat\  = \ 
            m[\([\ iwith[{Xt, Xtin, Xtout}, metabolites@net]\ \ ]\)] . 
              Kint; \[IndentingNewLine]tmp\  = \ 
            iwith[Xtin, 
              extmet]; \[IndentingNewLine]extmat[\([tmp]\)]\  = \ \
\(-extmat[\([tmp]\)]\); \[IndentingNewLine]rconstr\  = \ 
            Join[Table[\ {\(-\[Infinity]\), \[Infinity]}, {nrev}], 
              Table[\ {0, \[Infinity]}, {Length[Kint] - 
                    nrev}]]; \[IndentingNewLine]mconstr\  = \(extmet\  /. \ \ \
meta[Xt, _, _]\  \[Rule] \ {\(-\[Infinity]\), \[Infinity]}\)\  /. \ 
              meta[_, _, _]\  \[Rule] \ \ \ {0, \[Infinity]}; \
\[IndentingNewLine]xlat\  = \ 
            Join[tags@net, exch[extmet]]; \[IndentingNewLine]xlat\  = \ 
            MapThread[
              Rule, {xlat, Range@\(Length@xlat\)}]; \[IndentingNewLine]{net, 
            Join[Kint, extmat], Join[rconstr, mconstr], xlat, 
            numeric}];\)\)}], "Input",
  CellLabel->"In[78]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(rconstr\\)\\\" is similar to existing symbol \
\\\"\\!\\(constr\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[78]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(mconstr\\)\\\" is similar to existing \
symbols \\!\\({constr, rconstr}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[78]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(extmet\\)\\\" is similar to existing symbols \
\\!\\({extmat, xtmet}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[78]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(FBA::"\<Objective Reaction\>"\  = \ "\<`1` not found\>";\)\), "\
\[IndentingNewLine]", 
    \(\(FBA::"\<Infeasible constraints\>"\  = \ "\<`1`, ignored\>";\)\), "\
\[IndentingNewLine]", 
    \(\(FBA[\ {net_mnet, K_, dconstr_, xlat_, 
            numeric_}, \[IndentingNewLine]\ \ \ \ \ \ \ \ fac_. \ opt_R\  | \ \
\ fac_. \ opt_Rx, \[IndentingNewLine]\ \ \ \ \ \ \ \ constr_]\  \
:= \[IndentingNewLine]\ 
        Block[\ {nconstr, a, b, c, Constr, optv, lpm, lpb, nontriv, eqs, 
            ineqs, res, infeas, infeas1}, \[IndentingNewLine]\ 
          nconstr\  = \ constr\  /. \ xlat; \[IndentingNewLine]infeas\  = \ 
            DeleteCases[
              nconstr, {_Integer, _}]; \[IndentingNewLine]infeas1\  = \ 
            infeas\  /. \ {a_, {b_, c_}}\ \  \[RuleDelayed] \((\ 
                  b\  \[LessEqual] \ 0\  \[LessEqual] 
                    c)\); \[IndentingNewLine]infeas1\  = \ 
            iwith[False, infeas1]; \[IndentingNewLine]If[\ 
            infeas1\  \[NotEqual] \ {}, \ 
            Message[FBA::"\<Infeasible constraints\>", 
              infeas[\([infeas1]\)]]]; \ \[IndentingNewLine]\ 
          nconstr\  = \ 
            Cases[nconstr, {_Integer, _}] // Trp; \[IndentingNewLine]\ 
          Constr\  = \ dconstr; \ \[IndentingNewLine]If[
            constr\  \[NotEqual] \ {}, \ 
            Constr[\([First@nconstr]\)]\  = \ 
              Last@nconstr]; \[IndentingNewLine]eqs\  = \ 
            Position[Constr, {a_, a_}, {1}]\  // 
              Flatten; \[IndentingNewLine]ineqs\  = \ 
            Complement[Range@\(Length@Constr\), 
              eqs]; \[IndentingNewLine]lpm\  = \ 
            Join[K[\([eqs]\)], K[\([ineqs]\)], 
              K[\([ineqs]\)]]; \[IndentingNewLine]lpb\  = \ 
            Join[\ \[IndentingNewLine]\ 
              Constr[\([eqs]\)]\ \ \ \ \ \  /. \ {a_, a_}\  \[Rule] \ {a, 
                    0}, \[IndentingNewLine]\ 
              Constr[\([ineqs]\)]\  /. \ {a_, b_}\  \[Rule] \ {a, 
                    1}, \ \[IndentingNewLine]Constr\ [\([ineqs]\)]\  /. \ \
{a_, b_}\  \[Rule] \ {b, \(-1\)}]; \[IndentingNewLine]nontriv = 
            Position[
              lpb, \ {a_, b_} /; \ 
                a\ b\  \[NotEqual] \(-\[Infinity]\), {1}]; \
\[IndentingNewLine]lpm\  = \ 
            Extract[lpm, nontriv]; \[IndentingNewLine]lpb\  = \ 
            Extract[lpb, nontriv]; \[IndentingNewLine]optv\  = \ \ opt\  /. \ 
              xlat; \[IndentingNewLine]If[\[Not] IntegerQ[
                optv], \[IndentingNewLine]Message[
              FBA::"\<Objective Reaction\>", opt]; \ 
            Return[$Failed]]; \[IndentingNewLine]optv\  = \ \(-fac\)\ K[\([\ 
                  optv]\)]; \[IndentingNewLine]res = 
            If[numeric, \[IndentingNewLine]LinearProgramming[optv, lpm // N, 
                lpb, \(-\[Infinity]\) + 
                  0  First[lpm]], \[IndentingNewLine]LinearProgramming[optv, 
                lpm, \ \ \ \ \ \ \ \ \ \ lpb, \(-\[Infinity]\) + 
                  0  First[lpm], 
                Method \[Rule] 
                  RevisedSimplex]\[IndentingNewLine]]; \
\[IndentingNewLine]{\(-\((optv . res)\)\)/fac, 
            Map[First, xlat] . \((K . res)\) // 
              Expand}\[IndentingNewLine]];\)\)}], "Input",
  CellLabel->"In[80]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(nconstr\\)\\\" is similar to existing \
symbols \\!\\({constr, dconstr, mconstr, rconstr}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[80]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(Constr\\)\\\" is similar to existing symbol \
\\\"\\!\\(constr\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[80]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(optv\\)\\\" is similar to existing symbols \
\\!\\({opt, opts}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[80]:="]
}, Open  ]],

Cell[BoxData[
    \(\(EndPackage[];\)\)], "Input",
  CellLabel->"In[83]:=",
  InitializationCell->True]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{874, 768},
WindowMargins->{{197, Automatic}, {0, Automatic}},
StyleDefinitions -> "ArticleClassic.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 226, 5, 60, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2005, 60, 257, 5, 44, "Input",
  InitializationCell->True],
Cell[2265, 67, 139, 3, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2441, 75, 57, 1, 61, "SectionFirst",
  InitializationCell->True],
Cell[2501, 78, 210, 5, 60, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2736, 87, 407, 8, 76, "Input",
  InitializationCell->True],
Cell[3146, 97, 385, 6, 21, "Message"]
}, Open  ]],
Cell[3546, 106, 175, 4, 44, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3746, 114, 159, 4, 28, "Input",
  InitializationCell->True],
Cell[3908, 120, 384, 6, 21, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4341, 132, 94, 1, 61, "SectionFirst",
  InitializationCell->True],
Cell[4438, 135, 1426, 29, 332, "Input",
  InitializationCell->True],
Cell[5867, 166, 1182, 28, 108, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7086, 199, 74, 1, 61, "SectionFirst",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7185, 204, 125, 3, 28, "Input",
  InitializationCell->True],
Cell[7313, 209, 387, 6, 21, "Message"]
}, Open  ]],
Cell[7715, 218, 442, 10, 92, "Input",
  InitializationCell->True],
Cell[8160, 230, 491, 10, 92, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[8676, 244, 971, 19, 204, "Input",
  InitializationCell->True],
Cell[9650, 265, 387, 6, 21, "Message"]
}, Open  ]],
Cell[10052, 274, 1117, 22, 156, "Input",
  InitializationCell->True],
Cell[11172, 298, 1029, 18, 188, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[12226, 320, 2443, 44, 380, "Input",
  InitializationCell->True],
Cell[14672, 366, 391, 6, 21, "Message"]
}, Open  ]],
Cell[15078, 375, 1370, 27, 316, "Input",
  InitializationCell->True],
Cell[16451, 404, 803, 16, 140, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[17279, 424, 1310, 25, 236, "Input",
  InitializationCell->True],
Cell[18592, 451, 384, 6, 21, "Message"],
Cell[18979, 459, 384, 6, 21, "Message"],
Cell[19366, 467, 391, 6, 21, "Message"]
}, Open  ]],
Cell[19772, 476, 663, 12, 124, "Input",
  InitializationCell->True],
Cell[20438, 490, 334, 7, 60, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20809, 502, 95, 1, 61, "SectionFirst",
  InitializationCell->True],
Cell[20907, 505, 2720, 49, 444, "Input",
  InitializationCell->True],
Cell[23630, 556, 3158, 58, 668, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[26813, 618, 2430, 46, 476, "Input",
  InitializationCell->True],
Cell[29246, 666, 388, 6, 21, "Message"],
Cell[29637, 674, 385, 6, 21, "Message"],
Cell[30025, 682, 385, 6, 21, "Message"],
Cell[30413, 690, 363, 6, 21, "Message"]
}, Open  ]],
Cell[30791, 699, 1449, 26, 300, "Input",
  InitializationCell->True],
Cell[32243, 727, 3384, 57, 572, "Input",
  InitializationCell->True],
Cell[35630, 786, 1069, 19, 220, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[36724, 809, 1055, 21, 204, "Input",
  InitializationCell->True],
Cell[37782, 832, 385, 6, 21, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38216, 844, 77, 1, 61, "SectionFirst",
  InitializationCell->True],
Cell[38296, 847, 700, 13, 156, "Input",
  InitializationCell->True],
Cell[38999, 862, 1356, 26, 268, "Input",
  InitializationCell->True],
Cell[40358, 890, 927, 19, 156, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[41322, 914, 101, 1, 61, "SectionFirst",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[41448, 919, 2201, 40, 444, "Input",
  InitializationCell->True],
Cell[43652, 961, 386, 6, 21, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44075, 972, 641, 13, 124, "Input",
  InitializationCell->True],
Cell[44719, 987, 390, 6, 21, "Message"]
}, Open  ]],
Cell[45124, 996, 2667, 47, 524, "Input",
  InitializationCell->True],
Cell[47794, 1045, 203, 4, 44, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[48034, 1054, 83, 1, 61, "SectionFirst",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[48142, 1059, 1915, 36, 380, "Input",
  InitializationCell->True],
Cell[50060, 1097, 386, 6, 21, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50483, 1108, 1134, 22, 252, "Input",
  InitializationCell->True],
Cell[51620, 1132, 393, 6, 21, "Message"],
Cell[52016, 1140, 389, 6, 21, "Message"],
Cell[52408, 1148, 391, 6, 21, "Message"],
Cell[52802, 1156, 384, 6, 21, "Message"]
}, Open  ]],
Cell[53201, 1165, 307, 7, 44, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[53545, 1177, 55, 1, 61, "SectionFirst",
  InitializationCell->True],
Cell[53603, 1180, 2016, 38, 428, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[55644, 1222, 2160, 39, 316, "Input",
  InitializationCell->True],
Cell[57807, 1263, 391, 6, 21, "Message"],
Cell[58201, 1271, 395, 7, 21, "Message"],
Cell[58599, 1280, 390, 6, 21, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59026, 1291, 3312, 61, 556, "Input",
  InitializationCell->True],
Cell[62341, 1354, 413, 7, 35, "Message"],
Cell[62757, 1363, 390, 6, 21, "Message"],
Cell[63150, 1371, 384, 6, 21, "Message"]
}, Open  ]],
Cell[63549, 1380, 103, 3, 28, "Input",
  InitializationCell->True]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

