/*
 * MATLAB Compiler: 3.0
 * Date: Thu Apr 28 14:18:20 2005
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-B"
 * "pairelvsIFmccbundle" "-t" "-W" "lib:Pkg" "-T" "link:exe" "-h" "pairelvsIF"
 * "pairelvsm.c" "libmmfile.mlib" "-M"
 * "-I/usr/local/Wolfram/Mathematica/5.0/AddOns/MathLink/DeveloperKit/Linux/Comp
 * ilerAdditions
 * -L/usr/local/Wolfram/Mathematica/5.0/AddOns/MathLink/DeveloperKit/Linux/Compi
 * lerAdditions -lML -lm" 
 */
#include "pairelvs.h"
#include "andvecmat_mex_interface.h"
#include "countbits_mex_interface.h"
#include "libmatlbm.h"
#include "libmmfile.h"
#include "nosuperset_mex_interface.h"
#include "packbituint8_mex_interface.h"
#include "unpackbit_mex_interface.h"

extern mxArray * Cov;

static mxChar _array1_[1] = { 'a' };
static mxArray * _mxarray0_;

static mxChar _array3_[1] = { 'b' };
static mxArray * _mxarray2_;

static mxChar _array5_[1] = { 'c' };
static mxArray * _mxarray4_;
static mxArray * _mxarray6_;
static mxArray * _mxarray7_;
static mxArray * _mxarray8_;
static mxArray * _mxarray9_;
static mxArray * _mxarray10_;

void InitializeModule_pairelvs(void) {
    _mxarray0_ = mclInitializeString(1, _array1_);
    _mxarray2_ = mclInitializeString(1, _array3_);
    _mxarray4_ = mclInitializeString(1, _array5_);
    _mxarray6_ = mclInitializeDouble(2.0);
    _mxarray7_ = mclInitializeDouble(0.0);
    _mxarray8_ = mclInitializeDouble(1.0);
    _mxarray9_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray10_ = mclInitializeDouble(100.0);
}

void TerminateModule_pairelvs(void) {
    mxDestroyArray(_mxarray10_);
    mxDestroyArray(_mxarray9_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray7_);
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray0_);
}

static void mlfPairelvs_Covadd(mxArray * npair, mxArray * nveczp);
static void mlxPairelvs_Covadd(int nlhs,
                               mxArray * plhs[],
                               int nrhs,
                               mxArray * prhs[]);
static mxArray * Mpairelvs(mxArray * * Sres,
                           mxArray * * MsgString,
                           int nargout_,
                           mxArray * covS,
                           mxArray * irrevfluxes,
                           mxArray * minzeroes);
static void Mpairelvs_Covadd(mxArray * npair, mxArray * nveczp);

static mexFunctionTableEntry local_function_table_[1]
  = { { "Covadd", mlxPairelvs_Covadd, 2, 0, NULL } };

_mexLocalFunctionTable _local_function_table_pairelvs
  = { 1, local_function_table_ };

/*
 * The function "mlfPairelvs" contains the normal interface for the "pairelvs"
 * M-function from file "/home/robert/pairelvs/build/pairelvs.m" (lines 1-124).
 * This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfPairelvs(mxArray * * Sres,
                      mxArray * * MsgString,
                      mxArray * covS,
                      mxArray * irrevfluxes,
                      mxArray * minzeroes) {
    int nargout = 1;
    mxArray * res = NULL;
    mxArray * Sres__ = NULL;
    mxArray * MsgString__ = NULL;
    mlfEnterNewContext(2, 3, Sres, MsgString, covS, irrevfluxes, minzeroes);
    if (Sres != NULL) {
        ++nargout;
    }
    if (MsgString != NULL) {
        ++nargout;
    }
    res
      = Mpairelvs(
          &Sres__, &MsgString__, nargout, covS, irrevfluxes, minzeroes);
    mlfRestorePreviousContext(
      2, 3, Sres, MsgString, covS, irrevfluxes, minzeroes);
    if (Sres != NULL) {
        mclCopyOutputArg(Sres, Sres__);
    } else {
        mxDestroyArray(Sres__);
    }
    if (MsgString != NULL) {
        mclCopyOutputArg(MsgString, MsgString__);
    } else {
        mxDestroyArray(MsgString__);
    }
    return mlfReturnValue(res);
}

/*
 * The function "mlxPairelvs" contains the feval interface for the "pairelvs"
 * M-function from file "/home/robert/pairelvs/build/pairelvs.m" (lines 1-124).
 * The feval function calls the implementation version of pairelvs through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
void mlxPairelvs(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[3];
    mxArray * mplhs[3];
    int i;
    if (nlhs > 3) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: pairelvs Line: 1 Column:"
            " 1 The function \"pairelvs\" was called with m"
            "ore than the declared number of outputs (3)."),
          NULL);
    }
    if (nrhs > 3) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: pairelvs Line: 1 Column:"
            " 1 The function \"pairelvs\" was called with m"
            "ore than the declared number of inputs (3)."),
          NULL);
    }
    for (i = 0; i < 3; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 3 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 3; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 3, mprhs[0], mprhs[1], mprhs[2]);
    mplhs[0]
      = Mpairelvs(&mplhs[1], &mplhs[2], nlhs, mprhs[0], mprhs[1], mprhs[2]);
    mlfRestorePreviousContext(0, 3, mprhs[0], mprhs[1], mprhs[2]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 3 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 3; ++i) {
        mxDestroyArray(mplhs[i]);
    }
}

/*
 * The function "mlfPairelvs_Covadd" contains the normal interface for the
 * "pairelvs/Covadd" M-function from file
 * "/home/robert/pairelvs/build/pairelvs.m" (lines 124-140). This function
 * processes any input arguments and passes them to the implementation version
 * of the function, appearing above.
 */
static void mlfPairelvs_Covadd(mxArray * npair, mxArray * nveczp) {
    mlfEnterNewContext(0, 2, npair, nveczp);
    Mpairelvs_Covadd(npair, nveczp);
    mlfRestorePreviousContext(0, 2, npair, nveczp);
}

/*
 * The function "mlxPairelvs_Covadd" contains the feval interface for the
 * "pairelvs/Covadd" M-function from file
 * "/home/robert/pairelvs/build/pairelvs.m" (lines 124-140). The feval function
 * calls the implementation version of pairelvs/Covadd through this function.
 * This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static void mlxPairelvs_Covadd(int nlhs,
                               mxArray * plhs[],
                               int nrhs,
                               mxArray * prhs[]) {
    mxArray * mprhs[2];
    int i;
    if (nlhs > 0) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: pairelvs/Covadd Line: 124 Colu"
            "mn: 1 The function \"pairelvs/Covadd\" was called wi"
            "th more than the declared number of outputs (0)."),
          NULL);
    }
    if (nrhs > 2) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: pairelvs/Covadd Line: 124 Col"
            "umn: 1 The function \"pairelvs/Covadd\" was called "
            "with more than the declared number of inputs (2)."),
          NULL);
    }
    for (i = 0; i < 2 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 2; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 2, mprhs[0], mprhs[1]);
    Mpairelvs_Covadd(mprhs[0], mprhs[1]);
    mlfRestorePreviousContext(0, 2, mprhs[0], mprhs[1]);
}

/*
 * The function "Mpairelvs" is the implementation version of the "pairelvs"
 * M-function from file "/home/robert/pairelvs/build/pairelvs.m" (lines 1-124).
 * It contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [res, Sres, MsgString] = pairelvs(covS,irrevfluxes,minzeroes)
 */
static mxArray * Mpairelvs(mxArray * * Sres,
                           mxArray * * MsgString,
                           int nargout_,
                           mxArray * covS,
                           mxArray * irrevfluxes,
                           mxArray * minzeroes) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_pairelvs);
    mxArray * res = NULL;
    mxArray * resneg = NULL;
    mxArray * ind = NULL;
    mxArray * t = NULL;
    mxArray * n = NULL;
    mxArray * ggcands = NULL;
    mxArray * gcands = NULL;
    mxArray * candszp = NULL;
    mxArray * posorz = NULL;
    mxArray * negorz = NULL;
    mxArray * m = NULL;
    mxArray * cancelcheck = NULL;
    mxArray * keeps = NULL;
    mxArray * numcands = NULL;
    mxArray * numggcands = NULL;
    mxArray * numgcands = NULL;
    mxArray * negpp = NULL;
    mxArray * negnp = NULL;
    mxArray * negzp = NULL;
    mxArray * nsr = NULL;
    mxArray * revp = NULL;
    mxArray * ns = NULL;
    mxArray * ps = NULL;
    mxArray * zerzp = NULL;
    mxArray * szs = NULL;
    mxArray * zs = NULL;
    mxArray * dum = NULL;
    mxArray * covpp = NULL;
    mxArray * ncount = NULL;
    mxArray * covnp = NULL;
    mxArray * zcount = NULL;
    mxArray * covzp = NULL;
    mxArray * flip2 = NULL;
    mxArray * flip1 = NULL;
    mxArray * buf = NULL;
    mxArray * revn = NULL;
    mxArray * revb = NULL;
    mxArray * k = NULL;
    mxArray * Pos = NULL;
    mxArray * Zer = NULL;
    mxArray * Neg = NULL;
    mxArray * ans = NULL;
    mclCopyArray(&covS);
    mclCopyArray(&irrevfluxes);
    mclCopyArray(&minzeroes);
    /*
     * %
     * % Author:     R.Urbanczik
     * %
     * % Inputs:  covS,  n by k uint8-array.
     * %                 covS(i, 1:k-1) encodes the signs of K\beta(i), where
     * %                 K is the old constraint matrix and the \beta(i) are
     * %                 the old elementary vectors. covS(i,k) gives the sign
     * %                 for the new constraint.
     * %          irrevfluxes, variable length indexvector such that covS(i,:)
     * %                       is reversible if covS(i,irrevfluxes) == Zer.
     * %          minzeroes, minimal number of zeroes for an elementary vector
     * %
     * % Outputs: res,  m by 2 index array,
     * %                a pair [i,j] of res give the indexes such that the old
     * %                \beta(i,:) and \beta(j,:) can be combined to form an
     * %                elementary vector of the new system.
     * %                res lists these pairs for all vectors which are elementary
     * %                in the new system, but which where not elementary in the
     * %                old one.
     * %          Sres, m by k uint8-array.
     * %                Sres(l,:) encodes the signs of the new elementary vector
     * %                obtained from the pair res(i,:).
     * %          MsgString, string with some statistics.
     * %                  
     * %
     * global Cov 
     * 
     * %  fid = fopen('/home/robert/pairelvs/build/debug','a+');
     * %  fprintf(fid,'%s\n',char(covS));
     * 
     * Neg = uint8('a'); Zer= uint8('b'); Pos = uint8('c');
     */
    mlfAssign(&Neg, mlfUint8(_mxarray0_));
    mlfAssign(&Zer, mlfUint8(_mxarray2_));
    mlfAssign(&Pos, mlfUint8(_mxarray4_));
    /*
     * k = size(covS,2);
     */
    mlfAssign(
      &k, mlfSize(mclValueVarargout(), mclVa(covS, "covS"), _mxarray6_));
    /*
     * 
     * 
     * 
     * revb = find(sum(+(covS(:,irrevfluxes) ~= Zer),2) == 0);
     */
    mlfAssign(
      &revb,
      mlfFind(
        NULL,
        NULL,
        mclEq(
          mlfSum(
            mclUplus(
              mclNe(
                mclArrayRef2(
                  mclVa(covS, "covS"),
                  mlfCreateColonIndex(),
                  mclVa(irrevfluxes, "irrevfluxes")),
                mclVv(Zer, "Zer"))),
            _mxarray6_),
          _mxarray7_)));
    /*
     * revn = revb(find((covS(revb,k) == Neg)));
     */
    mlfAssign(
      &revn,
      mclArrayRef1(
        mclVv(revb, "revb"),
        mlfFind(
          NULL,
          NULL,
          mclEq(
            mclArrayRef2(
              mclVa(covS, "covS"), mclVv(revb, "revb"), mclVv(k, "k")),
            mclVv(Neg, "Neg")))));
    /*
     * buf = covS(revn,:);
     */
    mlfAssign(
      &buf,
      mclArrayRef2(
        mclVa(covS, "covS"), mclVv(revn, "revn"), mlfCreateColonIndex()));
    /*
     * flip1 = (buf == Neg); flip2 =  (buf == Pos);
     */
    mlfAssign(&flip1, mclEq(mclVv(buf, "buf"), mclVv(Neg, "Neg")));
    mlfAssign(&flip2, mclEq(mclVv(buf, "buf"), mclVv(Pos, "Pos")));
    /*
     * buf(flip1) = Pos;     buf(flip2) = Neg;
     */
    mclArrayAssign1(&buf, mclVv(Pos, "Pos"), mclVv(flip1, "flip1"));
    mclArrayAssign1(&buf, mclVv(Neg, "Neg"), mclVv(flip2, "flip2"));
    /*
     * covS(revn,:) = buf;
     */
    mclArrayAssign2(
      &covS, mclVv(buf, "buf"), mclVv(revn, "revn"), mlfCreateColonIndex());
    /*
     * 
     * 
     * [covzp, zcount] = packbituint8(covS(:,1:(k-1)),Zer);
     */
    mlfNPackbituint8(
      0,
      mlfVarargout(&covzp, &zcount, NULL),
      mclArrayRef2(
        mclVa(covS, "covS"),
        mlfCreateColonIndex(),
        mlfColon(_mxarray8_, mclMinus(mclVv(k, "k"), _mxarray8_), NULL)),
      mclVv(Zer, "Zer"),
      NULL);
    /*
     * [covnp,ncount] = packbituint8(covS(:,1:(k-1)),Neg); 
     */
    mlfNPackbituint8(
      0,
      mlfVarargout(&covnp, &ncount, NULL),
      mclArrayRef2(
        mclVa(covS, "covS"),
        mlfCreateColonIndex(),
        mlfColon(_mxarray8_, mclMinus(mclVv(k, "k"), _mxarray8_), NULL)),
      mclVv(Neg, "Neg"),
      NULL);
    /*
     * [covpp,dum] = packbituint8(covS(:,1:(k-1)),Pos);
     */
    mlfNPackbituint8(
      0,
      mlfVarargout(&covpp, &dum, NULL),
      mclArrayRef2(
        mclVa(covS, "covS"),
        mlfCreateColonIndex(),
        mlfColon(_mxarray8_, mclMinus(mclVv(k, "k"), _mxarray8_), NULL)),
      mclVv(Pos, "Pos"),
      NULL);
    /*
     * zs = find(covS(:,k) == Zer);
     */
    mlfAssign(
      &zs,
      mlfFind(
        NULL,
        NULL,
        mclEq(
          mclArrayRef2(
            mclVa(covS, "covS"), mlfCreateColonIndex(), mclVv(k, "k")),
          mclVv(Zer, "Zer"))));
    /*
     * [dum,szs] = sort(-double(countbits(covzp(:,zs)))); 
     */
    mlfAssign(
      &dum,
      mlfSort(
        &szs,
        mclUminus(
          mlfDouble(
            mlfNCountbits(
              0,
              mclValueVarargout(),
              mclArrayRef2(
                mclVv(covzp, "covzp"), mlfCreateColonIndex(), mclVv(zs, "zs")),
              NULL))),
        NULL));
    /*
     * zs = zs(szs);
     */
    mlfAssign(&zs, mclArrayRef1(mclVv(zs, "zs"), mclVv(szs, "szs")));
    /*
     * zerzp = covzp(:,zs);
     */
    mlfAssign(
      &zerzp,
      mclArrayRef2(
        mclVv(covzp, "covzp"), mlfCreateColonIndex(), mclVv(zs, "zs")));
    /*
     * 
     * 
     * ps = find(covS(:,k) >  Zer);
     */
    mlfAssign(
      &ps,
      mlfFind(
        NULL,
        NULL,
        mclGt(
          mclArrayRef2(
            mclVa(covS, "covS"), mlfCreateColonIndex(), mclVv(k, "k")),
          mclVv(Zer, "Zer"))));
    /*
     * ns = find(covS(:,k) <  Zer);
     */
    mlfAssign(
      &ns,
      mlfFind(
        NULL,
        NULL,
        mclLt(
          mclArrayRef2(
            mclVa(covS, "covS"), mlfCreateColonIndex(), mclVv(k, "k")),
          mclVv(Zer, "Zer"))));
    /*
     * revp = revb((covS(revb,k) ~= Zer));
     */
    mlfAssign(
      &revp,
      mclArrayRef1(
        mclVv(revb, "revb"),
        mclNe(
          mclArrayRef2(mclVa(covS, "covS"), mclVv(revb, "revb"), mclVv(k, "k")),
          mclVv(Zer, "Zer"))));
    /*
     * nsr = [ns; revp];
     */
    mlfAssign(&nsr, mlfVertcat(mclVv(ns, "ns"), mclVv(revp, "revp"), NULL));
    /*
     * negzp  = covzp(:,nsr);
     */
    mlfAssign(
      &negzp,
      mclArrayRef2(
        mclVv(covzp, "covzp"), mlfCreateColonIndex(), mclVv(nsr, "nsr")));
    /*
     * negnp = [covnp(:,ns), covpp(:,revp)]; 
     */
    mlfAssign(
      &negnp,
      mlfHorzcat(
        mclArrayRef2(
          mclVv(covnp, "covnp"), mlfCreateColonIndex(), mclVv(ns, "ns")),
        mclArrayRef2(
          mclVv(covpp, "covpp"), mlfCreateColonIndex(), mclVv(revp, "revp")),
        NULL));
    /*
     * negpp = [covpp(:,ns), covnp(:,revp)];
     */
    mlfAssign(
      &negpp,
      mlfHorzcat(
        mclArrayRef2(
          mclVv(covpp, "covpp"), mlfCreateColonIndex(), mclVv(ns, "ns")),
        mclArrayRef2(
          mclVv(covnp, "covnp"), mlfCreateColonIndex(), mclVv(revp, "revp")),
        NULL));
    /*
     * covS = [];   
     */
    mlfAssign(&covS, _mxarray9_);
    /*
     * Cov.len = 0;            Cov.keepmask = false(0,1); 
     */
    mlfIndexAssign(mclPrepareGlobal(&Cov), ".len", _mxarray7_);
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".keepmask",
      mlfFalse(_mxarray7_, _mxarray8_, NULL));
    /*
     * Cov.BTp = covzp(:,[]);  Cov.cmb = zeros(2,0);
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".BTp",
      mclArrayRef2(mclVv(covzp, "covzp"), mlfCreateColonIndex(), _mxarray9_));
    mlfIndexAssign(
      mclPrepareGlobal(&Cov), ".cmb", mlfZeros(_mxarray6_, _mxarray7_, NULL));
    /*
     * 
     * %  disp(size(ps,1)*size(nsr,1));
     * numgcands = 0; numggcands = 0; numcands = 0;
     */
    mlfAssign(&numgcands, _mxarray7_);
    mlfAssign(&numggcands, _mxarray7_);
    mlfAssign(&numcands, _mxarray7_);
    /*
     * keeps = 1:length(nsr);
     */
    mlfAssign(
      &keeps,
      mlfColon(_mxarray8_, mlfScalar(mclLengthInt(mclVv(nsr, "nsr"))), NULL));
    /*
     * cancelcheck = (max(ncount) > 0) | length(revp) > 0;
     */
    mlfAssign(
      &cancelcheck,
      mclOr(
        mclGt(mlfMax(NULL, mclVv(ncount, "ncount"), NULL, NULL), _mxarray7_),
        mclBoolToArray(mclLengthInt(mclVv(revp, "revp")) > 0)));
    /*
     * 
     * 
     * for m = ps'
     */
    {
        mclForLoopIterator viter__;
        for (mclForStart(&viter__, mlfCtranspose(mclVv(ps, "ps")), NULL, NULL);
             mclForNext(&viter__, &m);
             ) {
            /*
             * if cancelcheck
             */
            if (mlfTobool(mclVv(cancelcheck, "cancelcheck"))) {
                /*
                 * negorz =  bitor(covzp(:,m),covnp(:,m));
                 */
                mlfAssign(
                  &negorz,
                  mlfBitor(
                    mclArrayRef2(
                      mclVv(covzp, "covzp"),
                      mlfCreateColonIndex(),
                      mclVv(m, "m")),
                    mclArrayRef2(
                      mclVv(covnp, "covnp"),
                      mlfCreateColonIndex(),
                      mclVv(m, "m"))));
                /*
                 * posorz =  bitor(covzp(:,m),covpp(:,m));
                 */
                mlfAssign(
                  &posorz,
                  mlfBitor(
                    mclArrayRef2(
                      mclVv(covzp, "covzp"),
                      mlfCreateColonIndex(),
                      mclVv(m, "m")),
                    mclArrayRef2(
                      mclVv(covpp, "covpp"),
                      mlfCreateColonIndex(),
                      mclVv(m, "m"))));
                /*
                 * keeps =find((~nosuperset(negorz,negnp)) & (~nosuperset(posorz,negpp)));
                 */
                mlfAssign(
                  &keeps,
                  mlfFind(
                    NULL,
                    NULL,
                    mclAnd(
                      mclNot(
                        mlfNNosuperset(
                          0,
                          mclValueVarargout(),
                          mclVv(negorz, "negorz"),
                          mclVv(negnp, "negnp"),
                          NULL)),
                      mclNot(
                        mlfNNosuperset(
                          0,
                          mclValueVarargout(),
                          mclVv(posorz, "posorz"),
                          mclVv(negpp, "negpp"),
                          NULL)))));
                /*
                 * numcands =  numcands+length(keeps);
                 */
                mlfAssign(
                  &numcands,
                  mclPlus(
                    mclVv(numcands, "numcands"),
                    mlfScalar(mclLengthInt(mclVv(keeps, "keeps")))));
            /*
             * end;
             */
            }
            /*
             * candszp = andvecmat(covzp(:,m),negzp(:,keeps)); 
             */
            mlfAssign(
              &candszp,
              mlfNAndvecmat(
                0,
                mclValueVarargout(),
                mclArrayRef2(
                  mclVv(covzp, "covzp"), mlfCreateColonIndex(), mclVv(m, "m")),
                mclArrayRef2(
                  mclVv(negzp, "negzp"),
                  mlfCreateColonIndex(),
                  mclVv(keeps, "keeps")),
                NULL));
            /*
             * gcands = find( countbits(candszp) >= minzeroes-1);
             */
            mlfAssign(
              &gcands,
              mlfFind(
                NULL,
                NULL,
                mclGe(
                  mlfNCountbits(
                    0, mclValueVarargout(), mclVv(candszp, "candszp"), NULL),
                  mclMinus(mclVa(minzeroes, "minzeroes"), _mxarray8_))));
            /*
             * numgcands = numgcands + length(gcands);
             */
            mlfAssign(
              &numgcands,
              mclPlus(
                mclVv(numgcands, "numgcands"),
                mlfScalar(mclLengthInt(mclVv(gcands, "gcands")))));
            /*
             * ggcands = gcands(nosuperset(zerzp,candszp(:,gcands)));
             */
            mlfAssign(
              &ggcands,
              mclArrayRef1(
                mclVv(gcands, "gcands"),
                mlfNNosuperset(
                  0,
                  mclValueVarargout(),
                  mclVv(zerzp, "zerzp"),
                  mclArrayRef2(
                    mclVv(candszp, "candszp"),
                    mlfCreateColonIndex(),
                    mclVv(gcands, "gcands")),
                  NULL)));
            /*
             * numggcands = numggcands + length(ggcands);  
             */
            mlfAssign(
              &numggcands,
              mclPlus(
                mclVv(numggcands, "numggcands"),
                mlfScalar(mclLengthInt(mclVv(ggcands, "ggcands")))));
            /*
             * for n = ggcands'
             */
            {
                mclForLoopIterator viter__0;
                for (mclForStart(
                       &viter__0,
                       mlfCtranspose(mclVv(ggcands, "ggcands")),
                       NULL,
                       NULL);
                     mclForNext(&viter__0, &n);
                     ) {
                    /*
                     * t = candszp(:,n); 
                     */
                    mlfAssign(
                      &t,
                      mclArrayRef2(
                        mclVv(candszp, "candszp"),
                        mlfCreateColonIndex(),
                        mclVv(n, "n")));
                    /*
                     * if nosuperset(Cov.BTp,t)
                     */
                    if (mlfTobool(
                          mlfNNosuperset(
                            0,
                            mclValueVarargout(),
                            mlfIndexRef(mclVg(&Cov, "Cov"), ".BTp"),
                            mclVv(t, "t"),
                            NULL))) {
                        /*
                         * Covadd([m,keeps(n)],t); 
                         */
                        mlfPairelvs_Covadd(
                          mlfHorzcat(
                            mclVv(m, "m"),
                            mclArrayRef1(mclVv(keeps, "keeps"), mclVv(n, "n")),
                            NULL),
                          mclVv(t, "t"));
                    /*
                     * end
                     */
                    }
                /*
                 * end;
                 */
                }
                mclDestroyForLoopIterator(viter__0);
            }
        /*
         * end; 
         */
        }
        mclDestroyForLoopIterator(viter__);
    }
    /*
     * Cov.cmb  = Cov.cmb(:,Cov.keepmask);
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".cmb",
      mlfIndexRef(
        mclVg(&Cov, "Cov"),
        ".cmb(?,?)",
        mlfCreateColonIndex(),
        mlfIndexRef(mclVg(&Cov, "Cov"), ".keepmask")));
    /*
     * Cov.BTp  = Cov.BTp(:,Cov.keepmask);
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".BTp",
      mlfIndexRef(
        mclVg(&Cov, "Cov"),
        ".BTp(?,?)",
        mlfCreateColonIndex(),
        mlfIndexRef(mclVg(&Cov, "Cov"), ".keepmask")));
    /*
     * Cov.len = size(Cov.BTp,2);
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".len",
      mclFeval(
        mclValueVarargout(),
        mlxSize,
        mlfIndexRef(mclVg(&Cov, "Cov"), ".BTp"),
        _mxarray6_,
        NULL));
    /*
     * if Cov.len == 0 
     */
    if (mlfTobool(
          mclFeval(
            mclValueVarargout(),
            mlxEq,
            mlfIndexRef(mclVg(&Cov, "Cov"), ".len"),
            _mxarray7_,
            NULL))) {
        /*
         * Cov.BTp = covzp(:,[]);  Cov.cmb = zeros(2,0);
         */
        mlfIndexAssign(
          mclPrepareGlobal(&Cov),
          ".BTp",
          mclArrayRef2(
            mclVv(covzp, "covzp"), mlfCreateColonIndex(), _mxarray9_));
        mlfIndexAssign(
          mclPrepareGlobal(&Cov),
          ".cmb",
          mlfZeros(_mxarray6_, _mxarray7_, NULL));
    /*
     * end  
     */
    }
    /*
     * 
     * if ~cancelcheck
     */
    if (mclNotBool(mclVv(cancelcheck, "cancelcheck"))) {
        /*
         * numcands = size(ps,1)*size(nsr,1);
         */
        mlfAssign(
          &numcands,
          mclMtimes(
            mlfSize(mclValueVarargout(), mclVv(ps, "ps"), _mxarray8_),
            mlfSize(mclValueVarargout(), mclVv(nsr, "nsr"), _mxarray8_)));
    /*
     * end;
     */
    }
    /*
     * MsgString = ...
     */
    mlfAssign(
      MsgString,
      mlfNum2str(
        mlfHorzcat(
          mlfSize(mclValueVarargout(), mclVv(zerzp, "zerzp"), _mxarray6_),
          mclVv(numcands, "numcands"),
          mclVv(numgcands, "numgcands"),
          mclVv(numggcands, "numggcands"),
          mlfIndexRef(mclVg(&Cov, "Cov"), ".len"),
          NULL),
        NULL));
    /*
     * num2str([size(zerzp,2), numcands, ...
     * numgcands,numggcands,Cov.len]);
     * 
     * res = Cov.cmb;
     */
    mlfAssign(&res, mlfIndexRef(mclVg(&Cov, "Cov"), ".cmb"));
    /*
     * ind = unpackbit(Cov.BTp);
     */
    mlfAssign(
      &ind,
      mlfNUnpackbit(
        0, mclValueVarargout(), mlfIndexRef(mclVg(&Cov, "Cov"), ".BTp"), NULL));
    /*
     * ind = ind(:,1:(k-1));
     */
    mlfAssign(
      &ind,
      mclArrayRef2(
        mclVv(ind, "ind"),
        mlfCreateColonIndex(),
        mlfColon(_mxarray8_, mclMinus(mclVv(k, "k"), _mxarray8_), NULL)));
    /*
     * Sres= uint8(ind);
     */
    mlfAssign(Sres, mlfUint8(mclVv(ind, "ind")));
    /*
     * Sres( ind) = Zer;
     */
    mclArrayAssign1(Sres, mclVv(Zer, "Zer"), mclVv(ind, "ind"));
    /*
     * Sres(~ind) = Pos;
     */
    mclArrayAssign1(Sres, mclVv(Pos, "Pos"), mclNot(mclVv(ind, "ind")));
    /*
     * resneg = bitor(covnp(:,res(1,:)),negnp(:,res(2,:)));
     */
    mlfAssign(
      &resneg,
      mlfBitor(
        mclArrayRef2(
          mclVv(covnp, "covnp"),
          mlfCreateColonIndex(),
          mclArrayRef2(mclVv(res, "res"), _mxarray8_, mlfCreateColonIndex())),
        mclArrayRef2(
          mclVv(negnp, "negnp"),
          mlfCreateColonIndex(),
          mclArrayRef2(mclVv(res, "res"), _mxarray6_, mlfCreateColonIndex()))));
    /*
     * ind = unpackbit(resneg);
     */
    mlfAssign(
      &ind,
      mlfNUnpackbit(0, mclValueVarargout(), mclVv(resneg, "resneg"), NULL));
    /*
     * ind = ind(:,1:(k-1));
     */
    mlfAssign(
      &ind,
      mclArrayRef2(
        mclVv(ind, "ind"),
        mlfCreateColonIndex(),
        mlfColon(_mxarray8_, mclMinus(mclVv(k, "k"), _mxarray8_), NULL)));
    /*
     * Sres(ind) = Neg;
     */
    mclArrayAssign1(Sres, mclVv(Neg, "Neg"), mclVv(ind, "ind"));
    /*
     * Sres = [Sres, repmat(Zer,size(Sres,1),1)];
     */
    mlfAssign(
      Sres,
      mlfHorzcat(
        mclVv(*Sres, "Sres"),
        mlfRepmat(
          mclVv(Zer, "Zer"),
          mlfSize(mclValueVarargout(), mclVv(*Sres, "Sres"), _mxarray8_),
          _mxarray8_),
        NULL));
    /*
     * 
     * res = res';
     */
    mlfAssign(&res, mlfCtranspose(mclVv(res, "res")));
    /*
     * res = [res(:,1), nsr(res(:,2))];
     */
    mlfAssign(
      &res,
      mlfHorzcat(
        mclArrayRef2(mclVv(res, "res"), mlfCreateColonIndex(), _mxarray8_),
        mclArrayRef1(
          mclVv(nsr, "nsr"),
          mclArrayRef2(mclVv(res, "res"), mlfCreateColonIndex(), _mxarray6_)),
        NULL));
    /*
     * res = int32(res);
     */
    mlfAssign(&res, mlfInt32(mclVv(res, "res")));
    /*
     * 
     * Cov = [];
     */
    mlfAssign(mclPrepareGlobal(&Cov), _mxarray9_);
    mclValidateOutput(res, 1, nargout_, "res", "pairelvs");
    mclValidateOutput(*Sres, 2, nargout_, "Sres", "pairelvs");
    mclValidateOutput(*MsgString, 3, nargout_, "MsgString", "pairelvs");
    mxDestroyArray(ans);
    mxDestroyArray(Neg);
    mxDestroyArray(Zer);
    mxDestroyArray(Pos);
    mxDestroyArray(k);
    mxDestroyArray(revb);
    mxDestroyArray(revn);
    mxDestroyArray(buf);
    mxDestroyArray(flip1);
    mxDestroyArray(flip2);
    mxDestroyArray(covzp);
    mxDestroyArray(zcount);
    mxDestroyArray(covnp);
    mxDestroyArray(ncount);
    mxDestroyArray(covpp);
    mxDestroyArray(dum);
    mxDestroyArray(zs);
    mxDestroyArray(szs);
    mxDestroyArray(zerzp);
    mxDestroyArray(ps);
    mxDestroyArray(ns);
    mxDestroyArray(revp);
    mxDestroyArray(nsr);
    mxDestroyArray(negzp);
    mxDestroyArray(negnp);
    mxDestroyArray(negpp);
    mxDestroyArray(numgcands);
    mxDestroyArray(numggcands);
    mxDestroyArray(numcands);
    mxDestroyArray(keeps);
    mxDestroyArray(cancelcheck);
    mxDestroyArray(m);
    mxDestroyArray(negorz);
    mxDestroyArray(posorz);
    mxDestroyArray(candszp);
    mxDestroyArray(gcands);
    mxDestroyArray(ggcands);
    mxDestroyArray(n);
    mxDestroyArray(t);
    mxDestroyArray(ind);
    mxDestroyArray(resneg);
    mxDestroyArray(minzeroes);
    mxDestroyArray(irrevfluxes);
    mxDestroyArray(covS);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return res;
    /*
     * 
     * 
     * 
     */
}

/*
 * The function "Mpairelvs_Covadd" is the implementation version of the
 * "pairelvs/Covadd" M-function from file
 * "/home/robert/pairelvs/build/pairelvs.m" (lines 124-140). It contains the
 * actual compiled code for that M-function. It is a static function and must
 * only be called from one of the interface functions, appearing below.
 */
/*
 * function Covadd(npair,nveczp)  
 */
static void Mpairelvs_Covadd(mxArray * npair, mxArray * nveczp) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_pairelvs);
    mxArray * ans = NULL;
    mclCopyArray(&npair);
    mclCopyArray(&nveczp);
    /*
     * global Cov  
     * 
     * Cov.keepmask = nosuperset(nveczp,Cov.BTp) & Cov.keepmask;
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".keepmask",
      mclFeval(
        mclValueVarargout(),
        mlxAnd,
        mlfNNosuperset(
          0,
          mclValueVarargout(),
          mclVa(nveczp, "nveczp"),
          mlfIndexRef(mclVg(&Cov, "Cov"), ".BTp"),
          NULL),
        mlfIndexRef(mclVg(&Cov, "Cov"), ".keepmask"),
        NULL));
    /*
     * if size(Cov.BTp,2) == Cov.len
     */
    if (mlfTobool(
          mclFeval(
            mclValueVarargout(),
            mlxEq,
            mclFeval(
              mclValueVarargout(),
              mlxSize,
              mlfIndexRef(mclVg(&Cov, "Cov"), ".BTp"),
              _mxarray6_,
              NULL),
            mlfIndexRef(mclVg(&Cov, "Cov"), ".len"),
            NULL))) {
        /*
         * Cov.cmb = [Cov.cmb(:,Cov.keepmask),zeros(size(Cov.cmb,1),100)]; 
         */
        mlfIndexAssign(
          mclPrepareGlobal(&Cov),
          ".cmb",
          mlfHorzcat(
            mlfIndexRef(
              mclVg(&Cov, "Cov"),
              ".cmb(?,?)",
              mlfCreateColonIndex(),
              mlfIndexRef(mclVg(&Cov, "Cov"), ".keepmask")),
            mlfZeros(
              mclFeval(
                mclValueVarargout(),
                mlxSize,
                mlfIndexRef(mclVg(&Cov, "Cov"), ".cmb"),
                _mxarray8_,
                NULL),
              _mxarray10_,
              NULL),
            NULL));
        /*
         * Cov.BTp = [Cov.BTp(:,Cov.keepmask),repmat(uint32(0),length(nveczp),100)];
         */
        mlfIndexAssign(
          mclPrepareGlobal(&Cov),
          ".BTp",
          mlfHorzcat(
            mlfIndexRef(
              mclVg(&Cov, "Cov"),
              ".BTp(?,?)",
              mlfCreateColonIndex(),
              mlfIndexRef(mclVg(&Cov, "Cov"), ".keepmask")),
            mlfRepmat(
              mlfUint32(_mxarray7_),
              mlfScalar(mclLengthInt(mclVa(nveczp, "nveczp"))),
              _mxarray10_),
            NULL));
        /*
         * Cov.keepmask = [Cov.keepmask(Cov.keepmask); false(100,1)];
         */
        mlfIndexAssign(
          mclPrepareGlobal(&Cov),
          ".keepmask",
          mlfVertcat(
            mlfIndexRef(
              mclVg(&Cov, "Cov"),
              ".keepmask(?)",
              mlfIndexRef(mclVg(&Cov, "Cov"), ".keepmask")),
            mlfFalse(_mxarray10_, _mxarray8_, NULL),
            NULL));
        /*
         * Cov.len =  size(Cov.BTp,2)-100;
         */
        mlfIndexAssign(
          mclPrepareGlobal(&Cov),
          ".len",
          mclMinus(
            mclFeval(
              mclValueVarargout(),
              mlxSize,
              mlfIndexRef(mclVg(&Cov, "Cov"), ".BTp"),
              _mxarray6_,
              NULL),
            _mxarray10_));
    /*
     * end
     */
    }
    /*
     * Cov.len = Cov.len+1; 
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".len",
      mclFeval(
        mclValueVarargout(),
        mlxPlus,
        mlfIndexRef(mclVg(&Cov, "Cov"), ".len"),
        _mxarray8_,
        NULL));
    /*
     * Cov.cmb(:,Cov.len)  = npair; 
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".cmb(?,?)",
      mlfCreateColonIndex(),
      mlfIndexRef(mclVg(&Cov, "Cov"), ".len"),
      mclVa(npair, "npair"));
    /*
     * Cov.BTp(:,Cov.len) = nveczp;
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".BTp(?,?)",
      mlfCreateColonIndex(),
      mlfIndexRef(mclVg(&Cov, "Cov"), ".len"),
      mclVa(nveczp, "nveczp"));
    /*
     * Cov.keepmask(Cov.len) = true;                 
     */
    mlfIndexAssign(
      mclPrepareGlobal(&Cov),
      ".keepmask(?)",
      mlfIndexRef(mclVg(&Cov, "Cov"), ".len"),
      mlfTrue(NULL));
    mxDestroyArray(ans);
    mxDestroyArray(nveczp);
    mxDestroyArray(npair);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    /*
     * 
     * 
     */
}
