function [res, Sres, MsgString] = pairelvs(covS,irrevfluxes,minzeroes)
%
% Author:     R.Urbanczik
%
% Inputs:  covS,  n by k uint8-array.
%                 covS(i, 1:k-1) encodes the signs of K\beta(i), where
%                 K is the old constraint matrix and the \beta(i) are
%                 the old elementary vectors. covS(i,k) gives the sign
%                 for the new constraint.
%          irrevfluxes, variable length indexvector such that covS(i,:)
%                       is reversible if covS(i,irrevfluxes) == Zer.
%          minzeroes, minimal number of zeroes for an elementary vector
%
% Outputs: res,  m by 2 index array,
%                a pair [i,j] of res give the indexes such that the old
%                \beta(i,:) and \beta(j,:) can be combined to form an
%                elementary vector of the new system.
%                res lists these pairs for all vectors which are elementary
%                in the new system, but which where not elementary in the
%                old one.
%          Sres, m by k uint8-array.
%                Sres(l,:) encodes the signs of the new elementary vector
%                obtained from the pair res(i,:).
%          MsgString, string with some statistics.
%                  
%
global Cov 

%  fid = fopen('/home/robert/pairelvs/build/debug','a+');
%  fprintf(fid,'%s\n',char(covS));

  Neg = uint8('a'); Zer= uint8('b'); Pos = uint8('c');
  k = size(covS,2);
 

  
  revb = find(sum(+(covS(:,irrevfluxes) ~= Zer),2) == 0);
  revn = revb(find((covS(revb,k) == Neg)));
  buf = covS(revn,:);
  flip1 = (buf == Neg); flip2 =  (buf == Pos);
  buf(flip1) = Pos;     buf(flip2) = Neg;
  covS(revn,:) = buf;
 
  
  [covzp, zcount] = packbituint8(covS(:,1:(k-1)),Zer);
  [covnp,ncount] = packbituint8(covS(:,1:(k-1)),Neg); 
  [covpp,dum] = packbituint8(covS(:,1:(k-1)),Pos);
  zs = find(covS(:,k) == Zer);
  [dum,szs] = sort(-double(countbits(covzp(:,zs)))); 
  zs = zs(szs);
  zerzp = covzp(:,zs);
  
  
  ps = find(covS(:,k) >  Zer);
  ns = find(covS(:,k) <  Zer);
  revp = revb((covS(revb,k) ~= Zer));
  nsr = [ns; revp];
  negzp  = covzp(:,nsr);
  negnp = [covnp(:,ns), covpp(:,revp)]; 
  negpp = [covpp(:,ns), covnp(:,revp)];
  covS = [];   
  Cov.len = 0;            Cov.keepmask = false(0,1); 
  Cov.BTp = covzp(:,[]);  Cov.cmb = zeros(2,0);
 
%  disp(size(ps,1)*size(nsr,1));
  numgcands = 0; numggcands = 0; numcands = 0;
  keeps = 1:length(nsr);
  cancelcheck = (max(ncount) > 0) | length(revp) > 0;
   
    
  for m = ps'
    if cancelcheck
      negorz =  bitor(covzp(:,m),covnp(:,m));
      posorz =  bitor(covzp(:,m),covpp(:,m));
      keeps =find((~nosuperset(negorz,negnp)) & (~nosuperset(posorz,negpp)));
      numcands =  numcands+length(keeps);
     end;
    candszp = andvecmat(covzp(:,m),negzp(:,keeps)); 
    gcands = find( countbits(candszp) >= minzeroes-1);
    numgcands = numgcands + length(gcands);
    ggcands = gcands(nosuperset(zerzp,candszp(:,gcands)));
    numggcands = numggcands + length(ggcands);  
    for n = ggcands'
      t = candszp(:,n); 
      if nosuperset(Cov.BTp,t)
        Covadd([m,keeps(n)],t); 
      end
    end;
  end; 
  Cov.cmb  = Cov.cmb(:,Cov.keepmask);
  Cov.BTp  = Cov.BTp(:,Cov.keepmask);
  Cov.len = size(Cov.BTp,2);
  if Cov.len == 0 
    Cov.BTp = covzp(:,[]);  Cov.cmb = zeros(2,0);
  end  
  
  if ~cancelcheck
     numcands = size(ps,1)*size(nsr,1);
  end;
  MsgString = ...
        num2str([size(zerzp,2), numcands, ...
                 numgcands,numggcands,Cov.len]);
  
  res = Cov.cmb;
  ind = unpackbit(Cov.BTp);
  ind = ind(:,1:(k-1));
  Sres= uint8(ind);
  Sres( ind) = Zer;
  Sres(~ind) = Pos;
  resneg = bitor(covnp(:,res(1,:)),negnp(:,res(2,:)));
  ind = unpackbit(resneg);
  ind = ind(:,1:(k-1));
  Sres(ind) = Neg;
  Sres = [Sres, repmat(Zer,size(Sres,1),1)];
 
  res = res';
  res = [res(:,1), nsr(res(:,2))];
  res = int32(res);
 
  Cov = [];



function Covadd(npair,nveczp)  
global Cov  

    Cov.keepmask = nosuperset(nveczp,Cov.BTp) & Cov.keepmask;
    if size(Cov.BTp,2) == Cov.len
      Cov.cmb = [Cov.cmb(:,Cov.keepmask),zeros(size(Cov.cmb,1),100)]; 
      Cov.BTp = [Cov.BTp(:,Cov.keepmask),repmat(uint32(0),length(nveczp),100)];
      Cov.keepmask = [Cov.keepmask(Cov.keepmask); false(100,1)];
      Cov.len =  size(Cov.BTp,2)-100;
    end
    Cov.len = Cov.len+1; 
    Cov.cmb(:,Cov.len)  = npair; 
    Cov.BTp(:,Cov.len) = nveczp;
    Cov.keepmask(Cov.len) = true;                 
                      
 
