/***************************************************************************

Author: Robert  Urbanczik
Call:  Y = countbits(A,B)
       A   : np by m uint32-Array
       Y   : 1 by m uint32-Array
Does:  Y(i) is the number of bits which are 1 in A(:,i) 

***************************************************************************/
#include <math.h>
#include "mex.h"

/* Input Arguments */

#define	A_IN	prhs[0]


/* Output Arguments */

#define	YP_OUT	plhs[0]

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    unsigned int  *Y,*A; 
    unsigned int x,m,np,l,k; 
    unsigned int d[2];
    const int *dimp;
    
    /* Check for proper number of arguments */
    
    if (nrhs != 1) { 
	mexErrMsgTxt("One input arguments required."); 
    } else if (nlhs > 1) {
	mexErrMsgTxt("Too many output arguments."); 
    } 

    dimp =  mxGetDimensions(A_IN);
    np = dimp[0];
    m = dimp[1];    
  
    d[0] = m; ;
    YP_OUT = mxCreateNumericArray(1, d, mxUINT32_CLASS, mxREAL);
    
    /* Assign pointers to the various parameters */ 
    Y = mxGetData(YP_OUT);
    A = mxGetData(A_IN); 
        
    /* Do the actual computations  */

    for (l = 0; l < m; l++){
     for (k = 0; k < np; k++) {
       x = *A;
       while (x != 0) { *Y += x%2;  x = x/2;}
       A++;}
     Y++;}
 
}


