/***************************************************************************

Author: Robert  Urbanczik
Call:  Y = tcountbits(A,B)
       A   : np by m uint32-Array
       Y   : 1 by m uint32-Array
Does:  Y(i) is the number of bits which are 1 in A(:,i) 

***************************************************************************/
#include <math.h>
#include "mex.h"

static char bits[256] =
{
      0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,  /* 0   - 15  */
      1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,  /* 16  - 31  */
      1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,  /* 32  - 47  */
      2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,  /* 48  - 63  */
      1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,  /* 64  - 79  */
      2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,  /* 80  - 95  */
      2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,  /* 96  - 111 */
      3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,  /* 112 - 127 */
      1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,  /* 128 - 143 */
      2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,  /* 144 - 159 */
      2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,  /* 160 - 175 */
      3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,  /* 176 - 191 */
      2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,  /* 192 - 207 */
      3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,  /* 208 - 223 */
      3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,  /* 224 - 239 */
      4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8   /* 240 - 255 */
};



/* Input Arguments */

#define	A_IN	prhs[0]


/* Output Arguments */

#define	YP_OUT	plhs[0]

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    unsigned char *A;
    unsigned int  *Y; 
    unsigned int x,m,np,l,k; 
    unsigned int d[2];
    const int *dimp;
    
    /* Check for proper number of arguments */
    
    if (nrhs != 1) { 
	mexErrMsgTxt("One input arguments required."); 
    } else if (nlhs > 1) {
	mexErrMsgTxt("Too many output arguments."); 
    } 

    dimp =  mxGetDimensions(A_IN);
    np = dimp[0];
    m = dimp[1];    
  
    d[0] = m; ;
    YP_OUT = mxCreateNumericArray(1, d, mxUINT32_CLASS, mxREAL);
    
    /* Assign pointers to the various parameters */ 
    Y = mxGetData(YP_OUT);
    A = mxGetData(A_IN); 
        
    /* Do the actual computations  */

    for (l = 0; l < m; l++){
     for (k = 0; k < np; k++) {
	 *Y += bits[A[0]]+ bits[A[1]]+ bits[A[2]]+ bits[A[3]];
        A +=4;}
     Y++;}
 
}


